#include <stdio.h>
#include <stdlib.h>
#include <float.h>
#include <limits.h>
#include <string.h>
#include <stdbool.h>
#include "gridstore.h"

#define QUERY_PREFIX "SELECT * WHERE"
#define MINIMUM -INT_MAX
#define MAXIMUM INT_MAX
#define MIN_VAL DBL_MIN
#define POINT_PREFIX "POINT("
#define SURFACE_PREFIX "POLYHEDRALSURFACE("
#define POLYGON_PREFIX "POLYGON(("


typedef enum BoundingOption {
	LESSER = 1,
	LESSEREQ = 2,
	GREATER = 3,
	GREATEREQ = 4,
	EQUALS = 5,
	NEQ = 6
} BoundingOption;

typedef enum Dimension {
	TWO_DIMENSIONAL = 2,
	THREE_DIMENSIONAL = 3
} Dimension;

typedef struct Limits {
	double minX;
	double minY;
	double minZ;
	double maxX;
	double maxY;
	double maxZ;
} Limits;

Limits setInitialRanges();

char* formPoint_2(double x, double y);
char* formPoint_3(double x, double y, double z);


char* formBoundingSquare(double minX,double minY, double maxX,double maxY);
char* formPlane(double* points, int length,Dimension dimension);
char* formSurfaceWkt(double minX, double minY, double minZ, double maxX, double maxY, double maxZ);


char* formTql(char* column, char* geometry, bool include);
char* formQSFTql(char* column, double* matrix,bool include);

double formApproximation(double value, BoundingOption option);

GSRowSet* executeSearch(GSCollection* collection,const GSChar* column, const GSChar* wkt);
GSRowSet* executeTql(GSCollection* collection, const GSChar* tql);

GSRowSet* searchArea(GSCollection* collection, char* column, double minLatitude, double minLongitude, double maxLatitude, double maxLongitude, bool include);
GSRowSet* searchVolume(GSCollection* collection, char* column,double minX, double minY, double minZ, double maxX, double maxY, double maxZ, bool include);

char* searchXRange_1( double value, BoundingOption option);
char* searchXRange_2(double firstX, double secondX);

char* searchYRange_1(double value, BoundingOption option);
char* searchYRange_2(double firstY, double secondY);

char* searchZRange_1(double value, BoundingOption option);
char* searchZRange_2(double firstZ, double secondZ);

GSRowSet* searchQuadratic(GSCollection* collection,char* column, double* matrix, bool include);
GSRowSet* searchPlane(GSCollection* collection, char* column, double* points, int length, Dimension dimension, bool include);
