package sample.logic;

public enum BoundingOption {
	LESSER(1),
	LESSEREQ(2),
	GREATER(3),
	GREATEREQ(4),
	EQUALS(5),
	NEQ(6);

	int code;
	BoundingOption(int code) {
		this.code = code;
	}

	public int getCode(){
		return code;
	}

	public String toString(){
		String str = null;
		switch(code){
			case 1:
				str = "LESS THAN";
				break;
			case 2:
				str = "LESS THAN OR EQUAL TO";
				break;
			case 3:
				str = "GREATER THAN";
				break;
			case 4:
				str = "GREATER THAN OR EQUAL TO";
				break;
		
			case 5:
				str = "EQUALS TO";
				break;
			case 6:
				str = "NOT EQUAL TO";
				break;
		}
		return str;
	}
}
