package sample.row;


import java.util.Date;
import java.sql.Blob;
import java.sql.SQLException;


import com.toshiba.mwcloud.gs.RowKey;
import com.toshiba.mwcloud.gs.Geometry;

public class TrafficCamera {

	@RowKey
	public Date timestamp;

	public String id;

	public String url;

	public Geometry area;

	public int cars;

	public double elevation;

	public Blob image;

	public static String makeImageBytes(Blob blob) throws SQLException {
		byte[] blobData = blob.getBytes(1, (int)(blob.length()));
		StringBuilder byteText = new StringBuilder();
		if (blobData.length > 0){
			for(byte imageByte : blobData){
				byteText.append(String.format("0x%02x",imageByte));
			}
		} else{
			byteText.append("NULL");
		}
		return byteText.toString();
	}

	public String toString() {
		StringBuilder cameraText = new StringBuilder();
		cameraText.append("Camera Reading: ");
		cameraText.append(timestamp);
		cameraText.append(String.format(" %s %s ",id,url));
		cameraText.append(area);
		cameraText.append(String.format(" %d %.5f ",cars,elevation));
		return cameraText.toString();
	}
}

