#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "gridstore.h"
#include "geometryLogic.h"


Limits setInitialRanges(){
	Limits limits;
	limits.minX = MINIMUM;
	limits.minY = MINIMUM;
	limits.minZ = MINIMUM;
	limits.maxX = MAXIMUM;
	limits.maxY = MAXIMUM;;
	limits.maxZ = MAXIMUM;;

	return limits;	
}

char* formPoint_2(double x, double y){
	int digitAllocation = 10;
	digitAllocation += ((int) abs(x) / 10 + 2);
	digitAllocation += ((int) abs(y) / 10 + 2);
	char* wkt = (char*) malloc(sizeof(char) * (strlen(POINT_PREFIX) + digitAllocation + 4));

	sprintf(wkt,"POINT(%.5f,%.5f)",x,y);
	return wkt;
}

char* formPoint_3(double x, double y, double z){
	int digitAllocation = 15;
	digitAllocation += ((int) abs(x) / 10 + 2);
	digitAllocation += ((int) abs(y) / 10 + 2);
	digitAllocation += ((int) abs(z) / 10 + 2);
	char* wkt = (char*) malloc(sizeof(char) * (strlen(POINT_PREFIX) + digitAllocation + 5));

	sprintf(wkt,"POINT(%.5f,%.5f,%.5f)",x,y,z);
	return wkt;
}

char* formBoundingSquare(double minX, double minY, double maxX, double maxY){
	int digitAllocation = 100;
	int numCommas = 4;
	int numParenths = 2;
	
	int minXAllocation = ((int) abs(minX) / 10 + 2);
	int minYAllocation = ((int) abs(minY) / 10 + 2);
	int maxXAllocation = ((int) abs(maxX) / 10 + 2);
	int maxYAllocation = ((int) abs(maxY) / 10 + 2);

	int coordinateAllocation = 5 + (2 * (maxXAllocation)) + (2 * (maxYAllocation)) + (3 * (minXAllocation)) + (3 * (minYAllocation));

	char* wkt = (char *) malloc(sizeof(char) * (strlen(POLYGON_PREFIX) + digitAllocation + coordinateAllocation + numCommas + numParenths + 2));
	sprintf(wkt,"POLYGON((%.5f %.5f, %.5f %.5f, %.5f %.5f, %.5f %.5f, %.5f %.5f))",minX,minY,maxX,minY,maxX,maxY,minX,maxY,minX,minY);

	return wkt;
}

char* formPlane(double* points, int length, Dimension dimension){
	int stopIndex = 2;
	if(dimension == THREE_DIMENSIONAL){
		stopIndex = 3;
	}

	int i;
	int digitAllocation = 0;

	for(i = 0; i < length; i++){
		digitAllocation += (abs((int) points[i]) / 10 + 8);
	}

	char* plane = (char*) malloc(sizeof(char) * (strlen(POLYGON_PREFIX) + 3 + (length -1) + (digitAllocation * 3)));
	strcpy(plane,POLYGON_PREFIX);

	for(i = 0; i < length; i++){
		char* buffer = (char*) malloc(sizeof(char) * (abs((int) points[i]) / 10 + 10));
		sprintf(buffer," %.5f ",points[i]);
		strcat(plane,buffer);

		if((i + 1) % stopIndex == 0 && stopIndex > 0){
			strcat(plane,",");
		}

		free(buffer);
	}

	for(i = 0; i < stopIndex; i++){
		char* buffer = (char*) malloc(sizeof(char) * (abs((int) points[i]) / 10 + 10));

		sprintf(buffer," %.5f ",points[i]);
		strcat(plane,buffer);
	
		free(buffer);
	}

	strcat(plane,"))");
	return plane;
}

char* formSurfaceWkt(double minX, double minY, double minZ, double maxX, double maxY, double maxZ){
	int decimalAllocation = (15 * 5 * 6);
	int numCommas = (4 * 6) + 4;
	int numParenths = 2 + (4 * 6);

	int minXAllocation = ( abs((int) minX) / 10 + 4);
	int minYAllocation = (abs((int) minY) / 10 + 4);
	int minZAllocation = (abs((int) minZ)  / 10 + 4);
	
	int maxXAllocation = (abs((int) maxX)  / 10 + 4);
	int maxYAllocation = (abs((int) maxY)  / 10 + 4);
	int maxZAllocation = (abs((int) maxZ)  / 10 + 4);

	int pointsAllocation = abs(((15 * minXAllocation) + (15 * minYAllocation) + (15 * minZAllocation) + (15 * maxXAllocation) + (15 * maxYAllocation) + (15 * maxZAllocation)));

	char* wkt = (char*) malloc(sizeof(char) * (strlen(SURFACE_PREFIX) + pointsAllocation + decimalAllocation + numCommas + numParenths + 6));
	sprintf(wkt,
		"POLYHEDRALSURFACE(((%.5f %.5f %.5f, %.5f %.5f %.5f, %.5f %.5f %.5f, %.5f %.5f %.5f, %.5f %.5f %.5f)),((%.5f %.5f %.5f, %.5f %.5f %.5f, %.5f %.5f %.5f, %.5f %.5f %.5f, %.5f %.5f %.5f)),((%.5f %.5f %.5f, %.5f %.5f %.5f, %.5f %.5f %.5f, %.5f %.5f %.5f, %.5f %.5f %.5f)),((%.5f %.5f %.5f, %.5f %.5f %.5f, %.5f %.5f %.5f, %.5f %.5f %.5f, %.5f %.5f %.5f)),((%.5f %.5f %.5f, %.5f %.5f %.5f, %.5f %.5f %.5f, %.5f %.5f %.5f, %.5f %.5f %.5f)),((%.5f %.5f %.5f, %.5f %.5f %.5f, %.5f %.5f %.5f, %.5f %.5f %.5f, %.5f %.5f %.5f)))",
		minX,minY,minZ,minX,maxY,minZ,maxX,maxY,minZ,maxX,minY,minZ,minX,minY,minZ,
		minX,minY,minZ,minX,maxY,minZ,minX,maxY,maxZ,minX,minY,maxZ,minX,minY,minZ,
		minX,minY,minZ,maxX,minY,minZ,maxX,minY,maxZ,minX,minY,maxZ,minX,minY,minZ,
		maxX,maxY,maxZ,maxX,minY,maxZ,minX,minY,maxZ,minX,maxY,maxZ,maxX,maxY,maxZ,
		maxX,maxY,maxZ,maxX,minY,maxZ,maxX,minY,minZ,maxX,maxY,minZ,maxX,maxY,maxZ,
		maxX,maxY,maxZ,maxX,maxY,minZ,minX,maxY,minZ,minX,maxY,maxZ,maxX,maxY,maxZ);
	return wkt;
}

char* formTql(char* column, char* geometry, bool include){

	char* tql = (char*) malloc(sizeof(char) * (strlen(QUERY_PREFIX) + strlen(geometry) + strlen(column) + 47));
	strcpy(tql,QUERY_PREFIX);
	if(!include){
		strcat(tql," NOT ");
	}

	strcat(tql,"ST_MBRIntersects(");
	strcat(tql,column);
	strcat(tql,"'");
	strcat(tql,geometry);
	strcat(tql,"'))");
	// sprintf(tql,"SELECT * WHERE %s ST_MBRIntersects(%s,ST_GeomFromText('%s'))",column,geometry);	

	return tql;
}

char* formQSFTql(char* column, double* matrix, bool include){
	int digitAllocation = 16 * 7;
	int matrixSize = sizeof(matrix) / sizeof(*matrix);
	int i;

	for(i = 0; i < 16; i++){
		if(i < matrixSize){
			digitAllocation += ((int) abs(matrix[i]) / 10 + 1);
		} else {
			digitAllocation += 2;
		}
	}

	char* tql = (char*) malloc(sizeof(char) * (strlen(QUERY_PREFIX) + 39 + digitAllocation + strlen(column)));
	strcpy(tql,QUERY_PREFIX);
	if(!include){
		strcat(tql," NOT ");
	}

	strcat(tql, "ST_QSFMBRIntersects(ST_MakeQSF(");

	char buffer[128];
	for(i = 0; i < 16; i++){
		if(i < matrixSize){
			sprintf(buffer," %.5f ",matrix[i]);
			strcat(tql,buffer);
		} else {
			strcat(tql," 0 ");
		}
	}

	strcat(tql,"),");
	strcat(tql,column);
	strcat(tql,")");

	return tql;
}

double formApproximation(double value, BoundingOption option){
	if(option == LESSER){
		return value - MIN_VAL;	
	} else if(option == GREATER){
		return value + MIN_VAL;
	}

	return value;
}

GSRowSet* executeSearch(GSCollection* collection, const GSChar* column, const GSChar* wkt){
	GSQuery* query;
	GSRowSet* rowSet;

	gsQueryByGeometry(collection,column,wkt,GS_GEOMETRY_OPERATOR_INTERSECT,&query);
	gsFetch(query,GS_FALSE,&rowSet);

	return rowSet;
}

GSRowSet* executeTql(GSCollection* collection, const GSChar* tql){
	GSQuery* query;
	GSRowSet* rowSet;

	gsQuery(collection,tql,&query);
	gsFetch(query,GS_FALSE,&rowSet);
	return rowSet;
}

GSRowSet* searchArea(GSCollection* collection, char* column, double minLatitude, double minLongitude, double maxLatitude, double maxLongitude, bool include){
	GSRowSet* rowSet;
	char* wkt = formBoundingSquare(minLatitude,minLongitude,maxLatitude,maxLongitude);

	if(include){
		const GSChar* col = column;
		const GSChar* geometry = wkt;
		rowSet = executeSearch(collection,col,geometry);
	} else {

		char* tqlStr = formTql(column,wkt,include);
		const GSChar* tql = tqlStr;
		rowSet = executeTql(collection,tql);
		free(tqlStr);
	}

	free(wkt);
	return rowSet;
}

GSRowSet* searchVolume(GSCollection* collection, char* column,double minX, double minY, double minZ, double maxX, double maxY, double maxZ, bool include){
	GSRowSet* rowSet;
	char* wkt = formSurfaceWkt(minX,minY,minZ,maxX,maxY,maxZ);
	if(include){
		const GSChar* col = column;
		const GSChar* geom = wkt;
		rowSet = executeSearch(collection,col,geom);
	} else {
		char* tqlStr = formTql(column,wkt,include);
		const GSChar* tql = tqlStr;
		rowSet = executeTql(collection,tql);
		free(tqlStr);
	}

	free(wkt);
	return rowSet;
}

char* searchXRange_1(double value, BoundingOption option){
	Limits limits = setInitialRanges();

	if(option == GREATER){
		limits.minX = value + MIN_VAL;
	} else if(option == LESSER){
		limits.maxX = value - MIN_VAL;
	} else if(option == GREATEREQ){
		limits.minX = value;
	} else if(option == LESSEREQ){
		limits.maxX = value;
	}

	char* wkt = formSurfaceWkt(limits.minX,limits.minY,limits.minZ,limits.maxX,limits.maxY,limits.maxZ);
	return wkt;
}

char* searchXRange_2(double firstX,double secondX){
	Limits limits = setInitialRanges();

	double min = firstX;
	double max = secondX;

	if(firstX > secondX){
		min = secondX;
		max = firstX;
	}

	limits.minX = min;
	limits.maxX = max;

	char* wkt = formSurfaceWkt(limits.minX,limits.minY,limits.minZ,limits.maxX,limits.maxY,limits.maxZ);
	return wkt;
}

char* searchYRange_1(double value, BoundingOption option){
	Limits limits = setInitialRanges();

	if(option == GREATER){
		limits.minY = value + MIN_VAL;
	} else if(option == LESSER){
		limits.maxY = value - MIN_VAL;
	} else if(option == GREATEREQ){
		limits.minY = value;
	} else if(option == LESSEREQ){
		limits.maxY = value;
	}

	char* wkt = formSurfaceWkt(limits.minX,limits.minY,limits.minZ,limits.maxX,limits.maxY,limits.maxZ);
	return wkt;
}

char* searchYRange_2(double firstY,double secondY){
	Limits limits = setInitialRanges();

	double min = firstY;
	double max = secondY;

	if(firstY > secondY){
		min = secondY;
		max = firstY;
	}

	limits.minY = min;
	limits.maxY = max;

	char* wkt = formSurfaceWkt(limits.minX,limits.minY,limits.minZ,limits.maxX,limits.maxY,limits.maxZ);
	return wkt;
}


char* searchZRange_1(double value, BoundingOption option){
	Limits limits = setInitialRanges();

	if(option == GREATER){
		limits.minZ = value + MIN_VAL;
	} else if(option == LESSER){
		limits.maxZ = value - MIN_VAL;
	} else if(option == GREATEREQ){
		limits.minZ = value;
	} else if(option == LESSEREQ){
		limits.maxZ = value;
	}

	char* wkt = formSurfaceWkt(limits.minX,limits.minY,limits.minZ,limits.maxX,limits.maxY,limits.maxZ);
	return wkt;
}

char* searchZRange_2(double firstZ,double secondZ){
	Limits limits = setInitialRanges();

	double min = firstZ;
	double max = secondZ;

	if(firstZ > secondZ){
		min = secondZ;
		max = firstZ;
	}

	limits.minZ = min;
	limits.maxZ = max;

	char* wkt = formSurfaceWkt(limits.minX,limits.minY,limits.minZ,limits.maxX,limits.maxY,limits.maxZ);
	return wkt;
}

GSRowSet* searchQuadratic(GSCollection* collection, char* column, double* matrix, bool include){
	GSRowSet* rowSet;

	char* tqlStr = formQSFTql(column,matrix,include);
	const GSChar* tql = tqlStr;
	rowSet = executeTql(collection,tql);

	free(tqlStr);
	return rowSet;
}

GSRowSet* searchPlane(GSCollection* collection, char* column,double* points, int length, Dimension dimension, bool include){
	GSRowSet* rowSet;

	char* wkt = formPlane(points,length,dimension);
	char* tqlStr = formTql(column,wkt,include);
	const GSChar* tql = tqlStr;

	rowSet = executeTql(collection,tql);

	free(tqlStr);
	free(wkt);

	return rowSet;
}