package sample;

import java.util.Properties;
import java.util.Date;
import java.util.Map;
import java.util.Map.Entry;
import java.util.List;
import java.util.ArrayList;
import java.util.HashMap;
import java.lang.Object.*;

import java.io.IOException;
import java.io.FileReader;

import com.toshiba.mwcloud.gs.Collection;
import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.GridStore;
import com.toshiba.mwcloud.gs.GridStoreFactory;
import com.toshiba.mwcloud.gs.Query;
import com.toshiba.mwcloud.gs.Geometry;
import com.toshiba.mwcloud.gs.GeometryOperator;
import com.toshiba.mwcloud.gs.RowSet;
import com.toshiba.mwcloud.gs.IndexType;
import com.toshiba.mwcloud.gs.TimeUnit;
import com.toshiba.mwcloud.gs.TimestampUtils;

import sample.row.PipeMonitor;
import sample.logic.PipeMonitorLogic;

import au.com.bytecode.opencsv.CSVReader;


public class PipeCollection {


	public static void main(String args[]) throws IOException, GSException {
		Properties properties = new Properties();
		properties.setProperty("notificationAddress",args[0]);
		properties.setProperty("notificationPort",args[1]);
		properties.setProperty("clusterName",args[2]);
		properties.setProperty("user",args[3]);
		properties.setProperty("password",args[4]);

		GridStore gridstore = null;
		gridstore = GridStoreFactory.getInstance().getGridStore(properties);

		String name = "Pipes101";
		String csvName = "../data/PipeData.csv";
		String column = "pipe";

		Collection<String,PipeMonitor> pipeCollection = gridstore.putCollection(name,PipeMonitor.class);

		pipeCollection.createIndex("id",IndexType.HASH);
		pipeCollection.createIndex("installation",IndexType.TREE);
		pipeCollection.createIndex("pipe",IndexType.SPATIAL);

		Date date = TimestampUtils.add(TimestampUtils.current(),-1,TimeUnit.DAY);
		PipeMonitorLogic.readCSV(pipeCollection,date,csvName);


		Query<PipeMonitor> apiQuery = pipeCollection.query(column,Geometry.valueOf("LINESTRING(1 1 1, 1 0 1, 1 0 0)"),GeometryOperator.INTERSECT);
		RowSet<PipeMonitor> apiRs = apiQuery.fetch(false);

		int result = 1;
		while(apiRs.hasNext()){
			PipeMonitor pipeMonitor = apiRs.next();
			System.out.print(String.format("API Result %d: ",result++));
			System.out.println(pipeMonitor);
		}

		String tql = "SELECT * WHERE NOT ST_MBRIntersects(pipe,ST_GeomFromText('LINESTRING(7 2 0, 7 2 4)')) AND elevation > -5.3";
		result = 1;

		System.out.println();

		Query<PipeMonitor> query = pipeCollection.query(tql);
		RowSet<PipeMonitor> rowSet = query.fetch(false);

		while(rowSet.hasNext()){
			PipeMonitor pipeMonitor = rowSet.next();
			System.out.print(String.format("TQL Result %d: ",result++));
			System.out.println(pipeMonitor);
		}


		if(gridstore != null)
			gridstore.close();
	}
}
