package sample.logic;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Date;
import java.lang.Object.*;
import java.util.List;

import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialException;

import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.GridStore;
import com.toshiba.mwcloud.gs.TimeSeries;
import com.toshiba.mwcloud.gs.TimeUnit;
import com.toshiba.mwcloud.gs.TimestampUtils;
import com.toshiba.mwcloud.gs.Geometry;
import com.toshiba.mwcloud.gs.RowSet;
import com.toshiba.mwcloud.gs.Query;


import au.com.bytecode.opencsv.CSVReader;

import sample.row.TrafficCamera;

public class TrafficCameraLogic {
	private static final String PREFIX = "POLYGON";
	private static final String IMAGE_PREFIX = "data/img";

	private static Geometry parseWkt(String edges){
		String wkt = PREFIX + "((" + edges.replaceAll(":",",") + "))";
		Geometry geometry = Geometry.valueOf(wkt);
		return geometry;
	}


	public static void readCameraCSV(TimeSeries<TrafficCamera> timeseries, String csvFile) throws GSException, SerialException, SQLException, IOException {
		CSVReader reader = null;
		String nextLine[];
		int offset = 0;

		try {
			reader = new CSVReader(new FileReader(csvFile));
			nextLine = reader.readNext();

			while((nextLine = reader.readNext()) != null){
				TrafficCamera trafficCamera = new TrafficCamera();
				trafficCamera.timestamp = TimestampUtils.current();

				trafficCamera.id = nextLine[0];
				String url = nextLine[1];
				trafficCamera.url = IMAGE_PREFIX + "/" + url;

				String bottomLeft = nextLine[2];
				String bottomRight = nextLine[3];
				String topRight = nextLine[4];
				String topLeft = nextLine[5];

				String wkt = String.format("POLYGON((%s,%s,%s,%s,%s))",bottomLeft,bottomRight,topRight,topLeft,bottomLeft);
				trafficCamera.area = Geometry.valueOf(wkt);

				trafficCamera.cars = Integer.parseInt(nextLine[6]);
				trafficCamera.elevation = Double.parseDouble(nextLine[7]);

				ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
				if((trafficCamera.url != null) && (!trafficCamera.url.isEmpty())){
					File snapShot = new File(trafficCamera.url);
					long len = snapShot.length();
					if (snapShot.exists() && snapShot.isFile()){
						InputStream iStream = null;
						try {
							iStream = new BufferedInputStream(new FileInputStream(trafficCamera.url));
							byte[] buffer = new byte[(int) len];
							while((iStream.read(buffer)) != -1){
								byteStream.write(buffer);
							}
						} finally {
							if(iStream != null)
								iStream.close();
						}
					} 
				} else {
					trafficCamera.url = "NULL";
				}

				System.out.println(byteStream.toByteArray().length);
				trafficCamera.image = new SerialBlob(byteStream.toByteArray());
				
				System.out.print("Inserting ");
				System.out.print(trafficCamera);
				System.out.println(" into Timeseries");

				timeseries.put(trafficCamera.timestamp,trafficCamera);
			}

		} catch (GSException exception){
			exception.printStackTrace();
			System.out.println("Error occurred in GridDB!");
		} catch (IOException exception){
			exception.printStackTrace();
			System.out.println("Error handling file: " + csvFile);
		} finally {
			if(reader != null)
				reader.close();
		}
	}
}