package sample.row;

import com.toshiba.mwcloud.gs.RowKey;
import com.toshiba.mwcloud.gs.Geometry;

import java.util.Date;

public class TrafficLight {
	@RowKey
	public  String tag; // Sensor Id of Smart Traffic Light
	
	public Geometry point; // Latitude, Longitude, and Elevation of Sensor
	
	public Date installation; // Time of installation to the Traffic Grid
	
	public boolean active; // Whether the traffic light sensor is on
	
	public int reports; // Number of reports that the Traffic Light has issued
	
	public String streets; // Cross streets of Traffic Light

	public String toString(){
		return String.format("Traffic Light: %s %s %s %b %d %s",tag,point.toString(),installation.toString(),active,reports,streets);
	}
}