# Geometry-Sample Package for GridDB SE

### Add CSV Parser Library in C

```
	$ git clone https://github.com/JamesRamm/csv_parser
	$ cp csv_parser/src/* include/.
```

### Adding GridDB to Environment

Add paths to the GridDB C and Java API 

```
	$ export CLASSPATH=${CLASSPATH}:path/to/gridstore.jar
	$ export CLASSPATH=${CLASSPATH}:${PWD}/lib/opencsv-2.3.jar

	$ export LD_LIBRARY_PATH=path/to/libgridstore.so.0.0.0
```

### Build and Run

Make these edits in `Makefile`

```
	INCLUDES = -I/path/to/gridstore.h/directory -I/path/to/csvparser.h/directory
	LFLAGS = -L/path/to/libgridstore.so.0.0.0/directory
	SRCS = path/to/csvparser.c
```

These are the default paths.

```
	INCLUDES = -I/usr/include -I../include ## Has gridstore.h ; csvparser.h
	LFLAGS = -L/usr/lib64 ## Has libgridstore.so.0.0.0
	SRCS = ../include/csvparser.c
```

Build and run C-sample programs.

```
	$ cd c_sample
	$ make
	$ ./geometrySample host port clusterName username password
	$ ./sample2 host port clusterName username password
	$ ./sample3 host port clusterName username password
	$ ./sample4 host port clusterName username password
	$ ./streetLights host port clusterName username password
	$ ./smartBuildings host port clusterName username password
```

Build and run Java-sample programs

```
	$ ant sample
	$ cd class
	$ java sample/GeometrySample host port clusterName username password
	$ java sample/TrafficLightCollection host port clusterName username password
	$ java sample/TrafficCameraTimeseries host port clusterName username password
	$ java sample/PipeCollection host port clusterName username password
	$ java sample/StreetLightApplication host port clusterName username password
	$ java sample/BuildingApplication host port clusterName username password
```
