package sample;

import javax.sql.rowset.serial.SerialException;
import java.sql.SQLException;
import java.sql.Blob;

import java.util.Properties;
import java.util.Date;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import java.util.ArrayList;
import java.lang.Object.*;


import java.io.IOException;
import java.sql.SQLException;

import javax.sql.rowset.serial.SerialBlob;


import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.TimeSeries;
import com.toshiba.mwcloud.gs.TimestampUtils;
import com.toshiba.mwcloud.gs.TimeUnit;
import com.toshiba.mwcloud.gs.GridStore;
import com.toshiba.mwcloud.gs.GridStoreFactory;
import com.toshiba.mwcloud.gs.IndexType;
import com.toshiba.mwcloud.gs.Query;
import com.toshiba.mwcloud.gs.RowSet;


import sample.logic.TrafficCameraLogic;
import sample.row.TrafficCamera;

public class TrafficCameraTimeseries {

	public static void main(String args[]) throws GSException, SerialException, IOException, SQLException {
		Properties properties = new Properties();
		properties.setProperty("notificationAddress",args[0]);
		properties.setProperty("notificationPort",args[1]);
		properties.setProperty("clusterName",args[2]);
		properties.setProperty("user",args[3]);
		properties.setProperty("password",args[4]);

		GridStore gridstore = null;
		gridstore = GridStoreFactory.getInstance().getGridStore(properties);

		String name = "CameraTs121";
		String column = "area";
		String csvName = "../data/CameraReadings.csv";

		TimeSeries<TrafficCamera> timeseries = gridstore.putTimeSeries(name,TrafficCamera.class);


		Date date = TimestampUtils.add(TimestampUtils.current(),-1,TimeUnit.DAY);

		TrafficCameraLogic.readCameraCSV(timeseries,csvName);

		String tql = "SELECT * WHERE ST_MBRIntersects(area,ST_GeomFromText('POLYGON((8 8, 9 8, 9 9, 8 9, 8 8))')) AND cars < 100";

		Query<TrafficCamera> query = timeseries.query(tql);
		RowSet<TrafficCamera> rowSet = query.fetch(false);

		System.out.println();

		int result = 1;
		while(rowSet.hasNext()){
			TrafficCamera camera = rowSet.next();
			System.out.println(String.format("TQL Result %d: %s",result++,camera.toString()));
			System.out.println(String.format("Image Size: %d",camera.image.length()));
		}

		gridstore.dropTimeSeries(name);


		if(gridstore != null)
			gridstore.close();
	}
}
