package sample;

import java.util.Properties;
import java.util.Date;
import java.lang.Object.*;
import java.util.List;
import java.util.ArrayList;

import java.text.ParseException;
import java.io.IOException;
import java.io.FileReader;

import com.toshiba.mwcloud.gs.Collection;
import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.GridStore;
import com.toshiba.mwcloud.gs.GridStoreFactory;
import com.toshiba.mwcloud.gs.Geometry;
import com.toshiba.mwcloud.gs.GeometryOperator;
import com.toshiba.mwcloud.gs.RowSet;
import com.toshiba.mwcloud.gs.Query;
import com.toshiba.mwcloud.gs.IndexType;
import com.toshiba.mwcloud.gs.TimeUnit;
import com.toshiba.mwcloud.gs.TimestampUtils;


import sample.row.TrafficLight;

import sample.logic.TrafficLightLogic;


public class TrafficLightCollection {

	public static void main(String args[]) throws GSException, IOException, ParseException {
		Properties properties = new Properties();
		properties.setProperty("notificationAddress",args[0]);
		properties.setProperty("notificationPort",args[1]);
		properties.setProperty("clusterName",args[2]);
		properties.setProperty("user",args[3]);
		properties.setProperty("password",args[4]);

		GridStore gridstore = null;
		gridstore = GridStoreFactory.getInstance().getGridStore(properties);
		
		// Set that CSV File Properties and Move Data Readings
		String collectionName = "Lights01";
		String csvFile = "../data/trafficLights.csv";
		String geoColumn = "point";

		// Instantiate Collection and Indexes
		Collection<String,TrafficLight> lightCollection = gridstore.putCollection(collectionName, TrafficLight.class);

		lightCollection.createIndex("tag",IndexType.HASH);
		lightCollection.createIndex("installation",IndexType.TREE);
		lightCollection.createIndex("point",IndexType.SPATIAL);

		Date startDate = TimestampUtils.add(TimestampUtils.current(),-1,TimeUnit.DAY);

		TrafficLightLogic.readPointsCSV(lightCollection,startDate,csvFile);
		System.out.println();

		
		Query<TrafficLight> apiQuery = lightCollection.query(geoColumn,Geometry.valueOf("POINT(47.33 84.72 0.7)"),GeometryOperator.INTERSECT);
		RowSet<TrafficLight> apiRs = apiQuery.fetch(false);
		int result = 1;

		while(apiRs.hasNext()){
			TrafficLight trafficLight = apiRs.next();
			System.out.print(String.format("API Result %d: ",result++));
			System.out.println(trafficLight);
		}

		System.out.println();

		String tql = "SELECT * WHERE ST_MBRIntersects(point,ST_GeomFromText('POLYGON((39.90 81.00, 50.10 81.00, 50.10 87.00, 39.90 87.00, 39.90 81.00))'))" +
		" AND reports < 20 AND active AND installation > TIMESTAMPADD(DAY,NOW(),-9)";
		
		Query<TrafficLight> query = lightCollection.query(tql);
		RowSet<TrafficLight> rowSet = query.fetch(false);

		result = 1;
		while(rowSet.hasNext()){
			TrafficLight trafficLight = rowSet.next();
			System.out.print(String.format("TQL Result %d: ",result++));
			System.out.println(trafficLight);
		}

		if(gridstore != null)
			gridstore.close();
	}
}
