package sample.logic;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.Map.Entry;
import java.util.HashMap;
import java.lang.Object.*;

import java.io.IOException;
import java.io.FileReader;

import com.toshiba.mwcloud.gs.Container;
import com.toshiba.mwcloud.gs.Collection;
import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.Query;
import com.toshiba.mwcloud.gs.Geometry;
import com.toshiba.mwcloud.gs.GeometryOperator;
import com.toshiba.mwcloud.gs.RowSet;
import com.toshiba.mwcloud.gs.TimeUnit;
import com.toshiba.mwcloud.gs.TimestampUtils;

import sample.row.PipeMonitor;

import au.com.bytecode.opencsv.CSVReader;

public class PipeMonitorLogic {
	private static final String PREFIX = "LINESTRING";

	private static Geometry formLine(String dataPoints){
		String wkt = PREFIX + "(" + dataPoints.replaceAll(":",",") + ")";
		Geometry geometry = Geometry.valueOf(wkt);
		return geometry;
	}

	public static void readCSV(Collection<String,PipeMonitor> collection, Date endDate, String csvName) throws GSException, IOException {
		CSVReader reader = null;
		String nextLine[];
		int offset = 0;

		try {
			reader = new CSVReader(new FileReader(csvName));
			nextLine = reader.readNext();

			while((nextLine = reader.readNext()) != null){
				PipeMonitor pipeMonitor = new PipeMonitor();
				pipeMonitor.id = nextLine[0];
				pipeMonitor.pipe = formLine(nextLine[1]);
				pipeMonitor.installation = TimestampUtils.add(endDate,offset--,TimeUnit.DAY);
				pipeMonitor.radius = Double.parseDouble(nextLine[2]);
				pipeMonitor.elevation = Double.parseDouble(nextLine[3]);
				System.out.print("Inserting ");
				System.out.print(pipeMonitor);
				System.out.println(" into collecion.");
				collection.put(pipeMonitor.id,pipeMonitor);
			}
			System.out.println();
		} catch (GSException gsException){
			gsException.printStackTrace();
			System.out.println("Error handling connection with GridDB");
		} catch (IOException ioException){
			ioException.printStackTrace();
			System.out.println("Error handling file " + csvName);
		} finally {
			if(reader != null)
				reader.close();
		}
	}
}