package sample.logic;

import java.util.Date;
import java.lang.Object.*;

import java.io.IOException;
import java.io.FileReader;

import com.toshiba.mwcloud.gs.Container;
import com.toshiba.mwcloud.gs.Collection;
import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.Query;
import com.toshiba.mwcloud.gs.Geometry;
import com.toshiba.mwcloud.gs.GeometryOperator;
import com.toshiba.mwcloud.gs.RowSet;
import com.toshiba.mwcloud.gs.TimeUnit;
import com.toshiba.mwcloud.gs.TimestampUtils;

import sample.row.TrafficLight;

import au.com.bytecode.opencsv.CSVReader;

public class TrafficLightLogic {
	private static final String PREFIX = "POINT(";

	private static Geometry makeCoordinates(String points[], String prefix){
		String wktString = prefix;
		for(String point : points)
			wktString += String.format(" %s",point);
		wktString += ")";
		Geometry coordinates = Geometry.valueOf(wktString);
		return coordinates;
	}


	private static Geometry makeCoordinates(double x, double y, String prefix){
		Geometry coordinates = Geometry.valueOf(String.format("%s %f %f)",prefix,x,y));
		return coordinates;
	}

	private static Geometry makeCoordinates(double x, double y, double z, String prefix){
		Geometry coordinates = Geometry.valueOf(String.format("%s %f %f %f)",prefix,x,y,z));
		return coordinates; 
	}

	public static String makeWkt(double x, double y){
		String wkt = String.format("%s %f %f)",PREFIX,x,y);
		return wkt;
	}

	public static String makeWkt(double x, double y, double z){
		String wkt = String.format("%s %f %f %f)",PREFIX,x,y,z);
		return wkt;
	}

	public static void readPointsCSV(Collection<String,TrafficLight> collection, Date endDate, String csvFile) throws GSException, IOException {
		CSVReader reader = null;
		String nextLine[];
		int offset = 0;

		try {
			reader = new CSVReader(new FileReader(csvFile));
			nextLine = reader.readNext();

			while((nextLine = reader.readNext()) != null){
				TrafficLight trafficLight = new TrafficLight();
				trafficLight.tag = nextLine[0];
				int index = 1;
				String points[] = new String[3];
				for(int i = 0; i < 3; i++)
		 			points[i] = nextLine[index++];
		 		trafficLight.point = makeCoordinates(points,PREFIX);
		 		trafficLight.installation = TimestampUtils.add(endDate,offset--,TimeUnit.DAY);
		 		trafficLight.active =  Boolean.parseBoolean(nextLine[index++]);
		 		trafficLight.reports = Integer.parseInt(nextLine[index++]);
		 		trafficLight.streets = nextLine[index++];
		 		System.out.println("Inserting " + trafficLight.toString() + " into collection.");
		 		collection.put(trafficLight.tag,trafficLight);
			}
		}  catch(GSException gsException){
			gsException.printStackTrace();
			System.out.println("Error with GridDB");
		}  catch(IOException ioException){
			ioException.printStackTrace();
			System.out.println("Error with " + csvFile);
		} finally {
			if(reader != null)
				reader.close();
		}
	}

}