/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs;

import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.GridStore;
import com.toshiba.mwcloud.gs.common.GridStoreFactoryProvider;
import com.toshiba.mwcloud.gs.common.LoggingUtils;
import java.io.Closeable;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceLoader;

public abstract class GridStoreFactory
implements Closeable {
    private static final String DEFAULT_CLASS_NAME = "com.toshiba.mwcloud.gs.subnet.SubnetGridStoreFactory";
    private static final GridStoreFactory INSTANCE;

    protected GridStoreFactory() {
    }

    private static GridStoreFactory newInstance() {
        for (ClassLoader cl : new ClassLoader[]{GridStoreFactory.class.getClassLoader(), Thread.currentThread().getContextClassLoader(), ClassLoader.getSystemClassLoader()}) {
            Iterator<GridStoreFactoryProvider> i$ = ServiceLoader.load(GridStoreFactoryProvider.class, cl).iterator();
            if (!i$.hasNext()) continue;
            GridStoreFactoryProvider provider = i$.next();
            return provider.getFactory();
        }
        try {
            return (GridStoreFactory)Class.forName(DEFAULT_CLASS_NAME).newInstance();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public static GridStoreFactory getInstance() {
        return INSTANCE;
    }

    public abstract GridStore getGridStore(Properties var1) throws GSException;

    public abstract void setProperties(Properties var1) throws GSException;

    @Override
    public abstract void close() throws GSException;

    private static void registerLoggers() {
        boolean loggerAvailable = false;
        try {
            Class.forName("org.slf4j.Logger");
            Class.forName("org.slf4j.LoggerFactory");
            loggerAvailable = true;
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        for (String subName : LoggingUtils.SUB_LOGGER_NAMES) {
            LoggingUtils.BaseGridStoreLogger logger;
            if (loggerAvailable) {
                try {
                    logger = (LoggingUtils.BaseGridStoreLogger)Class.forName("com.toshiba.mwcloud.gs.GridStoreLogger$" + subName).newInstance();
                }
                catch (Exception e) {
                    throw new Error(e);
                }
            } else {
                logger = null;
            }
            LoggingUtils.registerLogger(subName, logger);
        }
    }

    static {
        GridStoreFactory.registerLoggers();
        INSTANCE = GridStoreFactory.newInstance();
    }
}

