/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs;

import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.GSType;
import com.toshiba.mwcloud.gs.common.GSErrorCode;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class RowKeyPredicate<K> {
    private static boolean stringRangeRestricted = false;
    private final Class<?> keyClass;
    private K start;
    private K finish;
    private Set<K> distinctKeys;

    private RowKeyPredicate(Class<?> keyClass) {
        this.keyClass = keyClass;
    }

    public static RowKeyPredicate<Object> create(GSType keyType) throws GSException {
        try {
            switch (keyType) {
                case STRING: {
                    return new RowKeyPredicate<Object>(String.class);
                }
                case INTEGER: {
                    return new RowKeyPredicate<Object>(Integer.class);
                }
                case LONG: {
                    return new RowKeyPredicate<Object>(Long.class);
                }
                case TIMESTAMP: {
                    return new RowKeyPredicate<Object>(Date.class);
                }
            }
            throw new GSException(145009, "Unsupported key type (type=" + (Object)((Object)keyType) + ")");
        }
        catch (NullPointerException e) {
            throw GSErrorCode.checkNullParameter((Object)keyType, "keyType", e);
        }
    }

    public static <K> RowKeyPredicate<K> create(Class<K> keyType) throws GSException {
        if (keyType != String.class && keyType != Integer.class && keyType != Long.class && keyType != Date.class) {
            if (keyType == null) {
                throw GSErrorCode.checkNullParameter(keyType, "keyType", null);
            }
            throw new GSException(145009, "Unsupported key type (type=" + keyType + ")");
        }
        return new RowKeyPredicate<K>(keyType);
    }

    public void setStart(K startKey) throws GSException {
        if (this.distinctKeys != null) {
            throw new GSException(145002, "Distinct key has already been specified");
        }
        if (this.keyClass == String.class && startKey != null && stringRangeRestricted) {
            throw new GSException(145003, "String range is not supported");
        }
        this.keyClass.cast(startKey);
        this.start = startKey;
    }

    public void setFinish(K finishKey) throws GSException {
        if (this.distinctKeys != null) {
            throw new GSException(145002, "Distinct key has already been specified");
        }
        if (this.keyClass == String.class && finishKey != null && stringRangeRestricted) {
            throw new GSException(145003, "String range is not supported");
        }
        this.keyClass.cast(finishKey);
        this.finish = finishKey;
    }

    public void add(K key) throws GSException {
        if (this.start != null || this.finish != null) {
            throw new GSException(145002, "Start or finish key has already been specified");
        }
        this.keyClass.cast(key);
        if (key == null) {
            throw GSErrorCode.checkNullParameter(key, "key", null);
        }
        if (this.distinctKeys == null) {
            this.distinctKeys = new HashSet<K>();
        }
        this.distinctKeys.add(key);
    }

    public GSType getKeyType() {
        if (this.keyClass == String.class) {
            return GSType.STRING;
        }
        if (this.keyClass == Integer.class) {
            return GSType.INTEGER;
        }
        if (this.keyClass == Long.class) {
            return GSType.LONG;
        }
        if (this.keyClass == Date.class) {
            return GSType.TIMESTAMP;
        }
        throw new Error("Internal error by unknown key class (class=" + this.keyClass + ")");
    }

    public K getStart() {
        return this.start;
    }

    public K getFinish() {
        return this.finish;
    }

    public Collection<K> getDistinctKeys() {
        if (this.distinctKeys == null) {
            return null;
        }
        return Collections.unmodifiableCollection(this.distinctKeys);
    }
}

