/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.common;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.UUID;

public class BasicBuffer {
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final int HUGE_BUFFER_GROW_UNIT = 0x100000;
    private ByteBuffer base;

    public BasicBuffer(int initialSize) {
        this.base = ByteBuffer.allocate(initialSize);
        this.base.order(ByteOrder.LITTLE_ENDIAN);
    }

    public ByteBuffer base() {
        return this.base;
    }

    public void prepare(int size) {
        if (size <= this.base.remaining()) {
            return;
        }
        long requiredCapacity = (long)this.base.position() + (long)size;
        long newCapacity = Long.highestOneBit(requiredCapacity) << 1;
        if (newCapacity > Integer.MAX_VALUE) {
            if (requiredCapacity <= Integer.MAX_VALUE) {
                long unit = 0x100000L;
                newCapacity = Math.min(Integer.MAX_VALUE, (requiredCapacity + 0x100000L - 1L) / 0x100000L * 0x100000L);
            } else {
                throw new IllegalArgumentException("Too large size (size=" + size + ", requiredCapacity=" + requiredCapacity + ")");
            }
        }
        ByteBuffer newBuffer = ByteBuffer.allocate((int)newCapacity);
        newBuffer.order(this.base.order());
        this.base.flip();
        newBuffer.put(this.base);
        this.base = newBuffer;
    }

    public void putBoolean(boolean value) {
        this.prepare(1);
        this.base.put((byte)(value ? 1 : 0));
    }

    public void putBooleanPrepared(boolean value) {
        this.base.put((byte)(value ? 1 : 0));
    }

    public void put(byte value) {
        this.prepare(1);
        this.base.put(value);
    }

    public void putShort(short value) {
        this.prepare(2);
        this.base.putShort(value);
    }

    public void putInt(int value) {
        this.prepare(4);
        this.base.putInt(value);
    }

    public void putLong(long value) {
        this.prepare(8);
        this.base.putLong(value);
    }

    public void putFloat(float value) {
        this.prepare(4);
        this.base.putFloat(value);
    }

    public void putDouble(double value) {
        this.prepare(8);
        this.base.putDouble(value);
    }

    public void putChar(char value) {
        this.prepare(2);
        this.base.putChar(value);
    }

    public void putString(String value) {
        byte[] buf = value.getBytes(DEFAULT_CHARSET);
        this.prepare(4 + buf.length);
        this.base.putInt(buf.length);
        this.base.put(buf);
    }

    public void putDate(Date value) {
        this.putLong(value.getTime());
    }

    public void putDatePrepared(Date value) {
        this.base.putLong(value.getTime());
    }

    public void putEnum(Enum<?> value) {
        this.prepare(4);
        this.base.putInt(value.ordinal());
    }

    public void putEnumPrepared(Enum<?> value) {
        this.base.putInt(value.ordinal());
    }

    public void putByteEnum(Enum<?> value) {
        this.prepare(1);
        this.base.put((byte)(value.ordinal() & 0xFF));
    }

    public void putByteEnumPrepared(Enum<?> value) {
        this.base.put((byte)(value.ordinal() & 0xFF));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putUUID(UUID uuid) {
        this.prepare(16);
        ByteOrder orgOrder = this.base.order();
        try {
            this.base.order(ByteOrder.BIG_ENDIAN);
            long mostSigBits = uuid.getMostSignificantBits();
            long leastSigBits = uuid.getLeastSignificantBits();
            this.base.putLong(mostSigBits);
            this.base.putLong(leastSigBits);
        }
        finally {
            this.base.order(orgOrder);
        }
    }

    public boolean getBoolean() {
        return this.base.get() != 0;
    }

    public String getString() {
        byte[] buf = new byte[this.base.getInt()];
        this.base().get(buf);
        return new String(buf, 0, buf.length, DEFAULT_CHARSET);
    }

    public Date getDate() {
        return new Date(this.base.getLong());
    }

    public <E extends Enum<E>> E getEnum(Class<E> type) {
        try {
            return (E)((Enum[])type.getEnumConstants())[this.base.getInt()];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalStateException(e);
        }
    }

    public <E extends Enum<E>> E getByteEnum(Class<E> type) {
        try {
            return (E)((Enum[])type.getEnumConstants())[this.base.get() & 0xFF];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalStateException(e);
        }
    }

    public <E extends Enum<E>> E getByteEnum(E[] enumConstants) {
        try {
            return enumConstants[this.base.get() & 0xFF];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID getUUID() {
        ByteOrder orgOrder = this.base.order();
        try {
            this.base.order(ByteOrder.BIG_ENDIAN);
            long mostSigBits = this.base.getLong();
            long leastSigBits = this.base.getLong();
            UUID uUID = new UUID(mostSigBits, leastSigBits);
            return uUID;
        }
        finally {
            this.base.order(orgOrder);
        }
    }

    public void clear() {
        this.base.clear();
    }
}

