/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.common;

import com.toshiba.mwcloud.gs.AggregationResult;
import com.toshiba.mwcloud.gs.ColumnInfo;
import com.toshiba.mwcloud.gs.ContainerInfo;
import com.toshiba.mwcloud.gs.ContainerType;
import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.GSType;
import com.toshiba.mwcloud.gs.Geometry;
import com.toshiba.mwcloud.gs.QueryAnalysisEntry;
import com.toshiba.mwcloud.gs.Row;
import com.toshiba.mwcloud.gs.RowField;
import com.toshiba.mwcloud.gs.RowKey;
import com.toshiba.mwcloud.gs.TimestampUtils;
import com.toshiba.mwcloud.gs.TransientRowField;
import com.toshiba.mwcloud.gs.common.AggregationResultImpl;
import com.toshiba.mwcloud.gs.common.BasicBuffer;
import com.toshiba.mwcloud.gs.common.BlobImpl;
import com.toshiba.mwcloud.gs.common.GeometryUtils;
import com.toshiba.mwcloud.gs.common.InternPool;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.rowset.serial.SerialBlob;

public class RowMapper {
    protected static boolean acceptAggregationResultColumnId = false;
    protected static boolean restrictKeyOrderFirst = true;
    private static final RowMapper AGGREGATION_RESULT_MAPPER;
    private static final byte[] EMPTY_LONG_BYTES;
    private static final int MAX_VAR_SIZE_LENGTH = 4;
    private static final GSType[] TYPE_CONSTANTS;
    private static final BlobFactory SERIAL_BLOB_FACTORY;
    private static final Pattern METHOD_PATTERN;
    private static final Cache CACHE;
    private static final byte ANY_NULL_TYPE = -1;
    private Class<?> rowType;
    private Constructor<?> rowConstructor;
    private final Map<String, Entry> entryMap;
    private final List<Entry> entryList;
    private Entry keyEntry;
    private final boolean forTimeSeries;
    private final Set<String> transientRowFilelds = new HashSet<String>();
    private final int variableEntryCount;
    static final int VAR_SIZE_1BYTE_THRESHOLD = 128;

    private RowMapper(Class<?> rowType, Constructor<?> rowConstructor, Map<String, Entry> entryMap, List<Entry> entryList, Entry keyEntry, boolean forTimeSeries) {
        this.rowType = rowType;
        this.rowConstructor = rowConstructor;
        this.entryMap = entryMap;
        this.entryList = entryList;
        this.keyEntry = keyEntry;
        this.forTimeSeries = forTimeSeries;
        this.variableEntryCount = RowMapper.calculateVariableEntryCount(entryList);
    }

    private RowMapper(Class<?> rowType, boolean forTimeSeries) throws GSException, SecurityException {
        this.rowType = rowType;
        this.entryMap = new HashMap<String, Entry>();
        this.entryList = new ArrayList<Entry>();
        this.forTimeSeries = forTimeSeries;
        this.rowConstructor = RowMapper.getRowConstructor(rowType);
        for (Field field : rowType.getDeclaredFields()) {
            this.accept(field);
        }
        for (AccessibleObject accessibleObject : rowType.getDeclaredMethods()) {
            this.accept((Method)accessibleObject);
        }
        this.applyOrder(restrictKeyOrderFirst);
        this.checkKeyType(forTimeSeries);
        this.variableEntryCount = RowMapper.calculateVariableEntryCount(this.entryList);
    }

    private RowMapper(ContainerType containerType, ContainerInfo containerInfo, boolean anyTypeAllowed) throws GSException {
        ContainerType anotherContainerType = containerInfo.getType();
        if (anotherContainerType != null && anotherContainerType != containerType) {
            throw new GSException(145000, "Inconsistent container type");
        }
        this.rowType = Row.class;
        this.entryMap = new HashMap<String, Entry>();
        this.entryList = new ArrayList<Entry>();
        this.forTimeSeries = containerType == ContainerType.TIME_SERIES;
        this.rowConstructor = null;
        int columnCount = containerInfo.getColumnCount();
        if (columnCount <= 0 && !anyTypeAllowed) {
            throw new GSException(145023, "Empty schema");
        }
        for (int i = 0; i < columnCount; ++i) {
            this.accept(containerInfo.getColumnInfo(i), anyTypeAllowed);
        }
        if (containerInfo.isRowKeyAssigned()) {
            this.keyEntry = this.entryList.get(0);
            this.keyEntry.keyType = true;
        }
        this.checkKeyType(this.forTimeSeries);
        this.variableEntryCount = RowMapper.calculateVariableEntryCount(this.entryList);
    }

    private static int calculateVariableEntryCount(List<Entry> entryList) {
        int count = 0;
        for (Entry entry : entryList) {
            if (!RowMapper.hasVarDataPart(entry.elementType, entry.arrayUsed)) continue;
            ++count;
        }
        return count;
    }

    public static RowMapper getInstance(Class<?> rowType, boolean forTimeSeries) throws GSException, SecurityException {
        if (rowType == AggregationResult.class) {
            throw new GSException(145002, "Illegal row type");
        }
        return CACHE.getInstance(rowType, forTimeSeries);
    }

    public static RowMapper getInstance(ContainerType containerType, ContainerInfo containerInfo) throws GSException {
        return CACHE.intern(new RowMapper(containerType, containerInfo, false));
    }

    public static RowMapper getInstance(ContainerType containerType, ContainerInfo containerInfo, boolean anyTypeAllowed) throws GSException {
        return CACHE.intern(new RowMapper(containerType, containerInfo, anyTypeAllowed));
    }

    public static RowMapper getInstance(Row row) throws GSException {
        if (row instanceof ArrayRow) {
            return ((ArrayRow)row).mapper;
        }
        return RowMapper.getInstance(null, row.getSchema());
    }

    public static RowMapper getAggregationResultMapper() {
        return AGGREGATION_RESULT_MAPPER;
    }

    public static RowMapper getInstance(BasicBuffer in, boolean forTimeSeries) throws GSException {
        return RowMapper.getInstance(in, forTimeSeries, false);
    }

    public static RowMapper getInstance(BasicBuffer in, boolean forTimeSeries, boolean anyTypeAllowed) throws GSException {
        ContainerType containerType = forTimeSeries ? ContainerType.TIME_SERIES : ContainerType.COLLECTION;
        int columnCount = in.base().getInt();
        int keyIndex = in.base().getInt();
        ArrayList<ColumnInfo> columnInfoList = new ArrayList<ColumnInfo>();
        for (int i = 0; i < columnCount; ++i) {
            String columnName = in.getString();
            GSType elementType = RowMapper.getType(in);
            boolean arrayUsed = in.getBoolean();
            columnInfoList.add(new ColumnInfo((String)(columnName.isEmpty() && anyTypeAllowed ? null : columnName), RowMapper.toFullType(elementType, arrayUsed)));
        }
        return RowMapper.getInstance(containerType, new ContainerInfo(null, containerType, columnInfoList, keyIndex == 0), anyTypeAllowed);
    }

    public void checkSchemaMatched(RowMapper mapper) throws GSException {
        if (this == mapper) {
            return;
        }
        if (this.rowType == AggregationResult.class || mapper.rowType == AggregationResult.class) {
            throw new IllegalArgumentException();
        }
        if (this.entryList.size() != mapper.entryList.size()) {
            throw new GSException(145023, "");
        }
        for (int i = 0; i < this.entryList.size(); ++i) {
            Entry thisEntry = this.entryList.get(i);
            Entry entry = mapper.entryList.get(i);
            if (thisEntry.keyType ^ entry.keyType) {
                throw new GSException(145023, "");
            }
            if (thisEntry.elementType != entry.elementType) {
                throw new GSException(145023, "");
            }
            if (thisEntry.arrayUsed ^ entry.arrayUsed) {
                throw new GSException(145023, "");
            }
            if (thisEntry.columnName.equals(entry.columnName) || RowMapper.normalizeSymbol(thisEntry.columnName).equals(RowMapper.normalizeSymbol(entry.columnName))) continue;
            throw new GSException(145023, "");
        }
    }

    public RowMapper reorderBySchema(BasicBuffer in, boolean columnOrderIgnorable) throws GSException {
        Entry newKeyEntry;
        int i;
        int size = in.base().getInt();
        if (size != this.entryList.size()) {
            throw new GSException(145023, "Inconsistent remote schema (column count)");
        }
        int newKeyIndex = in.base().getInt();
        HashMap<String, Entry> newEntryMap = new HashMap<String, Entry>();
        ArrayList<Entry> newEntryList = new ArrayList<Entry>(size);
        for (i = 0; i < size; ++i) {
            newEntryList.add(null);
        }
        for (i = 0; i < size; ++i) {
            Entry newEntry = new Entry(null);
            newEntry.importColumnSchema(in, i);
            String normalizedName = RowMapper.normalizeSymbol(newEntry.columnName);
            Entry orgEntry = this.entryMap.get(normalizedName);
            if (orgEntry == null) {
                throw new GSException(145023, "Inconsistent remote schema (column not found)");
            }
            newEntry.importObjectMapping(orgEntry, columnOrderIgnorable);
            if (newEntryList.get(i) != null) {
                throw new GSException(145023, "Inconsistent remote schema (duplicate column)");
            }
            newEntryList.set(i, newEntry);
            newEntryMap.put(normalizedName, newEntry);
        }
        if (this.keyEntry == null) {
            if (newKeyIndex >= 0) {
                throw new GSException(145023, "Remote schema must not have a key");
            }
            newKeyEntry = null;
        } else {
            if (newKeyIndex < 0) {
                throw new GSException(145023, "Remote schema must have a key");
            }
            newKeyEntry = (Entry)newEntryList.get(newKeyIndex);
            String normalizedName = RowMapper.normalizeSymbol(this.keyEntry.columnName);
            if (!normalizedName.equals(RowMapper.normalizeSymbol(newKeyEntry.columnName))) {
                throw new GSException(145023, "Inconsistent remote schema (column name)");
            }
            newKeyEntry.keyType = true;
        }
        return CACHE.intern(new RowMapper(this.rowType, this.rowConstructor, newEntryMap, newEntryList, newKeyEntry, this.forTimeSeries));
    }

    public RowMapper applyResultType(Class<?> rowType) throws GSException {
        if (this.getRowType() == rowType) {
            return this;
        }
        if (rowType == AggregationResult.class) {
            return AGGREGATION_RESULT_MAPPER;
        }
        if (rowType == QueryAnalysisEntry.class) {
            return RowMapper.getInstance(QueryAnalysisEntry.class, false);
        }
        if (rowType == null) {
            return null;
        }
        throw new GSException(145002, "Unsupported result type");
    }

    public boolean hasKey() {
        return this.keyEntry != null;
    }

    public Class<?> getRowType() {
        return this.rowType;
    }

    public boolean isForTimeSeries() {
        return this.forTimeSeries;
    }

    public GSType getFieldElementType(int columnId) {
        return this.entryList.get((int)columnId).elementType;
    }

    public boolean isArray(int columnId) {
        return this.entryList.get((int)columnId).arrayUsed;
    }

    public boolean hasAnyTypeColumn() {
        for (Entry entry : this.entryList) {
            if (entry.elementType != null) continue;
            return true;
        }
        return false;
    }

    private int getVariableEntryCount() {
        return this.variableEntryCount;
    }

    public ContainerType getContainerType() {
        if (this.rowType == AggregationResult.class) {
            return null;
        }
        if (this.forTimeSeries) {
            return ContainerType.TIME_SERIES;
        }
        return ContainerType.COLLECTION;
    }

    public ContainerInfo getContainerInfo() {
        if (this.rowType == AggregationResult.class) {
            return null;
        }
        ArrayList<ColumnInfo> columnInfoList = new ArrayList<ColumnInfo>(this.entryList.size());
        for (Entry entry : this.entryList) {
            columnInfoList.add(entry.getColumnInfo());
        }
        return new ContainerInfo(null, null, columnInfoList, this.hasKey());
    }

    public void exportSchema(BasicBuffer out) throws GSException {
        if (this.rowType == AggregationResult.class) {
            throw new GSException(145000, "Unexpected row type: AggregationResult");
        }
        out.putInt(this.entryList.size());
        out.putInt(this.keyEntry == null ? -1 : this.keyEntry.order);
        for (Entry entry : this.entryList) {
            entry.exportColumnSchema(out);
        }
    }

    public int resolveColumnId(String name) throws GSException {
        Entry entry = this.entryMap.get(RowMapper.normalizeSymbol(name));
        if (entry == null) {
            throw new GSException(145008, "Unknown column: \"" + name + "\"");
        }
        return entry.order;
    }

    public Object resolveKey(Object keyObj, Object rowObj) throws GSException {
        return this.resolveKey(keyObj, rowObj, this.isGeneral());
    }

    public Object resolveKey(Object keyObj, Object rowObj, boolean general) throws GSException {
        if (keyObj != null) {
            return keyObj;
        }
        if (this.keyEntry == null) {
            throw new GSException(145024, "Row key does not exist");
        }
        return this.keyEntry.getFieldObj(rowObj, general);
    }

    public Object resolveKey(String keyString) throws GSException {
        if (this.keyEntry == null) {
            throw new GSException(145024, "Row key does not exist");
        }
        if (this.keyEntry.arrayUsed) {
            throw new GSException(145009, "Unsupported key type");
        }
        try {
            switch (this.keyEntry.elementType) {
                case STRING: {
                    return keyString;
                }
                case INTEGER: {
                    return Integer.parseInt(keyString);
                }
                case LONG: {
                    return Long.parseLong(keyString);
                }
                case TIMESTAMP: {
                    return TimestampUtils.getFormat().parse(keyString);
                }
            }
            throw new GSException(145009, "Unsupported key type");
        }
        catch (NumberFormatException e) {
            throw new GSException(145006, (Throwable)e);
        }
        catch (ParseException e) {
            throw new GSException(145006, (Throwable)e);
        }
    }

    public Row createGeneralRow() throws GSException {
        return new ArrayRow(this);
    }

    public Object createRow(boolean general) throws GSException {
        if (general || this.isGeneral()) {
            return this.createGeneralRow();
        }
        try {
            return this.rowConstructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new GSException(145000, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new GSException(145000, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new GSException(e);
        }
    }

    public void encodeKey(BasicBuffer buffer, Object keyObj, MappingMode mode) throws GSException {
        if (this.keyEntry == null) {
            throw new GSException(145024, "Row key does not exist");
        }
        if (this.keyEntry.arrayUsed) {
            throw new GSException(145009, "Unsupported key type");
        }
        RowMapper.encodeKey(buffer, keyObj, this.keyEntry.elementType, mode);
    }

    public static void encodeKey(BasicBuffer buffer, Object keyObj, GSType type, MappingMode mode) throws GSException {
        switch (type) {
            case STRING: {
                RowMapper.putString(buffer, (String)keyObj, mode == MappingMode.ROWWISE_SEPARATED_V2);
                break;
            }
            case INTEGER: {
                buffer.putInt((Integer)keyObj);
                break;
            }
            case LONG: {
                buffer.putLong((Long)keyObj);
                break;
            }
            case TIMESTAMP: {
                buffer.putDate((Date)keyObj);
                break;
            }
            default: {
                throw new GSException(145009, "Unsupported key type");
            }
        }
    }

    public Cursor createCursor(BasicBuffer buffer, MappingMode mode, int rowCount, boolean rowIdIncluded, BlobFactory blobFactory) {
        return new Cursor(buffer, mode, rowCount, rowIdIncluded, blobFactory);
    }

    public void encode(BasicBuffer buffer, MappingMode mode, Object keyObj, Object rowObj) throws GSException {
        Cursor cursor = new Cursor(buffer, mode, 1, false, null);
        this.encode(cursor, keyObj, rowObj, this.isGeneral());
    }

    public Object decode(BasicBuffer buffer, MappingMode mode, BlobFactory blobFactory) throws GSException {
        Cursor cursor = new Cursor(buffer, mode, 1, false, blobFactory);
        return this.decode(cursor, this.isGeneral());
    }

    public void encode(Cursor cursor, Object keyObj, Object rowObj) throws GSException {
        this.encode(cursor, keyObj, rowObj, this.isGeneral());
    }

    public Object decode(Cursor cursor) throws GSException {
        return this.decode(cursor, this.isGeneral());
    }

    public void encode(Cursor cursor, Object keyObj, Object rowObj, boolean general) throws GSException {
        if (this.rowType == AggregationResult.class) {
            throw new GSException(145000, "Unexpected row type: AggregationResult");
        }
        if (!this.rowType.isInstance(rowObj)) {
            if (rowObj == null) {
                throw new NullPointerException("The row object is null");
            }
            if (!general) {
                throw new ClassCastException("Inconsistent row type");
            }
        }
        if (keyObj != null && this.keyEntry == null) {
            throw new GSException(145025, "Key must not be specified");
        }
        if (this.rowType == Row.class || general) {
            RowMapper.getInstance((Row)rowObj).checkSchemaMatched(this);
        }
        cursor.beginRowOutput();
        if (cursor.getMode() == MappingMode.AGGREGATED) {
            throw new IllegalArgumentException();
        }
        for (Entry entry : this.entryList) {
            entry.encode(cursor, keyObj, rowObj, general);
        }
        cursor.endRow();
    }

    public Object decode(Cursor cursor, boolean general) throws GSException {
        Object rowObj = this.createRow(general);
        cursor.decode(general, rowObj);
        return rowObj;
    }

    public void extractSubRowSetAndCount(Cursor cursor, int rowOffset, int rowLimit, BasicBuffer out, boolean includeVarDataOffset) throws GSException {
        if (cursor.getMode() != MappingMode.ROWWISE_SEPARATED && cursor.getMode() != MappingMode.ROWWISE_SEPARATED_V2) {
            throw new IllegalArgumentException();
        }
        if (rowOffset < 0 || rowLimit <= 0 || rowOffset >= cursor.rowCount) {
            return;
        }
        int extractingCount = Math.min(cursor.rowCount - rowOffset, rowLimit);
        BasicBuffer in = cursor.buffer;
        cursor.skipRowInput(rowOffset);
        int fixedOffset = in.base().position();
        int fixedLength = this.getFixedRowPartSize(cursor.rowIdIncluded, cursor.mode) * extractingCount;
        int varOffset = this.scanVarDataStartOffset(cursor);
        cursor.skipRowInput(extractingCount - 2);
        int varLength = this.scanVarDataEndOffset(cursor) - varOffset;
        cursor.skipRowInput(-(cursor.rowIndex + 1));
        if (includeVarDataOffset) {
            out.putLong(varOffset);
        }
        out.putLong(extractingCount);
        in.base().limit(fixedOffset + fixedLength);
        in.base().position(fixedOffset);
        out.prepare(fixedLength);
        out.base().put(in.base());
        in.base().limit(cursor.varDataTop + varOffset + varLength);
        in.base().position(cursor.varDataTop + varOffset);
        out.prepare(varLength);
        out.base().put(in.base());
        in.base().position(cursor.topPos);
    }

    private int scanVarDataStartOffset(Cursor cursor) {
        BasicBuffer in = cursor.buffer;
        if (cursor.mode == MappingMode.ROWWISE_SEPARATED_V2) {
            int orgPos = in.base().position();
            if (cursor.isRowIdIncluded()) {
                in.base().getLong();
            }
            int startOffset = this.getVariableEntryCount() > 0 ? (int)in.base().getLong() : 0;
            in.base().position(orgPos);
            cursor.beginRowInput();
            for (int i = 0; i < this.entryList.size(); ++i) {
                in.base().position(in.base().position() + this.getFixedFieldPartSize(i, cursor.mode));
            }
            cursor.endRow();
            return startOffset;
        }
        int startOffset = Integer.MAX_VALUE;
        cursor.beginRowInput();
        for (Entry entry : this.entryList) {
            cursor.beginField();
            if (RowMapper.hasVarDataPart(entry.elementType, entry.arrayUsed)) {
                startOffset = Math.min(startOffset, (int)in.base().getLong());
                continue;
            }
            in.base().position(in.base().position() + this.getFixedFieldPartSize(entry.order, cursor.getMode()));
        }
        cursor.endRow();
        if (startOffset == Integer.MAX_VALUE) {
            startOffset = 0;
        }
        return startOffset;
    }

    private int scanVarDataEndOffset(Cursor cursor) {
        BasicBuffer in = cursor.buffer;
        if (cursor.mode == MappingMode.ROWWISE_SEPARATED_V2) {
            int endOffset;
            cursor.beginRowInput();
            for (int i = 0; i < this.entryList.size(); ++i) {
                in.base().position(in.base().position() + this.getFixedFieldPartSize(i, cursor.mode));
            }
            cursor.endRow();
            if (cursor.hasNext()) {
                int orgPos = in.base().position();
                if (cursor.isRowIdIncluded()) {
                    in.base().getLong();
                }
                endOffset = this.getVariableEntryCount() > 0 ? (int)in.base().getLong() : 0;
                in.base().position(orgPos);
            } else {
                endOffset = in.base().limit() - cursor.varDataTop;
            }
            return endOffset;
        }
        int endOffset = 0;
        cursor.beginRowInput();
        for (Entry entry : this.entryList) {
            cursor.beginField();
            if (RowMapper.hasVarDataPart(entry.elementType, entry.arrayUsed)) {
                int offset = (int)(in.base().getLong() - cursor.varDataBaseOffset);
                int orgPos = in.base().position();
                in.base().position(cursor.varDataTop + offset);
                int size = in.base().getInt() + 4;
                endOffset = Math.max(endOffset, offset + size);
                in.base().position(orgPos);
                continue;
            }
            in.base().position(in.base().position() + this.getFixedFieldPartSize(entry.order, cursor.getMode()));
        }
        cursor.endRow();
        return endOffset;
    }

    private boolean isGeneral() {
        return this.rowType == Row.class;
    }

    private static Constructor<?> getRowConstructor(Class<?> rowType) throws GSException {
        Constructor<?> defaultConstructor = null;
        for (Constructor<?> constructor : rowType.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != 0) continue;
            defaultConstructor = constructor;
            break;
        }
        if (defaultConstructor == null) {
            throw new GSException(145002, "Default construtor not found or specified class is non-static");
        }
        defaultConstructor.setAccessible(true);
        return defaultConstructor;
    }

    private void accept(Field field) throws GSException {
        int modifier = field.getModifiers();
        if (Modifier.isFinal(modifier) || Modifier.isPrivate(modifier) || Modifier.isStatic(modifier) || Modifier.isTransient(modifier)) {
            return;
        }
        RowField rowField = field.getAnnotation(RowField.class);
        String orgName = rowField == null || rowField.name().isEmpty() ? field.getName() : rowField.name();
        String name = RowMapper.normalizeSymbol(orgName);
        if (field.getAnnotation(TransientRowField.class) != null) {
            this.transientRowFilelds.add(name);
            return;
        }
        if (RowMapper.resolveElementType(field.getType(), false, false) == null) {
            return;
        }
        Entry entry = this.putEntry(orgName, rowField);
        if (entry.rowTypeField != null) {
            throw new GSException("Duplicate field name (" + name + ")");
        }
        entry.rowTypeField = field;
        entry.nameByField = orgName;
        entry.applyAccessibleObject(field);
        entry.setObjectType(field.getType());
        this.acceptKeyEntry(entry);
    }

    private void accept(Method method) throws GSException {
        boolean forGetter;
        Class<Object> objectType;
        int modifier = method.getModifiers();
        if (Modifier.isPrivate(modifier) || Modifier.isStatic(modifier)) {
            return;
        }
        RowField rowField = method.getAnnotation(RowField.class);
        Matcher matcher = METHOD_PATTERN.matcher(method.getName());
        if (!matcher.find()) {
            return;
        }
        String orgName = rowField == null || rowField.name().isEmpty() ? matcher.group(5) : rowField.name();
        String name = RowMapper.normalizeSymbol(orgName);
        if (method.getAnnotation(TransientRowField.class) != null) {
            this.transientRowFilelds.add(name);
            return;
        }
        if (matcher.group(2) != null) {
            if (method.getParameterTypes().length != 0) {
                return;
            }
            objectType = method.getReturnType();
            forGetter = true;
        } else if (matcher.group(3) != null) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 1) {
                return;
            }
            objectType = parameterTypes[0];
            forGetter = false;
        } else {
            if (method.getParameterTypes().length != 0 || method.getReturnType() != Boolean.TYPE) {
                return;
            }
            objectType = Boolean.TYPE;
            forGetter = true;
        }
        if (RowMapper.resolveElementType(objectType, false, false) == null) {
            return;
        }
        Entry entry = this.putEntry(orgName, rowField);
        if (forGetter) {
            if (entry.getterMethod != null) {
                throw new GSException("Duplicate getter name (" + name + ")");
            }
            entry.getterMethod = method;
            entry.nameByGetter = orgName;
        } else {
            if (entry.setterMethod != null) {
                throw new GSException("Duplicate setter name (" + name + ")");
            }
            entry.setterMethod = method;
        }
        entry.applyAccessibleObject(method);
        entry.setObjectType(objectType);
        this.acceptKeyEntry(entry);
    }

    private void accept(ColumnInfo columnInfo, boolean anyTypeAllowed) throws GSException {
        String normalizedName;
        String orgName = columnInfo.getName();
        String string = normalizedName = anyTypeAllowed && orgName == null ? orgName : RowMapper.normalizeSymbol(orgName);
        if (this.entryMap.containsKey(normalizedName)) {
            throw new GSException("Duplicate column name (" + orgName + ")");
        }
        Entry entry = new Entry(orgName);
        GSType type = columnInfo.getType();
        if (!anyTypeAllowed || type != null) {
            entry.elementType = RowMapper.toArrayElementType(type);
            if (entry.elementType == null) {
                entry.elementType = columnInfo.getType();
            } else {
                entry.arrayUsed = true;
            }
        }
        entry.order = this.entryList.size();
        if (normalizedName != null) {
            this.entryMap.put(normalizedName, entry);
        }
        this.entryList.add(entry);
    }

    private Entry putEntry(String name, RowField rowField) throws GSException {
        int order;
        Entry entry = this.entryMap.get(RowMapper.normalizeSymbol(name));
        if (entry == null) {
            entry = new Entry(name);
            this.entryMap.put(RowMapper.normalizeSymbol(name), entry);
            this.entryList.add(entry);
        }
        if (rowField != null && (order = rowField.columnNumber()) >= 0) {
            if (entry.order >= 0) {
                if (entry.order != order) {
                    throw new GSException("Illegal column number");
                }
            } else {
                entry.order = order;
                entry.orderSpecified = true;
            }
        }
        return entry;
    }

    private void acceptKeyEntry(Entry entry) throws GSException {
        if (entry.keyType) {
            if (this.keyEntry != null && this.keyEntry != entry) {
                throw new GSException(145021, "Multiple keys found");
            }
            this.keyEntry = entry;
        }
    }

    private void applyOrder(boolean keyFirst) throws GSException {
        boolean specified = false;
        Iterator<Entry> i = this.entryList.iterator();
        while (i.hasNext()) {
            Entry entry = i.next();
            String normalizedName = RowMapper.normalizeSymbol(entry.columnName);
            if (!entry.reduceByAccessors() || this.transientRowFilelds.contains(normalizedName)) {
                this.entryMap.remove(normalizedName);
                i.remove();
            }
            specified |= entry.orderSpecified;
        }
        if (this.entryList.isEmpty()) {
            throw new GSException(145023, "Empty schema");
        }
        if (!(specified || keyFirst && !this.entryList.get((int)0).keyType)) {
            int order = 0;
            for (Entry entry : this.entryList) {
                entry.order = order++;
            }
            return;
        }
        ArrayList<Entry> orgList = new ArrayList<Entry>(this.entryList);
        Collections.fill(this.entryList, null);
        int rest = orgList.size();
        for (Entry entry : orgList) {
            int order = entry.order;
            if (order < 0) continue;
            if (order >= orgList.size() || this.entryList.get(order) != null) {
                throw new GSException("Illegal order");
            }
            this.entryList.set(order, entry);
            --rest;
        }
        if (rest > 0) {
            ListIterator<Entry> it = this.entryList.listIterator();
            boolean keyConsumed = false;
            if (keyFirst && this.keyEntry != null) {
                if (this.keyEntry.order > 0) {
                    throw new GSException("Key must be first column");
                }
                while (it.next() != null) {
                }
                this.keyEntry.order = it.previousIndex();
                it.set(this.keyEntry);
                --rest;
                keyConsumed = true;
            }
            for (Entry entry : orgList) {
                if (entry == this.keyEntry && keyConsumed || entry.order >= 0) continue;
                while (it.next() != null) {
                }
                entry.order = it.previousIndex();
                it.set(entry);
                if (--rest != 0) continue;
                break;
            }
        }
        if (rest != 0) {
            throw new InternalError();
        }
        if (this.keyEntry != null && keyFirst && !this.entryList.get((int)0).keyType) {
            throw new GSException("Key must be first column");
        }
    }

    private void checkKeyType(boolean forTimeSeries) throws GSException {
        if (this.keyEntry == null) {
            if (forTimeSeries) {
                throw new GSException("Key must be required for time series");
            }
            return;
        }
        if (this.keyEntry.arrayUsed) {
            throw new GSException(145009, "Key type must not be array");
        }
        if (forTimeSeries) {
            if (this.keyEntry.elementType != GSType.TIMESTAMP) {
                throw new GSException(145009, "Illegal key type for time series: " + (Object)((Object)this.keyEntry.elementType));
            }
        } else {
            if (this.keyEntry.elementType == null) {
                throw new GSException(145009, "Key must not be any type");
            }
            switch (this.keyEntry.elementType) {
                case STRING: 
                case INTEGER: 
                case LONG: 
                case TIMESTAMP: {
                    break;
                }
                default: {
                    throw new GSException(145009, "Illegal key type for collection: " + (Object)((Object)this.keyEntry.elementType));
                }
            }
        }
    }

    private void decodeAggregation(Cursor cursor, boolean general, Object rowObj) throws GSException {
        if (this.rowType == AggregationResult.class) {
            Object value;
            if (cursor.isRowIdIncluded()) {
                throw new GSException(145011, "Illegal result type");
            }
            cursor.beginRowInput();
            BasicBuffer in = cursor.getBuffer();
            if (acceptAggregationResultColumnId) {
                in.base().getInt();
            }
            GSType type = (GSType)in.getByteEnum(TYPE_CONSTANTS);
            Object orgValue = RowMapper.getField(cursor, type, false);
            switch (type) {
                case BYTE: {
                    value = (long)((Byte)orgValue).byteValue();
                    break;
                }
                case SHORT: {
                    value = (long)((Short)orgValue).shortValue();
                    break;
                }
                case INTEGER: {
                    value = (long)((Integer)orgValue).intValue();
                    break;
                }
                case LONG: {
                    value = orgValue;
                    break;
                }
                case FLOAT: {
                    value = (double)((Float)orgValue).floatValue();
                    break;
                }
                case DOUBLE: {
                    value = orgValue;
                    break;
                }
                case TIMESTAMP: {
                    value = orgValue;
                    break;
                }
                default: {
                    throw new GSException(145010, "Unsupported aggregation result type");
                }
            }
            try {
                ((AggregationResultImpl)rowObj).setValue(value);
            }
            catch (ClassCastException e) {
                throw new GSException(145000, "Internal error by inconsistent aggregation result type", e);
            }
            return;
        }
        if (!acceptAggregationResultColumnId) {
            throw new GSException(145011, "");
        }
        cursor.beginRowInput();
        BasicBuffer in = cursor.getBuffer();
        int column = in.base().getInt();
        GSType type = (GSType)in.getByteEnum(TYPE_CONSTANTS);
        if (column < 0 || column >= this.entryList.size()) {
            if (column == -1) {
                throw new GSException(145011, "Unable to map non columnwise aggregation (ex. COUNT())");
            }
            throw new GSException(145011, "Illegal column ID");
        }
        Entry entry = this.entryList.get(column);
        if (type == entry.elementType) {
            entry.decode(cursor, rowObj, general);
        } else {
            Number fieldObj;
            Object orgValue = RowMapper.getField(cursor, type, false);
            if (!(orgValue instanceof Long) && !(orgValue instanceof Double)) {
                throw new GSException(145011, "Unacceptable result type");
            }
            switch (entry.elementType) {
                case BYTE: {
                    fieldObj = (byte)(orgValue instanceof Long ? (double)((Long)orgValue).longValue() : (Double)orgValue);
                    break;
                }
                case SHORT: {
                    fieldObj = (short)(orgValue instanceof Long ? (double)((Long)orgValue).longValue() : (Double)orgValue);
                    break;
                }
                case INTEGER: {
                    fieldObj = (int)(orgValue instanceof Long ? (double)((Long)orgValue).longValue() : (Double)orgValue);
                    break;
                }
                case LONG: {
                    fieldObj = (long)(orgValue instanceof Long ? (double)((Long)orgValue).longValue() : (Double)orgValue);
                    break;
                }
                case FLOAT: {
                    fieldObj = Float.valueOf((float)(orgValue instanceof Long ? (double)((Long)orgValue).longValue() : (Double)orgValue));
                    break;
                }
                case DOUBLE: {
                    fieldObj = orgValue instanceof Long ? (double)((Long)orgValue).longValue() : (Double)orgValue;
                    break;
                }
                default: {
                    throw new GSException(145010, "Unacceptable result type");
                }
            }
            entry.setFieldObj(rowObj, fieldObj, general);
        }
        cursor.endRow();
    }

    private int getNullsByteSize(int fieldNum) {
        return (fieldNum + 7) / 8;
    }

    private int getFixedRowPartSize(boolean rowIdIncluded, MappingMode mode) {
        int size;
        int n = size = rowIdIncluded ? 8 : 0;
        if (mode == MappingMode.ROWWISE_SEPARATED_V2) {
            size += this.getNullsByteSize(this.entryList.size());
        }
        boolean hasVarDataPart = false;
        for (Entry entry : this.entryList) {
            size += RowMapper.getFixedEncodedSize(entry.elementType, entry.arrayUsed, mode);
            if (hasVarDataPart || !RowMapper.hasVarDataPart(entry.elementType, entry.arrayUsed)) continue;
            hasVarDataPart = true;
        }
        if (mode == MappingMode.ROWWISE_SEPARATED_V2 && hasVarDataPart) {
            size += 8;
        }
        return size;
    }

    private int getFixedFieldPartSize(int columnId, MappingMode mode) {
        Entry entry = this.entryList.get(columnId);
        return RowMapper.getFixedEncodedSize(entry.elementType, entry.arrayUsed, mode);
    }

    private int getColumnCount() {
        return this.entryList.size();
    }

    private Entry getEntry(int index) {
        return this.entryList.get(index);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entryList == null ? 0 : ((Object)this.entryList).hashCode());
        result = 31 * result + (this.entryMap == null ? 0 : ((Object)this.entryMap).hashCode());
        result = 31 * result + (this.forTimeSeries ? 1231 : 1237);
        result = 31 * result + (this.keyEntry == null ? 0 : this.keyEntry.hashCode());
        result = 31 * result + (this.rowConstructor == null ? 0 : this.rowConstructor.hashCode());
        result = 31 * result + (this.rowType == null ? 0 : this.rowType.hashCode());
        result = 31 * result + (this.transientRowFilelds == null ? 0 : ((Object)this.transientRowFilelds).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RowMapper other = (RowMapper)obj;
        if (this.entryList == null ? other.entryList != null : !((Object)this.entryList).equals(other.entryList)) {
            return false;
        }
        if (this.entryMap == null ? other.entryMap != null : !((Object)this.entryMap).equals(other.entryMap)) {
            return false;
        }
        if (this.forTimeSeries != other.forTimeSeries) {
            return false;
        }
        if (this.keyEntry == null ? other.keyEntry != null : !this.keyEntry.equals(other.keyEntry)) {
            return false;
        }
        if (this.rowConstructor == null ? other.rowConstructor != null : !this.rowConstructor.equals(other.rowConstructor)) {
            return false;
        }
        if (this.rowType == null ? other.rowType != null : !this.rowType.equals(other.rowType)) {
            return false;
        }
        return !(this.transientRowFilelds == null ? other.transientRowFilelds != null : !((Object)this.transientRowFilelds).equals(other.transientRowFilelds));
    }

    private static GSType resolveElementType(Class<?> type, boolean subClassAllowed, boolean validating) throws GSException {
        Class<?> elementTypeBase = type.isArray() ? type.getComponentType() : type;
        if (elementTypeBase == Boolean.TYPE) {
            return GSType.BOOL;
        }
        if (elementTypeBase == Byte.TYPE) {
            return GSType.BYTE;
        }
        if (elementTypeBase == Short.TYPE) {
            return GSType.SHORT;
        }
        if (elementTypeBase == Integer.TYPE) {
            return GSType.INTEGER;
        }
        if (elementTypeBase == Long.TYPE) {
            return GSType.LONG;
        }
        if (elementTypeBase == Float.TYPE) {
            return GSType.FLOAT;
        }
        if (elementTypeBase == Double.TYPE) {
            return GSType.DOUBLE;
        }
        if (elementTypeBase == String.class) {
            return GSType.STRING;
        }
        if (elementTypeBase == Date.class) {
            return GSType.TIMESTAMP;
        }
        if (elementTypeBase == Geometry.class) {
            if (!validating || !type.isArray()) {
                return GSType.GEOMETRY;
            }
        } else if (elementTypeBase == Blob.class) {
            if (!validating || !type.isArray()) {
                return GSType.BLOB;
            }
        } else if (!type.isArray()) {
            if (elementTypeBase == Boolean.class) {
                return GSType.BOOL;
            }
            if (elementTypeBase == Byte.class) {
                return GSType.BYTE;
            }
            if (elementTypeBase == Short.class) {
                return GSType.SHORT;
            }
            if (elementTypeBase == Integer.class) {
                return GSType.INTEGER;
            }
            if (elementTypeBase == Long.class) {
                return GSType.LONG;
            }
            if (elementTypeBase == Float.class) {
                return GSType.FLOAT;
            }
            if (elementTypeBase == Double.class) {
                return GSType.DOUBLE;
            }
            if (subClassAllowed) {
                if (Date.class.isAssignableFrom(elementTypeBase)) {
                    return GSType.TIMESTAMP;
                }
                if (Geometry.class.isAssignableFrom(elementTypeBase)) {
                    return GSType.GEOMETRY;
                }
                if (Blob.class.isAssignableFrom(elementTypeBase)) {
                    return GSType.BLOB;
                }
            }
        }
        if (validating) {
            throw new GSException(145010, "Unsupported field type (className=" + type.getName() + ", elementClassName=" + elementTypeBase + ", arrayType=" + type.isArray() + ")");
        }
        return null;
    }

    private static void putArraySizeInfo(Cursor cursor, int elementSize, int elementCount) throws GSException {
        BasicBuffer out = cursor.buffer;
        if (cursor.getMode() == MappingMode.ROWWISE_SEPARATED_V2) {
            RowMapper.putVarSize(out, elementSize * elementCount / 8 + RowMapper.getEncodedLength(elementCount));
            RowMapper.putVarSize(out, elementCount);
        } else {
            out.putInt((32 + elementSize * elementCount) / 8);
            out.putInt(elementCount);
        }
    }

    private static void putField(Cursor cursor, Object fieldObj, GSType type, boolean arrayUsed) throws GSException {
        cursor.beginField();
        BasicBuffer out = cursor.buffer;
        if (arrayUsed) {
            cursor.beginVarDataOutput();
            switch (type) {
                case STRING: {
                    String[] rawArray = (String[])fieldObj;
                    int orgPos = out.base().position();
                    if (cursor.isVarSizeMode()) {
                        int estimatedTotalSize = rawArray.length * 32;
                        int estimatedHeadSize = RowMapper.getEncodedLength(estimatedTotalSize);
                        out.prepare(8);
                        RowMapper.putVarSizePrepared(out, estimatedTotalSize);
                        RowMapper.putVarSizePrepared(out, rawArray.length);
                        for (String element : rawArray) {
                            RowMapper.putString(out, element, true);
                        }
                        int endPos = out.base().position();
                        int totalSize = endPos - (orgPos + estimatedHeadSize);
                        int actualHeadSize = RowMapper.getEncodedLength(totalSize);
                        if (estimatedHeadSize != actualHeadSize) {
                            out.prepare(actualHeadSize - estimatedHeadSize);
                            byte[] rawBuf = out.base().array();
                            System.arraycopy(rawBuf, orgPos + estimatedHeadSize, rawBuf, orgPos + actualHeadSize, totalSize);
                            endPos = orgPos + (actualHeadSize + totalSize);
                        }
                        out.base().position(orgPos);
                        RowMapper.putVarSizePrepared(out, totalSize);
                        out.base().position(endPos);
                        break;
                    }
                    out.putInt(0);
                    out.putInt(rawArray.length);
                    for (int i = 0; i < rawArray.length; ++i) {
                        out.putString(rawArray[i]);
                    }
                    int endPos = out.base().position();
                    out.base().position(orgPos);
                    out.putInt(endPos - (orgPos + 4));
                    out.base().position(endPos);
                    break;
                }
                case BOOL: {
                    boolean[] rawArray = (boolean[])fieldObj;
                    RowMapper.putArraySizeInfo(cursor, 8, rawArray.length);
                    for (int i = 0; i < rawArray.length; ++i) {
                        out.putBoolean(rawArray[i]);
                    }
                    break;
                }
                case BYTE: {
                    byte[] rawArray = (byte[])fieldObj;
                    RowMapper.putArraySizeInfo(cursor, 8, rawArray.length);
                    out.prepare(rawArray.length);
                    out.base().put(rawArray);
                    break;
                }
                case SHORT: {
                    short[] rawArray = (short[])fieldObj;
                    RowMapper.putArraySizeInfo(cursor, 16, rawArray.length);
                    for (int i = 0; i < rawArray.length; ++i) {
                        out.putShort(rawArray[i]);
                    }
                    break;
                }
                case INTEGER: {
                    int[] rawArray = (int[])fieldObj;
                    RowMapper.putArraySizeInfo(cursor, 32, rawArray.length);
                    for (int i = 0; i < rawArray.length; ++i) {
                        out.putInt(rawArray[i]);
                    }
                    break;
                }
                case LONG: {
                    long[] rawArray = (long[])fieldObj;
                    RowMapper.putArraySizeInfo(cursor, 64, rawArray.length);
                    for (int i = 0; i < rawArray.length; ++i) {
                        out.putLong(rawArray[i]);
                    }
                    break;
                }
                case FLOAT: {
                    float[] rawArray = (float[])fieldObj;
                    RowMapper.putArraySizeInfo(cursor, 32, rawArray.length);
                    for (int i = 0; i < rawArray.length; ++i) {
                        out.putFloat(rawArray[i]);
                    }
                    break;
                }
                case DOUBLE: {
                    double[] rawArray = (double[])fieldObj;
                    RowMapper.putArraySizeInfo(cursor, 64, rawArray.length);
                    for (int i = 0; i < rawArray.length; ++i) {
                        out.putDouble(rawArray[i]);
                    }
                    break;
                }
                case TIMESTAMP: {
                    Date[] rawArray = (Date[])fieldObj;
                    RowMapper.putArraySizeInfo(cursor, 64, rawArray.length);
                    for (int i = 0; i < rawArray.length; ++i) {
                        out.putDate(rawArray[i]);
                    }
                    break;
                }
                case GEOMETRY: {
                    throw new GSException(145010, "Illegal array type");
                }
                case BLOB: {
                    throw new GSException(145010, "Illegal array type");
                }
                default: {
                    throw new InternalError();
                }
            }
            cursor.endVarData();
        } else if (type != null) {
            switch (type) {
                case STRING: {
                    cursor.beginVarDataOutput();
                    RowMapper.putString(out, (String)fieldObj, cursor.isVarSizeMode());
                    cursor.endVarData();
                    break;
                }
                case BOOL: {
                    out.putBooleanPrepared((Boolean)fieldObj);
                    break;
                }
                case BYTE: {
                    out.base().put((Byte)fieldObj);
                    break;
                }
                case SHORT: {
                    out.base().putShort((Short)fieldObj);
                    break;
                }
                case INTEGER: {
                    out.base().putInt((Integer)fieldObj);
                    break;
                }
                case LONG: {
                    out.base().putLong((Long)fieldObj);
                    break;
                }
                case FLOAT: {
                    out.base().putFloat(((Float)fieldObj).floatValue());
                    break;
                }
                case DOUBLE: {
                    out.base().putDouble((Double)fieldObj);
                    break;
                }
                case TIMESTAMP: {
                    out.putDatePrepared((Date)fieldObj);
                    break;
                }
                case GEOMETRY: {
                    cursor.beginVarDataOutput();
                    int dataSize = GeometryUtils.getBytesLength((Geometry)fieldObj);
                    if (cursor.isVarSizeMode()) {
                        RowMapper.putVarSize(out, dataSize);
                    } else {
                        out.putInt(dataSize);
                    }
                    GeometryUtils.putGeometry(out, (Geometry)fieldObj);
                    cursor.endVarData();
                    break;
                }
                case BLOB: {
                    byte[] rawArray;
                    cursor.beginVarDataOutput();
                    try {
                        if (fieldObj instanceof BlobImpl) {
                            rawArray = ((BlobImpl)fieldObj).getDataDirect();
                        } else {
                            Blob blob = (Blob)fieldObj;
                            long length = blob.length();
                            if (length > Integer.MAX_VALUE) {
                                throw new GSException("Blob size limit exceeded");
                            }
                            rawArray = length > 0L ? blob.getBytes(1L, (int)length) : new byte[]{};
                        }
                    }
                    catch (SQLException e) {
                        throw new GSException(e);
                    }
                    if (cursor.isVarSizeMode()) {
                        RowMapper.putVarSize(out, rawArray.length);
                    } else {
                        out.putInt(rawArray.length);
                    }
                    out.prepare(rawArray.length);
                    out.base().put(rawArray);
                    cursor.endVarData();
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        } else if (fieldObj == null) {
            RowMapper.putTypePrepared(out, null);
            out.base().putLong(0L);
        } else {
            Class<?> fieldClass = fieldObj.getClass();
            GSType actualElementType = RowMapper.resolveElementType(fieldClass, true, true);
            boolean actualArrayUsed = fieldClass.isArray();
            RowMapper.putTypePrepared(out, RowMapper.toFullType(actualElementType, actualArrayUsed));
            int lastPos = out.base().position();
            RowMapper.putField(cursor, fieldObj, actualElementType, actualArrayUsed);
            int fixedGap = lastPos + 8 - out.base().position();
            out.base().put(EMPTY_LONG_BYTES, 0, fixedGap);
        }
    }

    private static Object getField(Cursor cursor, GSType type, boolean arrayUsed) throws GSException {
        cursor.beginField();
        BasicBuffer in = cursor.buffer;
        if (arrayUsed) {
            Object[] result;
            int length;
            cursor.beginVarDataInput();
            if (cursor.isVarSizeMode()) {
                RowMapper.getVarSize(in);
                length = RowMapper.getVarSize(in);
            } else {
                in.base().getInt();
                length = in.base().getInt();
            }
            switch (type) {
                case STRING: {
                    String[] rawArray = new String[length];
                    for (int i = 0; i < length; ++i) {
                        rawArray[i] = RowMapper.getString(in, cursor.isVarSizeMode());
                    }
                    result = rawArray;
                    break;
                }
                case BOOL: {
                    boolean[] rawArray = new boolean[length];
                    for (int i = 0; i < length; ++i) {
                        rawArray[i] = in.getBoolean();
                    }
                    result = rawArray;
                    break;
                }
                case BYTE: {
                    byte[] rawArray = new byte[length];
                    in.base().get(rawArray);
                    result = rawArray;
                    break;
                }
                case SHORT: {
                    short[] rawArray = new short[length];
                    for (int i = 0; i < length; ++i) {
                        rawArray[i] = in.base().getShort();
                    }
                    result = rawArray;
                    break;
                }
                case INTEGER: {
                    int[] rawArray = new int[length];
                    for (int i = 0; i < length; ++i) {
                        rawArray[i] = in.base().getInt();
                    }
                    result = rawArray;
                    break;
                }
                case LONG: {
                    long[] rawArray = new long[length];
                    for (int i = 0; i < length; ++i) {
                        rawArray[i] = in.base().getLong();
                    }
                    result = rawArray;
                    break;
                }
                case FLOAT: {
                    float[] rawArray = new float[length];
                    for (int i = 0; i < length; ++i) {
                        rawArray[i] = in.base().getFloat();
                    }
                    result = rawArray;
                    break;
                }
                case DOUBLE: {
                    double[] rawArray = new double[length];
                    for (int i = 0; i < length; ++i) {
                        rawArray[i] = in.base().getDouble();
                    }
                    result = rawArray;
                    break;
                }
                case TIMESTAMP: {
                    Date[] rawArray = new Date[length];
                    for (int i = 0; i < length; ++i) {
                        rawArray[i] = in.getDate();
                    }
                    result = rawArray;
                    break;
                }
                case GEOMETRY: {
                    throw new GSException(145010, "Illegal array type");
                }
                case BLOB: {
                    throw new GSException(145010, "Illegal array type");
                }
                default: {
                    throw new InternalError();
                }
            }
            cursor.endVarData();
            return result;
        }
        if (type != null) {
            switch (type) {
                case STRING: {
                    cursor.beginVarDataInput();
                    String result = RowMapper.getString(in, cursor.isVarSizeMode());
                    cursor.endVarData();
                    return result;
                }
                case BOOL: {
                    return in.getBoolean();
                }
                case BYTE: {
                    return in.base().get();
                }
                case SHORT: {
                    return in.base().getShort();
                }
                case INTEGER: {
                    return in.base().getInt();
                }
                case LONG: {
                    return in.base().getLong();
                }
                case FLOAT: {
                    return Float.valueOf(in.base().getFloat());
                }
                case DOUBLE: {
                    return in.base().getDouble();
                }
                case TIMESTAMP: {
                    return in.getDate();
                }
                case GEOMETRY: {
                    cursor.beginVarDataInput();
                    int length = cursor.isVarSizeMode() ? RowMapper.getVarSize(in) : in.base().getInt();
                    Geometry result = GeometryUtils.getGeometry(in, length);
                    cursor.endVarData();
                    return result;
                }
                case BLOB: {
                    cursor.beginVarDataInput();
                    int length = cursor.isVarSizeMode() ? RowMapper.getVarSize(in) : in.base().getInt();
                    byte[] rawArray = new byte[length];
                    in.base().get(rawArray);
                    Blob blob = cursor.blobFactory == null ? SERIAL_BLOB_FACTORY.createBlob(rawArray) : cursor.blobFactory.createBlob(rawArray);
                    cursor.endVarData();
                    return blob;
                }
            }
            throw new InternalError();
        }
        GSType actualType = RowMapper.getType(in);
        if (actualType == null) {
            in.base().getLong();
            return null;
        }
        GSType actualElementType = RowMapper.toArrayElementType(actualType);
        boolean actualArrayUsed = actualElementType != null;
        int lastPos = in.base().position();
        Object value = RowMapper.getField(cursor, actualArrayUsed ? actualElementType : actualType, actualArrayUsed);
        int fixedGap = lastPos + 8 - in.base().position();
        if (fixedGap < 0 || fixedGap > 8) {
            throw new Error();
        }
        for (int r = fixedGap; r > 0; --r) {
            in.base().get();
        }
        return value;
    }

    private static int getFixedEncodedSize(GSType type, boolean arrayUsed, MappingMode mode) {
        if (arrayUsed) {
            if (mode == MappingMode.ROWWISE_SEPARATED_V2) {
                return 0;
            }
            return 8;
        }
        if (type != null) {
            switch (type) {
                case STRING: {
                    if (mode == MappingMode.ROWWISE_SEPARATED_V2) {
                        return 0;
                    }
                    return 8;
                }
                case BOOL: {
                    return 1;
                }
                case BYTE: {
                    return 1;
                }
                case SHORT: {
                    return 2;
                }
                case INTEGER: {
                    return 4;
                }
                case LONG: {
                    return 8;
                }
                case FLOAT: {
                    return 4;
                }
                case DOUBLE: {
                    return 8;
                }
                case TIMESTAMP: {
                    return 8;
                }
                case GEOMETRY: {
                    if (mode == MappingMode.ROWWISE_SEPARATED_V2) {
                        return 0;
                    }
                    return 8;
                }
                case BLOB: {
                    if (mode == MappingMode.ROWWISE_SEPARATED_V2) {
                        return 0;
                    }
                    return 8;
                }
            }
            throw new InternalError();
        }
        return 9;
    }

    private static void putTypePrepared(BasicBuffer out, GSType type) {
        if (type == null) {
            out.base().put((byte)-1);
        } else {
            out.putByteEnumPrepared(type);
        }
    }

    private static GSType getType(BasicBuffer in) {
        byte rawType = in.base().get();
        if (rawType == -1) {
            return null;
        }
        try {
            return TYPE_CONSTANTS[rawType & 0xFF];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalStateException(e);
        }
    }

    private static boolean hasVarDataPart(GSType type, boolean arrayUsed) {
        if (arrayUsed) {
            return true;
        }
        if (type != null) {
            switch (type) {
                case STRING: {
                    return true;
                }
                case GEOMETRY: {
                    return true;
                }
                case BLOB: {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public static GSType toFullType(GSType elementType, boolean arrayUsed) {
        if (arrayUsed) {
            switch (elementType) {
                case STRING: {
                    return GSType.STRING_ARRAY;
                }
                case BOOL: {
                    return GSType.BOOL_ARRAY;
                }
                case BYTE: {
                    return GSType.BYTE_ARRAY;
                }
                case SHORT: {
                    return GSType.SHORT_ARRAY;
                }
                case INTEGER: {
                    return GSType.INTEGER_ARRAY;
                }
                case LONG: {
                    return GSType.LONG_ARRAY;
                }
                case FLOAT: {
                    return GSType.FLOAT_ARRAY;
                }
                case DOUBLE: {
                    return GSType.DOUBLE_ARRAY;
                }
                case TIMESTAMP: {
                    return GSType.TIMESTAMP_ARRAY;
                }
            }
            throw new InternalError();
        }
        return elementType;
    }

    public static GSType toArrayElementType(GSType type) {
        switch (type) {
            case STRING_ARRAY: {
                return GSType.STRING;
            }
            case BOOL_ARRAY: {
                return GSType.BOOL;
            }
            case BYTE_ARRAY: {
                return GSType.BYTE;
            }
            case SHORT_ARRAY: {
                return GSType.SHORT;
            }
            case INTEGER_ARRAY: {
                return GSType.INTEGER;
            }
            case LONG_ARRAY: {
                return GSType.LONG;
            }
            case FLOAT_ARRAY: {
                return GSType.FLOAT;
            }
            case DOUBLE_ARRAY: {
                return GSType.DOUBLE;
            }
            case TIMESTAMP_ARRAY: {
                return GSType.TIMESTAMP;
            }
        }
        return null;
    }

    public static String normalizeSymbol(String value) throws GSException {
        return RowMapper.normalizeExtendedSymbol(value, false);
    }

    public static String normalizeExtendedSymbol(String value, boolean extend) throws GSException {
        String result = value.toLowerCase(Locale.US);
        if (result.isEmpty()) {
            throw new GSException(145001, "Empty symbol (value=\"" + value + "\")");
        }
        char[] charArray = result.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char ch = charArray[i];
            if (!('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9' || ch == '_' || extend && (ch == '@' || ch == '/' || ch == '#'))) {
                throw new GSException(145007, "Illegal char in symbol (value=\"" + value + "\")");
            }
            if (i != 0 || '0' > ch || ch > '9') continue;
            throw new GSException(145007, "Illegal char in symbol (value=\"" + value + "\")");
        }
        return result;
    }

    static final boolean varSizeIs1Byte(int val) {
        return (val & 1) == 1;
    }

    static final boolean varSizeIs4Byte(int val) {
        return (val & 3) == 0;
    }

    static final boolean varSizeIsOId(int val) {
        return (val & 3) == 2;
    }

    static final boolean varSizeIs1Byte(byte val) {
        return (val & 1) == 1;
    }

    static final boolean varSizeIs4Byte(byte val) {
        return (val & 3) == 0;
    }

    static final boolean varSizeIsOId(byte val) {
        return (val & 3) == 2;
    }

    static final int decode1ByteVarSize(int val) {
        return (val & 0xFF) >>> 1;
    }

    static final int decode4ByteVarSize(int val) {
        return val >>> 2;
    }

    static final long decode8ByteVarSize(long val) {
        return val >>> 2;
    }

    static final int encode1ByteVarSize(int val) {
        return val << 1 | 1;
    }

    static final int encode4ByteVarSize(int val) {
        return val << 2;
    }

    static final long encode8ByteVarSize(long val) {
        return val << 2 | 2L;
    }

    static final int encodeVarSize(int val) {
        if (val < 128) {
            return val << 1 | 1;
        }
        return val << 2;
    }

    static final long encodeVarSizeOId(long val) {
        return val << 2 | 2L;
    }

    static final int getEncodedLength(int val) {
        if (val < 128) {
            return 1;
        }
        return 4;
    }

    public static void putSize(BasicBuffer out, int value, MappingMode mode) {
        if (mode == MappingMode.ROWWISE_SEPARATED_V2) {
            RowMapper.putVarSize(out, value);
        } else {
            out.putInt(value);
        }
    }

    static final void putVarSize(BasicBuffer out, int value) {
        if (value < 128) {
            out.put((byte)RowMapper.encode1ByteVarSize(value));
        } else {
            out.putInt(RowMapper.encode4ByteVarSize(value));
        }
    }

    static void putVarSizePrepared(BasicBuffer out, int value) {
        if (value < 128) {
            out.base().put((byte)RowMapper.encode1ByteVarSize(value));
        } else {
            out.base().putInt(RowMapper.encode4ByteVarSize(value));
        }
    }

    static final int getVarSize(BasicBuffer in) {
        byte first = in.base().get();
        if (RowMapper.varSizeIs1Byte(first)) {
            return RowMapper.decode1ByteVarSize(first);
        }
        if (RowMapper.varSizeIs4Byte(first)) {
            in.base().position(in.base().position() - 1);
            int rawSize = in.base().getInt();
            return RowMapper.decode4ByteVarSize(rawSize);
        }
        throw new RuntimeException();
    }

    static void putString(BasicBuffer out, String value, boolean varSizeMode) {
        if (varSizeMode) {
            byte[] buf = value.getBytes(BasicBuffer.DEFAULT_CHARSET);
            out.prepare(4 + buf.length);
            RowMapper.putVarSizePrepared(out, buf.length);
            out.base().put(buf);
        } else {
            out.putString(value);
        }
    }

    static String getString(BasicBuffer in, boolean varSizeMode) {
        int bytesLength = varSizeMode ? RowMapper.getVarSize(in) : in.base().getInt();
        byte[] buf = new byte[bytesLength];
        in.base().get(buf);
        return new String(buf, 0, buf.length, BasicBuffer.DEFAULT_CHARSET);
    }

    static {
        try {
            AGGREGATION_RESULT_MAPPER = new RowMapper(AggregationResult.class, AggregationResultImpl.class.getConstructor(new Class[0]), Collections.<String, Entry>emptyMap(), Collections.<Entry>emptyList(), null, false);
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
        EMPTY_LONG_BYTES = new byte[8];
        TYPE_CONSTANTS = GSType.values();
        SERIAL_BLOB_FACTORY = new BlobFactory(){

            @Override
            public Blob createBlob(byte[] data) throws GSException {
                try {
                    return new SerialBlob(data);
                }
                catch (SQLException e) {
                    throw new Error(e);
                }
            }
        };
        METHOD_PATTERN = Pattern.compile("^((get)|(set)|(is))(.+)$");
        CACHE = new Cache();
    }

    public static class Tool {
        private Tool() {
        }

        public static Class<?> getRowType(RowMapper mapper) {
            return mapper.getRowType();
        }

        public static ContainerInfo getContainerSchema(RowMapper mapper) {
            return mapper.getContainerInfo();
        }

        public static RowMapper resolveMapper(ContainerInfo containerSchema) throws GSException {
            return RowMapper.getInstance(containerSchema.getType(), containerSchema);
        }

        public static int getColumnCount(RowMapper mapper) {
            return mapper.getColumnCount();
        }

        public static String getColumnName(RowMapper mapper, int index) {
            return ((RowMapper)mapper).getEntry((int)index).columnName;
        }

        public static GSType getElementType(RowMapper mapper, int index) {
            return ((RowMapper)mapper).getEntry((int)index).elementType;
        }

        public static boolean isArrayColumn(RowMapper mapper, int index) {
            return ((RowMapper)mapper).getEntry((int)index).arrayUsed;
        }

        public static int getKeyColumnId(RowMapper mapper) {
            for (int i = 0; i < mapper.getColumnCount(); ++i) {
                if (!((RowMapper)mapper).getEntry((int)i).keyType) continue;
                return i;
            }
            return -1;
        }

        public static Object createRowObject(RowMapper mapper) throws GSException {
            return mapper.createRow(mapper.isGeneral());
        }

        public static Object getFieldObj(RowMapper mapper, int index, Object rowObj) throws GSException {
            return mapper.getEntry(index).getFieldObj(rowObj, mapper.isGeneral());
        }

        public static void setFieldObj(RowMapper mapper, int index, Object rowObj, Object fieldObj) throws GSException {
            mapper.getEntry(index).setFieldObj(rowObj, fieldObj, mapper.isGeneral());
        }

        public static GSType getAnyValueType(Row generatedRow, int column) throws GSException {
            Object value = !(generatedRow instanceof ArrayRow) ? generatedRow.getValue(column) : ((ArrayRow)generatedRow).getValueDirect(column);
            if (value == null) {
                return null;
            }
            return RowMapper.resolveElementType(value.getClass(), true, false);
        }
    }

    private static class Cache {
        private final Map<Class<?>, RowMapper> timeSeriesMap = new WeakHashMap();
        private final Map<Class<?>, RowMapper> collectionMap = new WeakHashMap();
        private final InternPool<RowMapper> internPool = new InternPool();

        private Cache() {
        }

        synchronized RowMapper getInstance(Class<?> rowType, boolean forTimeSeries) throws GSException {
            Map<Class<?>, RowMapper> map = forTimeSeries ? this.timeSeriesMap : this.collectionMap;
            RowMapper mapper = map.get(rowType);
            if (mapper == null) {
                mapper = new RowMapper(rowType, forTimeSeries);
                map.put(rowType, mapper);
                this.internPool.intern(mapper);
            }
            return mapper;
        }

        synchronized RowMapper intern(RowMapper mapper) {
            return this.internPool.intern(mapper);
        }
    }

    private static class ArrayRow
    implements Row {
        private final RowMapper mapper;
        private final Object[] fieldArray;

        ArrayRow(RowMapper mapper) throws GSException {
            if (mapper.getContainerType() == null) {
                throw new GSException(145003, "");
            }
            this.mapper = mapper;
            this.fieldArray = new Object[mapper.getColumnCount()];
        }

        private Object getInitialValue(int column) throws GSException {
            Entry entry = (Entry)this.mapper.entryList.get(column);
            if (entry.arrayUsed) {
                switch (entry.elementType) {
                    case STRING: {
                        return new String[0];
                    }
                    case BOOL: {
                        return new boolean[0];
                    }
                    case BYTE: {
                        return new byte[0];
                    }
                    case SHORT: {
                        return new short[0];
                    }
                    case INTEGER: {
                        return new int[0];
                    }
                    case LONG: {
                        return new long[0];
                    }
                    case FLOAT: {
                        return new float[0];
                    }
                    case DOUBLE: {
                        return new double[0];
                    }
                    case TIMESTAMP: {
                        return new Date[0];
                    }
                }
                throw new InternalError();
            }
            if (entry.elementType != null) {
                switch (entry.elementType) {
                    case STRING: {
                        return "";
                    }
                    case BOOL: {
                        return false;
                    }
                    case BYTE: {
                        return (byte)0;
                    }
                    case SHORT: {
                        return (short)0;
                    }
                    case INTEGER: {
                        return 0;
                    }
                    case LONG: {
                        return 0L;
                    }
                    case FLOAT: {
                        return Float.valueOf(0.0f);
                    }
                    case DOUBLE: {
                        return 0.0;
                    }
                    case TIMESTAMP: {
                        return new Date(0L);
                    }
                    case GEOMETRY: {
                        return Geometry.valueOf("POINT(EMPTY)");
                    }
                    case BLOB: {
                        return SERIAL_BLOB_FACTORY.createBlob(new byte[0]);
                    }
                }
                throw new InternalError();
            }
            return null;
        }

        private void checkPrimitiveType(int column, GSType elementType) throws GSException {
            Entry entry;
            try {
                entry = (Entry)this.mapper.entryList.get(column);
            }
            catch (IndexOutOfBoundsException e) {
                throw new GSException(145002, "", e);
            }
            if (entry.arrayUsed || elementType != entry.elementType) {
                throw new GSException(145002, "");
            }
        }

        private void checkArrayType(int column, GSType elementType) throws GSException {
            Entry entry;
            try {
                entry = (Entry)this.mapper.entryList.get(column);
            }
            catch (IndexOutOfBoundsException e) {
                throw new GSException(145002, "", e);
            }
            if (!entry.arrayUsed || elementType != entry.elementType) {
                throw new GSException(145002, "");
            }
        }

        private void setValueDirect(int column, Object fieldValue) throws GSException {
            try {
                if (fieldValue == null && ((Entry)((RowMapper)this.mapper).entryList.get((int)column)).elementType != null) {
                    throw new GSException(145001, "");
                }
                this.fieldArray[column] = fieldValue;
            }
            catch (IndexOutOfBoundsException e) {
                throw new GSException(145002, (Throwable)e);
            }
        }

        private Object getValueDirect(int column) throws GSException {
            Object fieldValue;
            try {
                fieldValue = this.fieldArray[column];
            }
            catch (IndexOutOfBoundsException e) {
                throw new GSException(145002, (Throwable)e);
            }
            if (fieldValue == null) {
                return this.getInitialValue(column);
            }
            return fieldValue;
        }

        private void setNonNullValueDirect(int column, Object fieldValue) throws GSException {
            try {
                this.fieldArray[column] = fieldValue;
            }
            catch (IndexOutOfBoundsException e) {
                throw new GSException(145002, (Throwable)e);
            }
        }

        private void checkObjectArrayElements(Object[] arrayElements) throws GSException {
            for (Object element : arrayElements) {
                if (element != null) continue;
                throw new GSException(145001, "");
            }
        }

        private Blob tryCopyBlob(Blob src) throws GSException {
            if (src == null) {
                return null;
            }
            try {
                if (src.length() == 0L) {
                    return SERIAL_BLOB_FACTORY.createBlob(new byte[0]);
                }
                return new SerialBlob(src);
            }
            catch (SQLException e) {
                throw new GSException(e);
            }
        }

        @Override
        public ContainerInfo getSchema() throws GSException {
            return this.mapper.getContainerInfo();
        }

        @Override
        public void setValue(int column, Object fieldValue) throws GSException {
            boolean typeMatched;
            block31: {
                block32: {
                    Entry entry;
                    block30: {
                        try {
                            entry = (Entry)this.mapper.entryList.get(column);
                        }
                        catch (IndexOutOfBoundsException e) {
                            throw new GSException(145002, "", e);
                        }
                        if (!entry.arrayUsed) break block30;
                        switch (entry.elementType) {
                            case STRING: {
                                if (!(fieldValue instanceof String[])) break;
                                this.setStringArray(column, (String[])fieldValue);
                                return;
                            }
                            case BOOL: {
                                if (!(fieldValue instanceof boolean[])) break;
                                this.setBoolArray(column, (boolean[])fieldValue);
                                return;
                            }
                            case BYTE: {
                                if (!(fieldValue instanceof byte[])) break;
                                this.setByteArray(column, (byte[])fieldValue);
                                return;
                            }
                            case SHORT: {
                                if (!(fieldValue instanceof short[])) break;
                                this.setShortArray(column, (short[])fieldValue);
                                return;
                            }
                            case INTEGER: {
                                if (!(fieldValue instanceof int[])) break;
                                this.setIntegerArray(column, (int[])fieldValue);
                                return;
                            }
                            case LONG: {
                                if (!(fieldValue instanceof long[])) break;
                                this.setLongArray(column, (long[])fieldValue);
                                return;
                            }
                            case FLOAT: {
                                if (!(fieldValue instanceof float[])) break;
                                this.setFloatArray(column, (float[])fieldValue);
                                return;
                            }
                            case DOUBLE: {
                                if (!(fieldValue instanceof double[])) break;
                                this.setDoubleArray(column, (double[])fieldValue);
                                return;
                            }
                            case TIMESTAMP: {
                                if (!(fieldValue instanceof Date[])) break;
                                this.setTimestampArray(column, (Date[])fieldValue);
                                return;
                            }
                            default: {
                                throw new InternalError();
                            }
                        }
                        typeMatched = false;
                        break block31;
                    }
                    if (entry.elementType == null) break block32;
                    switch (entry.elementType) {
                        case STRING: {
                            typeMatched = fieldValue instanceof String;
                            break block31;
                        }
                        case BOOL: {
                            typeMatched = fieldValue instanceof Boolean;
                            break block31;
                        }
                        case BYTE: {
                            typeMatched = fieldValue instanceof Byte;
                            break block31;
                        }
                        case SHORT: {
                            typeMatched = fieldValue instanceof Short;
                            break block31;
                        }
                        case INTEGER: {
                            typeMatched = fieldValue instanceof Integer;
                            break block31;
                        }
                        case LONG: {
                            typeMatched = fieldValue instanceof Long;
                            break block31;
                        }
                        case FLOAT: {
                            typeMatched = fieldValue instanceof Float;
                            break block31;
                        }
                        case DOUBLE: {
                            typeMatched = fieldValue instanceof Double;
                            break block31;
                        }
                        case TIMESTAMP: {
                            typeMatched = fieldValue instanceof Date;
                            break block31;
                        }
                        case GEOMETRY: {
                            typeMatched = fieldValue instanceof Geometry;
                            break block31;
                        }
                        case BLOB: {
                            if (fieldValue instanceof Blob) {
                                this.setBlob(column, (Blob)fieldValue);
                                return;
                            }
                            typeMatched = false;
                            break block31;
                        }
                        default: {
                            throw new InternalError();
                        }
                    }
                }
                if (fieldValue != null) {
                    RowMapper.resolveElementType(fieldValue.getClass(), true, true);
                }
                typeMatched = true;
            }
            if (!typeMatched) {
                if (fieldValue == null) {
                    throw new GSException(145001, "");
                }
                throw new GSException(145002, "");
            }
            this.setValueDirect(column, fieldValue);
        }

        @Override
        public Object getValue(int column) throws GSException {
            Entry entry;
            try {
                entry = (Entry)this.mapper.entryList.get(column);
            }
            catch (IndexOutOfBoundsException e) {
                throw new GSException(145002, "", e);
            }
            if (entry.arrayUsed) {
                switch (entry.elementType) {
                    case STRING: {
                        return this.getStringArray(column);
                    }
                    case BOOL: {
                        return this.getBoolArray(column);
                    }
                    case BYTE: {
                        return this.getByteArray(column);
                    }
                    case SHORT: {
                        return this.getShortArray(column);
                    }
                    case INTEGER: {
                        return this.getIntegerArray(column);
                    }
                    case LONG: {
                        return this.getLongArray(column);
                    }
                    case FLOAT: {
                        return this.getFloatArray(column);
                    }
                    case DOUBLE: {
                        return this.getDoubleArray(column);
                    }
                    case TIMESTAMP: {
                        return this.getTimestampArray(column);
                    }
                }
                throw new InternalError();
            }
            if (entry.elementType == GSType.BLOB) {
                return this.getBlob(column);
            }
            return this.getValueDirect(column);
        }

        @Override
        public void setString(int column, String fieldValue) throws GSException {
            this.checkPrimitiveType(column, GSType.STRING);
            this.setValueDirect(column, fieldValue);
        }

        @Override
        public String getString(int column) throws GSException {
            this.checkPrimitiveType(column, GSType.STRING);
            return (String)this.getValueDirect(column);
        }

        @Override
        public void setBool(int column, boolean fieldValue) throws GSException {
            this.checkPrimitiveType(column, GSType.BOOL);
            this.setValueDirect(column, fieldValue);
        }

        @Override
        public boolean getBool(int column) throws GSException {
            this.checkPrimitiveType(column, GSType.BOOL);
            return (Boolean)this.getValueDirect(column);
        }

        @Override
        public void setByte(int column, byte fieldValue) throws GSException {
            this.checkPrimitiveType(column, GSType.BYTE);
            this.setValueDirect(column, fieldValue);
        }

        @Override
        public byte getByte(int column) throws GSException {
            this.checkPrimitiveType(column, GSType.BYTE);
            return (Byte)this.getValueDirect(column);
        }

        @Override
        public void setShort(int column, short fieldValue) throws GSException {
            this.checkPrimitiveType(column, GSType.SHORT);
            this.setValueDirect(column, fieldValue);
        }

        @Override
        public short getShort(int column) throws GSException {
            this.checkPrimitiveType(column, GSType.SHORT);
            return (Short)this.getValueDirect(column);
        }

        @Override
        public void setInteger(int column, int fieldValue) throws GSException {
            this.checkPrimitiveType(column, GSType.INTEGER);
            this.setValueDirect(column, fieldValue);
        }

        @Override
        public int getInteger(int column) throws GSException {
            this.checkPrimitiveType(column, GSType.INTEGER);
            return (Integer)this.getValueDirect(column);
        }

        @Override
        public void setLong(int column, long fieldValue) throws GSException {
            this.checkPrimitiveType(column, GSType.LONG);
            this.setValueDirect(column, fieldValue);
        }

        @Override
        public long getLong(int column) throws GSException {
            this.checkPrimitiveType(column, GSType.LONG);
            return (Long)this.getValueDirect(column);
        }

        @Override
        public void setFloat(int column, float fieldValue) throws GSException {
            this.checkPrimitiveType(column, GSType.FLOAT);
            this.setValueDirect(column, Float.valueOf(fieldValue));
        }

        @Override
        public float getFloat(int column) throws GSException {
            this.checkPrimitiveType(column, GSType.FLOAT);
            return ((Float)this.getValueDirect(column)).floatValue();
        }

        @Override
        public void setDouble(int column, double fieldValue) throws GSException {
            this.checkPrimitiveType(column, GSType.DOUBLE);
            this.setValueDirect(column, fieldValue);
        }

        @Override
        public double getDouble(int column) throws GSException {
            this.checkPrimitiveType(column, GSType.DOUBLE);
            return (Double)this.getValueDirect(column);
        }

        @Override
        public void setTimestamp(int column, Date fieldValue) throws GSException {
            this.checkPrimitiveType(column, GSType.TIMESTAMP);
            this.setValueDirect(column, fieldValue);
        }

        @Override
        public Date getTimestamp(int column) throws GSException {
            this.checkPrimitiveType(column, GSType.TIMESTAMP);
            return (Date)this.getValueDirect(column);
        }

        @Override
        public void setGeometry(int column, Geometry fieldValue) throws GSException {
            this.checkPrimitiveType(column, GSType.GEOMETRY);
            this.setValueDirect(column, fieldValue);
        }

        @Override
        public Geometry getGeometry(int column) throws GSException {
            this.checkPrimitiveType(column, GSType.GEOMETRY);
            return (Geometry)this.getValueDirect(column);
        }

        @Override
        public void setBlob(int column, Blob fieldValue) throws GSException {
            this.checkPrimitiveType(column, GSType.BLOB);
            this.setValueDirect(column, this.tryCopyBlob(fieldValue));
        }

        @Override
        public Blob getBlob(int column) throws GSException {
            this.checkPrimitiveType(column, GSType.BLOB);
            if (this.fieldArray[column] == null) {
                return (Blob)this.getInitialValue(column);
            }
            return this.tryCopyBlob((Blob)this.getValueDirect(column));
        }

        @Override
        public void setStringArray(int column, String[] fieldValue) throws GSException {
            this.checkArrayType(column, GSType.STRING);
            if (fieldValue == null) {
                this.setValueDirect(column, null);
                return;
            }
            this.checkObjectArrayElements(fieldValue);
            String[] dest = new String[fieldValue.length];
            System.arraycopy(fieldValue, 0, dest, 0, fieldValue.length);
            this.setNonNullValueDirect(column, dest);
        }

        @Override
        public String[] getStringArray(int column) throws GSException {
            this.checkArrayType(column, GSType.STRING);
            String[] src = (String[])this.getValueDirect(column);
            String[] dest = new String[src.length];
            System.arraycopy(src, 0, dest, 0, src.length);
            return dest;
        }

        @Override
        public void setBoolArray(int column, boolean[] fieldValue) throws GSException {
            this.checkArrayType(column, GSType.BOOL);
            if (fieldValue == null) {
                this.setValueDirect(column, null);
                return;
            }
            boolean[] dest = new boolean[fieldValue.length];
            System.arraycopy(fieldValue, 0, dest, 0, fieldValue.length);
            this.setNonNullValueDirect(column, dest);
        }

        @Override
        public boolean[] getBoolArray(int column) throws GSException {
            this.checkArrayType(column, GSType.BOOL);
            boolean[] src = (boolean[])this.getValueDirect(column);
            boolean[] dest = new boolean[src.length];
            System.arraycopy(src, 0, dest, 0, src.length);
            return dest;
        }

        @Override
        public void setByteArray(int column, byte[] fieldValue) throws GSException {
            this.checkArrayType(column, GSType.BYTE);
            if (fieldValue == null) {
                this.setValueDirect(column, null);
                return;
            }
            byte[] dest = new byte[fieldValue.length];
            System.arraycopy(fieldValue, 0, dest, 0, fieldValue.length);
            this.setNonNullValueDirect(column, dest);
        }

        @Override
        public byte[] getByteArray(int column) throws GSException {
            this.checkArrayType(column, GSType.BYTE);
            byte[] src = (byte[])this.getValueDirect(column);
            byte[] dest = new byte[src.length];
            System.arraycopy(src, 0, dest, 0, src.length);
            return dest;
        }

        @Override
        public void setShortArray(int column, short[] fieldValue) throws GSException {
            this.checkArrayType(column, GSType.SHORT);
            if (fieldValue == null) {
                this.setValueDirect(column, null);
                return;
            }
            short[] dest = new short[fieldValue.length];
            System.arraycopy(fieldValue, 0, dest, 0, fieldValue.length);
            this.setNonNullValueDirect(column, dest);
        }

        @Override
        public short[] getShortArray(int column) throws GSException {
            this.checkArrayType(column, GSType.SHORT);
            short[] src = (short[])this.getValueDirect(column);
            short[] dest = new short[src.length];
            System.arraycopy(src, 0, dest, 0, src.length);
            return dest;
        }

        @Override
        public void setIntegerArray(int column, int[] fieldValue) throws GSException {
            this.checkArrayType(column, GSType.INTEGER);
            if (fieldValue == null) {
                this.setValueDirect(column, null);
                return;
            }
            int[] dest = new int[fieldValue.length];
            System.arraycopy(fieldValue, 0, dest, 0, fieldValue.length);
            this.setNonNullValueDirect(column, dest);
        }

        @Override
        public int[] getIntegerArray(int column) throws GSException {
            this.checkArrayType(column, GSType.INTEGER);
            int[] src = (int[])this.getValueDirect(column);
            int[] dest = new int[src.length];
            System.arraycopy(src, 0, dest, 0, src.length);
            return dest;
        }

        @Override
        public void setLongArray(int column, long[] fieldValue) throws GSException {
            this.checkArrayType(column, GSType.LONG);
            if (fieldValue == null) {
                this.setValueDirect(column, null);
                return;
            }
            long[] dest = new long[fieldValue.length];
            System.arraycopy(fieldValue, 0, dest, 0, fieldValue.length);
            this.setNonNullValueDirect(column, dest);
        }

        @Override
        public long[] getLongArray(int column) throws GSException {
            this.checkArrayType(column, GSType.LONG);
            long[] src = (long[])this.getValueDirect(column);
            long[] dest = new long[src.length];
            System.arraycopy(src, 0, dest, 0, src.length);
            return dest;
        }

        @Override
        public void setFloatArray(int column, float[] fieldValue) throws GSException {
            this.checkArrayType(column, GSType.FLOAT);
            if (fieldValue == null) {
                this.setValueDirect(column, null);
                return;
            }
            float[] dest = new float[fieldValue.length];
            System.arraycopy(fieldValue, 0, dest, 0, fieldValue.length);
            this.setNonNullValueDirect(column, dest);
        }

        @Override
        public float[] getFloatArray(int column) throws GSException {
            this.checkArrayType(column, GSType.FLOAT);
            float[] src = (float[])this.getValueDirect(column);
            float[] dest = new float[src.length];
            System.arraycopy(src, 0, dest, 0, src.length);
            return dest;
        }

        @Override
        public void setDoubleArray(int column, double[] fieldValue) throws GSException {
            this.checkArrayType(column, GSType.DOUBLE);
            if (fieldValue == null) {
                this.setValueDirect(column, null);
                return;
            }
            double[] dest = new double[fieldValue.length];
            System.arraycopy(fieldValue, 0, dest, 0, fieldValue.length);
            this.setNonNullValueDirect(column, dest);
        }

        @Override
        public double[] getDoubleArray(int column) throws GSException {
            this.checkArrayType(column, GSType.DOUBLE);
            double[] src = (double[])this.getValueDirect(column);
            double[] dest = new double[src.length];
            System.arraycopy(src, 0, dest, 0, src.length);
            return dest;
        }

        @Override
        public void setTimestampArray(int column, Date[] fieldValue) throws GSException {
            this.checkArrayType(column, GSType.TIMESTAMP);
            if (fieldValue == null) {
                this.setValueDirect(column, null);
                return;
            }
            this.checkObjectArrayElements(fieldValue);
            Date[] dest = new Date[fieldValue.length];
            System.arraycopy(fieldValue, 0, dest, 0, fieldValue.length);
            this.setNonNullValueDirect(column, dest);
        }

        @Override
        public Date[] getTimestampArray(int column) throws GSException {
            this.checkArrayType(column, GSType.TIMESTAMP);
            Date[] src = (Date[])this.getValueDirect(column);
            Date[] dest = new Date[src.length];
            System.arraycopy(src, 0, dest, 0, src.length);
            return dest;
        }
    }

    public class Cursor {
        private BasicBuffer buffer;
        private final int rowCount;
        private final MappingMode mode;
        private final boolean rowIdIncluded;
        private final BlobFactory blobFactory;
        private int rowIndex = -1;
        private int fieldIndex = -1;
        private final int topPos;
        private final int varDataTop;
        private int partialVarDataOffset;
        private int varDataLast;
        private int pendingPos = -1;
        private long lastRowId = -1L;
        private long varDataBaseOffset;
        private int nullsByteSize;

        private Cursor(BasicBuffer buffer, MappingMode mode, int rowCount, boolean rowIdIncluded, BlobFactory blobFactory) {
            this.buffer = buffer;
            this.mode = mode;
            this.rowCount = rowCount;
            this.rowIdIncluded = rowIdIncluded;
            this.blobFactory = blobFactory;
            this.topPos = buffer.base().position();
            switch (mode) {
                case ROWWISE_SEPARATED: {
                    this.varDataTop = this.topPos + RowMapper.this.getFixedRowPartSize(rowIdIncluded, mode) * rowCount;
                    break;
                }
                case ROWWISE_SEPARATED_V2: {
                    this.varDataTop = this.topPos + RowMapper.this.getFixedRowPartSize(rowIdIncluded, mode) * rowCount;
                    this.nullsByteSize = RowMapper.this.getNullsByteSize(RowMapper.this.entryList.size());
                    break;
                }
                case COLUMNWISE_SEPARATED: {
                    if (rowIdIncluded) {
                        throw new IllegalArgumentException();
                    }
                    this.varDataTop = this.topPos + RowMapper.this.getFixedRowPartSize(false, mode) * rowCount;
                    break;
                }
                default: {
                    this.varDataTop = -1;
                }
            }
            this.varDataLast = this.varDataTop;
            this.partialVarDataOffset = 0;
        }

        public void setVarDataBaseOffset(long varDataBaseOffset) {
            this.varDataBaseOffset = varDataBaseOffset;
        }

        public int getRowCount() {
            return this.rowCount;
        }

        public long getLastRowId() {
            return this.lastRowId;
        }

        public void setRowId(long rowId) {
            this.lastRowId = rowId;
        }

        public boolean isRowIdIncluded() {
            return this.rowIdIncluded;
        }

        public boolean hasNext() {
            return this.rowIndex + 1 < this.rowCount;
        }

        public boolean isInRange() {
            return 0 <= this.rowIndex && this.rowIndex < this.rowCount;
        }

        public void reset() {
            this.rowIndex = -1;
            this.fieldIndex = -1;
            this.buffer.base().position(this.topPos);
            if (this.varDataTop >= 0) {
                this.buffer.base().limit(this.varDataTop);
            }
            this.varDataLast = this.varDataTop;
            this.partialVarDataOffset = 0;
            this.pendingPos = -1;
            this.lastRowId = -1L;
        }

        public void resetBuffer() {
            this.buffer = null;
        }

        public void decode(boolean general, Object rowObj) throws GSException {
            if (this.mode == MappingMode.AGGREGATED) {
                RowMapper.this.decodeAggregation(this, general, rowObj);
            } else {
                if (RowMapper.this.rowType == AggregationResult.class) {
                    throw new GSException(145000, "Unexpected row type: AggregationResult");
                }
                this.beginRowInput();
                for (Entry entry : RowMapper.this.entryList) {
                    entry.decode(this, rowObj, general);
                }
                this.endRow();
            }
        }

        public int getRowIndex() {
            return this.rowIndex;
        }

        private BasicBuffer getBuffer() {
            return this.buffer;
        }

        private MappingMode getMode() {
            return this.mode;
        }

        private boolean isVarSizeMode() {
            return this.mode == MappingMode.ROWWISE_SEPARATED_V2;
        }

        private void prepareOutput() {
            int limit = this.buffer.base().limit();
            if (limit < this.varDataTop) {
                this.buffer.prepare(this.varDataTop - this.buffer.base().position());
            }
        }

        private void skipRowInput(int skipCount) {
            if (this.rowIndex + skipCount < -1) {
                throw new IllegalStateException();
            }
            if (this.mode == MappingMode.COLUMNWISE_SEPARATED && this.rowIdIncluded) {
                throw new IllegalStateException();
            }
            this.rowIndex += skipCount;
            this.buffer.base().position(this.topPos + RowMapper.this.getFixedRowPartSize(this.rowIdIncluded, this.mode) * (this.rowIndex + 1));
        }

        private void beginRowInput() {
            ++this.rowIndex;
            this.fieldIndex = -1;
            if (this.rowIdIncluded) {
                this.lastRowId = this.buffer.base().getLong();
            }
            if (this.mode == MappingMode.ROWWISE_SEPARATED_V2) {
                if (RowMapper.this.getVariableEntryCount() > 0) {
                    long varDataOffset = this.buffer.base().getLong();
                    if (this.rowIndex == 0) {
                        this.partialVarDataOffset = (int)varDataOffset;
                    }
                    this.varDataLast = this.varDataTop + (int)varDataOffset - this.partialVarDataOffset;
                    int savePos = this.buffer.base().position();
                    this.buffer.base().position(this.varDataLast);
                    int elemCount = RowMapper.getVarSize(this.buffer);
                    this.varDataLast = this.buffer.base().position();
                    this.buffer.base().position(savePos);
                }
                this.buffer.base().position(this.buffer.base().position() + this.nullsByteSize);
            }
        }

        private void beginRowOutput() {
            if (this.rowIndex < 0) {
                this.prepareOutput();
            }
            if (this.rowIdIncluded) {
                if (this.lastRowId <= 0L) {
                    throw new IllegalStateException();
                }
                this.buffer.putLong(this.lastRowId);
                this.lastRowId = -1L;
            }
            if (this.mode == MappingMode.ROWWISE_SEPARATED_V2) {
                if (RowMapper.this.getVariableEntryCount() > 0) {
                    long varOffset = this.varDataLast - this.varDataTop;
                    this.buffer.base().putLong(varOffset);
                    int savePos = this.buffer.base().position();
                    this.buffer.base().position(this.varDataLast);
                    RowMapper.putVarSize(this.buffer, RowMapper.this.getVariableEntryCount());
                    this.varDataLast = this.buffer.base().position();
                    this.buffer.base().position(savePos);
                }
                for (int i = this.nullsByteSize; i > 0; --i) {
                    boolean nullByte = false;
                    this.buffer.base().put((byte)0);
                }
            }
            ++this.rowIndex;
            this.fieldIndex = -1;
        }

        private void endRow() {
            if (this.varDataLast >= 0 && this.rowIndex + 1 >= this.rowCount) {
                this.buffer.base().position(this.varDataLast);
            }
        }

        private void beginField() {
            if (this.mode == MappingMode.COLUMNWISE_SEPARATED) {
                ++this.fieldIndex;
                int pos = this.fieldIndex == 0 ? this.topPos + RowMapper.this.getFixedFieldPartSize(0, this.mode) * this.rowIndex : this.buffer.base().position() + RowMapper.this.getFixedFieldPartSize(this.fieldIndex - 1, this.mode) * (this.rowCount - this.rowIndex - 1) + RowMapper.this.getFixedFieldPartSize(this.fieldIndex, this.mode) * this.rowIndex;
                this.buffer.base().position(pos);
            }
        }

        private void beginVarDataInput() {
            if (this.varDataTop >= 0) {
                if (this.pendingPos >= 0) {
                    throw new IllegalStateException();
                }
                if (this.mode == MappingMode.ROWWISE_SEPARATED_V2) {
                    this.pendingPos = this.buffer.base().position();
                    this.buffer.base().position(this.varDataLast);
                } else {
                    int offset = (int)(this.buffer.base().getLong() - this.varDataBaseOffset);
                    this.pendingPos = this.buffer.base().position();
                    this.buffer.base().position(this.varDataTop + offset);
                }
            }
        }

        private void beginVarDataOutput() {
            if (this.varDataTop >= 0) {
                if (this.pendingPos >= 0) {
                    throw new IllegalStateException();
                }
                if (this.mode == MappingMode.ROWWISE_SEPARATED_V2) {
                    this.pendingPos = this.buffer.base().position();
                    this.buffer.base().position(this.varDataLast);
                } else {
                    int offset = this.varDataLast - this.varDataTop;
                    this.buffer.base().putLong(offset);
                    this.pendingPos = this.buffer.base().position();
                    this.buffer.base().position(this.varDataLast);
                }
            }
        }

        private void endVarData() {
            if (this.varDataTop >= 0) {
                if (this.pendingPos < 0) {
                    throw new IllegalStateException();
                }
                this.varDataLast = this.buffer.base().position();
                this.buffer.base().position(this.pendingPos);
                this.pendingPos = -1;
            }
        }
    }

    private static class Entry
    implements Cloneable {
        String columnName;
        String nameByField;
        String nameByGetter;
        Field rowTypeField;
        Method getterMethod;
        Method setterMethod;
        GSType elementType;
        boolean arrayUsed;
        boolean keyType;
        int order = -1;
        boolean orderSpecified;

        Entry(String columnName) {
            this.columnName = columnName;
        }

        void applyAccessibleObject(AccessibleObject ao) {
            this.keyType |= ao.getAnnotation(RowKey.class) != null;
            ao.setAccessible(true);
        }

        boolean reduceByAccessors() throws GSException {
            if (this.getterMethod != null || this.setterMethod != null) {
                if (this.getterMethod != null && this.setterMethod != null) {
                    this.rowTypeField = null;
                    if (this.nameByGetter == null) {
                        throw new Error();
                    }
                    this.columnName = this.nameByGetter;
                    return true;
                }
                if (this.getterMethod == null && this.setterMethod.getAnnotation(RowField.class) != null || this.setterMethod == null && this.getterMethod.getAnnotation(RowField.class) != null) {
                    throw new GSException("Inconsistent annotation");
                }
                this.getterMethod = null;
                this.setterMethod = null;
            }
            if (this.rowTypeField != null) {
                if (this.nameByField == null) {
                    throw new Error();
                }
                this.columnName = this.nameByField;
                return true;
            }
            return false;
        }

        void setObjectType(Class<?> objectType) throws GSException {
            this.elementType = RowMapper.resolveElementType(objectType, false, false);
            if (objectType.isArray()) {
                switch (this.elementType) {
                    case GEOMETRY: 
                    case BLOB: {
                        throw new GSException(145010, "BLOB or GEOMETRY must not be an element of array");
                    }
                }
                this.arrayUsed = true;
            } else {
                this.arrayUsed = false;
            }
        }

        ColumnInfo getColumnInfo() {
            return new ColumnInfo(this.columnName, RowMapper.toFullType(this.elementType, this.arrayUsed));
        }

        void exportColumnSchema(BasicBuffer out) {
            out.putString(this.columnName);
            out.prepare(1);
            RowMapper.putTypePrepared(out, this.elementType);
            out.putBoolean(this.arrayUsed);
        }

        void importColumnSchema(BasicBuffer in, int order) throws GSException {
            this.columnName = in.getString();
            this.elementType = RowMapper.getType(in);
            this.arrayUsed = in.getBoolean();
            this.order = order;
        }

        void importObjectMapping(Entry orgEntry, boolean orderIgnorable) throws GSException {
            if (this.order != orgEntry.order && (orgEntry.orderSpecified || !orderIgnorable)) {
                throw new GSException(145023, "Inconsistent column order (name=" + this.columnName + ", localOrder=" + orgEntry.order + ", remoteOrder=" + this.order + ")");
            }
            this.order = orgEntry.order;
            if (!RowMapper.normalizeSymbol(this.columnName).equals(RowMapper.normalizeSymbol(orgEntry.columnName)) || this.elementType != orgEntry.elementType || this.arrayUsed != orgEntry.arrayUsed) {
                throw new GSException(145023, "Inconsistent remote column");
            }
            this.rowTypeField = orgEntry.rowTypeField;
            this.getterMethod = orgEntry.getterMethod;
            this.setterMethod = orgEntry.setterMethod;
        }

        void encode(Cursor cursor, Object keyObj, Object rowObj, boolean general) throws GSException {
            Object fieldObj;
            Object object = fieldObj = !this.keyType || keyObj == null ? this.getFieldObj(rowObj, general) : keyObj;
            if (fieldObj == null && this.elementType != null) {
                throw new NullPointerException("Null field (columnName=" + this.columnName + ", type=" + (Object)((Object)RowMapper.toFullType(this.elementType, this.arrayUsed)) + ")");
            }
            RowMapper.putField(cursor, fieldObj, this.elementType, this.arrayUsed);
        }

        void decode(Cursor cursor, Object rowObj, boolean general) throws GSException {
            this.setFieldObj(rowObj, RowMapper.getField(cursor, this.elementType, this.arrayUsed), general);
        }

        Object getFieldObj(Object rowObj, boolean general) throws GSException {
            if (general) {
                return ((Row)rowObj).getValue(this.order);
            }
            try {
                if (this.rowTypeField != null) {
                    return this.rowTypeField.get(rowObj);
                }
                return this.getterMethod.invoke(rowObj, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new GSException(145000, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new GSException(e);
            }
        }

        void setFieldObj(Object rowObj, Object fieldObj, boolean general) throws GSException {
            if (general) {
                if (rowObj.getClass() == ArrayRow.class) {
                    ((ArrayRow)rowObj).setValueDirect(this.order, fieldObj);
                } else {
                    ((Row)rowObj).setValue(this.order, fieldObj);
                }
                return;
            }
            try {
                if (this.rowTypeField != null) {
                    this.rowTypeField.set(rowObj, fieldObj);
                } else {
                    this.setterMethod.invoke(rowObj, fieldObj);
                }
            }
            catch (IllegalAccessException e) {
                throw new GSException(145000, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new GSException(e);
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.arrayUsed ? 1231 : 1237);
            result = 31 * result + (this.columnName == null ? 0 : this.columnName.hashCode());
            result = 31 * result + (this.elementType == null ? 0 : this.elementType.hashCode());
            result = 31 * result + (this.getterMethod == null ? 0 : this.getterMethod.hashCode());
            result = 31 * result + (this.keyType ? 1231 : 1237);
            result = 31 * result + (this.nameByField == null ? 0 : this.nameByField.hashCode());
            result = 31 * result + (this.nameByGetter == null ? 0 : this.nameByGetter.hashCode());
            result = 31 * result + this.order;
            result = 31 * result + (this.orderSpecified ? 1231 : 1237);
            result = 31 * result + (this.rowTypeField == null ? 0 : this.rowTypeField.hashCode());
            result = 31 * result + (this.setterMethod == null ? 0 : this.setterMethod.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            if (this.arrayUsed != other.arrayUsed) {
                return false;
            }
            if (this.columnName == null ? other.columnName != null : !this.columnName.equals(other.columnName)) {
                return false;
            }
            if (this.elementType != other.elementType) {
                return false;
            }
            if (this.getterMethod == null ? other.getterMethod != null : !this.getterMethod.equals(other.getterMethod)) {
                return false;
            }
            if (this.keyType != other.keyType) {
                return false;
            }
            if (this.nameByField == null ? other.nameByField != null : !this.nameByField.equals(other.nameByField)) {
                return false;
            }
            if (this.nameByGetter == null ? other.nameByGetter != null : !this.nameByGetter.equals(other.nameByGetter)) {
                return false;
            }
            if (this.order != other.order) {
                return false;
            }
            if (this.orderSpecified != other.orderSpecified) {
                return false;
            }
            if (this.rowTypeField == null ? other.rowTypeField != null : !this.rowTypeField.equals(other.rowTypeField)) {
                return false;
            }
            return !(this.setterMethod == null ? other.setterMethod != null : !this.setterMethod.equals(other.setterMethod));
        }
    }

    public static interface BlobFactory {
        public Blob createBlob(byte[] var1) throws GSException;
    }

    public static enum MappingMode {
        NORMAL,
        ROWWISE_SEPARATED,
        ROWWISE_SEPARATED_V2,
        COLUMNWISE_SEPARATED,
        AGGREGATED;

    }
}

