/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.subnet;

import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.common.BasicBuffer;
import com.toshiba.mwcloud.gs.common.GSConnectionException;
import com.toshiba.mwcloud.gs.common.GSStatementException;
import com.toshiba.mwcloud.gs.common.GSWrongNodeException;
import com.toshiba.mwcloud.gs.common.LoggingUtils;
import com.toshiba.mwcloud.gs.common.PropertyUtils;
import com.toshiba.mwcloud.gs.common.Statement;
import com.toshiba.mwcloud.gs.common.StatementResult;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.BufferUnderflowException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Formatter;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

public class NodeConnection
implements Closeable {
    public static final int EE_MAGIC_NUMBER = 65021048;
    private static final int DEFAULT_PROTOCOL_VERSION = 10;
    private static final int STATEMENT_TYPE_NUMBER_V2_OFFSET = 100;
    private static final int SPECIAL_PARTITION_ID = 0;
    private static final StatementResult[] STATEMENT_RESULT_CONSTANTS = StatementResult.values();
    private static volatile boolean detailErrorMessageEnabled = false;
    private static volatile int protocolVersion = 10;
    private static volatile int firstStatementTypeNumber = NodeConnection.statementToNumber(Statement.CONNECT);
    private static boolean tcpNoDelayEnabled = true;
    private static final LoggingUtils.BaseGridStoreLogger HEARTBEAT_LOGGER = LoggingUtils.getLogger("Heartbeat");
    private static final LoggingUtils.BaseGridStoreLogger IO_LOGGER = LoggingUtils.getLogger("StatementIO");
    private static final Statement[] STATEMENT_LIST = Statement.values();
    private final long statementTimeoutMillis;
    private final long heartbeatTimeoutMillis;
    private final Socket socket;
    private final InputStream input;
    private final OutputStream output;
    private final Integer alternativeVersion;
    private final boolean ipv6Enabled;
    private AuthMode authMode = Challenge.getDefaultMode();
    private boolean responseUnacceptable;
    private long statementId = 0L;
    private byte[] pendingResp;

    public NodeConnection(InetSocketAddress address, Config config) throws GSException {
        this.statementTimeoutMillis = config.statementTimeoutEnabled ? config.statementTimeoutMillis : Long.MAX_VALUE;
        this.heartbeatTimeoutMillis = config.heartbeatTimeoutMillis;
        try {
            this.socket = new Socket();
            if (tcpNoDelayEnabled) {
                this.socket.setTcpNoDelay(true);
            }
            this.socket.connect(address, PropertyUtils.timeoutPropertyToIntMillis(config.connectTimeoutMillis));
            this.socket.setSoTimeout(PropertyUtils.timeoutPropertyToIntMillis(Math.min(this.statementTimeoutMillis, this.heartbeatTimeoutMillis)));
            this.input = this.socket.getInputStream();
            this.output = this.socket.getOutputStream();
        }
        catch (IOException e) {
            throw new GSConnectionException(145028, "Failed to connect (address=" + address + ", reason=" + e.getMessage() + ")", e);
        }
        this.alternativeVersion = config.alternativeVersion;
        this.ipv6Enabled = address.getAddress() instanceof Inet6Address;
    }

    public static void setDetailErrorMessageEnabled(boolean detailErrorMessageEnabled) {
        NodeConnection.detailErrorMessageEnabled = detailErrorMessageEnabled;
    }

    public static int getProtocolVersion() {
        return protocolVersion;
    }

    public static boolean isSupportedProtocolVersion(int protocolVersion) {
        switch (protocolVersion) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static void setProtocolVersion(int protocolVersion) throws GSException {
        if (!NodeConnection.isSupportedProtocolVersion(protocolVersion)) {
            throw new GSException(145002, "Wrong protocol version (version=" + protocolVersion + ")");
        }
        NodeConnection.protocolVersion = protocolVersion;
        firstStatementTypeNumber = NodeConnection.statementToNumber(Statement.CONNECT);
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.socket.getRemoteSocketAddress();
    }

    private static int getEEHeadLength(boolean ipv6Enabled) {
        if (ipv6Enabled) {
            return 32;
        }
        return 20;
    }

    public static int getRequestHeadLength(boolean ipv6Enabled) {
        return NodeConnection.getRequestHeadLength(ipv6Enabled, false);
    }

    public static int getRequestHeadLength(boolean ipv6Enabled, boolean firstStatement) {
        int statementIdSize = NodeConnection.isStatementIdLarge(firstStatement) ? 8 : 4;
        return NodeConnection.getEEHeadLength(ipv6Enabled) + 8 + statementIdSize;
    }

    public static void fillRequestHead(boolean ipv6Enabled, BasicBuffer req) {
        NodeConnection.fillRequestHead(ipv6Enabled, req, false);
    }

    public static void fillRequestHead(boolean ipv6Enabled, BasicBuffer req, boolean firstStatement) {
        req.clear();
        req.prepare(NodeConnection.getRequestHeadLength(ipv6Enabled, firstStatement));
        req.base().putInt(65021048);
        if (ipv6Enabled) {
            req.base().putLong(0L);
            req.base().putLong(0L);
        } else {
            req.base().putInt(0);
        }
        req.base().putInt(0);
        req.base().putInt(-1);
        req.base().putInt(0);
        req.base().putInt(0);
        req.base().putInt(0);
        NodeConnection.putStatementId(req, 0L, firstStatement);
    }

    public static boolean isStatementIdLarge(boolean firstStatement) {
        return !firstStatement && protocolVersion >= 3;
    }

    public static void putStatementId(BasicBuffer req, long statementId) {
        NodeConnection.putStatementId(req, statementId, false);
    }

    public static void putStatementId(BasicBuffer req, long statementId, boolean firstStatement) {
        if (NodeConnection.isStatementIdLarge(firstStatement)) {
            req.putLong(statementId);
        } else {
            req.putInt((int)statementId);
        }
    }

    public static long getStatementId(BasicBuffer resp, boolean firstStatement) {
        if (NodeConnection.isStatementIdLarge(firstStatement)) {
            return resp.base().getLong();
        }
        return resp.base().getInt();
    }

    public static boolean isOptionalRequestEnabled() {
        return protocolVersion >= 3;
    }

    public static void tryPutEmptyOptionalRequest(BasicBuffer req) {
        if (NodeConnection.isOptionalRequestEnabled()) {
            req.putInt(0);
        }
    }

    public void executeStatement(Statement statement, int partitionId, long statementId, BasicBuffer req, BasicBuffer resp) throws GSException {
        this.executeStatementDirect(NodeConnection.statementToNumber(statement), partitionId, statementId, req, resp, null);
    }

    public void executeStatementDirect(int statementTypeNumber, int partitionId, long statementId, BasicBuffer req, BasicBuffer resp, Heartbeat heartbeat) throws GSException {
        boolean statementIdMatched;
        int readLength;
        long reqStatementId;
        if (partitionId < 0) {
            throw new GSException(145000, "Internal error by illegal partition ID (partitionId=" + partitionId + ", address=" + this.getRemoteSocketAddress() + ")");
        }
        boolean firstStatement = statementTypeNumber == firstStatementTypeNumber;
        int reqHeadLength = NodeConnection.getRequestHeadLength(this.ipv6Enabled, firstStatement);
        int eeHeadLength = NodeConnection.getEEHeadLength(this.ipv6Enabled);
        int reqLength = req.base().position();
        if (statementId == 0L) {
            while (++this.statementId == 0L) {
            }
            reqStatementId = this.statementId;
        } else {
            reqStatementId = statementId;
        }
        if (IO_LOGGER.isDebugEnabled()) {
            int n = statementTypeNumber - NodeConnection.getStatementNumberOffset();
            String statementName = 0 <= n && n < STATEMENT_LIST.length ? STATEMENT_LIST[n].toString() : "(" + n + ")";
            IO_LOGGER.debug("statementIO.started", statementName, this.getRemoteSocketAddress(), partitionId, reqStatementId);
        }
        req.base().position(eeHeadLength - 4);
        req.base().putInt(reqLength - eeHeadLength);
        req.base().putInt(statementTypeNumber);
        req.base().putInt(partitionId);
        NodeConnection.putStatementId(req, reqStatementId, firstStatement);
        try {
            this.output.write(req.base().array(), 0, reqLength);
        }
        catch (IOException e) {
            throw new GSConnectionException(145028, "Failed to send message (address=" + this.getRemoteSocketAddress() + ", reason=" + e.getMessage() + ")", e);
        }
        req.base().clear();
        req.base().position(reqHeadLength);
        if (resp == null) {
            return;
        }
        resp.clear();
        resp.prepare(eeHeadLength);
        resp.base().limit(eeHeadLength);
        try {
            readLength = this.readFully(resp.base().array(), 0, eeHeadLength, resp.base().capacity());
        }
        catch (GSException e) {
            if (this.responseUnacceptable || heartbeat != null || firstStatement) {
                throw e;
            }
            heartbeat = new Heartbeat();
            heartbeat.orgStatementTypeNumber = statementTypeNumber;
            heartbeat.orgStatementId = reqStatementId;
            heartbeat.orgStatementFound = false;
            resp = this.processHeartbeat(partitionId, resp, heartbeat);
            readLength = eeHeadLength;
        }
        if (resp.base().getInt() != 65021048) {
            throw new GSConnectionException(145031, "Protocol error by illegal magic number (address=" + this.getRemoteSocketAddress() + ")");
        }
        resp.base().position(eeHeadLength - 4);
        int respBodyLength = resp.base().getInt();
        int respTotalLength = eeHeadLength + respBodyLength;
        if (readLength > respTotalLength) {
            int orgPendingLength;
            int extraLength = readLength - respTotalLength;
            if (this.pendingResp == null) {
                orgPendingLength = 0;
                this.pendingResp = new byte[extraLength];
            } else {
                orgPendingLength = this.pendingResp.length;
                byte[] orgPendingResp = this.pendingResp;
                this.pendingResp = new byte[orgPendingLength + extraLength];
                System.arraycopy(orgPendingResp, 0, this.pendingResp, 0, orgPendingResp.length);
            }
            System.arraycopy(resp.base().array(), respTotalLength, this.pendingResp, orgPendingLength, extraLength);
        } else if (readLength < respTotalLength) {
            int length = respTotalLength - readLength;
            resp.base().limit(readLength);
            resp.base().position(readLength);
            resp.prepare(length);
            resp.base().position(eeHeadLength);
            this.readFully(resp.base().array(), readLength, length, length);
        }
        resp.base().limit(respTotalLength);
        int respStatementTypeNumber = resp.base().getInt();
        if (respStatementTypeNumber != statementTypeNumber) {
            if (heartbeat == null || respStatementTypeNumber != heartbeat.orgStatementTypeNumber) {
                throw new GSConnectionException(145031, "Protocol error by illegal statement type (address=" + this.getRemoteSocketAddress() + ")");
            }
            heartbeat.orgStatementFound = true;
            boolean orgFirstStatement = heartbeat.orgStatementTypeNumber == firstStatementTypeNumber;
            statementIdMatched = NodeConnection.getStatementId(resp, orgFirstStatement) == heartbeat.orgStatementId;
        } else {
            boolean bl = statementIdMatched = NodeConnection.getStatementId(resp, firstStatement) == reqStatementId;
        }
        if (!statementIdMatched) {
            throw new GSConnectionException(145031, "Protocol error by illegal statement ID (address=" + this.getRemoteSocketAddress() + ")");
        }
        StatementResult result = (StatementResult)resp.getByteEnum(STATEMENT_RESULT_CONSTANTS);
        if (result != StatementResult.SUCCESS) {
            GSException remoteException;
            try {
                remoteException = this.readRemoteException(result, resp, partitionId);
            }
            catch (BufferUnderflowException e) {
                throw new GSConnectionException(145031, "Protocol error by invalid remote error message (result=" + (Object)((Object)result) + ", address=" + this.getRemoteSocketAddress() + ", reason=" + e.getMessage() + ")", e);
            }
            remoteException.fillInStackTrace();
            if (heartbeat != null && respStatementTypeNumber == firstStatementTypeNumber) {
                throw new GSConnectionException(145028, "Connection problem occurred by invalid heartbeat response (result=" + (Object)((Object)result) + ", address=" + this.getRemoteSocketAddress() + ", reason=" + remoteException.getMessage() + ")", remoteException);
            }
            throw remoteException;
        }
        if (heartbeat != null && heartbeat.orgException != null) {
            throw heartbeat.orgException;
        }
    }

    private int readFully(byte[] value, int offset, int length, int maxLength) throws GSException {
        int pos = offset;
        if (this.pendingResp != null) {
            int consumed = Math.min(this.pendingResp.length, maxLength);
            System.arraycopy(this.pendingResp, 0, value, pos, consumed);
            pos += consumed;
            this.pendingResp = (byte[])(this.pendingResp.length == consumed ? null : Arrays.copyOfRange(this.pendingResp, consumed, this.pendingResp.length));
        }
        int endPos = offset + length;
        int maxEndPos = offset + maxLength;
        try {
            int last;
            do {
                if ((last = this.input.read(value, pos, maxEndPos - pos)) >= 0) continue;
                throw new GSConnectionException(145028, "Connection unexpectedly terminated (address=" + this.getRemoteSocketAddress() + ")");
            } while ((pos += last) < endPos);
            return pos - offset;
        }
        catch (GSConnectionException e) {
            throw e;
        }
        catch (IOException e) {
            boolean timeoutOccurred = e instanceof SocketTimeoutException;
            if (!timeoutOccurred || pos != offset) {
                this.responseUnacceptable = true;
            }
            if (timeoutOccurred) {
                throw new GSConnectionException(145029, "Connection timed out on receiving (receivedSize=" + (pos - offset) + ", totalSize=" + length + ", address=" + this.getRemoteSocketAddress() + ", reason=" + e.getMessage() + ")", e);
            }
            throw new GSConnectionException(145028, "Connection problem occurred on receiving (receivedSize=" + (pos - offset) + ", totalSize=" + length + ", address=" + this.getRemoteSocketAddress() + ", reason=" + e.getMessage() + ")", e);
        }
    }

    private BasicBuffer processHeartbeat(int partitionId, BasicBuffer resp, Heartbeat heartbeat) throws GSException {
        BasicBuffer heartbeatBuf = this.createRequestBuffer();
        int eeHeadLength = NodeConnection.getEEHeadLength(this.ipv6Enabled);
        long startTime = System.currentTimeMillis();
        long initialMillis = Math.min(this.statementTimeoutMillis, this.heartbeatTimeoutMillis);
        while (true) {
            long elapsedMillis;
            if ((elapsedMillis = System.currentTimeMillis() - startTime + initialMillis) >= this.statementTimeoutMillis) {
                throw new GSConnectionException(145029, "Connection timed out by statement timeout (elapsedMillis=" + elapsedMillis + ", statementTimeoutMillis=" + this.statementTimeoutMillis + ", address=" + this.getRemoteSocketAddress() + ")");
            }
            if (HEARTBEAT_LOGGER.isInfoEnabled()) {
                int n = heartbeat.orgStatementTypeNumber - NodeConnection.getStatementNumberOffset();
                String statementName = 0 <= n && n < STATEMENT_LIST.length ? STATEMENT_LIST[n].toString() : "(" + n + ")";
                HEARTBEAT_LOGGER.info("heartbeat.started", statementName, this.getRemoteSocketAddress(), partitionId, heartbeat.orgStatementId, elapsedMillis);
            }
            while (++this.statementId == 0L) {
            }
            long lastHeartbeatId = this.statementId;
            BasicBuffer heartbeatReq = heartbeatBuf;
            this.putConnectRequest(heartbeatReq);
            try {
                this.executeStatementDirect(firstStatementTypeNumber, 0, lastHeartbeatId, heartbeatReq, resp, heartbeat);
            }
            catch (GSStatementException e) {
                heartbeat.orgException = e;
            }
            if (heartbeat.orgStatementFound) {
                resp = heartbeatBuf;
                resp.clear();
                resp.prepare(eeHeadLength);
                resp.base().limit(eeHeadLength);
                this.readFully(resp.base().array(), 0, eeHeadLength, eeHeadLength);
                heartbeat.orgStatementTypeNumber = firstStatementTypeNumber;
                heartbeat.orgStatementId = lastHeartbeatId;
                return resp;
            }
            resp.clear();
            resp.prepare(eeHeadLength);
            resp.base().limit(eeHeadLength);
            try {
                this.readFully(resp.base().array(), 0, eeHeadLength, eeHeadLength);
                return resp;
            }
            catch (GSException e) {
                if (!this.responseUnacceptable) continue;
                throw new GSConnectionException(145028, "Connection problem occurred after heartbeat (elapsedMillis=" + elapsedMillis + ", address=" + this.getRemoteSocketAddress() + ", reason=" + e.getMessage() + ")", e);
            }
            break;
        }
    }

    private GSException readRemoteException(StatementResult result, BasicBuffer resp, int partitionId) throws BufferUnderflowException {
        int count = resp.base().getInt();
        int topCode = 0;
        String topMessage = null;
        int majorCode = 0;
        String majorMessage = null;
        StringBuilder messageBuilder = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            int code = resp.base().getInt();
            String message = resp.getString();
            String typeName = resp.getString();
            String fileName = resp.getString();
            String functionName = resp.getString();
            int line = resp.base().getInt();
            if (i == 0) {
                topCode = code;
                topMessage = message;
            }
            boolean majorCodeUpdated = false;
            if (code != 0 && !typeName.endsWith("PlatformException")) {
                majorCodeUpdated = true;
                majorCode = code;
            }
            if (!detailErrorMessageEnabled) {
                if (message.isEmpty()) continue;
                if (majorCodeUpdated) {
                    majorMessage = message;
                    continue;
                }
                if (majorCode != 0) continue;
                majorMessage = "minorCode=" + code + " : " + message;
                continue;
            }
            if (i > 0) {
                messageBuilder.append(" by ");
            }
            if (typeName.isEmpty()) {
                messageBuilder.append("(Unknown exception)");
            } else {
                messageBuilder.append(typeName);
            }
            if (!fileName.isEmpty()) {
                messageBuilder.append(" ").append(fileName);
            }
            if (!functionName.isEmpty()) {
                messageBuilder.append(" ").append(functionName);
            }
            if (line > 0) {
                messageBuilder.append(" line=").append(line);
            }
            if (code != 0) {
                messageBuilder.append(" code=").append(code);
            }
            if (message.isEmpty()) continue;
            messageBuilder.append(" : ").append(message);
        }
        String errorName = null;
        if (resp.base().remaining() > 0) {
            errorName = resp.getString();
            if (errorName.isEmpty()) {
                errorName = null;
            } else {
                majorCode = topCode;
                majorMessage = topMessage;
            }
        }
        if (!detailErrorMessageEnabled && majorMessage != null) {
            messageBuilder.append(majorMessage);
        }
        if (messageBuilder.length() > 0) {
            messageBuilder.append(" ");
        }
        messageBuilder.append("(address=");
        messageBuilder.append(this.getRemoteSocketAddress());
        messageBuilder.append(", partitionId=").append(partitionId);
        messageBuilder.append(")");
        switch (result) {
            case STATEMENT_ERROR: {
                return new GSStatementException(majorCode == 0 ? 145027 : majorCode, errorName, messageBuilder.toString(), null);
            }
            case DENY: {
                return new GSWrongNodeException(majorCode == 0 ? 145030 : majorCode, errorName, messageBuilder.toString(), null);
            }
        }
        return new GSConnectionException(majorCode == 0 ? 145028 : majorCode, errorName, messageBuilder.toString(), null);
    }

    private void putConnectRequest(BasicBuffer req) {
        req.base().position(NodeConnection.getRequestHeadLength(this.ipv6Enabled, true));
        req.putInt(this.alternativeVersion == null ? protocolVersion : this.alternativeVersion);
    }

    public void connect(BasicBuffer req, BasicBuffer resp) throws GSException {
        req = req == null ? this.createRequestBuffer() : req;
        resp = resp == null ? this.createOutput() : resp;
        this.putConnectRequest(req);
        this.executeStatement(Statement.CONNECT, 0, 0L, req, resp);
        this.authMode = Challenge.getMode(resp);
    }

    public void disconnect(BasicBuffer req, BasicBuffer resp) throws GSException {
        req = req == null ? this.createRequestBuffer() : req;
        req.base().position(NodeConnection.getRequestHeadLength(this.ipv6Enabled, false));
        NodeConnection.tryPutEmptyOptionalRequest(req);
        this.executeStatement(Statement.DISCONNECT, 0, 0L, req, null);
        this.closeImmediately();
    }

    public void login(BasicBuffer req, BasicBuffer resp, LoginInfo loginInfo) throws GSException {
        Challenge challenge = this.loginInternal(req, resp, loginInfo, null);
        if (challenge != null) {
            this.loginInternal(req, resp, loginInfo, challenge);
        }
    }

    private Challenge loginInternal(BasicBuffer req, BasicBuffer resp, LoginInfo loginInfo, Challenge lastChallenge) throws GSException {
        req = req == null ? this.createRequestBuffer() : req;
        resp = resp == null ? this.createOutput() : resp;
        req.base().position(NodeConnection.getRequestHeadLength(this.ipv6Enabled, false));
        if (NodeConnection.isOptionalRequestEnabled()) {
            OptionalRequest request = new OptionalRequest();
            if (loginInfo.transactionTimeoutSecs >= 0) {
                request.put(OptionalRequestType.TRANSACTION_TIMEOUT, loginInfo.transactionTimeoutSecs);
            }
            if (loginInfo.database != null) {
                request.put(OptionalRequestType.DB_NAME, loginInfo.database);
            }
            request.format(req);
        }
        req.putString(loginInfo.user);
        req.putString(Challenge.build(this.authMode, lastChallenge, loginInfo.passwordDigest));
        req.putInt(PropertyUtils.timeoutPropertyToIntSeconds(this.statementTimeoutMillis));
        req.putBoolean(loginInfo.ownerMode);
        req.putString(loginInfo.clusterName == null ? "" : loginInfo.clusterName);
        Challenge.putRequest(req, this.authMode, lastChallenge);
        this.executeStatement(Statement.LOGIN, 0, 0L, req, resp);
        AuthMode[] resultMode = new AuthMode[]{this.authMode};
        Challenge respChallenge = Challenge.getResponse(resp, resultMode, lastChallenge);
        this.authMode = resultMode[0];
        return respChallenge;
    }

    public void reuse(BasicBuffer req, BasicBuffer resp, LoginInfo loginInfo) throws GSException {
        this.login(req, resp, loginInfo);
    }

    public void logout(BasicBuffer req, BasicBuffer resp) throws GSException {
        req = req == null ? this.createRequestBuffer() : req;
        resp = resp == null ? this.createOutput() : resp;
        req.base().position(NodeConnection.getRequestHeadLength(this.ipv6Enabled, false));
        NodeConnection.tryPutEmptyOptionalRequest(req);
        this.executeStatement(Statement.LOGOUT, 0, 0L, req, resp);
    }

    public static String getDigest(String pasword) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(pasword.getBytes(BasicBuffer.DEFAULT_CHARSET));
            StringBuilder builder = new StringBuilder();
            for (byte b : md.digest()) {
                builder.append(String.format("%02x", b));
            }
            return builder.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("Internal error while calculating digest", e);
        }
    }

    public static int statementToNumber(Statement statement) {
        return statement.ordinal() + NodeConnection.getStatementNumberOffset();
    }

    public static int getStatementNumberOffset() {
        if (protocolVersion < 2) {
            return 0;
        }
        return 100;
    }

    private BasicBuffer createRequestBuffer() {
        BasicBuffer req = new BasicBuffer(64);
        NodeConnection.fillRequestHead(this.ipv6Enabled, req, false);
        return req;
    }

    private BasicBuffer createOutput() {
        return new BasicBuffer(64);
    }

    public void closeImmediately() throws GSException {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            throw new GSException(145028, "Connection problem occurred on closing (reason=" + e.getMessage() + ")", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws GSException {
        try {
            if (!this.socket.isClosed()) {
                this.disconnect(null, null);
            }
        }
        finally {
            this.closeImmediately();
        }
    }

    public static class OptionalRequest {
        private final Map<OptionalRequestType, Object> requestMap = new EnumMap<OptionalRequestType, Object>(OptionalRequestType.class);

        public void clear() {
            this.requestMap.clear();
        }

        public void put(OptionalRequestType type, Object value) {
            this.requestMap.put(type, type.valueType().cast(value));
        }

        public void format(BasicBuffer req) {
            if (this.requestMap.isEmpty()) {
                req.putInt(0);
                return;
            }
            int headPos = req.base().position();
            req.putInt(0);
            int bodyPos = req.base().position();
            for (Map.Entry<OptionalRequestType, Object> entry : this.requestMap.entrySet()) {
                req.putShort((short)entry.getKey().id());
                Class<?> valueType = entry.getKey().valueType();
                if (valueType == Integer.class) {
                    req.putInt((Integer)entry.getValue());
                    continue;
                }
                if (valueType == Long.class) {
                    req.putLong((Long)entry.getValue());
                    continue;
                }
                if (valueType == Boolean.class) {
                    req.putBoolean((Boolean)entry.getValue());
                    continue;
                }
                if (valueType == String.class) {
                    req.putString((String)entry.getValue());
                    continue;
                }
                if (valueType == Byte.class) {
                    req.put((Byte)entry.getValue());
                    continue;
                }
                throw new Error("Internal error by illegal value type");
            }
            int endPos = req.base().position();
            req.base().position(headPos);
            req.putInt(endPos - bodyPos);
            req.base().position(endPos);
        }
    }

    public static enum OptionalRequestType {
        TRANSACTION_TIMEOUT(1, Integer.class),
        FOR_UPDATE(2, Boolean.class),
        CONTAINER_LOCK_REQUIRED(3, Boolean.class),
        SYSTEM_MODE(4, Boolean.class),
        DB_NAME(5, String.class),
        CONTAINER_ATTRIBUTE(6, Integer.class),
        ROW_INSERT_UPDATE(7, Integer.class),
        REQUEST_MODULE_TYPE(8, Byte.class),
        STATEMENT_TIMEOUT(10001, Integer.class),
        FETCH_LIMIT(10002, Long.class),
        FETCH_SIZE(10003, Long.class);

        private final int id;
        private final Class<?> valueType;

        private OptionalRequestType(int id, Class<?> valueType) {
            this.id = id;
            this.valueType = valueType;
        }

        public int id() {
            return this.id;
        }

        public Class<?> valueType() {
            return this.valueType;
        }
    }

    public static class PasswordDigest {
        private final String basicSecret;
        private final String cryptBase;
        private final String challengeBase;

        public PasswordDigest(String basicSecret, String cryptSecret, String challengeBase) {
            this.basicSecret = basicSecret;
            this.cryptBase = cryptSecret;
            this.challengeBase = challengeBase;
        }

        public String getBasicSecret() {
            return this.basicSecret;
        }
    }

    public static class Challenge {
        private static final AuthMode DEFAULT_MODE = AuthMode.CHALLENGE;
        private static final String DEFAULT_METHOD = "POST";
        private static final String DEFAULT_REALM = "DB_Auth";
        private static final String DEFAULT_URI = "/";
        private static final String DEFAULT_QOP = "auth";
        private static final Random RANDOM = new SecureRandom();
        private static boolean challengeEnabled = false;
        private final boolean challenging;
        private final String nonce;
        private final String nc;
        private final String opaque;
        private final String baseSalt;
        private String cnonce;

        public Challenge() {
            this.challenging = false;
            this.nonce = null;
            this.nc = null;
            this.opaque = null;
            this.baseSalt = null;
        }

        public Challenge(String nonce, String nc, String opaque, String baseSalt) {
            this.challenging = true;
            this.nonce = nonce;
            this.nc = nc;
            this.opaque = opaque;
            this.baseSalt = baseSalt;
        }

        public static boolean isChallenging(Challenge challenge) {
            return challenge != null && challenge.challenging;
        }

        public static PasswordDigest makeDigest(String user, String password) {
            return new PasswordDigest(Challenge.sha256Hash(password), Challenge.sha256Hash(user + ":" + password), Challenge.md5Hash(user + ":" + DEFAULT_REALM + ":" + password));
        }

        public static void putRequest(BasicBuffer out, AuthMode mode, Challenge lastChallenge) throws GSException {
            if (mode == AuthMode.NONE) {
                return;
            }
            out.putByteEnum(mode);
            boolean challenged = Challenge.isChallenging(lastChallenge);
            out.putBoolean(challenged);
            if (challenged) {
                out.putString(lastChallenge.opaque);
                out.putString(lastChallenge.cnonce);
            }
        }

        public static Challenge getResponse(BasicBuffer in, AuthMode[] mode, Challenge lastChallenge) throws GSException {
            AuthMode respMode = Challenge.getMode(in);
            if (respMode != mode[0]) {
                if (respMode == AuthMode.BASIC) {
                    mode[0] = respMode;
                    return new Challenge();
                }
                throw new GSConnectionException(145031, "");
            }
            if (respMode == AuthMode.NONE) {
                return null;
            }
            boolean respChallenging = in.getBoolean();
            boolean challenging = Challenge.isChallenging(lastChallenge);
            if (respMode != AuthMode.BASIC && !(respChallenging ^ challenging)) {
                throw new GSConnectionException(145031, "");
            }
            if (respChallenging) {
                String nonce = in.getString();
                String nc = in.getString();
                String opaque = in.getString();
                String baseSalt = in.getString();
                return new Challenge(nonce, nc, opaque, baseSalt);
            }
            return null;
        }

        public static String build(AuthMode mode, Challenge challenge, PasswordDigest digest) {
            if (!Challenge.isChallenging(challenge)) {
                if (mode == AuthMode.CHALLENGE) {
                    return "";
                }
                return digest.basicSecret;
            }
            return challenge.build(digest);
        }

        public String getOpaque() {
            return this.opaque;
        }

        public String getLastCNonce() {
            return this.cnonce;
        }

        public static String generateCNonce() {
            return Challenge.randomHexString(4);
        }

        public String build(PasswordDigest digest) {
            String cnonce = Challenge.generateCNonce();
            String result = this.build(digest, cnonce);
            this.cnonce = cnonce;
            return result;
        }

        public String build(PasswordDigest digest, String cnonce) {
            return "#1#" + this.getChallengeDigest(digest, cnonce) + "#" + this.getCryptSecret(digest);
        }

        public String getChallengeDigest(PasswordDigest digest, String cnonce) {
            String ha1 = Challenge.md5Hash(digest.challengeBase + ":" + this.nonce + ":" + cnonce);
            String ha2 = Challenge.md5Hash("POST:/");
            return Challenge.md5Hash(ha1 + ":" + this.nonce + ":" + this.nc + ":" + cnonce + ":" + DEFAULT_QOP + ":" + ha2);
        }

        public String getCryptSecret(PasswordDigest digest) {
            return Challenge.sha256Hash(this.baseSalt + ":" + digest.cryptBase);
        }

        public static String sha256Hash(String value) {
            return Challenge.hash(value, "SHA-256");
        }

        public static String md5Hash(String value) {
            return Challenge.hash(value, "MD5");
        }

        public static String hash(String value, String algorithm) {
            MessageDigest md;
            try {
                md = MessageDigest.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new Error("Internal error while calculating digest", e);
            }
            md.update(value.getBytes(BasicBuffer.DEFAULT_CHARSET));
            return Challenge.bytesToHex(md.digest());
        }

        public static String randomHexString(int bytesSize) {
            byte[] bytes = new byte[bytesSize];
            Challenge.getRandom().nextBytes(bytes);
            return Challenge.bytesToHex(bytes);
        }

        public static String bytesToHex(byte[] bytes) {
            Formatter formatter = new Formatter(new StringBuilder(), Locale.US);
            for (byte b : bytes) {
                formatter.format("%02x", b);
            }
            return formatter.toString();
        }

        public static Random getRandom() {
            return RANDOM;
        }

        public static AuthMode getDefaultMode() {
            if (challengeEnabled) {
                return DEFAULT_MODE;
            }
            return AuthMode.NONE;
        }

        public static AuthMode getMode(BasicBuffer in) throws GSException {
            if (challengeEnabled && in.base().remaining() > 0) {
                return in.getByteEnum(AuthMode.class);
            }
            return AuthMode.NONE;
        }
    }

    public static enum AuthMode {
        NONE,
        BASIC,
        CHALLENGE;

    }

    public static class LoginInfo {
        public static final String DEFAULT_DATABASE_NAME = null;
        private String user;
        private PasswordDigest passwordDigest;
        private String database;
        private boolean ownerMode;
        private String clusterName;
        private int transactionTimeoutSecs;

        public LoginInfo(String user, String password, boolean ownerMode, String database, String clusterName, long transactionTimeoutMillis) {
            this.user = user;
            this.passwordDigest = Challenge.makeDigest(user, password);
            this.database = database;
            this.ownerMode = ownerMode;
            this.clusterName = clusterName;
            this.transactionTimeoutSecs = PropertyUtils.timeoutPropertyToIntSeconds(transactionTimeoutMillis);
        }

        public LoginInfo(LoginInfo loginInfo) {
            this.set(loginInfo);
        }

        public void set(LoginInfo loginInfo) {
            this.user = loginInfo.user;
            this.passwordDigest = loginInfo.passwordDigest;
            this.database = loginInfo.database;
            this.ownerMode = loginInfo.ownerMode;
            this.clusterName = loginInfo.clusterName;
            this.transactionTimeoutSecs = loginInfo.transactionTimeoutSecs;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public void setPassword(String password) {
            this.passwordDigest = Challenge.makeDigest(this.user, password);
        }

        public void setDatabase(String database) {
            this.database = database;
        }

        public void setOwnerMode(boolean ownerMode) {
            this.ownerMode = ownerMode;
        }

        public boolean isOwnerMode() {
            return this.ownerMode;
        }

        public String getUser() {
            return this.user;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public String getDatabase() {
            return this.database;
        }
    }

    public static class Config {
        private static final long CONNECT_TIMEOUT_DEFAULT = 10000L;
        private static final long STATEMENT_TIMEOUT_DEFAULT = 15000L;
        private static final long HEARTBEAT_TIMEOUT_DEFAULT = 10000L;
        private long connectTimeoutMillis = 10000L;
        private long statementTimeoutMillis = 15000L;
        private long heartbeatTimeoutMillis = 10000L;
        private boolean statementTimeoutEnabled = false;
        private Integer alternativeVersion;

        public void set(Config config) {
            this.connectTimeoutMillis = config.connectTimeoutMillis;
            this.statementTimeoutMillis = config.statementTimeoutMillis;
            this.heartbeatTimeoutMillis = config.heartbeatTimeoutMillis;
            this.statementTimeoutEnabled = config.statementTimeoutEnabled;
            this.alternativeVersion = config.alternativeVersion;
        }

        public boolean set(PropertyUtils.WrappedProperties props) throws GSException {
            long connectTimeoutMillis = props.getTimeoutProperty("connectTimeout", this.connectTimeoutMillis, true);
            long statementTimeoutMillis = props.getTimeoutProperty("statementTimeout", this.statementTimeoutMillis, true);
            long heartbeatTimeoutMillis = props.getTimeoutProperty("heartbeatTimeout", this.heartbeatTimeoutMillis, true);
            boolean statementTimeoutEnabled = props.getBooleanProperty("statementTimeoutEnabled", this.statementTimeoutEnabled, true);
            if (connectTimeoutMillis < 0L || statementTimeoutMillis < 0L) {
                throw new GSException(145005, "Negative timeout properties (connectTimeoutMillis=" + connectTimeoutMillis + ", statementTimeoutMillis=" + statementTimeoutMillis + ", heartbeatTimeoutMillis=" + heartbeatTimeoutMillis + ")");
            }
            if (connectTimeoutMillis != this.connectTimeoutMillis || statementTimeoutMillis != this.statementTimeoutMillis || heartbeatTimeoutMillis != this.heartbeatTimeoutMillis || statementTimeoutEnabled != this.statementTimeoutEnabled) {
                this.connectTimeoutMillis = connectTimeoutMillis;
                this.statementTimeoutMillis = statementTimeoutMillis;
                this.heartbeatTimeoutMillis = heartbeatTimeoutMillis;
                this.statementTimeoutEnabled = statementTimeoutEnabled;
                return true;
            }
            return false;
        }

        public long getConnectTimeoutMillis() {
            return this.connectTimeoutMillis;
        }

        public long getStatementTimeoutMillis() {
            return this.statementTimeoutMillis;
        }

        public void setAlternativeVersion(Integer alternativeVersion) {
            this.alternativeVersion = alternativeVersion;
        }
    }

    static class Heartbeat {
        int orgStatementTypeNumber;
        long orgStatementId;
        boolean orgStatementFound;
        GSStatementException orgException;

        Heartbeat() {
        }
    }
}

