/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.subnet;

import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.common.BasicBuffer;
import com.toshiba.mwcloud.gs.common.GSConnectionException;
import com.toshiba.mwcloud.gs.common.InternPool;
import com.toshiba.mwcloud.gs.common.LoggingUtils;
import com.toshiba.mwcloud.gs.common.PropertyUtils;
import com.toshiba.mwcloud.gs.common.ServiceAddressResolver;
import com.toshiba.mwcloud.gs.common.Statement;
import com.toshiba.mwcloud.gs.subnet.NodeConnection;
import com.toshiba.mwcloud.gs.subnet.NodeConnectionPool;
import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class NodeResolver
implements Closeable {
    private static boolean ipv6EnabledDefault = false;
    public static final int NOTIFICATION_RECEIVE_TIMEOUT = 10000;
    private static final int DEFAULT_NOTIFICATION_STATEMENT_TYPE = 5000;
    private static final int DEFAULT_NOTIFICATION_PORT = 31999;
    private static final String DEFAULT_NOTIFICATION_ADDRESS = "239.0.0.1";
    private static final String DEFAULT_NOTIFICATION_ADDRESS_V6 = "ff12::1";
    private static final String DEFAULT_SERVICE_TYPE = "transaction";
    private static final AddressConfig DEFAULT_ADDRESS_CONFIG = new AddressConfig();
    public static final ProtocolConfig DEFAULT_PROTOCOL_CONFIG = new DefaultProtocolConfig();
    private static final LoggingUtils.BaseGridStoreLogger LOGGER = LoggingUtils.getLogger("Discovery");
    private final NodeConnectionPool pool;
    private final boolean ipv6Enabled;
    private final InetSocketAddress notificationAddress;
    private InetSocketAddress masterAddress;
    private InetSocketAddress prevMasterAddress;
    private final NodeConnection.Config connectionConfig = new NodeConnection.Config();
    private final NodeConnection.LoginInfo loginInfo;
    private int partitionCount;
    private int notifiedPartitionCount;
    private ContainerHashMode containerHashMode;
    private NodeConnection masterConnection;
    private final BasicBuffer req = new BasicBuffer(64);
    private final BasicBuffer resp = new BasicBuffer(64);
    private long notificationReceiveTimeoutMillis = 10000L;
    private volatile long connectionTrialCounter;
    private boolean connectionFailedPreviously;
    private final InternPool<InetSocketAddress> addressCache = new InternPool();
    private final Map<Integer, InetSocketAddress[]> nodeAddressMap = new HashMap<Integer, InetSocketAddress[]>();
    private int preferableConnectionPoolSize;
    private final ServiceAddressResolver serviceAddressResolver;
    private final Random random = new Random();
    private int lastSelectedMember = -1;
    private boolean alwaysMaster = false;
    private ProtocolConfig protocolConfig;

    public NodeResolver(NodeConnectionPool pool, boolean passive, InetSocketAddress address, NodeConnection.Config connectionConfig, NodeConnection.LoginInfo loginInfo, int partitionCount, ServiceAddressResolver.Config sarConfig, List<InetSocketAddress> memberList, AddressConfig addressConfig) throws GSException {
        this.pool = pool;
        this.ipv6Enabled = sarConfig == null ? address.getAddress() instanceof Inet6Address : sarConfig.isIPv6Expected();
        this.notificationAddress = passive ? address : null;
        this.masterAddress = passive ? null : address;
        this.connectionConfig.set(connectionConfig);
        this.loginInfo = new NodeConnection.LoginInfo(loginInfo);
        this.loginInfo.setDatabase(NodeConnection.LoginInfo.DEFAULT_DATABASE_NAME);
        this.loginInfo.setOwnerMode(false);
        this.partitionCount = partitionCount;
        this.containerHashMode = passive ? null : ContainerHashMode.CRC32;
        this.preferableConnectionPoolSize = pool.getMaxSize();
        this.serviceAddressResolver = NodeResolver.makeServiceAddressResolver(sarConfig, memberList, addressConfig);
        this.protocolConfig = DEFAULT_PROTOCOL_CONFIG;
        if (addressConfig != null) {
            this.alwaysMaster = addressConfig.alwaysMaster;
        }
        NodeConnection.fillRequestHead(this.ipv6Enabled, this.req);
    }

    private static ServiceAddressResolver makeServiceAddressResolver(ServiceAddressResolver.Config sarConfig, List<InetSocketAddress> memberList, AddressConfig addressConfig) throws GSException {
        if (sarConfig == null) {
            return null;
        }
        if (addressConfig == null) {
            return NodeResolver.makeServiceAddressResolver(sarConfig, memberList, DEFAULT_ADDRESS_CONFIG);
        }
        ServiceAddressResolver resolver = new ServiceAddressResolver(sarConfig);
        resolver.initializeType(0, addressConfig.serviceType);
        if (sarConfig.getProviderURL() == null && memberList.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (sarConfig.getProviderURL() == null) {
            for (int i = 0; i < memberList.size(); ++i) {
                resolver.setAddress(i, 0, memberList.get(i));
            }
            resolver.validate();
        }
        return resolver;
    }

    public synchronized void setUser(String user) {
        this.loginInfo.setUser(user);
    }

    public synchronized void setPassword(String password) {
        this.loginInfo.setPassword(password);
    }

    public synchronized void setConnectionConfig(NodeConnection.Config connectionConfig) {
        this.connectionConfig.set(connectionConfig);
    }

    public synchronized void setNotificationReceiveTimeoutMillis(long timeout) {
        this.notificationReceiveTimeoutMillis = timeout;
    }

    public synchronized void setPreferableConnectionPoolSize(int size) {
        if (size >= 0 && this.preferableConnectionPoolSize != size) {
            this.preferableConnectionPoolSize = size;
            this.updateConnectionPoolSize();
        }
    }

    public synchronized void setProtocolConfig(ProtocolConfig protocolConfig) {
        this.protocolConfig = protocolConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPartitionCount() throws GSException {
        long startTrialCount = this.connectionTrialCounter;
        NodeResolver nodeResolver = this;
        synchronized (nodeResolver) {
            if (this.partitionCount <= 0) {
                this.prepareMasterConnection(startTrialCount);
            }
            return this.partitionCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContainerHashMode getContainerHashMode() throws GSException {
        long startTrialCount = this.connectionTrialCounter;
        NodeResolver nodeResolver = this;
        synchronized (nodeResolver) {
            if (this.containerHashMode == null) {
                this.prepareMasterConnection(startTrialCount);
            }
            return this.containerHashMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetSocketAddress getMasterAddress() throws GSException {
        long startTrialCount = this.connectionTrialCounter;
        NodeResolver nodeResolver = this;
        synchronized (nodeResolver) {
            if (this.masterAddress == null) {
                this.prepareMasterConnection(startTrialCount);
            }
            return this.masterAddress;
        }
    }

    public InetSocketAddress getNodeAddress(int partitionId, boolean backupPreferred) throws GSException {
        return this.getNodeAddress(partitionId, backupPreferred, -1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetSocketAddress getNodeAddress(int partitionId, boolean backupPreferred, int partitionCount, InetAddress preferableHost) throws GSException {
        InetSocketAddress[] addressList;
        long startTrialCount = this.connectionTrialCounter;
        NodeResolver nodeResolver = this;
        synchronized (nodeResolver) {
            addressList = this.getNodeAddressList(partitionId, backupPreferred, partitionCount, startTrialCount, false);
        }
        int backupCount = addressList.length - 1;
        if (backupPreferred && backupCount > 0) {
            boolean ownerCount = true;
            InetSocketAddress address = addressList[1 + this.random.nextInt(backupCount)];
            if (preferableHost != null && !address.getAddress().equals(preferableHost)) {
                for (int i = 1; i < addressList.length; ++i) {
                    if (!addressList[i].getAddress().equals(preferableHost)) continue;
                    return addressList[i];
                }
            }
            return address;
        }
        return addressList[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetSocketAddress[] getNodeAddressList(int partitionId) throws GSException {
        InetSocketAddress[] addressList;
        long startTrialCount = this.connectionTrialCounter;
        NodeResolver nodeResolver = this;
        synchronized (nodeResolver) {
            addressList = this.getNodeAddressList(partitionId, true, this.partitionCount, startTrialCount, false);
        }
        return Arrays.copyOf(addressList, addressList.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InetSocketAddress[] getNodeAddressList(int partitionId, boolean backupPreferred, int partitionCount, long startTrialCount, boolean allowEmpty) throws GSException {
        Integer partitionIdKey = partitionId;
        InetSocketAddress[] addressList = this.nodeAddressMap.get(partitionId);
        if (addressList != null) {
            return addressList;
        }
        this.prepareMasterConnection(startTrialCount);
        if (partitionCount > 0 && this.partitionCount > 0 && partitionCount != this.partitionCount) {
            throw new GSConnectionException(145000, "Internal error by inconsistent partition count (expected=" + partitionCount + ", current=" + this.partitionCount + ", currentMaster=" + this.masterAddress + ", previousMaster=" + this.prevMasterAddress + ")");
        }
        if (partitionId < 0 || this.partitionCount > 0 && partitionId >= this.partitionCount) {
            throw new GSException(145000, "Internal error by invalid partition ID (partitionId=" + partitionId + ", partitionCount=" + partitionCount + ", masterAddress=" + this.masterAddress + ")");
        }
        NodeConnection.fillRequestHead(this.ipv6Enabled, this.req);
        boolean succeeded = false;
        try {
            NodeConnection.tryPutEmptyOptionalRequest(this.req);
            this.masterConnection.executeStatementDirect(this.protocolConfig.getNormalStatementType(Statement.GET_PARTITION_ADDRESS), partitionId, 0L, this.req, this.resp, null);
            this.acceptPartitionCount(this.resp.base().getInt(), false);
            byte[] addressBuffer = new byte[this.getInetAddressSize()];
            int sockAddrSize = addressBuffer.length + 4;
            byte ownerCount = this.resp.base().get();
            int ownerPosition = this.resp.base().position();
            this.resp.base().position(ownerPosition + sockAddrSize * ownerCount);
            byte backupCount = this.resp.base().get();
            int backupPosition = this.resp.base().position();
            this.resp.base().position(backupPosition + sockAddrSize * backupCount);
            if (ownerCount < 0 || backupCount < 0) {
                throw new GSConnectionException(145031, "Protocol error by negative address count (, masterAddress=" + this.masterAddress + ", partitionId=" + partitionId + ", ownerCount=" + ownerCount + ", backupCount=" + backupCount + ")");
            }
            if (!(ownerCount != 0 || backupCount != 0 && backupPreferred)) {
                if (allowEmpty) {
                    InetSocketAddress[] inetSocketAddressArray = new InetSocketAddress[]{};
                    return inetSocketAddressArray;
                }
                throw new GSConnectionException(145032, "Specified partition is currently not available (masterAddress=" + this.masterAddress + ", partitionId=" + partitionId + ", ownerCount=" + ownerCount + ", backupCount=" + backupCount + ", backupPreferred=" + backupPreferred + ")");
            }
            addressList = new InetSocketAddress[1 + backupCount];
            this.resp.base().position(ownerPosition);
            if (ownerCount > 0) {
                addressList[0] = this.decodeSocketAddress(this.resp, addressBuffer);
            }
            this.resp.base().position(backupPosition);
            for (int i = 1; i < addressList.length; ++i) {
                addressList[i] = this.decodeSocketAddress(this.resp, addressBuffer);
            }
            if (ownerCount > 0) {
                this.nodeAddressMap.put(partitionIdKey, addressList);
            }
            this.updateConnectionPoolSize();
            succeeded = true;
            this.connectionFailedPreviously = false;
            InetSocketAddress[] inetSocketAddressArray = addressList;
            return inetSocketAddressArray;
        }
        finally {
            if (!succeeded) {
                this.connectionFailedPreviously = true;
                try {
                    this.masterConnection.close();
                }
                catch (GSException e) {
                }
                finally {
                    this.masterConnection = null;
                    this.nodeAddressMap.remove(partitionIdKey);
                }
            }
        }
    }

    private int getInetAddressSize() {
        return this.ipv6Enabled ? 16 : 4;
    }

    private InetSocketAddress decodeSocketAddress(BasicBuffer in, byte[] addressBuffer) throws GSConnectionException {
        InetSocketAddress address;
        in.base().get(addressBuffer);
        try {
            address = new InetSocketAddress(InetAddress.getByAddress(addressBuffer), in.base().getInt());
        }
        catch (UnknownHostException e) {
            throw new GSConnectionException(145031, "Prorotol error by invalid address (reason=" + e.getMessage() + ")", e);
        }
        catch (IllegalArgumentException e) {
            throw new GSConnectionException(145031, "Prorotol error by invalid address (reason=" + e.getMessage() + ")", e);
        }
        return this.addressCache.intern(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareMasterConnection(long startTrialCount) throws GSException {
        boolean succeeded = false;
        try {
            if (this.connectionFailedPreviously && startTrialCount != this.connectionTrialCounter) {
                throw new GSConnectionException(145029, "Previously failed in the other thread");
            }
            if (this.masterAddress == null) {
                ++this.connectionTrialCounter;
                if (this.serviceAddressResolver == null) {
                    this.updateMasterInfo();
                } else {
                    this.updateNotificationMember();
                }
            }
            while (!this.tryUpdateMasterConnection()) {
                ++this.connectionTrialCounter;
            }
            succeeded = true;
            this.connectionFailedPreviously = false;
        }
        finally {
            if (!succeeded) {
                this.connectionFailedPreviously = true;
                this.invalidateMaster();
            }
        }
    }

    private void updateNotificationMember() throws GSException {
        URL url = this.serviceAddressResolver.getConfig().getProviderURL();
        if (url == null) {
            return;
        }
        LOGGER.debug("discovery.updatingMember", url, this.serviceAddressResolver.isAvailable());
        try {
            this.serviceAddressResolver.update();
            this.serviceAddressResolver.validate();
        }
        catch (GSException e) {
            if (this.serviceAddressResolver.isAvailable()) {
                LOGGER.info("discovery.previousMember", url, e);
                return;
            }
            throw new GSConnectionException(e);
        }
        if (LOGGER.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            for (int i = 0; i < this.serviceAddressResolver.getEntryCount(); ++i) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                InetSocketAddress address = this.serviceAddressResolver.getAddress(i, 0);
                builder.append(address.getAddress().getHostAddress());
                builder.append(":");
                builder.append(address.getPort());
            }
            builder.append("]");
            LOGGER.debug("discovery.memberUpdated", url, this.serviceAddressResolver.isChanged(), builder.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryUpdateMasterConnection() throws GSException {
        if (this.masterConnection != null) {
            return true;
        }
        NodeConnection pendingConnection = null;
        try {
            InetSocketAddress address;
            if (this.masterAddress == null) {
                int count = this.serviceAddressResolver.getEntryCount();
                if (count == 0) {
                    ServiceAddressResolver.Config config = this.serviceAddressResolver.getConfig();
                    throw new GSConnectionException(123504, "No address found in provider (url=" + config.getProviderURL() + ")");
                }
                int index = this.lastSelectedMember;
                if (index < 0) {
                    index = this.random.nextInt(count);
                } else if (++index >= count) {
                    index = 0;
                }
                this.lastSelectedMember = index;
                address = this.serviceAddressResolver.getAddress(index, 0);
                if (this.alwaysMaster) {
                    this.masterAddress = address;
                    this.containerHashMode = ContainerHashMode.CRC32;
                }
            } else {
                address = this.masterAddress;
            }
            boolean masterResolving = this.masterAddress == null;
            LOGGER.debug("discovery.checkingMaster", this.masterAddress, address);
            pendingConnection = this.pool.resolve(address, this.req, this.resp, this.connectionConfig, this.loginInfo, !this.connectionFailedPreviously);
            NodeConnection.fillRequestHead(this.ipv6Enabled, this.req);
            NodeConnection.tryPutEmptyOptionalRequest(this.req);
            if (masterResolving) {
                this.req.putBoolean(true);
            }
            boolean partitionId = false;
            pendingConnection.executeStatementDirect(this.protocolConfig.getNormalStatementType(Statement.GET_PARTITION_ADDRESS), 0, 0L, this.req, this.resp, null);
            int partitionCount = this.resp.base().getInt();
            if (masterResolving) {
                byte ownerCount = this.resp.base().get();
                byte backupCount = this.resp.base().get();
                if (ownerCount != 0 || backupCount != 0 || this.resp.base().remaining() == 0) {
                    throw new GSConnectionException(145031, "Protocol error by invalid master location");
                }
                boolean masterMatched = this.resp.getBoolean();
                this.containerHashMode = NodeResolver.decodeContainerHashMode(this.resp);
                this.masterAddress = this.decodeSocketAddress(this.resp, new byte[this.getInetAddressSize()]);
                LOGGER.debug("discovery.masterFound", new Object[]{this.masterAddress, pendingConnection.getRemoteSocketAddress(), this.containerHashMode, partitionCount});
                if (!masterMatched) {
                    NodeConnection connection = pendingConnection;
                    pendingConnection = null;
                    this.pool.add(connection);
                }
            }
            if (pendingConnection != null) {
                LOGGER.debug("discovery.masterUpdated", new Object[]{this.notificationAddress, this.masterAddress, this.containerHashMode, partitionCount});
                this.acceptPartitionCount(partitionCount, false);
                this.masterConnection = pendingConnection;
                pendingConnection = null;
            }
            if (pendingConnection != null) {
                this.pool.add(pendingConnection);
            }
        }
        catch (Throwable throwable) {
            if (pendingConnection != null) {
                this.pool.add(pendingConnection);
            }
            throw throwable;
        }
        return this.masterConnection != null;
    }

    private void updateMasterInfo() throws GSException {
        DatagramSocket socket = null;
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("discovery.updatingMaster", this.notificationAddress, this.notificationReceiveTimeoutMillis);
            }
            socket = new MulticastSocket(this.notificationAddress.getPort());
            socket.setSoTimeout(PropertyUtils.timeoutPropertyToIntMillis(this.notificationReceiveTimeoutMillis));
            socket.setReuseAddress(true);
            ((MulticastSocket)socket).joinGroup(this.notificationAddress.getAddress());
            int length = 28 + this.getInetAddressSize() * 2 + 1;
            DatagramPacket packet = new DatagramPacket(new byte[length], length);
            socket.receive(packet);
            if (packet.getLength() != length) {
                throw new GSConnectionException(145031, "Protocol error by invalid packet length (expected=" + length + ", actual=" + packet.getLength() + ")");
            }
            this.resp.clear();
            this.resp.prepare(length);
            this.resp.base().put(packet.getData());
            this.resp.base().flip();
            this.resp.base().position(16 + this.getInetAddressSize());
            int statementType = this.resp.base().getInt();
            if (statementType != this.protocolConfig.getNotificationStatementType()) {
                throw new GSConnectionException(145031, "Protocol error by illegal statement type (type=" + this.resp.base().getInt() + ")");
            }
            byte[] addressData = new byte[this.getInetAddressSize()];
            this.resp.base().get(addressData);
            InetSocketAddress masterAddress = new InetSocketAddress(InetAddress.getByAddress(addressData), this.resp.base().getInt());
            int partitionCount = this.resp.base().getInt();
            if (partitionCount <= 0) {
                throw new GSConnectionException(145031, "Protocol error by negative partition count");
            }
            ContainerHashMode containerHashMode = NodeResolver.decodeContainerHashMode(this.resp);
            this.acceptPartitionCount(partitionCount, true);
            this.masterAddress = masterAddress;
            this.containerHashMode = containerHashMode;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("discovery.masterUpdated", new Object[]{this.notificationAddress, masterAddress, containerHashMode, partitionCount});
            }
        }
        catch (IOException e) {
            throw new GSConnectionException(145028, "Failed to update by notification (address=" + this.notificationAddress + ", reason=" + e.getMessage() + ")", e);
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

    private static ContainerHashMode decodeContainerHashMode(BasicBuffer in) throws GSException {
        try {
            return in.getByteEnum(ContainerHashMode.class);
        }
        catch (IllegalStateException e) {
            throw new GSConnectionException(145031, "Protocol error by illegal hash mode (reason=" + e + ")", e);
        }
    }

    public synchronized void invalidateMaster() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("discovery.invalidatingMaster", new Object[]{this.notificationAddress, this.masterAddress, this.containerHashMode, this.partitionCount, this.masterConnection != null});
        }
        this.nodeAddressMap.clear();
        this.addressCache.clear();
        this.notifiedPartitionCount = 0;
        if (this.notificationAddress != null || this.serviceAddressResolver != null) {
            this.masterAddress = null;
            this.containerHashMode = null;
        }
        if (this.masterConnection != null) {
            try {
                this.masterConnection.close();
            }
            catch (GSException gSException) {
                // empty catch block
            }
            this.masterConnection = null;
        }
        this.updateConnectionPoolSize();
    }

    private void acceptPartitionCount(int partitionCount, boolean fromNotification) throws GSConnectionException {
        block5: {
            block7: {
                block6: {
                    if (partitionCount <= 0) {
                        throw new GSConnectionException(145031, "Protocol error by negative partition count");
                    }
                    if (partitionCount == this.partitionCount) {
                        return;
                    }
                    if (this.partitionCount > 0) break block5;
                    if (!fromNotification) break block6;
                    this.notifiedPartitionCount = partitionCount;
                    break block7;
                }
                if (this.notifiedPartitionCount > 0 && partitionCount != this.notifiedPartitionCount) break block5;
                this.partitionCount = partitionCount;
                this.prevMasterAddress = this.masterAddress;
            }
            return;
        }
        String clusterName = this.loginInfo.getClusterName() == null || this.loginInfo.getClusterName().isEmpty() ? null : this.loginInfo.getClusterName();
        throw new GSConnectionException(145033, "Multiple cluster detected with same network configuration or fundamental cluster configuration has been changed by receiving different partition count. Same cluster name might be assigned at the different cluster. Please check cluster configuration (specifiedPartitionCount=" + partitionCount + ", prevPartitionCount=" + (this.partitionCount <= 0 ? "(not yet set)" : Integer.valueOf(this.partitionCount)) + ", prevMasterAddress=" + (this.prevMasterAddress == null ? "(not yet set)" : this.prevMasterAddress) + ", fromNotification=" + fromNotification + (fromNotification ? ", notificationAddress=" + this.notificationAddress : ", masterAddress=" + this.masterAddress) + ", clusterName=" + (clusterName == null ? "(not specified)" : clusterName) + ")");
    }

    private void updateConnectionPoolSize() {
        this.pool.setMaxSize(Math.max(this.preferableConnectionPoolSize, this.addressCache.size()));
    }

    @Override
    public synchronized void close() throws GSException {
        if (this.masterConnection != null) {
            this.pool.add(this.masterConnection);
            this.masterConnection = null;
        }
    }

    public static InetSocketAddress getAddressProperties(PropertyUtils.WrappedProperties props, boolean[] passive, ServiceAddressResolver.Config sarConfig, List<InetSocketAddress> memberList, AddressConfig addressConfig) throws GSException {
        if (addressConfig == null) {
            return NodeResolver.getAddressProperties(props, passive, sarConfig, memberList, DEFAULT_ADDRESS_CONFIG);
        }
        String host = props.getProperty("host", false);
        passive[0] = host == null;
        String ipProtocol = props.getProperty("ipProtocol", true);
        boolean ipv6Enabled = ipv6EnabledDefault;
        if (ipProtocol != null) {
            if (ipProtocol.equals("IPV6")) {
                ipv6Enabled = true;
            }
            if (ipProtocol.equals("IPV4")) {
                ipv6Enabled = false;
            } else {
                throw new GSException(145002, "Illegal IP type (type=" + ipProtocol + ")");
            }
        }
        InetAddress address = NodeResolver.getNotificationProperties(props, host, ipv6Enabled, sarConfig, memberList, addressConfig);
        String portKey = passive[0] ? "notificationPort" : "port";
        Integer port = props.getIntProperty(portKey, false);
        if (port == null) {
            if (passive[0]) {
                port = addressConfig.notificationPort;
            } else if (address != null) {
                throw new GSException(145002, "Port must be specified");
            }
        }
        if (port != null && (port < 0 || port >= 65536)) {
            throw new GSException(145002, "Port out of range (port=" + port + ", propertyName=" + portKey + ")");
        }
        if (address == null) {
            return null;
        }
        return new InetSocketAddress(address, (int)port);
    }

    public static InetAddress getNotificationProperties(PropertyUtils.WrappedProperties props, String host, Boolean ipv6Expected, ServiceAddressResolver.Config sarConfig, List<InetSocketAddress> memberList, AddressConfig addressConfig) throws GSException {
        PropertyUtils.checkExclusiveProperties(props.getBase(), "notificationProvider", "notificationMember", "notificationAddress");
        PropertyUtils.checkExclusiveProperties(props.getBase(), "notificationProvider", "host");
        PropertyUtils.checkExclusiveProperties(props.getBase(), "notificationMember", "host");
        String notificationProvider = props.getProperty("notificationProvider", false);
        String notificationMember = props.getProperty("notificationMember", false);
        String notificationAddress = props.getProperty("notificationAddress", false);
        if (notificationProvider != null) {
            sarConfig.setProviderURL(notificationProvider);
        }
        sarConfig.setIPv6Expected(ipv6Expected != null && ipv6Expected != false);
        sarConfig.setTimeoutMillis((int)Math.min(props.getTimeoutProperty("notificationProviderTimeout", -1L, false), Integer.MAX_VALUE));
        memberList.addAll(NodeResolver.parseNotificationMember(notificationMember, ipv6Expected));
        if (notificationProvider != null || notificationMember != null) {
            return null;
        }
        if (host == null) {
            return NodeResolver.getNotificationAddress(notificationAddress, ipv6Expected, addressConfig, "notificationAddress");
        }
        return NodeResolver.getNotificationAddress(host, ipv6Expected, addressConfig, "host");
    }

    private static InetAddress getNotificationAddress(String host, Boolean ipv6Expected, AddressConfig config, String key) throws GSException {
        if (host == null) {
            String alternative = ipv6Expected != null && ipv6Expected != false ? config.notificationAddressV6 : config.notificationAddress;
            return ServiceAddressResolver.resolveAddress(alternative, ipv6Expected, key);
        }
        return ServiceAddressResolver.resolveAddress(host, ipv6Expected, key);
    }

    public static List<InetSocketAddress> parseNotificationMember(String value, Boolean ipv6Expected) throws GSException {
        if (value == null) {
            return Collections.emptyList();
        }
        if (value.isEmpty()) {
            throw new GSException(145001, "Notification member is empty");
        }
        ArrayList<InetSocketAddress> list = new ArrayList<InetSocketAddress>();
        for (String addrStr : value.split(",", -1)) {
            InetAddress inetAddr;
            int port;
            if (addrStr.isEmpty()) {
                throw new GSException(145002, "One or more element in notifications member are empty (element=" + addrStr + ", list=" + value + ")");
            }
            int portPos = addrStr.lastIndexOf(":");
            int v6AddrEnd = addrStr.lastIndexOf("]");
            if (portPos < 0 || portPos < v6AddrEnd) {
                throw new GSException(145002, "Port not found in notification member (element=" + addrStr + ", list=" + value + ")");
            }
            try {
                port = Integer.parseInt(addrStr.substring(portPos + 1));
            }
            catch (NumberFormatException e) {
                throw new GSException(145002, "Failed to parse port in notification member (element=" + addrStr + ", list=" + value + ", reason=" + e.getMessage() + ")", e);
            }
            try {
                inetAddr = ServiceAddressResolver.resolveAddress(addrStr.substring(0, portPos), ipv6Expected, null);
            }
            catch (GSException e) {
                throw new GSException(145002, "Failed to resolve host in notification member (element=" + addrStr + ", list=" + value + ", reason=" + e.getMessage() + ")", e);
            }
            try {
                list.add(new InetSocketAddress(inetAddr, port));
            }
            catch (IllegalArgumentException e) {
                throw new GSException(145002, "Illegal port in notification member (element=" + addrStr + ", list=" + value + ", reason=" + e.getMessage() + ")", e);
            }
        }
        return list;
    }

    public static class AddressConfig {
        public int notificationPort = 31999;
        public String notificationAddress = "239.0.0.1";
        public String notificationAddressV6 = "ff12::1";
        public String serviceType = "transaction";
        public boolean alwaysMaster = false;
    }

    private static class DefaultProtocolConfig
    extends ProtocolConfig {
        private DefaultProtocolConfig() {
        }

        @Override
        public int getNotificationStatementType() {
            return 5000;
        }

        @Override
        public int getNormalStatementType(Statement statement) {
            if (statement == Statement.GET_PARTITION_ADDRESS) {
                return NodeConnection.statementToNumber(statement);
            }
            throw new Error();
        }
    }

    public static abstract class ProtocolConfig {
        public abstract int getNotificationStatementType();

        public abstract int getNormalStatementType(Statement var1);
    }

    public static enum ContainerHashMode {
        CRC32;

    }
}

