/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.subnet;

import com.toshiba.mwcloud.gs.Collection;
import com.toshiba.mwcloud.gs.ColumnInfo;
import com.toshiba.mwcloud.gs.CompressionMethod;
import com.toshiba.mwcloud.gs.Container;
import com.toshiba.mwcloud.gs.ContainerInfo;
import com.toshiba.mwcloud.gs.ContainerType;
import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.GSType;
import com.toshiba.mwcloud.gs.GridStore;
import com.toshiba.mwcloud.gs.IndexType;
import com.toshiba.mwcloud.gs.PartitionController;
import com.toshiba.mwcloud.gs.Query;
import com.toshiba.mwcloud.gs.Row;
import com.toshiba.mwcloud.gs.RowKeyPredicate;
import com.toshiba.mwcloud.gs.TimeSeries;
import com.toshiba.mwcloud.gs.TimeSeriesProperties;
import com.toshiba.mwcloud.gs.TimeUnit;
import com.toshiba.mwcloud.gs.TriggerInfo;
import com.toshiba.mwcloud.gs.common.BasicBuffer;
import com.toshiba.mwcloud.gs.common.BlobImpl;
import com.toshiba.mwcloud.gs.common.GSConnectionException;
import com.toshiba.mwcloud.gs.common.GSStatementException;
import com.toshiba.mwcloud.gs.common.LoggingUtils;
import com.toshiba.mwcloud.gs.common.RowMapper;
import com.toshiba.mwcloud.gs.common.Statement;
import com.toshiba.mwcloud.gs.experimental.ContainerAttribute;
import com.toshiba.mwcloud.gs.experimental.ContainerCondition;
import com.toshiba.mwcloud.gs.experimental.DatabaseInfo;
import com.toshiba.mwcloud.gs.experimental.ExtendedContainerInfo;
import com.toshiba.mwcloud.gs.experimental.PrivilegeInfo;
import com.toshiba.mwcloud.gs.experimental.UserInfo;
import com.toshiba.mwcloud.gs.subnet.GridStoreChannel;
import com.toshiba.mwcloud.gs.subnet.NodeConnection;
import com.toshiba.mwcloud.gs.subnet.SubnetCollection;
import com.toshiba.mwcloud.gs.subnet.SubnetContainer;
import com.toshiba.mwcloud.gs.subnet.SubnetPartitionController;
import com.toshiba.mwcloud.gs.subnet.SubnetQuery;
import com.toshiba.mwcloud.gs.subnet.SubnetTimeSeries;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Blob;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class SubnetGridStore
implements GridStore {
    private static final boolean ENABLE_COMPRESSION_WINDOW_SIZE = true;
    private static boolean OLD_TIME_SERIES_PRORERTIES = false;
    private static final RowMapper.BlobFactory BLOB_FACTORY = new RowMapper.BlobFactory(){

        @Override
        public Blob createBlob(byte[] data) throws GSException {
            BlobImpl blob = new BlobImpl(null);
            blob.setDataDirect(data);
            return blob;
        }
    };
    private static final LoggingUtils.BaseGridStoreLogger LOGGER = LoggingUtils.getLogger("Transaction");
    private static boolean pathKeyOperationEnabled = false;
    static final String SYSTEM_USER_CONTAINER_NAME = "gs#users@0";
    private static final byte DEFAULT_DBUSER_PROPERTY = 0;
    private static final String DEFAULT_PRIVILEGE = "ALL";
    private static final int USER_INFO_COUNT_LIMIT = 128;
    private static final int DATABASE_INFO_COUNT_LIMIT = 128;
    private static final int USER_PASSWORD_LENGTH_LIMIT = 64;
    private final GridStoreChannel channel;
    private final GridStoreChannel.Context context;
    private final GridStoreChannel.ContextReference contextRef;
    private final NamedContainerMap<SubnetContainer<?, ?>> containerMap;
    private final GridStoreChannel.ContextMonitor contextMonitor = GridStoreChannel.createContextMonitorIfAvailable();
    private static final String CONTEXT_CONTROLLER_NAME = "##internal.contextController";

    public SubnetGridStore(GridStoreChannel channel, GridStoreChannel.Context context) throws GSException {
        this.channel = channel;
        this.context = context;
        this.contextRef = channel.registerContext(context, this);
        if (context.getContainerCache() != null) {
            context.addRemoteReference(new CacheReference(this, context));
        }
        this.containerMap = pathKeyOperationEnabled ? SubnetGridStore.makeContainerMap() : null;
    }

    private static NamedContainerMap<SubnetContainer<?, ?>> makeContainerMap() {
        return new NamedContainerMap<SubnetContainer<?, ?>>(){

            @Override
            protected Class<?> getRowType(SubnetContainer<?, ?> container) {
                return container.getRowMapper().getRowType();
            }
        };
    }

    static void setPathKeyOperationEnabled(boolean pathKeyOperationEnabled) {
        SubnetGridStore.pathKeyOperationEnabled = pathKeyOperationEnabled;
    }

    public GridStoreChannel getChannel() {
        return this.channel;
    }

    public GridStoreChannel.Context getContext() {
        return this.context;
    }

    private void executeStatement(Statement statement, int partitionId, BasicBuffer req, BasicBuffer resp, String containerName) throws GSException {
        this.beginComplexedStatement(statement, partitionId, containerName);
        this.channel.executeStatement(this.context, statement, partitionId, 0L, req, resp, this.contextMonitor);
        this.endComplexedStatement();
    }

    private void beginComplexedStatement(Statement statement, int partitionId, String containerName) {
        if (this.contextMonitor != null) {
            this.contextMonitor.setContainerName(containerName);
            this.contextMonitor.startStatement(statement, 0L, partitionId, null);
        }
    }

    private void endComplexedStatement() {
        if (this.contextMonitor != null) {
            this.contextMonitor.endStatement();
        }
    }

    private SubnetContainer<?, ?> resolveContainer(String containerName, Class<?> rowType) throws GSException {
        if (this.containerMap == null) {
            throw new GSException(145003, "Path key operation is restricted");
        }
        SubnetContainer<?, ?> container = this.containerMap.get(containerName, rowType);
        if (container == null) {
            throw new GSException(145034, "Related container not opened (name=" + containerName + ", rowType=" + (rowType == null ? "" : rowType.getName()) + ")");
        }
        return this.duplicateContainer(container);
    }

    private <R> SubnetContainer<?, R> duplicateContainer(SubnetContainer<?, R> base) throws GSException {
        RowMapper mapper = base.getRowMapper();
        if (mapper.isForTimeSeries()) {
            return new SubnetTimeSeries<R>(this, this.channel, this.context, base.getRowType(), mapper, base.getSchemaVersionId(), base.getPartitionId(), base.getContainerId(), null, null);
        }
        return new SubnetCollection(this, this.channel, this.context, base.getRowType(), mapper, base.getSchemaVersionId(), base.getPartitionId(), base.getContainerId(), null, null);
    }

    void createReference(SubnetContainer<?, ?> container) throws GSException {
        if (this.containerMap == null) {
            return;
        }
        this.containerMap.add(container.getNormalizedContainerName(), container);
    }

    void removeReference(SubnetContainer<?, ?> container) {
        if (this.containerMap == null) {
            return;
        }
        this.containerMap.remove(container.getNormalizedContainerName(), container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(String pathKey, Object rowObject) throws GSException {
        String[] keyElements = SubnetGridStore.splitPathKey(pathKey);
        SubnetContainer<?, ?> container = this.resolveContainer(keyElements[0], rowObject.getClass());
        try {
            RowMapper mapper = container.getRowMapper();
            Object key = mapper.resolveKey(keyElements[1]);
            boolean bl = SubnetGridStore.putChecked(container, key, rowObject);
            return bl;
        }
        finally {
            container.close();
        }
    }

    private static <R> boolean putChecked(SubnetContainer<?, R> container, Object key, Object row) throws GSException {
        SubnetContainer<Object, R> typedContainer = SubnetGridStore.disguiseTypedContainer(container);
        Class<R> rowType = typedContainer.getRowType();
        return typedContainer.put(key, rowType.cast(row));
    }

    @Override
    public Object get(String pathKey) throws GSException {
        return this.getByPathKey(pathKey, null);
    }

    @Override
    public <R> R get(String pathKey, Class<R> rowType) throws GSException {
        return rowType.cast(this.getByPathKey(pathKey, rowType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getByPathKey(String pathKey, Class<?> rowType) throws GSException {
        String[] keyElements = SubnetGridStore.splitPathKey(pathKey);
        SubnetContainer<Object, ?> container = SubnetGridStore.disguiseTypedContainer(this.resolveContainer(keyElements[0], rowType));
        try {
            RowMapper mapper = container.getRowMapper();
            Object key = mapper.resolveKey(keyElements[1]);
            Object obj = container.get(key);
            return obj;
        }
        finally {
            container.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(String pathKey) throws GSException {
        String[] keyElements = SubnetGridStore.splitPathKey(pathKey);
        SubnetContainer<Object, ?> container = SubnetGridStore.disguiseTypedContainer(this.resolveContainer(keyElements[0], null));
        try {
            RowMapper mapper = container.getRowMapper();
            Object key = mapper.resolveKey(keyElements[1]);
            boolean bl = container.remove(key);
            return bl;
        }
        finally {
            container.close();
        }
    }

    private static String[] splitPathKey(String pathKey) throws GSException {
        String[] components = pathKey.split("/", 2);
        if (components.length != 2) {
            throw new GSException(145002, "Invalid path key (value=" + pathKey + ")");
        }
        return components;
    }

    private static void tryPutDatabaseOptionalRequest(BasicBuffer req, GridStoreChannel.Context context) {
        NodeConnection.tryPutEmptyOptionalRequest(req);
    }

    public static void tryPutSystemOptionalRequest(BasicBuffer req, GridStoreChannel.Context context, boolean systemMode) {
        if (!systemMode) {
            NodeConnection.tryPutEmptyOptionalRequest(req);
            return;
        }
        NodeConnection.OptionalRequest optionalRequest = context.getOptionalRequest();
        optionalRequest.put(NodeConnection.OptionalRequestType.SYSTEM_MODE, systemMode);
        optionalRequest.format(req);
    }

    public static int getContainerAttributeFlag(ContainerAttribute attribute) throws GSException {
        switch (attribute) {
            case BASE: {
                return 0;
            }
            case BASE_SYSTEM: {
                return 1;
            }
            case SINGLE: {
                return 16;
            }
            case SINGLE_SYSTEM: {
                return 17;
            }
            case SINGLE_SEMI_PERMANENT_SYSTEM: {
                return 21;
            }
            case LARGE: {
                return 32;
            }
            case SUB: {
                return 48;
            }
        }
        throw new InternalError();
    }

    public static ContainerAttribute getContainerAttribute(int flag) throws GSException {
        for (ContainerAttribute elem : ContainerAttribute.values()) {
            if (SubnetGridStore.getContainerAttributeFlag(elem) != flag) continue;
            return elem;
        }
        return null;
    }

    private static void tryPutAttributeOptionalRequest(BasicBuffer req, GridStoreChannel.Context context, boolean systemMode, ContainerInfo containerInfo) throws GSException {
        ContainerAttribute attribute = containerInfo instanceof ExtendedContainerInfo ? ((ExtendedContainerInfo)containerInfo).getAttribute() : null;
        if (!systemMode && attribute == null) {
            NodeConnection.tryPutEmptyOptionalRequest(req);
            return;
        }
        NodeConnection.OptionalRequest optionalRequest = context.getOptionalRequest();
        if (systemMode) {
            optionalRequest.put(NodeConnection.OptionalRequestType.SYSTEM_MODE, systemMode);
        }
        if (attribute != null) {
            optionalRequest.put(NodeConnection.OptionalRequestType.CONTAINER_ATTRIBUTE, SubnetGridStore.getContainerAttributeFlag(attribute));
        }
        optionalRequest.format(req);
    }

    @Override
    public ContainerInfo getContainerInfo(String name) throws GSException {
        return this.getExtendedContainerInfo(name, false);
    }

    public ExtendedContainerInfo getExtendedContainerInfo(String name, boolean systemMode) throws GSException {
        return this.getExtendedContainerInfo(name, EnumSet.allOf(ContainerPropertyType.class), null, systemMode);
    }

    private ExtendedContainerInfo getExtendedContainerInfo(String name, EnumSet<ContainerPropertyType> typeSet, ContainerIdInfo[] containerIdInfoResult, boolean systemMode) throws GSException {
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        SubnetGridStore.tryPutSystemOptionalRequest(req, this.context, systemMode);
        int partitionId = this.channel.resolvePartitionId(this.context, name);
        req.putString(name);
        req.putInt(((AbstractCollection)typeSet).size());
        if (NodeConnection.getProtocolVersion() < 2 || GridStoreChannel.v1ProtocolCompatible_1_1_103x) {
            typeSet = ((EnumSet)typeSet).clone();
            ((AbstractCollection)typeSet).remove((Object)ContainerPropertyType.TRIGGER);
        }
        Iterator i$ = ((AbstractCollection)typeSet).iterator();
        while (i$.hasNext()) {
            ContainerPropertyType type = (ContainerPropertyType)((Object)i$.next());
            req.putByteEnum(type);
        }
        this.executeStatement(Statement.GET_CONTAINER_PROPERTIES, partitionId, req, resp, name);
        boolean found = resp.getBoolean();
        if (!found) {
            return null;
        }
        int propertyCount = resp.base().getInt();
        if (propertyCount != ((AbstractCollection)typeSet).size()) {
            throw new GSConnectionException(145031, "Protocol error by illegal property count (expected=" + ((AbstractCollection)typeSet).size() + ", actual=" + propertyCount + ")");
        }
        ContainerIdInfo containerIdInfo = null;
        Boolean[] keyAssigned = new Boolean[1];
        String[] dataAffinity = new String[1];
        ContainerType[] containerType = new ContainerType[1];
        ArrayList<String> columnNameList = new ArrayList<String>();
        ArrayList<GSType> columnTypeList = new ArrayList<GSType>();
        TimeSeriesProperties tsProps = null;
        ContainerAttribute containerAttribute = null;
        ArrayList<Set<IndexType>> indexTypesList = new ArrayList<Set<IndexType>>();
        ArrayList<URL> eventNotificationList = new ArrayList<URL>();
        ArrayList<TriggerInfo> triggerList = new ArrayList<TriggerInfo>();
        for (int i = 0; i < propertyCount; ++i) {
            ContainerPropertyType propertyType = resp.getByteEnum(ContainerPropertyType.class);
            int propertySize = resp.base().getInt();
            if (propertySize < 0 || propertySize > resp.base().remaining()) {
                throw new GSConnectionException(145031, "Protocol error by illegal property size");
            }
            int curEnd = resp.base().position() + propertySize;
            switch (propertyType) {
                case ID: {
                    containerIdInfo = SubnetGridStore.importIdProperty(resp);
                    if (containerIdInfoResult == null) break;
                    containerIdInfoResult[0] = containerIdInfo;
                    break;
                }
                case SCHEMA: {
                    SubnetGridStore.importSchemaProperty(resp, columnNameList, columnTypeList, containerType, keyAssigned);
                    tsProps = SubnetGridStore.importContainerProperties(resp, columnNameList, dataAffinity, containerType[0]);
                    break;
                }
                case INDEX: {
                    SubnetGridStore.importIndexProperty(resp, indexTypesList, columnNameList.size());
                    break;
                }
                case EVENT_NOTIFICATION: {
                    SubnetGridStore.importEventNotificationProperty(resp, eventNotificationList);
                    break;
                }
                case TRIGGER: {
                    SubnetGridStore.importTriggerProperty(resp, columnNameList, triggerList);
                    break;
                }
                case ATTRIBUTE: {
                    containerAttribute = SubnetGridStore.getContainerAttribute(resp.base().getInt());
                    break;
                }
                default: {
                    throw new GSConnectionException(145031, "Protocol error by illegal property type");
                }
            }
            if (resp.base().position() == curEnd) continue;
            throw new GSConnectionException(145031, "Protocol error by illegal property format");
        }
        ArrayList<ColumnInfo> columnInfoList = new ArrayList<ColumnInfo>();
        for (int i = 0; i < columnNameList.size(); ++i) {
            columnInfoList.add(new ColumnInfo((String)columnNameList.get(i), (GSType)((Object)columnTypeList.get(i)), (Set)indexTypesList.get(i)));
        }
        ExtendedContainerInfo containerInfo = new ExtendedContainerInfo();
        containerInfo.setName(containerIdInfo.remoteName);
        containerInfo.setType(containerType[0]);
        containerInfo.setColumnInfoList(columnInfoList);
        containerInfo.setRowKeyAssigned(keyAssigned[0]);
        containerInfo.setAttribute(containerAttribute);
        containerInfo.setTimeSeriesProperties(tsProps);
        containerInfo.setTriggerInfoList(triggerList);
        containerInfo.setDataAffinity(dataAffinity[0]);
        return containerInfo;
    }

    public <K, R> SubnetCollection<K, R> putCollection(String name, Class<R> rowType) throws GSException {
        return this.putCollection(name, (Class)rowType, false);
    }

    public static String normalizeFullContainerName(String name) throws GSException {
        return RowMapper.normalizeExtendedSymbol(name, true);
    }

    private <K, R> SubnetContainer<K, R> findContainerByCache(GridStoreChannel.ContainerCache cache, String name, Class<R> rowType, ContainerType containerType) throws GSException {
        String normalizedName = SubnetGridStore.normalizeFullContainerName(name);
        GridStoreChannel.LocatedSchema schema = cache.findSchema(normalizedName, rowType, containerType);
        if (schema == null) {
            return null;
        }
        int partitionId = this.channel.resolvePartitionId(this.context, normalizedName);
        if (containerType == ContainerType.COLLECTION) {
            return new SubnetCollection(this, this.channel, this.context, rowType, schema.getMapper(), schema.getVersionId(), partitionId, schema.getContainerId(), normalizedName, schema.getContainerName());
        }
        return SubnetGridStore.disguiseTypedContainer(new SubnetTimeSeries<R>(this, this.channel, this.context, rowType, schema.getMapper(), schema.getVersionId(), partitionId, schema.getContainerId(), normalizedName, schema.getContainerName()));
    }

    public static boolean isContainerStatementUnified() {
        return NodeConnection.getProtocolVersion() >= 3;
    }

    public static boolean isSessionUUIDSummarized() {
        return NodeConnection.getProtocolVersion() >= 3;
    }

    public static boolean isTSDivisionAndAffinityEnabled() {
        return NodeConnection.getProtocolVersion() >= 3 && !GridStoreChannel.v15TSPropsCompatible;
    }

    private static Statement getContainerStatement(Statement statement, ContainerType containerType) {
        if (SubnetGridStore.isContainerStatementUnified()) {
            return statement;
        }
        if (containerType == ContainerType.TIME_SERIES) {
            switch (statement) {
                case PUT_CONTAINER: {
                    return Statement.PUT_TIME_SERIES;
                }
                case GET_CONTAINER: {
                    return Statement.GET_TIME_SERIES;
                }
                case DROP_CONTAINER: {
                    return Statement.DROP_TIME_SERIES;
                }
            }
            throw new Error("Internal error by invalid container statement (statement=" + (Object)((Object)statement) + ")");
        }
        if (containerType == ContainerType.COLLECTION) {
            if (statement == Statement.DROP_CONTAINER) {
                return Statement.DROP_COLLECTION;
            }
            return statement;
        }
        return statement;
    }

    private static void tryPutContainerType(BasicBuffer req, ContainerType containerType) {
        if (!SubnetGridStore.isContainerStatementUnified()) {
            return;
        }
        if (containerType == null) {
            req.put((byte)-1);
        } else {
            req.putByteEnum(containerType);
        }
    }

    private <K, R> SubnetContainer<K, R> putContainer(String name, ContainerType containerType, Class<R> rowType, ContainerInfo info, boolean modifiable) throws GSException {
        SubnetContainer<K, R> cachedContainer;
        GridStoreChannel.ContainerCache cache = this.context.getContainerCache();
        if (cache != null && !modifiable && info == null && (cachedContainer = this.findContainerByCache(cache, name, rowType, containerType)) != null) {
            return cachedContainer;
        }
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        SubnetGridStore.tryPutSystemOptionalRequest(req, this.context, false);
        boolean forTimeSeries = containerType == ContainerType.TIME_SERIES;
        RowMapper orgMapper = RowMapper.getInstance(rowType, forTimeSeries);
        int partitionId = this.channel.resolvePartitionId(this.context, name);
        req.putString(name);
        SubnetGridStore.tryPutContainerType(req, containerType);
        req.putBoolean(modifiable);
        orgMapper.exportSchema(req);
        if (info != null && (info.getColumnCount() > 0 || info.isRowKeyAssigned() || info.isColumnOrderIgnorable())) {
            throw new GSException(145023, "Schema can not be specified on ContainerInfo (columnCount=" + info.getColumnCount() + ", " + "rowKeyAssigned=" + info.isRowKeyAssigned() + ", " + "columnOrderIgnorable=" + info.isColumnOrderIgnorable() + ")");
        }
        this.exportContainerProperties(req, containerType, info, orgMapper, name);
        Statement statement = SubnetGridStore.getContainerStatement(Statement.PUT_CONTAINER, containerType);
        this.executeStatement(statement, partitionId, req, resp, name);
        int schemaVerId = resp.base().getInt();
        long containerId = resp.base().getLong();
        String[] acceptedNames = this.acceptRemoteContainerName(resp, name);
        String normalizedName = acceptedNames[0];
        String remoteName = acceptedNames[1];
        RowMapper mapper = orgMapper.reorderBySchema(resp, true);
        if (cache != null) {
            cache.cacheSchema(normalizedName, new GridStoreChannel.LocatedSchema(mapper, containerId, schemaVerId, remoteName));
        }
        if (forTimeSeries) {
            return SubnetGridStore.disguiseTypedContainer(new SubnetTimeSeries<R>(this, this.channel, this.context, rowType, mapper, schemaVerId, partitionId, containerId, normalizedName, remoteName));
        }
        return new SubnetCollection(this, this.channel, this.context, rowType, mapper, schemaVerId, partitionId, containerId, normalizedName, remoteName);
    }

    public <K, R> SubnetCollection<K, R> putCollection(String name, Class<R> rowType, boolean modifiable) throws GSException {
        SubnetContainer<K, R> container = this.putContainer(name, ContainerType.COLLECTION, rowType, null, modifiable);
        return (SubnetCollection)container;
    }

    public <R> SubnetTimeSeries<R> putTimeSeries(String name, Class<R> rowType) throws GSException {
        SubnetContainer container = this.putContainer(name, ContainerType.TIME_SERIES, rowType, null, false);
        return (SubnetTimeSeries)container;
    }

    public <R> SubnetTimeSeries<R> putTimeSeries(String name, Class<R> rowType, TimeSeriesProperties props, boolean modifiable) throws GSException {
        ContainerInfo info = new ContainerInfo();
        info.setTimeSeriesProperties(props);
        SubnetContainer container = this.putContainer(name, ContainerType.TIME_SERIES, rowType, info, modifiable);
        return (SubnetTimeSeries)container;
    }

    private String[] acceptRemoteContainerName(BasicBuffer in, String localName) throws GSException {
        String remoteName = in.getString();
        return this.filterRemoteContainerName(remoteName, localName);
    }

    private String[] filterRemoteContainerName(String remoteName, String localName) throws GSException {
        String normalizedLocalName = RowMapper.normalizeExtendedSymbol(localName, true);
        if (!remoteName.equals(localName) && !RowMapper.normalizeExtendedSymbol(remoteName, true).equals(normalizedLocalName)) {
            throw new GSConnectionException(145031, "Protocol error by inconsistent container name (localName=" + localName + ", remoteName=" + remoteName + ")");
        }
        return new String[]{!pathKeyOperationEnabled && this.context.getContainerCache() == null ? null : normalizedLocalName, this.contextMonitor == null ? null : remoteName};
    }

    private void exportContainerProperties(BasicBuffer out, ContainerType type, ContainerInfo info, RowMapper mapper, String containerName) throws GSException {
        TimeSeriesProperties tsProps;
        if (SubnetGridStore.isTSDivisionAndAffinityEnabled() && !GridStoreChannel.v20AffinityCompatible) {
            String dataAffinity = info == null ? null : info.getDataAffinity();
            out.putString(dataAffinity == null ? this.context.getDataAffinityPattern().match(containerName, "") : dataAffinity);
        }
        TimeSeriesProperties timeSeriesProperties = tsProps = info == null ? null : info.getTimeSeriesProperties();
        if (type != ContainerType.TIME_SERIES) {
            if (tsProps != null) {
                throw new GSException(145023, "TimeSeriesProperties used except for TimeSeries (containerType=" + (Object)((Object)type) + ")");
            }
            return;
        }
        if (OLD_TIME_SERIES_PRORERTIES) {
            out.putInt(-1);
            out.putByteEnum(TimeUnit.DAY);
            out.putInt(-1);
            out.putByteEnum(TimeUnit.DAY);
            out.putInt(0);
            return;
        }
        if (tsProps == null) {
            out.putBoolean(false);
        } else {
            out.putBoolean(true);
            out.putInt(tsProps.getRowExpirationTime());
            TimeUnit timeUnit = tsProps.getRowExpirationTimeUnit();
            if (timeUnit == null) {
                out.putByteEnum(TimeUnit.DAY);
            } else {
                out.putByteEnum(timeUnit);
            }
            if (SubnetGridStore.isTSDivisionAndAffinityEnabled()) {
                out.putInt(tsProps.getExpirationDivisionCount());
                if (GridStoreChannel.v20AffinityCompatible) {
                    out.putString("");
                }
            }
            out.putInt(tsProps.getCompressionWindowSize());
            timeUnit = tsProps.getCompressionWindowSizeUnit();
            if (timeUnit == null) {
                out.putByteEnum(TimeUnit.DAY);
            } else {
                out.putByteEnum(timeUnit);
            }
            out.putByteEnum(tsProps.getCompressionMethod());
            Set<String> columnNameSet = tsProps.getSpecifiedColumns();
            out.putInt(columnNameSet.size());
            for (String columnName : columnNameSet) {
                out.putInt(mapper.resolveColumnId(columnName));
                boolean relative = tsProps.isCompressionRelative(columnName);
                out.putBoolean(relative);
                if (relative) {
                    out.putDouble(tsProps.getCompressionRate(columnName));
                    out.putDouble(tsProps.getCompressionSpan(columnName));
                    continue;
                }
                out.putDouble(tsProps.getCompressionWidth(columnName));
            }
        }
    }

    private static TimeSeriesProperties importContainerProperties(BasicBuffer in, List<String> columnNameList, String[] dataAffinity, ContainerType containerType) throws GSException {
        if (SubnetGridStore.isTSDivisionAndAffinityEnabled() && !GridStoreChannel.v20AffinityCompatible) {
            dataAffinity[0] = in.getString();
            if (dataAffinity[0].isEmpty()) {
                dataAffinity[0] = null;
            }
        }
        if (containerType != ContainerType.TIME_SERIES) {
            return null;
        }
        boolean exists = in.getBoolean();
        if (!exists) {
            return null;
        }
        TimeSeriesProperties props = new TimeSeriesProperties();
        int rowExpirationTime = in.base().getInt();
        TimeUnit timeUnit = in.getByteEnum(TimeUnit.class);
        if (rowExpirationTime >= 0) {
            props.setRowExpiration(rowExpirationTime, timeUnit);
        }
        if (SubnetGridStore.isTSDivisionAndAffinityEnabled()) {
            int count = in.base().getInt();
            if (count > 0) {
                props.setExpirationDivisionCount(count);
            }
            if (GridStoreChannel.v20AffinityCompatible) {
                in.getString();
            }
        }
        int compressionWindowSize = in.base().getInt();
        timeUnit = in.getByteEnum(TimeUnit.class);
        if (compressionWindowSize >= 0) {
            props.setCompressionWindowSize(compressionWindowSize, timeUnit);
        }
        CompressionMethod compressionMethod = in.getByteEnum(CompressionMethod.class);
        props.setCompressionMethod(compressionMethod);
        int entryCount = in.base().getInt();
        if (entryCount > 0 && compressionMethod != CompressionMethod.HI) {
            throw new GSException(145031, "Protocol error by unexpected compression entry (entryCount=" + entryCount + ", " + "compressionMethod=" + (Object)((Object)compressionMethod) + ")");
        }
        if (entryCount < 0) {
            throw new GSException(145031, "Protocol error by negative entry count (entryCount=" + entryCount + ")");
        }
        for (int i = 0; i < entryCount; ++i) {
            int columnId = in.base().getInt();
            if (columnId < 0 || columnId >= columnNameList.size()) {
                throw new GSException(145031, "Protocol error by illegal column ID (columnId=" + columnId + ", " + "columnCount=" + columnNameList.size() + ")");
            }
            String columnName = columnNameList.get(columnId);
            boolean relative = in.getBoolean();
            if (relative) {
                double rate = in.base().getDouble();
                double span = in.base().getDouble();
                props.setRelativeHiCompression(columnName, rate, span);
                continue;
            }
            double width = in.base().getDouble();
            props.setAbsoluteHiCompression(columnName, width);
        }
        return props;
    }

    private <K, R> SubnetContainer<K, R> getContainer(String name, ContainerType containerType, Class<R> rowType, boolean systemMode) throws GSException {
        SubnetContainer<K, R> cachedContainer;
        GridStoreChannel.ContainerCache cache = this.context.getContainerCache();
        if (cache != null && !systemMode && (cachedContainer = this.findContainerByCache(cache, name, rowType, containerType)) != null) {
            return cachedContainer;
        }
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        SubnetGridStore.tryPutSystemOptionalRequest(req, this.context, systemMode);
        boolean forTimeSeries = containerType == ContainerType.TIME_SERIES;
        RowMapper orgMapper = RowMapper.getInstance(rowType, forTimeSeries);
        int partitionId = this.channel.resolvePartitionId(this.context, name);
        req.putString(name);
        SubnetGridStore.tryPutContainerType(req, containerType);
        Statement statement = SubnetGridStore.getContainerStatement(Statement.GET_CONTAINER, containerType);
        this.executeStatement(statement, partitionId, req, resp, name);
        boolean found = resp.getBoolean();
        if (!found) {
            return null;
        }
        int schemaVerId = resp.base().getInt();
        long containerId = resp.base().getLong();
        String[] acceptedNames = this.acceptRemoteContainerName(resp, name);
        String normalizedName = acceptedNames[0];
        String remoteName = acceptedNames[1];
        RowMapper mapper = orgMapper.reorderBySchema(resp, true);
        if (cache != null && !systemMode) {
            cache.cacheSchema(normalizedName, new GridStoreChannel.LocatedSchema(mapper, containerId, schemaVerId, remoteName));
        }
        if (forTimeSeries) {
            return SubnetGridStore.disguiseTypedContainer(new SubnetTimeSeries<R>(this, this.channel, this.context, rowType, mapper, schemaVerId, partitionId, containerId, normalizedName, remoteName));
        }
        return new SubnetCollection(this, this.channel, this.context, rowType, mapper, schemaVerId, partitionId, containerId, normalizedName, remoteName);
    }

    public <K, R> SubnetCollection<K, R> getCollection(String name, Class<R> rowType) throws GSException {
        SubnetContainer<K, R> container = this.getContainer(name, ContainerType.COLLECTION, rowType, false);
        return (SubnetCollection)container;
    }

    public <R> SubnetTimeSeries<R> getTimeSeries(String name, Class<R> rowType) throws GSException {
        SubnetContainer container = this.getContainer(name, ContainerType.TIME_SERIES, rowType, false);
        return (SubnetTimeSeries)container;
    }

    @Override
    public void dropCollection(String name) throws GSException {
        this.dropContainer(name, ContainerType.COLLECTION, false);
    }

    @Override
    public void dropTimeSeries(String name) throws GSException {
        this.dropContainer(name, ContainerType.TIME_SERIES, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws GSException {
        try {
            this.channel.closeContext(this.context);
        }
        finally {
            this.channel.unregisterContext(this.contextRef);
        }
    }

    private static ContainerIdInfo importIdProperty(BasicBuffer in) throws GSException {
        int versionId = in.base().getInt();
        long containerId = in.base().getLong();
        String remoteName = in.getString();
        return new ContainerIdInfo(versionId, containerId, remoteName);
    }

    private static void importSchemaProperty(BasicBuffer in, List<String> columnNameList, List<GSType> columnTypeList, ContainerType[] containerType, Boolean[] keyAssigned) throws GSException {
        columnNameList.clear();
        columnTypeList.clear();
        containerType[0] = in.getByteEnum(ContainerType.class);
        int columnCount = in.base().getInt();
        if (columnCount <= 0) {
            throw new GSConnectionException(145031, "Protocol error by non positive column count (columnCount=" + columnCount + ")");
        }
        int keyIndex = in.base().getInt();
        if (keyIndex != 0 && keyIndex != -1) {
            throw new GSConnectionException(145031, "Protocol error by illegal row key index (keyIndex=" + keyIndex + ")");
        }
        keyAssigned[0] = keyIndex >= 0;
        for (int i = 0; i < columnCount; ++i) {
            String columnName = in.getString();
            GSType elementType = in.getByteEnum(GSType.class);
            boolean arrayUsed = in.getBoolean();
            columnNameList.add(columnName);
            columnTypeList.add(RowMapper.toFullType(elementType, arrayUsed));
        }
    }

    private static void importIndexProperty(BasicBuffer in, List<Set<IndexType>> indexTypesList, int columnCount) throws GSException {
        indexTypesList.clear();
        for (int i = 0; i < columnCount; ++i) {
            indexTypesList.add(Collections.emptySet());
        }
        int entryCount = in.base().getInt();
        if (entryCount < 0) {
            throw new GSConnectionException(145031, "Protocol error by negative entry count (entryCount=" + entryCount + ")");
        }
        for (int i = 0; i < entryCount; ++i) {
            int columnId = in.base().getInt();
            if (columnId < 0 || columnId >= columnCount) {
                throw new GSException(145031, "Protocol error by illegal column ID (entryCount=" + columnId + ", " + "columnCount=" + columnCount + ")");
            }
            Set<IndexType> indexTypeSet = indexTypesList.get(columnId);
            if (indexTypeSet.isEmpty()) {
                indexTypeSet = EnumSet.noneOf(IndexType.class);
                indexTypesList.set(columnId, indexTypeSet);
            }
            IndexType indexType = in.getByteEnum(IndexType.class);
            indexTypeSet.add(indexType);
        }
    }

    private static void importEventNotificationProperty(BasicBuffer in, List<URL> eventNotificationInfoList) throws GSException {
        eventNotificationInfoList.clear();
        int entryCount = in.base().getInt();
        if (entryCount < 0) {
            return;
        }
        for (int i = 0; i < entryCount; ++i) {
            String urlString = in.getString();
            try {
                eventNotificationInfoList.add(new URL(urlString));
                continue;
            }
            catch (MalformedURLException e) {
                throw new GSConnectionException(145031, "Protocol error by malformed URL (urlString=\"" + urlString + "\", " + "reason=" + e.getMessage() + ")", e);
            }
        }
    }

    private static void importTriggerProperty(BasicBuffer in, List<String> columnNameList, List<TriggerInfo> triggerInfoList) throws GSException {
        triggerInfoList.clear();
        int entryCount = in.base().getInt();
        if (entryCount < 0) {
            return;
        }
        for (int i = 0; i < entryCount; ++i) {
            String name = in.getString();
            TriggerInfo.Type type = in.getByteEnum(TriggerInfo.Type.class);
            String uriString = in.getString();
            int eventTypeFlag = in.base().getInt();
            EnumSet<TriggerInfo.EventType> eventSet = EnumSet.noneOf(TriggerInfo.EventType.class);
            EnumSet<TriggerInfo.EventType> allEvantSet = EnumSet.allOf(TriggerInfo.EventType.class);
            for (TriggerInfo.EventType e : allEvantSet) {
                if ((eventTypeFlag & 1 << e.ordinal()) == 0) continue;
                eventSet.add(e);
            }
            HashSet<String> columnSet = new HashSet<String>();
            int columnCount = in.base().getInt();
            for (int j = 0; j < columnCount; ++j) {
                int columnId = in.base().getInt();
                if (columnId < 0 || columnId >= columnNameList.size()) {
                    throw new GSException(145031, "Protocol error by illegal column ID (entryCount=" + columnId + ", " + "columnCount=" + columnNameList.size() + ")");
                }
                String columnName = columnNameList.get(columnId);
                columnSet.add(columnName);
            }
            in.getString();
            String jmsDestinationType = in.getString();
            String jmsDestinationName = in.getString();
            String jmsUser = in.getString();
            String jmsPassword = in.getString();
            TriggerInfo info = new TriggerInfo();
            info.setName(name);
            info.setType(type);
            try {
                info.setURI(new URI(uriString));
            }
            catch (URISyntaxException e) {
                throw new GSConnectionException(145031, "Protocol error by malformed URI (uriString=\"" + uriString + "\", " + "reason=" + e.getMessage() + ")", e);
            }
            info.setTargetEvents(eventSet);
            info.setTargetColumns(columnSet);
            info.setJMSDestinationType(jmsDestinationType);
            info.setJMSDestinationName(jmsDestinationName);
            info.setUser(jmsUser);
            info.setPassword(jmsPassword);
            triggerInfoList.add(info);
        }
    }

    private static <K, R> SubnetContainer<K, R> disguiseTypedContainer(SubnetContainer<?, R> container) {
        return container;
    }

    private static String resolveContainerName(String name, ContainerInfo info) throws GSException {
        return SubnetGridStore.validateName(name, info.getName());
    }

    private static String validateName(String name, String anotherName) throws GSException {
        String another;
        String string = another = anotherName == null ? null : anotherName;
        if (name == null) {
            if (another == null) {
                throw new GSException(145001, "Name not specified");
            }
            return another;
        }
        if (another != null && !name.equals(another)) {
            throw new GSException(145002, "Inconsistent name (specifiedName=" + name + ", nameOnInfo=" + another + ")");
        }
        return name;
    }

    private static ContainerType resolveContainerType(ContainerType type, ContainerInfo info) throws GSException {
        ContainerType another;
        ContainerType containerType = another = info == null ? null : info.getType();
        if (type == null) {
            if (another == null) {
                throw new GSException(145001, "Container type not specified");
            }
            return another;
        }
        if (another != null && another != type) {
            throw new GSException(145023, "Inconsistent container type (specifiedType=" + (Object)((Object)type) + ", typeOnInfo=" + (Object)((Object)another) + ")");
        }
        return type;
    }

    private <K> Container<K, Row> getContainer(String name, ContainerType expectedType, boolean systemMode) throws GSException {
        SubnetContainer<K, Row> cachedContainer;
        SubnetCollection<K, Row> container;
        if (CONTEXT_CONTROLLER_NAME.equals(name) && (container = this.getContextControllerCollection(expectedType)) != null) {
            return container;
        }
        GridStoreChannel.ContainerCache cache = this.context.getContainerCache();
        if (cache != null && !systemMode && (cachedContainer = this.findContainerByCache(cache, name, Row.class, expectedType)) != null) {
            return cachedContainer;
        }
        ContainerIdInfo[] idInfo = new ContainerIdInfo[1];
        ExtendedContainerInfo containerInfo = this.getExtendedContainerInfo(name, EnumSet.allOf(ContainerPropertyType.class), idInfo, systemMode);
        if (containerInfo == null) {
            return null;
        }
        ContainerType resolvedType = SubnetGridStore.resolveContainerType(expectedType, containerInfo);
        int partitionId = this.channel.resolvePartitionId(this.context, name);
        RowMapper mapper = RowMapper.getInstance(resolvedType, containerInfo);
        String[] acceptedNames = this.filterRemoteContainerName(containerInfo.getName(), name);
        String normalizedName = acceptedNames[0];
        String remoteName = acceptedNames[1];
        if (cache != null && !systemMode) {
            cache.cacheSchema(normalizedName, new GridStoreChannel.LocatedSchema(mapper, idInfo[0].containerId, idInfo[0].versionId, remoteName));
        }
        if (containerInfo.getType() == ContainerType.TIME_SERIES) {
            return SubnetGridStore.disguiseTypedContainer(new SubnetTimeSeries<Row>(this, this.channel, this.context, Row.class, mapper, idInfo[0].versionId, partitionId, idInfo[0].containerId, normalizedName, remoteName));
        }
        return SubnetGridStore.disguiseTypedContainer(new SubnetCollection(this, this.channel, this.context, Row.class, mapper, idInfo[0].versionId, partitionId, idInfo[0].containerId, normalizedName, remoteName));
    }

    @Override
    public <K> Container<K, Row> getContainer(String name) throws GSException {
        return this.getContainer(name, null, false);
    }

    public <K> Container<K, Row> getContainer(String name, boolean systemMode) throws GSException {
        return this.getContainer(name, null, systemMode);
    }

    @Override
    public <K> Collection<K, Row> getCollection(String name) throws GSException {
        Container<K, Row> container = this.getContainer(name, ContainerType.COLLECTION, false);
        return (Collection)container;
    }

    @Override
    public TimeSeries<Row> getTimeSeries(String name) throws GSException {
        Container container = this.getContainer(name, ContainerType.TIME_SERIES, false);
        return (TimeSeries)container;
    }

    private <K> Container<K, Row> putContainer(String name, ContainerType containerType, ContainerInfo containerInfo, boolean modifiable, boolean systemMode) throws GSException {
        SubnetContainer<K, Row> container;
        name = SubnetGridStore.resolveContainerName(name, containerInfo);
        containerType = SubnetGridStore.resolveContainerType(containerType, containerInfo);
        GridStoreChannel.ContainerCache cache = this.context.getContainerCache();
        if (cache != null && !modifiable && !systemMode && containerInfo.getTimeSeriesProperties() != null && (container = this.findContainerByCache(cache, name, Row.class, containerType)) != null) {
            return container;
        }
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        SubnetGridStore.tryPutAttributeOptionalRequest(req, this.context, systemMode, containerInfo);
        RowMapper orgMapper = RowMapper.getInstance(containerType, containerInfo);
        int partitionId = this.channel.resolvePartitionId(this.context, name);
        req.putString(name);
        SubnetGridStore.tryPutContainerType(req, containerType);
        req.putBoolean(modifiable);
        orgMapper.exportSchema(req);
        this.exportContainerProperties(req, containerType, containerInfo, orgMapper, name);
        Statement statement = SubnetGridStore.getContainerStatement(Statement.PUT_CONTAINER, containerType);
        this.executeStatement(statement, partitionId, req, resp, name);
        int schemaVerId = resp.base().getInt();
        long containerId = resp.base().getLong();
        String[] acceptedNames = this.acceptRemoteContainerName(resp, name);
        String normalizedName = acceptedNames[0];
        String remoteName = acceptedNames[1];
        RowMapper mapper = orgMapper.reorderBySchema(resp, containerInfo.isColumnOrderIgnorable());
        if (cache != null && !systemMode) {
            cache.cacheSchema(normalizedName, new GridStoreChannel.LocatedSchema(mapper, containerId, schemaVerId, remoteName));
        }
        if (containerType == ContainerType.TIME_SERIES) {
            return SubnetGridStore.disguiseTypedContainer(new SubnetTimeSeries<Row>(this, this.channel, this.context, Row.class, mapper, schemaVerId, partitionId, containerId, normalizedName, remoteName));
        }
        return SubnetGridStore.disguiseTypedContainer(new SubnetCollection(this, this.channel, this.context, Row.class, mapper, schemaVerId, partitionId, containerId, normalizedName, remoteName));
    }

    public <K> Container<K, Row> putContainer(String name, ContainerInfo info, boolean modifiable, boolean systemMode) throws GSException {
        return this.putContainer(name, (ContainerType)null, info, modifiable, systemMode);
    }

    @Override
    public <K> Container<K, Row> putContainer(String name, ContainerInfo info, boolean modifiable) throws GSException {
        return this.putContainer(name, (ContainerType)null, info, modifiable, false);
    }

    @Override
    public <K> Collection<K, Row> putCollection(String name, ContainerInfo info, boolean modifiable) throws GSException {
        Container<K, Row> container = this.putContainer(name, ContainerType.COLLECTION, info, modifiable, false);
        return (Collection)container;
    }

    @Override
    public TimeSeries<Row> putTimeSeries(String name, ContainerInfo info, boolean modifiable) throws GSException {
        Container container = this.putContainer(name, ContainerType.TIME_SERIES, info, modifiable, false);
        return (TimeSeries)container;
    }

    private void dropContainer(String name, ContainerType containerType, boolean systemMode) throws GSException {
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        SubnetGridStore.tryPutSystemOptionalRequest(req, this.context, systemMode);
        req.putString(name);
        SubnetGridStore.tryPutContainerType(req, containerType);
        int partitionId = this.channel.resolvePartitionId(this.context, name);
        Statement statement = SubnetGridStore.getContainerStatement(Statement.DROP_CONTAINER, containerType);
        this.executeStatement(statement, partitionId, req, resp, name);
        GridStoreChannel.ContainerCache cache = this.context.getContainerCache();
        if (cache != null && !systemMode) {
            cache.removeSchema(RowMapper.normalizeExtendedSymbol(name, true));
        }
    }

    public void dropContainer(String name, boolean systemMode) throws GSException {
        this.dropContainer(name, null, systemMode);
    }

    @Override
    public void dropContainer(String name) throws GSException {
        this.dropContainer(name, null, false);
    }

    @Override
    public Row createRow(ContainerInfo info) throws GSException {
        this.channel.checkContextAvailable(this.context);
        RowMapper mapper = RowMapper.getInstance(info.getType(), info);
        return mapper.createGeneralRow();
    }

    @Override
    public void fetchAll(List<? extends Query<?>> queryList) throws GSException {
        MultiQueryStatement multiStatement;
        int partitionId;
        HashMap<Integer, MultiQueryStatement> requestMap = new HashMap<Integer, MultiQueryStatement>();
        for (Query<?> query : queryList) {
            SubnetQuery<?> subnetQuery = MultiQueryStatement.check(query, this);
            partitionId = subnetQuery.getContainer().getPartitionId();
            multiStatement = (MultiQueryStatement)requestMap.get(partitionId);
            if (multiStatement == null) {
                multiStatement = new MultiQueryStatement();
                requestMap.put(partitionId, multiStatement);
            }
            multiStatement.add(subnetQuery);
        }
        Statement statement = Statement.EXECUTE_MULTIPLE_QUERIES;
        this.beginComplexedStatement(statement, 0, null);
        for (Map.Entry entry : requestMap.entrySet()) {
            partitionId = (Integer)entry.getKey();
            multiStatement = (MultiQueryStatement)entry.getValue();
            this.executeStatement(partitionId, statement, multiStatement);
        }
        this.endComplexedStatement();
    }

    @Override
    public void multiPut(Map<String, List<Row>> containerRowsMap) throws GSException {
        MultiPutStatement multiStatement;
        int partitionId;
        HashMap<Integer, MultiPutStatement> requestMap = new HashMap<Integer, MultiPutStatement>();
        for (Map.Entry<String, List<Row>> entry : containerRowsMap.entrySet()) {
            String containerName = entry.getKey();
            partitionId = this.channel.resolvePartitionId(this.context, containerName);
            multiStatement = (MultiPutStatement)requestMap.get(partitionId);
            if (multiStatement == null) {
                multiStatement = new MultiPutStatement();
                requestMap.put(partitionId, multiStatement);
            }
            multiStatement.add(containerName, entry.getValue(), null);
        }
        Statement statement = Statement.PUT_MULTIPLE_CONTAINER_ROWS;
        this.beginComplexedStatement(statement, 0, null);
        for (Map.Entry entry : requestMap.entrySet()) {
            partitionId = (Integer)entry.getKey();
            multiStatement = (MultiPutStatement)entry.getValue();
            this.executeStatement(partitionId, statement, multiStatement);
        }
        this.endComplexedStatement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeStatement(int partitionId, Statement statement, MultiTransactionalStatement multiStatement) throws GSException {
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        boolean succeeded = false;
        try {
            int trialCount = 0;
            while (true) {
                int sessionTrial = 0;
                while (true) {
                    block23: {
                        this.channel.setupRequestBuffer(req);
                        if (!multiStatement.makeCreateSessionRequest(req, this.channel, this.context)) break;
                        try {
                            this.channel.executeStatement(this.context, Statement.CREATE_MULTIPLE_SESSIONS, partitionId, 0L, req, resp, this.contextMonitor);
                        }
                        catch (GSStatementException e) {
                            if (!SubnetContainer.isNewSessionConflicted(e)) {
                                throw e;
                            }
                            if (sessionTrial >= 2) {
                                throw new GSStatementException(e.getErrorCode(), "Failed to create session (totalTrialCount=" + trialCount + ", sessionTrialCount=" + sessionTrial + ", reason=" + e.getMessage() + ")", e);
                            }
                            if (!LOGGER.isInfoEnabled()) break block23;
                            LOGGER.info("transaction.regeneratingMultiSession", new Object[]{GridStoreChannel.ContextMonitor.getObjectId(this.context), statement, trialCount, sessionTrial, e});
                            break block23;
                        }
                        multiStatement.acceptCreateSessionResponse(resp);
                        if (trialCount <= 0 && sessionTrial <= 0 || !LOGGER.isInfoEnabled()) break;
                        LOGGER.info("transaction.sessionRepaired", new Object[]{GridStoreChannel.ContextMonitor.getObjectId(this.context), statement, trialCount, sessionTrial});
                        break;
                    }
                    ++sessionTrial;
                }
                try {
                    Object targetConnection;
                    this.channel.setupRequestBuffer(req);
                    if (!multiStatement.makeMainRequest(req, this.context)) {
                        break;
                    }
                    GridStoreChannel.Context context = this.context;
                    synchronized (context) {
                        this.channel.executeStatement(this.context, statement, partitionId, 0L, req, resp, this.contextMonitor);
                        targetConnection = this.channel.getLastConnection(this.context);
                    }
                    multiStatement.acceptMainResponse(resp, targetConnection);
                    succeeded = true;
                }
                catch (GSStatementException e) {
                    if (!multiStatement.acceptStatementErrorForSession(e)) {
                        throw e;
                    }
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("transaction.repairingMultiSession", new Object[]{GridStoreChannel.ContextMonitor.getObjectId(this.context), statement, trialCount, e});
                    }
                    if (trialCount >= 2) {
                        throw new GSStatementException(e.getErrorCode(), "Failed to repair session (trialCount=" + trialCount + ", reason=" + e.getMessage() + ")");
                    }
                    ++trialCount;
                    continue;
                }
                break;
            }
        }
        finally {
            block25: {
                try {
                    this.channel.setupRequestBuffer(req);
                    if (multiStatement.makeCloseSessionRequest(req, this.context)) {
                        this.channel.executeStatement(this.context, Statement.CLOSE_MULTIPLE_SESSIONS, partitionId, 0L, req, resp, this.contextMonitor);
                        multiStatement.acceptSessionClosed();
                    }
                }
                catch (GSException e) {
                    if (!succeeded) break block25;
                    throw e;
                }
            }
        }
    }

    @Override
    public Map<String, List<Row>> multiGet(Map<String, ? extends RowKeyPredicate<?>> containerPredicateMap) throws GSException {
        HashMap<Integer, MultiGetRequest> requestMap = new HashMap<Integer, MultiGetRequest>();
        for (Map.Entry<String, RowKeyPredicate<?>> entry : containerPredicateMap.entrySet()) {
            String containerName = entry.getKey();
            int partitionId = this.channel.resolvePartitionId(this.context, containerName);
            MultiGetRequest request = (MultiGetRequest)requestMap.get(partitionId);
            if (request == null) {
                request = new MultiGetRequest();
                requestMap.put(partitionId, request);
            }
            RowKeyPredicate<?> predicate = entry.getValue();
            request.add(containerName, predicate);
        }
        Statement statement = Statement.GET_MULTIPLE_CONTAINER_ROWS;
        this.beginComplexedStatement(statement, 0, null);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        HashMap<String, List<Row>> resultMap = new HashMap<String, List<Row>>();
        for (Map.Entry entry : requestMap.entrySet()) {
            this.channel.setupRequestBuffer(req);
            int partitionId = (Integer)entry.getKey();
            MultiGetRequest request = (MultiGetRequest)entry.getValue();
            if (!request.makeRequest(req, containerPredicateMap, this.context)) continue;
            this.channel.executeStatement(this.context, statement, partitionId, 0L, req, resp, this.contextMonitor);
            int headCount = resp.base().getInt();
            ArrayList<RowMapper> mapperList = new ArrayList<RowMapper>();
            for (int i = 0; i < headCount; ++i) {
                ContainerType containerType = resp.getByteEnum(ContainerType.class);
                mapperList.add(RowMapper.getInstance(resp, containerType == ContainerType.TIME_SERIES));
            }
            int bodyCount = resp.base().getInt();
            for (int i = 0; i < bodyCount; ++i) {
                int mapperIndex;
                RowMapper mapper;
                String containerName = resp.getString();
                ArrayList<Row> rowList = (ArrayList<Row>)resultMap.get(containerName);
                if (rowList == null) {
                    rowList = new ArrayList<Row>();
                    resultMap.put(containerName, rowList);
                }
                boolean rowIdIncluded = !(mapper = (RowMapper)mapperList.get(mapperIndex = resp.base().getInt())).isForTimeSeries();
                int rowCount = (int)resp.base().getLong();
                RowMapper.Cursor cursor = mapper.createCursor(resp, SubnetContainer.getRowMappingMode(), rowCount, rowIdIncluded, BLOB_FACTORY);
                for (int j = 0; j < rowCount; ++j) {
                    rowList.add((Row)mapper.decode(cursor));
                }
            }
        }
        this.endComplexedStatement();
        return resultMap;
    }

    @Override
    public PartitionController getPartitionController() throws GSException {
        this.channel.checkContextAvailable(this.context);
        return new SubnetPartitionController(this.channel, this.context);
    }

    private <K> SubnetCollection<K, Row> getContextControllerCollection(ContainerType expectedType) throws GSException {
        if (expectedType != null && expectedType != ContainerType.COLLECTION) {
            return null;
        }
        RowMapper mapper = RowMapper.getInstance(null, new ContainerInfo(null, null, Arrays.asList(new ColumnInfo("name", GSType.STRING), new ColumnInfo("value", GSType.STRING)), true));
        return new SubnetCollection<K, Row>(this, this.channel, this.context, Row.class, mapper, -1, -1, -1L, CONTEXT_CONTROLLER_NAME, null){

            @Override
            public Row get(K key, boolean forUpdate) throws GSException {
                if (!(key instanceof String)) {
                    throw new GSException(145002, "Type of key for context controller must be string");
                }
                Row row = this.mapper.createGeneralRow();
                if ("failoverCount".equals(key)) {
                    row.setString(1, Integer.toString(this.context.getFailoverCount()));
                    row.setValue(0, key);
                    return row;
                }
                throw new GSException(145002, "Unknown key");
            }

            @Override
            public boolean put(K key, Row value) throws GSException {
                if ("invalidateMaster".equals(key) && value.getString(1).equals(Boolean.TRUE.toString())) {
                    this.channel.invalidateMaster(this.context);
                    return true;
                }
                throw new GSException(145002, "Unknown key");
            }
        };
    }

    @Override
    public <K, R> Container<K, R> putContainer(String name, Class<R> rowType, ContainerInfo info, boolean modifiable) throws GSException {
        return this.putContainer(SubnetGridStore.resolveContainerName(name, info), SubnetGridStore.resolveContainerType(null, info), rowType, info, modifiable);
    }

    private static void setUserInfoRequest(BasicBuffer req, String userName) throws GSException {
        RowMapper.normalizeSymbol(userName);
        req.putString(userName);
    }

    private void setUserInfoRequest(BasicBuffer req, String userName, byte prop, String hashPassword) throws GSException {
        SubnetGridStore.setUserInfoRequest(req, userName);
        req.put(prop);
        if (hashPassword != null) {
            if (hashPassword.length() == 0) {
                throw new GSException(145002, "invalid parameter string length.");
            }
            req.putBoolean(true);
            req.putString(hashPassword);
        } else {
            req.putBoolean(false);
        }
    }

    private Map<String, UserInfo> getUserInfoMap(BasicBuffer resp) throws GSException {
        HashMap<String, UserInfo> map = new HashMap<String, UserInfo>();
        int userInfoCount = resp.base().getInt();
        if (userInfoCount == 0) {
            return map;
        }
        if (128 < userInfoCount) {
            throw new GSConnectionException(145031, "Protocol error by too many result num (expected less than 128: but " + userInfoCount + ")");
        }
        for (int i = 0; i < userInfoCount; ++i) {
            String userName = resp.getString();
            Byte property = resp.base().get();
            boolean passwordExist = resp.getBoolean();
            String hashPassword = "";
            if (passwordExist) {
                hashPassword = resp.getString();
            }
            map.put(userName, new UserInfo(userName, hashPassword, property != 0));
        }
        return map;
    }

    public void putUser(String name, UserInfo userInfo, boolean modifiable) throws GSException {
        name = SubnetGridStore.validateName(name, userInfo.getName());
        RowMapper.normalizeSymbol(name);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        NodeConnection.tryPutEmptyOptionalRequest(req);
        int partitionId = this.channel.resolvePartitionId(this.context, SYSTEM_USER_CONTAINER_NAME);
        if (userInfo.getPassword() != null && userInfo.getHashPassword() == null) {
            if (userInfo.getPassword().length() == 0 || 64 < userInfo.getPassword().length()) {
                throw new GSException(145002, "Illegal password length");
            }
            String hashPassword = NodeConnection.getDigest(userInfo.getPassword());
            this.setUserInfoRequest(req, name, (byte)0, hashPassword);
        } else if (userInfo.getPassword() == null && userInfo.getHashPassword() != null) {
            this.setUserInfoRequest(req, name, (byte)0, userInfo.getHashPassword());
        } else {
            if (userInfo.getPassword() == null) {
                throw new GSException(145001, "Password or hash password not specified");
            }
            throw new GSException(145002, "Password and hash password not specified");
        }
        req.putBoolean(modifiable);
        this.executeStatement(Statement.PUT_USER, partitionId, req, resp, null);
    }

    public void dropUser(String name) throws GSException {
        if (name == null) {
            throw new GSException(145001, "Name not specified");
        }
        RowMapper.normalizeSymbol(name);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        NodeConnection.tryPutEmptyOptionalRequest(req);
        int partitionId = this.channel.resolvePartitionId(this.context, SYSTEM_USER_CONTAINER_NAME);
        SubnetGridStore.setUserInfoRequest(req, name);
        this.executeStatement(Statement.DROP_USER, partitionId, req, resp, null);
    }

    public Map<String, UserInfo> getUsers() throws GSException {
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        NodeConnection.tryPutEmptyOptionalRequest(req);
        int partitionId = this.channel.resolvePartitionId(this.context, SYSTEM_USER_CONTAINER_NAME);
        req.putBoolean(false);
        req.put((byte)0);
        this.executeStatement(Statement.GET_USERS, partitionId, req, resp, null);
        Map<String, UserInfo> map = this.getUserInfoMap(resp);
        return map;
    }

    public UserInfo getCurrentUser() throws GSException {
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        NodeConnection.tryPutEmptyOptionalRequest(req);
        int partitionId = this.channel.resolvePartitionId(this.context, SYSTEM_USER_CONTAINER_NAME);
        RowMapper.normalizeExtendedSymbol(this.context.getUser(), true);
        req.putBoolean(true);
        req.putString(this.context.getUser());
        req.put((byte)0);
        this.executeStatement(Statement.GET_USERS, partitionId, req, resp, null);
        Map<String, UserInfo> map = this.getUserInfoMap(resp);
        if (map.size() != 1) {
            throw new GSConnectionException(145031, "Protocol error by illegal user info count (expected=1, actual=" + map.size() + ")");
        }
        UserInfo userInfo = map.get(this.context.getUser());
        if (userInfo == null) {
            throw new GSConnectionException(145031, "Protocol error by illegal user name (expected=" + this.context.getUser() + ")");
        }
        return userInfo;
    }

    private void setDatabaseInfoRequest(BasicBuffer req, String dbName) throws GSException {
        RowMapper.normalizeSymbol(dbName);
        req.putString(dbName);
    }

    private void setDatabaseInfoRequest(BasicBuffer req, String dbName, byte prop, Map<String, PrivilegeInfo> privileges) throws GSException {
        this.setDatabaseInfoRequest(req, dbName);
        req.put(prop);
        if (privileges != null) {
            req.base().putInt(privileges.size());
            for (Map.Entry<String, PrivilegeInfo> privilegeEntry : privileges.entrySet()) {
                RowMapper.normalizeSymbol(privilegeEntry.getKey());
                req.putString(privilegeEntry.getKey());
                PrivilegeInfo privilegeInfo = privilegeEntry.getValue();
                if (privilegeInfo == null) {
                    throw new GSException(145001, "PrivilegeInfo not specified");
                }
                req.putString(DEFAULT_PRIVILEGE);
            }
        } else {
            req.base().putInt(0);
        }
    }

    private void setDatabaseInfoRequest(BasicBuffer req, String dbName, byte prop, String userName, PrivilegeInfo info) throws GSException {
        HashMap<String, PrivilegeInfo> map = new HashMap<String, PrivilegeInfo>();
        map.put(userName, info);
        this.setDatabaseInfoRequest(req, dbName, (byte)0, map);
    }

    private Map<String, DatabaseInfo> getDatabaseInfoMap(BasicBuffer resp) throws GSException {
        HashMap<String, DatabaseInfo> map = new HashMap<String, DatabaseInfo>();
        int databaseInfoCount = resp.base().getInt();
        if (databaseInfoCount == 0) {
            return map;
        }
        if (128 < databaseInfoCount) {
            throw new GSConnectionException(145031, "Protocol error by too many result num (expected less than 128: but " + databaseInfoCount + ")");
        }
        for (int i = 0; i < databaseInfoCount; ++i) {
            String databaseName = resp.getString();
            Byte property = resp.base().get();
            int privilegeInfoCount = resp.base().getInt();
            HashMap<String, PrivilegeInfo> privilegeInfoMap = new HashMap<String, PrivilegeInfo>();
            for (int j = 0; j < privilegeInfoCount; ++j) {
                String userName = resp.getString();
                String privilegeData = resp.getString();
                if (!privilegeData.equals(DEFAULT_PRIVILEGE)) {
                    throw new GSConnectionException(145031, "Protocol error by illegal privilegeDataSize (expected=ALL, actual=" + privilegeData + ")");
                }
                privilegeInfoMap.put(userName, new PrivilegeInfo());
            }
            map.put(databaseName, new DatabaseInfo(databaseName, privilegeInfoMap));
        }
        return map;
    }

    public void putDatabase(String name, DatabaseInfo info, boolean modifiable) throws GSException {
        if (name == null) {
            throw new GSException(145001, "Name not specified");
        }
        RowMapper.normalizeSymbol(name);
        modifiable = false;
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        NodeConnection.tryPutEmptyOptionalRequest(req);
        int partitionId = this.channel.resolvePartitionId(this.context, SYSTEM_USER_CONTAINER_NAME);
        this.setDatabaseInfoRequest(req, name, (byte)0, null);
        req.putBoolean(modifiable);
        this.executeStatement(Statement.PUT_DATABASE, partitionId, req, resp, null);
    }

    public void dropDatabase(String name) throws GSException {
        DatabaseInfo info = this.getCurrentDatabase();
        if (!info.getName().equals(name)) {
            throw new GSException(145002, "Illegal database is specified; different from connected database");
        }
        PartitionController partitionController = this.getPartitionController();
        int partitionCount = partitionController.getPartitionCount();
        ContainerCondition cond = new ContainerCondition();
        cond.setAttributes(EnumSet.of(ContainerAttribute.BASE, ContainerAttribute.SINGLE_SYSTEM, ContainerAttribute.SINGLE, ContainerAttribute.LARGE, ContainerAttribute.SUB));
        for (int partitionIndex = 0; partitionIndex < partitionCount; ++partitionIndex) {
            long containerCount = ((SubnetPartitionController)partitionController).getContainerCount(partitionIndex, cond, true);
            if (0L >= containerCount) continue;
            throw new GSException(145045, "Illegal target error by non-empty database");
        }
        if (name == null) {
            throw new GSException(145001, "Name not specified");
        }
        RowMapper.normalizeSymbol(name);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        NodeConnection.tryPutEmptyOptionalRequest(req);
        int partitionId = this.channel.resolvePartitionId(this.context, SYSTEM_USER_CONTAINER_NAME);
        this.setDatabaseInfoRequest(req, name);
        this.executeStatement(Statement.DROP_DATABASE, partitionId, req, resp, null);
    }

    public Map<String, DatabaseInfo> getDatabases() throws GSException {
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        NodeConnection.tryPutEmptyOptionalRequest(req);
        int partitionId = this.channel.resolvePartitionId(this.context, SYSTEM_USER_CONTAINER_NAME);
        req.putBoolean(false);
        req.put((byte)0);
        this.executeStatement(Statement.GET_DATABASES, partitionId, req, resp, null);
        Map<String, DatabaseInfo> map = this.getDatabaseInfoMap(resp);
        return map;
    }

    public DatabaseInfo getCurrentDatabase() throws GSException {
        DatabaseInfo info;
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        NodeConnection.tryPutEmptyOptionalRequest(req);
        int partitionId = this.channel.resolvePartitionId(this.context, SYSTEM_USER_CONTAINER_NAME);
        String dbName = this.context.getDatabaseName();
        req.putBoolean(true);
        req.putString(dbName == null ? "" : dbName);
        req.put((byte)0);
        this.executeStatement(Statement.GET_DATABASES, partitionId, req, resp, null);
        Map<String, DatabaseInfo> map = this.getDatabaseInfoMap(resp);
        if (map.size() == 1) {
            info = dbName == null ? map.values().iterator().next() : map.get(dbName);
            if (info == null) {
                throw new GSConnectionException(145031, "Protocol error by illegal database name (expected=" + this.context.getDatabaseName() + ")");
            }
        } else {
            throw new GSConnectionException(145031, "Protocol error by illegal database info count (expected=1, actual=" + map.size() + ")");
        }
        return info;
    }

    public void putPrivilege(String dbName, String userName, PrivilegeInfo info) throws GSException {
        RowMapper.normalizeSymbol(dbName);
        RowMapper.normalizeSymbol(userName);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        NodeConnection.tryPutEmptyOptionalRequest(req);
        int partitionId = this.channel.resolvePartitionId(this.context, SYSTEM_USER_CONTAINER_NAME);
        this.setDatabaseInfoRequest(req, dbName, (byte)0, userName, info);
        this.executeStatement(Statement.PUT_PRIVILEGE, partitionId, req, resp, null);
    }

    public void dropPrivilege(String dbName, String userName, PrivilegeInfo info) throws GSException {
        RowMapper.normalizeSymbol(dbName);
        RowMapper.normalizeSymbol(userName);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        NodeConnection.tryPutEmptyOptionalRequest(req);
        int partitionId = this.channel.resolvePartitionId(this.context, SYSTEM_USER_CONTAINER_NAME);
        this.setDatabaseInfoRequest(req, dbName, (byte)0, userName, info);
        this.executeStatement(Statement.DROP_PRIVILEGE, partitionId, req, resp, null);
    }

    private static class MultiGetRequest {
        final List<RowKeyPredicate<?>> predicateList = new ArrayList();
        final List<String> containerNameList = new ArrayList<String>();

        private MultiGetRequest() {
        }

        void add(String containerName, RowKeyPredicate<?> predicate) {
            if (!this.predicateList.contains(predicate)) {
                this.predicateList.add(predicate);
            }
            this.containerNameList.add(containerName);
        }

        boolean makeRequest(BasicBuffer req, Map<String, ? extends RowKeyPredicate<?>> containerPredicateMap, GridStoreChannel.Context context) throws GSException {
            if (this.containerNameList.isEmpty()) {
                return false;
            }
            if (SubnetGridStore.isSessionUUIDSummarized()) {
                req.putUUID(context.getSessionUUID());
            }
            SubnetGridStore.tryPutDatabaseOptionalRequest(req, context);
            req.putInt(this.predicateList.size());
            for (RowKeyPredicate<?> predicate : this.predicateList) {
                GSType keyType = predicate.getKeyType();
                req.putByteEnum(keyType);
                java.util.Collection<?> distinctKeys = predicate.getDistinctKeys();
                Object startKey = predicate.getStart();
                Object finishKey = predicate.getFinish();
                if (distinctKeys == null) {
                    req.putByteEnum(PredicateType.RANGE);
                    req.putBoolean(startKey != null);
                    if (startKey != null) {
                        RowMapper.encodeKey(req, startKey, keyType, SubnetContainer.getRowMappingMode());
                    }
                    req.putBoolean(finishKey != null);
                    if (finishKey == null) continue;
                    RowMapper.encodeKey(req, finishKey, keyType, SubnetContainer.getRowMappingMode());
                    continue;
                }
                req.putByteEnum(PredicateType.DISTINCT);
                req.putInt(distinctKeys.size());
                for (Object key : distinctKeys) {
                    RowMapper.encodeKey(req, key, keyType, SubnetContainer.getRowMappingMode());
                }
            }
            req.putInt(this.containerNameList.size());
            for (String containerName : this.containerNameList) {
                RowKeyPredicate<?> predicate = containerPredicateMap.get(containerName);
                int predicateIndex = this.predicateList.indexOf(predicate);
                if (predicateIndex < 0) {
                    throw new Error("Internal error by unregistered predicate");
                }
                req.putString(containerName);
                req.putInt(predicateIndex);
            }
            return true;
        }
    }

    private static enum PredicateType {
        RANGE,
        DISTINCT;

    }

    private static class MultiPutStatement
    implements MultiTransactionalStatement {
        final List<RowMapper> mapperList = new ArrayList<RowMapper>();
        final List<String> containerNameList = new ArrayList<String>();
        final Map<String, SubEntry> subEntryMap = new HashMap<String, SubEntry>();
        UUID sessionUUID;

        private MultiPutStatement() {
        }

        void add(String containerName, List<Row> rowList, RowMapper mapper) throws GSException {
            if (rowList.isEmpty()) {
                return;
            }
            String normalizedName = RowMapper.normalizeExtendedSymbol(containerName, true);
            SubEntry entry = this.subEntryMap.get(normalizedName);
            for (Row row : rowList) {
                if (mapper == null) {
                    if (entry == null) {
                        mapper = RowMapper.getInstance(row);
                        continue;
                    }
                    mapper = RowMapper.getInstance(entry.rowList.get(0));
                    continue;
                }
                mapper.checkSchemaMatched(RowMapper.getInstance(row));
            }
            if (entry == null) {
                entry = new SubEntry();
                entry.rowList = rowList;
                this.subEntryMap.put(normalizedName, entry);
                this.containerNameList.add(normalizedName);
                entry.mapperIndex = this.indexOf(mapper);
                if (entry.mapperIndex < 0) {
                    entry.mapperIndex = this.mapperList.size();
                    this.mapperList.add(mapper);
                }
            } else {
                if (!entry.listMerged) {
                    entry.rowList = new ArrayList<Row>(entry.rowList);
                    entry.listMerged = true;
                }
                entry.rowList.addAll(rowList);
            }
        }

        @Override
        public boolean makeCreateSessionRequest(BasicBuffer req, GridStoreChannel channel, GridStoreChannel.Context context) throws GSException {
            this.sessionUUID = context.getSessionUUID();
            if (this.containerNameList.isEmpty()) {
                return false;
            }
            boolean summarized = SubnetGridStore.isSessionUUIDSummarized();
            if (summarized) {
                req.putUUID(this.sessionUUID);
            }
            SubnetGridStore.tryPutDatabaseOptionalRequest(req, context);
            boolean withId = false;
            req.putBoolean(withId);
            req.putInt(this.containerNameList.size());
            for (String containerName : this.containerNameList) {
                req.putString(containerName);
                if (!summarized) {
                    req.putUUID(this.sessionUUID);
                }
                if (SubnetContainer.isSessionIdGeneratorEnabled()) {
                    SubEntry entry = this.subEntryMap.get(containerName);
                    entry.sessionId = context.generateSessionId();
                    req.putLong(entry.sessionId);
                    continue;
                }
                SubnetContainer.putNewSessionProperties(req, channel, context);
            }
            return true;
        }

        @Override
        public void acceptCreateSessionResponse(BasicBuffer resp) throws GSException {
            int sessionCount = resp.base().getInt();
            if (this.subEntryMap.size() != sessionCount) {
                throw new GSConnectionException(145031, "Protocol error by inconsistent session count");
            }
            for (String containerName : this.containerNameList) {
                SubEntry entry = this.subEntryMap.get(containerName);
                entry.containerId = resp.base().getLong();
                if (SubnetContainer.isSessionIdGeneratorEnabled()) continue;
                entry.sessionId = resp.base().getLong();
                if (entry.sessionId != 0L) continue;
                throw new GSConnectionException(145031, "Protocol error by empty session ID");
            }
        }

        @Override
        public boolean makeMainRequest(BasicBuffer req, GridStoreChannel.Context context) throws GSException {
            if (this.containerNameList.isEmpty()) {
                return false;
            }
            boolean summarized = SubnetGridStore.isSessionUUIDSummarized();
            if (summarized) {
                req.putUUID(this.sessionUUID);
            }
            SubnetGridStore.tryPutDatabaseOptionalRequest(req, context);
            req.putInt(this.mapperList.size());
            for (RowMapper mapper : this.mapperList) {
                req.putByteEnum(mapper.isForTimeSeries() ? ContainerType.TIME_SERIES : ContainerType.COLLECTION);
                mapper.exportSchema(req);
            }
            req.putInt(this.containerNameList.size());
            for (String containerName : this.containerNameList) {
                SubEntry entry = this.subEntryMap.get(containerName);
                NodeConnection.putStatementId(req, 1L);
                req.putLong(entry.containerId);
                req.putLong(entry.sessionId);
                if (!summarized) {
                    req.putUUID(this.sessionUUID);
                }
                if (SubnetContainer.isSessionIdGeneratorEnabled()) {
                    req.putByteEnum(SubnetContainer.SessionMode.GET);
                    req.putByteEnum(SubnetContainer.TransactionMode.AUTO);
                }
                NodeConnection.tryPutEmptyOptionalRequest(req);
                req.putInt(entry.mapperIndex);
                int listBytesSize = 0;
                req.putInt(listBytesSize);
                int listStartPos = req.base().position();
                req.putLong(entry.rowList.size());
                RowMapper mapper = this.mapperList.get(entry.mapperIndex);
                RowMapper.Cursor cursor = mapper.createCursor(req, SubnetContainer.getRowMappingMode(), entry.rowList.size(), false, null);
                for (Row row : entry.rowList) {
                    mapper.encode(cursor, null, row);
                }
                int listEndPos = req.base().position();
                req.base().position(listStartPos - 4);
                req.putInt(listEndPos - listStartPos);
                req.base().position(listEndPos);
            }
            return true;
        }

        @Override
        public void acceptMainResponse(BasicBuffer resp, Object targetConnection) {
        }

        @Override
        public boolean makeCloseSessionRequest(BasicBuffer req, GridStoreChannel.Context context) {
            if (this.containerNameList.isEmpty()) {
                return false;
            }
            boolean summarized = SubnetGridStore.isSessionUUIDSummarized();
            if (summarized) {
                req.putUUID(this.sessionUUID);
            }
            SubnetGridStore.tryPutDatabaseOptionalRequest(req, context);
            req.putInt(this.containerNameList.size());
            for (String containerName : this.containerNameList) {
                SubEntry entry = this.subEntryMap.get(containerName);
                NodeConnection.putStatementId(req, 2L);
                req.putLong(entry.containerId);
                req.putLong(entry.sessionId);
                if (summarized) continue;
                req.putUUID(this.sessionUUID);
            }
            return true;
        }

        @Override
        public void acceptSessionClosed() {
        }

        @Override
        public boolean acceptStatementErrorForSession(GSStatementException cause) throws GSException {
            return SubnetContainer.isInitialSessionLost(Statement.CREATE_MULTIPLE_SESSIONS, 1L, false, cause);
        }

        int indexOf(RowMapper mapper) {
            for (int i = 0; i < this.mapperList.size(); ++i) {
                if (this.mapperList.get(i) != mapper) continue;
                return i;
            }
            return -1;
        }

        private static class SubEntry {
            List<Row> rowList;
            int mapperIndex;
            long containerId;
            long sessionId;
            boolean listMerged;

            private SubEntry() {
            }
        }
    }

    private static class MultiQueryStatement
    implements MultiTransactionalStatement {
        private final List<SubnetQuery<?>> queryList = new ArrayList();
        private List<SubnetQuery<?>> optionalQueryList;
        boolean updateQueryFound;
        UUID sessionUUID;

        private MultiQueryStatement() {
        }

        static SubnetQuery<?> check(Query<?> query, SubnetGridStore store) throws GSException {
            if (!(query instanceof SubnetQuery)) {
                if (query == null) {
                    throw new GSException(145001, "Empty query object");
                }
                throw new GSException(145002, "Query type not matched (class=" + query.getClass() + ")");
            }
            SubnetQuery subnetQuery = (SubnetQuery)query;
            if (subnetQuery.getContainer().getStore() != store) {
                throw new GSException(145002, "Derived GridStore instance not matched");
            }
            return subnetQuery;
        }

        void add(SubnetQuery<?> query) throws GSException {
            query.getContainer().clearBlob(false);
            this.updateQueryFound |= query.isForUpdate();
            this.queryList.add(query);
        }

        @Override
        public boolean makeCreateSessionRequest(BasicBuffer req, GridStoreChannel channel, GridStoreChannel.Context context) throws GSException {
            this.sessionUUID = context.getSessionUUID();
            if (!this.updateQueryFound || this.queryList.isEmpty()) {
                return false;
            }
            if (this.optionalQueryList == null) {
                this.optionalQueryList = new ArrayList();
            }
            this.optionalQueryList.clear();
            for (SubnetQuery<?> query : this.queryList) {
                if (!query.isForUpdate() || query.getContainer().getSessionIdDirect() != 0L) continue;
                this.optionalQueryList.add(query);
            }
            boolean summarized = SubnetGridStore.isSessionUUIDSummarized();
            if (summarized) {
                req.putUUID(this.sessionUUID);
            }
            SubnetGridStore.tryPutDatabaseOptionalRequest(req, context);
            boolean withId = true;
            req.putBoolean(withId);
            req.putInt(this.optionalQueryList.size());
            for (SubnetQuery<?> query : this.optionalQueryList) {
                SubnetContainer<?, ?> container = query.getContainer();
                req.putLong(container.getContainerId());
                if (!summarized) {
                    req.putUUID(this.sessionUUID);
                }
                if (SubnetContainer.isSessionIdGeneratorEnabled()) {
                    long sessionId = context.generateSessionId();
                    container.setSessionIdDirect(sessionId, false);
                    req.putLong(sessionId);
                    continue;
                }
                SubnetContainer.putNewSessionProperties(req, channel, context);
            }
            return true;
        }

        @Override
        public void acceptCreateSessionResponse(BasicBuffer resp) throws GSException {
            int sessionCount = resp.base().getInt();
            if (this.optionalQueryList.size() != sessionCount) {
                throw new GSConnectionException(145031, "Protocol error by inconsistent session count");
            }
            if (!SubnetContainer.isSessionIdGeneratorEnabled()) {
                for (int i = 0; i < sessionCount; ++i) {
                    SubnetContainer<?, ?> container = this.optionalQueryList.get(i).getContainer();
                    long containerId = resp.base().getLong();
                    if (containerId != container.getContainerId()) {
                        throw new GSConnectionException(145031, "Protocol error by inconsistent session ID");
                    }
                    long sessionId = resp.base().getLong();
                    if (sessionId == 0L) {
                        throw new GSConnectionException(145031, "Protocol error by empty session ID");
                    }
                    container.setSessionIdDirect(sessionId, true);
                }
            }
            this.optionalQueryList.clear();
        }

        @Override
        public boolean makeMainRequest(BasicBuffer req, GridStoreChannel.Context context) throws GSException {
            if (this.queryList.isEmpty()) {
                return false;
            }
            boolean summarized = SubnetGridStore.isSessionUUIDSummarized();
            if (summarized) {
                req.putUUID(this.sessionUUID);
            }
            SubnetGridStore.tryPutDatabaseOptionalRequest(req, context);
            req.putInt(this.queryList.size());
            for (SubnetQuery<?> query : this.queryList) {
                SubnetContainer<?, ?> container = query.getContainer();
                long statementId = container.isAutoCommit() ? 0L : container.updateStatementIdDirect();
                req.putInt(GridStoreChannel.statementToNumber(query.getStatement()));
                NodeConnection.putStatementId(req, statementId);
                query.makeRequest(req, summarized);
            }
            return true;
        }

        @Override
        public void acceptMainResponse(BasicBuffer resp, Object targetConnection) throws GSException {
            int count = resp.base().getInt();
            if (this.queryList.size() != count) {
                throw new GSConnectionException(145031, "Protocol error by inconsistent query count");
            }
            int totalEndPos = resp.base().limit();
            for (SubnetQuery<?> query : this.queryList) {
                long size = resp.base().getLong();
                if (size < 0L || size > (long)resp.base().remaining()) {
                    throw new GSConnectionException(145031, "Protocol error by invalid query message size");
                }
                resp.base().limit(resp.base().position() + (int)size);
                query.acceptResponse(resp, targetConnection, false);
                resp.base().limit(totalEndPos);
            }
        }

        @Override
        public boolean makeCloseSessionRequest(BasicBuffer req, GridStoreChannel.Context context) throws GSException {
            return false;
        }

        @Override
        public void acceptSessionClosed() throws GSException {
        }

        @Override
        public boolean acceptStatementErrorForSession(GSStatementException cause) throws GSException {
            if (!this.updateQueryFound) {
                return false;
            }
            boolean initialSessionLost = false;
            for (SubnetQuery<?> query : this.queryList) {
                SubnetContainer<?, ?> container = query.getContainer();
                if (SubnetCollection.isInitialSessionLost(Statement.EXECUTE_MULTIPLE_QUERIES, container.getStatementIdDirect(), container.isTransactionStarted(), cause)) {
                    initialSessionLost = true;
                    container.setSessionIdDirect(0L, true);
                    continue;
                }
                container.disableCache();
            }
            return initialSessionLost;
        }
    }

    private static interface MultiTransactionalStatement {
        public boolean makeCreateSessionRequest(BasicBuffer var1, GridStoreChannel var2, GridStoreChannel.Context var3) throws GSException;

        public void acceptCreateSessionResponse(BasicBuffer var1) throws GSException;

        public boolean makeMainRequest(BasicBuffer var1, GridStoreChannel.Context var2) throws GSException;

        public void acceptMainResponse(BasicBuffer var1, Object var2) throws GSException;

        public boolean makeCloseSessionRequest(BasicBuffer var1, GridStoreChannel.Context var2) throws GSException;

        public void acceptSessionClosed() throws GSException;

        public boolean acceptStatementErrorForSession(GSStatementException var1) throws GSException;
    }

    private static class ContainerIdInfo {
        final int versionId;
        final long containerId;
        final String remoteName;

        public ContainerIdInfo(int versionId, long containerId, String remoteName) {
            this.versionId = versionId;
            this.containerId = containerId;
            this.remoteName = remoteName;
        }
    }

    private static enum ContainerPropertyType {
        ID,
        SCHEMA,
        INDEX,
        EVENT_NOTIFICATION,
        TRIGGER,
        ATTRIBUTE;

    }

    private static class CacheReference
    extends GridStoreChannel.RemoteReference<SubnetGridStore> {
        public CacheReference(SubnetGridStore target, GridStoreChannel.Context context) {
            super(target, SubnetGridStore.class, context, 0, 0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close(GridStoreChannel channel, GridStoreChannel.Context context) throws GSException {
            GridStoreChannel.Context context2 = context;
            synchronized (context2) {
                GridStoreChannel.ContainerCache cache = context.getContainerCache();
                if (cache != null) {
                    BasicBuffer req = context.getSynchronizedRequestBuffer();
                    BasicBuffer resp = context.getSynchronizedResponseBuffer();
                    SubnetContainer.closeAllSessions(channel, context, req, resp, cache.takeAllSessions(context));
                }
            }
        }
    }

    public static abstract class NamedContainerMap<C extends Container<?, ?>> {
        private final Map<String, List<WeakReference<C>>> base = new HashMap<String, List<WeakReference<C>>>();

        public synchronized C get(String normalizedName, Class<?> rowType) throws GSException {
            List<WeakReference<C>> list = this.base.get(RowMapper.normalizeExtendedSymbol(normalizedName, true));
            if (list != null) {
                do {
                    for (WeakReference<C> containerRef : list) {
                        Container container = (Container)containerRef.get();
                        if (container == null || rowType != null && rowType != this.getRowType(container)) continue;
                        return (C)container;
                    }
                } while ((rowType = rowType.getSuperclass()) != null);
            }
            return null;
        }

        public synchronized void add(String normalizedName, C container) {
            List<WeakReference<C>> list = this.base.get(normalizedName);
            if (list == null) {
                list = new LinkedList<WeakReference<C>>();
                this.base.put(normalizedName, list);
            }
            list.add(new WeakReference<C>(container));
        }

        public synchronized void remove(String normalizedName, C container) {
            List<WeakReference<C>> list = this.base.get(normalizedName);
            if (list == null) {
                return;
            }
            Iterator<WeakReference<C>> it = list.iterator();
            while (it.hasNext()) {
                Container candidate = (Container)it.next().get();
                if (candidate != null && candidate != container) continue;
                it.remove();
            }
            if (list.isEmpty()) {
                this.base.remove(normalizedName);
            }
        }

        protected abstract Class<?> getRowType(C var1);
    }
}

