/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.subnet;

import com.toshiba.mwcloud.gs.Container;
import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.GSRecoverableException;
import com.toshiba.mwcloud.gs.Row;
import com.toshiba.mwcloud.gs.RowSet;
import com.toshiba.mwcloud.gs.common.RowMapper;
import com.toshiba.mwcloud.gs.subnet.GridStoreChannel;
import com.toshiba.mwcloud.gs.subnet.SubnetContainer;
import java.util.Arrays;
import java.util.HashSet;

public class SubnetRowSet<R>
implements RowSet<R> {
    private final SubnetContainer<?, ?> container;
    private final Class<R> rowType;
    private final RowMapper mapper;
    private RowMapper.Cursor resultCursor;
    private final long transactionId;
    private Object lastKey;
    private final long totalRowCount;
    private long remainingRowCount;
    private final long rowSetId;
    private final long rowSetIdHint;
    private final long fetchSize;
    private Object targetConnection;
    private final boolean partial;
    private boolean followingLost;
    private boolean closed;
    private final PartialRowSetReference remoteRef;

    public SubnetRowSet(SubnetContainer<?, ?> container, Class<R> rowType, RowMapper mapper, RowMapper.Cursor resultCursor, long transactionId) {
        this.container = container;
        this.rowType = rowType;
        this.mapper = mapper;
        this.resultCursor = resultCursor;
        this.transactionId = transactionId;
        this.totalRowCount = resultCursor.getRowCount();
        this.rowSetId = 0L;
        this.rowSetIdHint = 0L;
        this.fetchSize = 0L;
        this.partial = false;
        this.remoteRef = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubnetRowSet(SubnetContainer<?, ?> container, Class<R> rowType, RowMapper mapper, RowMapper.Cursor resultCursor, long transactionId, long totalRowCount, long rowSetId, long rowSetIdHint, long fetchSize, Object targetConnection) throws GSException {
        this.container = container;
        this.rowType = rowType;
        this.mapper = mapper;
        this.resultCursor = resultCursor;
        this.transactionId = transactionId;
        this.totalRowCount = totalRowCount;
        this.remainingRowCount = totalRowCount - (long)resultCursor.getRowCount();
        this.rowSetId = rowSetId;
        this.rowSetIdHint = rowSetIdHint;
        this.fetchSize = fetchSize;
        this.targetConnection = targetConnection;
        this.partial = true;
        GridStoreChannel.Context context = container.context;
        synchronized (context) {
            container.channel.cleanRemoteResources(container.context, new HashSet<Class>(Arrays.asList(NormalTarget.class, TransactionalTarget.class)));
            this.remoteRef = new PartialRowSetReference(this, rowSetId, rowSetIdHint, targetConnection);
            container.context.addRemoteReference(this.remoteRef);
        }
    }

    public boolean isPartial() {
        return this.partial;
    }

    private void checkOpened() throws GSException {
        if (GridStoreChannel.v10ResourceCompatible) {
            return;
        }
        if (this.closed || this.container.isClosed() || this.remoteRef != null && this.remoteRef.closed) {
            throw new GSException(145040, "This row set or related container has been closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws GSException {
        this.closed = true;
        if (this.targetConnection != null) {
            GridStoreChannel.Context context = this.container.context;
            synchronized (context) {
                if (this.targetConnection != null) {
                    try {
                        this.container.channel.closeRemoteResource(this.container.context, this.remoteRef, false);
                    }
                    finally {
                        this.targetConnection = null;
                    }
                }
            }
        }
        this.resultCursor.resetBuffer();
    }

    @Override
    public boolean hasNext() throws GSException {
        return this.resultCursor.hasNext() || this.remainingRowCount > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fetchFollowing() throws GSException {
        GridStoreChannel.Context context = this.container.context;
        synchronized (context) {
            if (this.followingLost) {
                throw new GSRecoverableException(145043, "Row set lost by modifications (remainingRowCount=" + this.remainingRowCount + ")");
            }
            if (this.targetConnection == null) {
                throw new GSException(145040, "Row set lost by transactional problem");
            }
            Object[] targetConnectionResult = new Object[]{this.targetConnection};
            boolean succeeded = false;
            try {
                this.resultCursor = this.container.fetchRowSet(this.rowSetId, this.rowSetIdHint, this.totalRowCount, this.remainingRowCount, this.fetchSize, targetConnectionResult, this.mapper);
                succeeded = true;
            }
            finally {
                block22: {
                    this.targetConnection = targetConnectionResult[0];
                    try {
                        if (this.targetConnection == null) {
                            this.container.context.removeRemoteReference(this.remoteRef);
                        }
                        if (succeeded) break block22;
                    }
                    catch (Throwable throwable) {
                        if (succeeded) throw throwable;
                        try {
                            this.close();
                            throw throwable;
                        }
                        catch (Throwable t) {}
                    }
                    try {
                        this.close();
                    }
                    catch (Throwable t) {}
                }
            }
            this.remainingRowCount -= (long)this.resultCursor.getRowCount();
            if (this.remainingRowCount > 0L && this.targetConnection == null) {
                this.followingLost = true;
            }
            if (!this.resultCursor.hasNext()) throw new GSRecoverableException(145043, "Row set lost by modifications (remainingRowCount=" + this.remainingRowCount + ")");
            return;
        }
    }

    @Override
    public R next() throws GSException {
        Object unchekedRowObj;
        this.checkOpened();
        if (!this.resultCursor.hasNext()) {
            if (this.remainingRowCount <= 0L) {
                throw new GSException(145037, "No more rows were found");
            }
            this.fetchFollowing();
        }
        Object rowObj = this.rowType == null ? (unchekedRowObj = this.mapper.decode(this.resultCursor)) : this.rowType.cast(this.mapper.decode(this.resultCursor));
        this.lastKey = this.mapper.hasKey() ? this.mapper.resolveKey(null, rowObj) : null;
        return (R)rowObj;
    }

    @Override
    public void remove() throws GSException {
        this.checkOpened();
        if (!this.resultCursor.isInRange()) {
            throw new GSException(145037, "Cursor out of range");
        }
        this.container.remove(this.mapper, this.transactionId, this.resultCursor.getLastRowId(), this.lastKey);
    }

    @Override
    public void update(R rowObj) throws GSException {
        this.checkOpened();
        if (!this.resultCursor.isInRange()) {
            throw new GSException(145037, "Cursor out of range");
        }
        this.container.update(this.mapper, this.transactionId, this.resultCursor.getLastRowId(), this.lastKey, rowObj);
    }

    @Override
    public int size() {
        return (int)this.totalRowCount;
    }

    public Row nextGeneralRow() throws GSException {
        this.checkOpened();
        if (!this.hasNext()) {
            throw new GSException(145037, "Cursor out of range");
        }
        Row rowObj = (Row)this.mapper.decode(this.resultCursor, true);
        this.lastKey = this.mapper.hasKey() ? this.mapper.resolveKey(null, rowObj, true) : null;
        return rowObj;
    }

    public static class Tool {
        private Tool() {
        }

        public static Container<?, ?> getContainer(SubnetRowSet<?> rowSet) {
            return ((SubnetRowSet)rowSet).container;
        }

        public static long getTransactionId(SubnetRowSet<?> rowSet) {
            return ((SubnetRowSet)rowSet).transactionId;
        }

        public static long getRowId(SubnetRowSet<?> rowSet) throws GSException {
            ((SubnetRowSet)rowSet).checkOpened();
            if (!((SubnetRowSet)rowSet).resultCursor.isInRange()) {
                throw new GSException(145037, "Cursor out of range");
            }
            if (!((SubnetRowSet)rowSet).resultCursor.isRowIdIncluded()) {
                throw new GSException(145003, "Elements of this RowSet are not collection row");
            }
            return ((SubnetRowSet)rowSet).resultCursor.getLastRowId();
        }

        public static Object getRowKey(SubnetRowSet<?> rowSet) throws GSException {
            ((SubnetRowSet)rowSet).checkOpened();
            if (!((SubnetRowSet)rowSet).resultCursor.isInRange()) {
                throw new GSException(145037, "Cursor out of range");
            }
            if (!((SubnetRowSet)rowSet).container.getRowMapper().hasKey()) {
                return null;
            }
            return ((SubnetRowSet)rowSet).lastKey;
        }
    }

    private static class PartialRowSetReference
    extends GridStoreChannel.RemoteReference<RowSet<?>> {
        private final long rowSetId;
        private final long rowSetIdHint;
        private final Object targetConnection;
        private boolean closed;

        PartialRowSetReference(SubnetRowSet<?> rowSet, long rowSetId, long rowSetIdHint, Object targetConnection) {
            super(rowSet, PartialRowSetReference.selectTargetClass(rowSet), ((SubnetRowSet)rowSet).container.context, ((SubnetRowSet)rowSet).container.getPartitionId(), ((SubnetRowSet)rowSet).container.getContainerId());
            this.rowSetId = rowSetId;
            this.rowSetIdHint = rowSetIdHint;
            this.targetConnection = targetConnection;
        }

        private static Class<?> selectTargetClass(SubnetRowSet<?> rowSet) {
            if (((SubnetRowSet)rowSet).transactionId == 0L) {
                return NormalTarget.class;
            }
            return TransactionalTarget.class;
        }

        @Override
        public void close(GridStoreChannel channel, GridStoreChannel.Context context) throws GSException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            SubnetContainer.closeRowSet(channel, context, this.partitionId, this.containerId, this.rowSetId, this.rowSetIdHint, this.targetConnection);
        }
    }

    private static interface TransactionalTarget
    extends SubnetContainer.TransactionalResource {
    }

    private static interface NormalTarget
    extends SubnetContainer.ContainerSubResource {
    }
}

