package sample;

import java.util.Properties;

import com.toshiba.mwcloud.gs.GridStore;
import com.toshiba.mwcloud.gs.GridStoreFactory;
import com.toshiba.mwcloud.gs.GSException;



public class FlushCluster {

	//Collection Containers used by PostgreSQL Foreign Data Wrapper Test scripts
	private static final String collections[] = {
		"department",
		"employee",
		"empdata",
		"numbers",
		"shorty",
		"jp_prefecture",
	};

	//Timeseries Containers used by PostgreSQL Foreign Data Wrapper Test scripts
	private static final String timeseriesContainers[] = {
		"jp_prefecture_readings",
		"water_quality_ts_3"
	};

	//Containers used for testing column types by the test *.sql scripts in PostgreSQL
	private static final String testContainers[] = {
		"type_string",
		"type_boolean",
		"type_byte",
		"type_short",
		"type_integer",
		"type_long",
		"type_float",
		"type_double",
		"type_timestamp",
		"type_blob",
		"type_string_array",
		"type_bool_array",
		"type_byte_array",
		"type_short_array",
		"type_integer_array",
		"type_long_array",
		"type_float_array",
		"type_double_array",
		"type_timestamp_array"
	};

	public static void main(String args[]) throws GSException {
		Properties properties = new Properties();

		//Collect GridDB Configuration settings from the command line
		properties.setProperty("notificationAddress",args[0]);
		properties.setProperty("notificationPort",args[1]);
		properties.setProperty("clusterName",args[2]);
		properties.setProperty("user",args[3]);
		properties.setProperty("password",args[4]);

		GridStore gridstore = null;	

		try {
			gridstore = GridStoreFactory.getInstance().getGridStore(properties); //Connect to GridDB

			for(int i = 0; i < collections.length; i++){

				//Drop all collection containers referenced in the *.sql  scripts in the 'sql' directory used for testing
				//the PostgreSQL data wrapper.
				gridstore.dropCollection(collections[i]);
				System.out.println("Removed collection: " + collections[i]);
			}

			for(int i = 0; i < timeseriesContainers.length; i++){
				
				//Drop all timeseries containers referenced in the *.sql  scripts in the 'sql' directory used for testing
				//the PostgreSQL data wrapper.
				gridstore.dropTimeSeries(timeseriesContainers[i]);
				System.out.println("Removed timeseries: " + timeseriesContainers[i]);
			}

			for(int i = 0; i < testContainers.length; i++){

				//Drop all containers that were used for testing data/column types with
				//the GridDB Foreign Data Wrapper for PostgreSQL.
				gridstore.dropContainer(testContainers[i]);
				System.out.println("Removed test container: " + testContainers[i]);
			}

		} catch(GSException e){
			e.printStackTrace();
		} finally {
			if(gridstore != null){
				gridstore.close(); //Close access to GridDB
			}
		}
	}

}