package sample.row;

import com.toshiba.mwcloud.gs.RowKey;
import com.toshiba.mwcloud.gs.TimestampUtils;

import java.sql.Blob;
import java.util.Date;

public class InstrumentLog {
	@RowKey
	public Date timestamp; //Timestamp Column (Primary Key for Timeseries containers)

	public String weatherstationid; //String column for the sensor that recorded the temperature measurement

	public double temperature; //Temperature reading

	public Blob liveimage; //Image recording (Binary Stream Data or Blob Column)

	public String toString(){
		return String.format(
			"%s: %s, temp: %f",
			weatherstationid,
			TimestampUtils.format(timestamp),
			temperature
		);
	}
	
}
