#!/bin/bash

## GridDB Configurations
GRIDDB_HOST=239.0.0.1
GRIDDB_PORT=31999
GRIDDB_CLUSTER=defaultCluster
GRIDDB_USER=admin
GRIDDB_PASSWORD=admin

## If by any chance you need to connect to either GridDB or PostgreSQL
## You can do so with these commands.

## GridDB Connection

## sudo su - gsadm -c "gs_startnode"
## sudo su - gsadm -c "gs_joincluster -c $GRIDDB_CLUSTER -u $GRIDDB_USER/$GRIDDB_PASSWORD"

## PostgreSQL Connection
## Start PostgreSQL source using Postmaster Command
## DATA_DIR=/usr/local/pgsq/data
## sudo su - postgres -c "postmaster -D $DATA_DIR >logfile 2>&1 &"

## Kill PostgreSQL Database Server
## sudo kill -INT `head -1 $DATA_DIR/postmaster.pid`

## Commmand to Launch PostgreSQL Shell
PSQL=psql

## Directory containing .sql scripts
SQL_DIR=sql

## Directory for storing output
OUT_DIR=test

## Demo .sql script for GridDB Foreign Data Wrapper.
SAMPLE_SQL=griddb_fdw_sample.sql



echo "Testing PostgreSQL Queries with GridDB as a Foreign Data Source."
echo "Ensure both your GridDB and PostgreSQL Servers are up and running"
echo "Requires PostgreSQL versions 9.6 - 10.0"

rm -f $OUT_DIR/*
echo sudo su - postgres -c "$PSQL -c '\i ${PWD}/$SQL_DIR/$SAMPLE_SQL'"
sudo su - postgres -c "$PSQL -c '\i ${PWD}/$SQL_DIR/$SAMPLE_SQL'" 2>&1 | tee $OUT_DIR/griddb_fdw_sample.out

echo sudo su - postgres -c "$PSQL -c '\i ${PWD}/$SQL_DIR/griddb_fdw.sql'"
sudo su - postgres -c "$PSQL -c '\i ${PWD}/$SQL_DIR/griddb_fdw.sql'" 2>&1 | tee $OUT_DIR/griddb_fdw.out

echo sudo su - postgres -c "$PSQL -c '\i ${PWD}/$SQL_DIR/griddb_fdw_data_type.sql'"
sudo su - postgres -c "$PSQL -c '\i ${PWD}/$SQL_DIR/griddb_fdw_data_type.sql'" 2>&1 | tee $OUT_DIR/griddb_fdw_data_type.out

echo "PostgreSQL FDW Tests on GridDB Complete."
