package sample.row;

import java.util.Date;

import com.toshiba.mwcloud.gs.RowKey;
import com.toshiba.mwcloud.gs.TimestampUtils;


public class QualitySample {
	@RowKey
	public Date timestamp; //Time the water quality reading was recorded

	public double water_temperature; //Temperature of the water

	public double turbidity; //Water turbidity

	public double depth; //Depth of the water sample

	public double wave_height; //Height of the wave at recording

	public double wave_period; //Wave's estimated period at time of recording

	public double battery_life; //Remaning battery life of the recoding sensor at the time of measurement

	public String beach_name; //Name of location where the recording was made.

	public String toString(){
		return String.format(
			"%s for %s, temp: %f, turbidity: %f, depth; %f, height: %f, period: %f, battery: %f",
			TimestampUtils.format(timestamp),
			beach_name,
			water_temperature,
			turbidity,
			depth,
			wave_height,
			wave_period,
			battery_life
		);
	}

}
