/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.subnet;

import com.toshiba.mwcloud.gs.ContainerType;
import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.GSRecoverableException;
import com.toshiba.mwcloud.gs.GSTimeoutException;
import com.toshiba.mwcloud.gs.common.BasicBuffer;
import com.toshiba.mwcloud.gs.common.GSConnectionException;
import com.toshiba.mwcloud.gs.common.GSStatementException;
import com.toshiba.mwcloud.gs.common.GSWrongNodeException;
import com.toshiba.mwcloud.gs.common.LoggingUtils;
import com.toshiba.mwcloud.gs.common.PropertyUtils;
import com.toshiba.mwcloud.gs.common.RowMapper;
import com.toshiba.mwcloud.gs.common.ServiceAddressResolver;
import com.toshiba.mwcloud.gs.common.Statement;
import com.toshiba.mwcloud.gs.subnet.NodeConnection;
import com.toshiba.mwcloud.gs.subnet.NodeConnectionPool;
import com.toshiba.mwcloud.gs.subnet.NodeResolver;
import java.io.Closeable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;

public class GridStoreChannel
implements Closeable {
    public static Boolean v1ProtocolCompatible = null;
    public static boolean v1ProtocolCompatible_1_1_103x = false;
    public static boolean v10ResourceCompatible = false;
    public static boolean v15TSPropsCompatible = false;
    public static boolean v15DDLCompatible = true;
    public static boolean v20AffinityCompatible = false;
    public static boolean v21StatementIdCompatible = false;
    private static int FAILOVER_TIMEOUT_DEFAULT = 60000;
    private static int FAILOVER_RETRY_INTERVAL = 1000;
    public static int INITIAL_BUFFER_SIZE = 256;
    public static int MAPPER_CACHE_SIZE = 32;
    private static int MAX_REF_SCAN_COUNT = 15;
    private static final int SYSTEM_CONTAINER_PARTITION_ID = 0;
    private static final LoggingUtils.BaseGridStoreLogger LOGGER = LoggingUtils.getLogger("Connection");
    private static final LoggingUtils.BaseGridStoreLogger STATEMENT_LOGGER = LoggingUtils.getLogger("StatementExec");
    private final Config config = new Config();
    private int statementRetryMode;
    private final NodeConnectionPool pool;
    private final NodeResolver nodeResolver;
    private final int requestHeadLength;
    private final Key key;
    private final Set<ContextReference> contextRefSet = new LinkedHashSet<ContextReference>();
    private static String NUMERICAL_REGEX = "\\A(0|[1-9][0-9]{0,8})\\z";
    private static Pattern NUMERICAL_REGEX_PATTERN = Pattern.compile(NUMERICAL_REGEX);

    public GridStoreChannel(Config config, Source source) throws GSException {
        this.pool = new NodeConnectionPool();
        this.key = source.key;
        this.nodeResolver = new NodeResolver(this.pool, this.key.passive, this.key.address, config.getConnectionConfig(), source.getLoginInfo(), source.partitionCount, this.key.sarConfig, this.key.memberList, null);
        this.requestHeadLength = NodeConnection.getRequestHeadLength(this.key.isIPV6Enabled());
        this.apply(config);
    }

    public NodeConnection.Config getConnectionConfig() {
        return this.config.getConnectionConfig();
    }

    public NodeConnectionPool getConnectionPool() {
        return this.pool;
    }

    public void apply(Source source) {
        this.nodeResolver.setUser(source.getLoginInfo().getUser());
        this.nodeResolver.setPassword(source.password);
    }

    public void apply(Config config) {
        this.config.set(config);
        this.nodeResolver.setConnectionConfig(this.config.connectionConfig);
        this.nodeResolver.setNotificationReceiveTimeoutMillis(config.getNotificationReceiveTimeoutMillis());
        this.nodeResolver.setPreferableConnectionPoolSize(config.getMaxConnectionPoolSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextReference registerContext(Context context, Object target) throws GSException {
        Set<ContextReference> set = this.contextRefSet;
        synchronized (set) {
            ArrayList<ContextReference> pendingList = new ArrayList<ContextReference>(MAX_REF_SCAN_COUNT);
            try {
                Iterator<ContextReference> it = this.contextRefSet.iterator();
                while (it.hasNext()) {
                    ContextReference ref = it.next();
                    if (ref.get() == null) {
                        this.closeContext(ref.context);
                    } else {
                        pendingList.add(ref);
                    }
                    it.remove();
                    if (pendingList.size() < MAX_REF_SCAN_COUNT) continue;
                    break;
                }
            }
            finally {
                if (pendingList != null) {
                    this.contextRefSet.addAll(pendingList);
                }
            }
            ContextReference newRef = new ContextReference(target, context);
            this.contextRefSet.add(newRef);
            return newRef;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterContext(ContextReference ref) {
        Set<ContextReference> set = this.contextRefSet;
        synchronized (set) {
            this.contextRefSet.remove(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllContext(boolean silent) throws GSException {
        Set<ContextReference> set = this.contextRefSet;
        synchronized (set) {
            boolean succeeded = false;
            try {
                Iterator<ContextReference> it = this.contextRefSet.iterator();
                while (it.hasNext()) {
                    Context context = it.next().context;
                    it.remove();
                    Context context2 = context;
                    synchronized (context2) {
                        if (!context.closed) {
                            if (silent) {
                                try {
                                    this.closeContext(context);
                                }
                                catch (Throwable t) {}
                            } else {
                                this.closeContext(context);
                            }
                        }
                    }
                }
                succeeded = true;
            }
            finally {
                if (!succeeded && !silent) {
                    this.closeAllContext(true);
                }
            }
        }
    }

    public long getFailoverTimeoutMillis(Context context) {
        if (context.failoverTimeoutMillis >= 0L) {
            return context.failoverTimeoutMillis;
        }
        return this.config.failoverTimeoutMillis;
    }

    public void setStatementRetryMode(int statementRetryMode) {
        this.statementRetryMode = statementRetryMode;
    }

    public BasicBuffer createRequestBuffer() {
        return this.createRequestBuffer(INITIAL_BUFFER_SIZE);
    }

    public BasicBuffer createRequestBuffer(int minCapacity) {
        BasicBuffer buffer = new BasicBuffer(Math.max(this.requestHeadLength, minCapacity));
        NodeConnection.fillRequestHead(this.key.isIPV6Enabled(), buffer);
        return buffer;
    }

    public BasicBuffer createResponseBuffer() {
        return this.createResponseBuffer(INITIAL_BUFFER_SIZE);
    }

    public BasicBuffer createResponseBuffer(int minCapacity) {
        return new BasicBuffer(Math.max(this.requestHeadLength, minCapacity));
    }

    public void setupRequestBuffer(BasicBuffer buffer) {
        buffer.base().position(this.requestHeadLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanRemoteResources(Context context, Set<? extends Class<?>> targetClasses) throws GSException {
        Context context2 = context;
        synchronized (context2) {
            Reference ref;
            while ((ref = context.remoteRefQueue.poll()) != null) {
                this.closeRemoteResource(context, (RemoteReference)ref, false);
            }
            block7: for (Class<?> clazz : targetClasses == null ? context.getReferenceTargetClasses() : targetClasses) {
                Set<RemoteReference<?>> set = context.getRemoteReferences(clazz);
                if (set.isEmpty()) continue;
                ArrayList pendingList = new ArrayList(MAX_REF_SCAN_COUNT);
                try {
                    Iterator<RemoteReference<?>> it = set.iterator();
                    while (it.hasNext()) {
                        RemoteReference<?> ref2 = it.next();
                        if (ref2.get() == null) {
                            this.closeRemoteResource(context, ref2, true);
                        } else {
                            pendingList.add(ref2);
                        }
                        it.remove();
                        if (pendingList.size() < MAX_REF_SCAN_COUNT) continue;
                        continue block7;
                    }
                }
                finally {
                    set.addAll(pendingList);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllRemoteResources(Context context, Set<Class<?>> targetClasses, int partitionId, long containerId, boolean silent) throws GSException {
        Context context2 = context;
        synchronized (context2) {
            boolean succeeded = false;
            try {
                for (Class<?> clazz : targetClasses == null ? context.getReferenceTargetClasses() : targetClasses) {
                    Iterator<RemoteReference<?>> it = context.getRemoteReferences(clazz).iterator();
                    while (it.hasNext()) {
                        RemoteReference<?> ref = it.next();
                        if (targetClasses == null || ref.partitionId == partitionId && ref.containerId == containerId) {
                            if (silent) {
                                try {
                                    this.closeRemoteResource(context, ref, true);
                                }
                                catch (Throwable t) {}
                            } else {
                                this.closeRemoteResource(context, ref, true);
                            }
                        }
                        it.remove();
                    }
                }
                succeeded = true;
            }
            finally {
                if (!succeeded) {
                    this.closeAllRemoteResources(context, targetClasses, partitionId, containerId, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeRemoteResource(Context context, RemoteReference<?> ref, boolean refMapRetained) throws GSException {
        Context context2 = context;
        synchronized (context2) {
            try {
                ref.close(this, context);
            }
            finally {
                try {
                    if (!refMapRetained) {
                        context.removeRemoteReference(ref);
                    }
                }
                finally {
                    ref.clear();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeContext(Context context) throws GSException {
        Context context2 = context;
        synchronized (context2) {
            try {
                this.closeAllRemoteResources(context, null, 0, 0L, false);
            }
            finally {
                context.partitionId = -1;
                context.lastConnection = null;
                context.closed = true;
                Iterator it = context.activeConnections.values().iterator();
                while (it.hasNext()) {
                    NodeConnection connection = (NodeConnection)it.next();
                    try {
                        if (connection != null) {
                            this.pool.add(connection);
                        }
                        connection = null;
                    }
                    finally {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    it.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getLastConnection(Context context) throws GSException {
        Context context2 = context;
        synchronized (context2) {
            return context.lastConnection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkActiveConnection(Context context, int partitionId, Object connection) throws GSException {
        SocketAddress address = ((NodeConnection)connection).getRemoteSocketAddress();
        Context context2 = context;
        synchronized (context2) {
            NodeConnection activeConnection = (NodeConnection)context.activeConnections.get(address);
            if (activeConnection == null || activeConnection != connection) {
                throw new GSRecoverableException(145042, "");
            }
        }
    }

    private static boolean isConnectionDependentStatement(Statement statement) {
        return statement == Statement.CLOSE_ROW_SET || statement == Statement.FETCH_ROW_SET;
    }

    public void executeStatement(Context context, Statement statement, int partitionId, long statementId, BasicBuffer req, BasicBuffer resp) throws GSException {
        this.executeStatement(context, statement, partitionId, statementId, req, resp, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeStatement(Context context, Statement statement, int partitionId, long statementId, BasicBuffer req, BasicBuffer resp, ContextMonitor contextMonitor) throws GSException {
        Context context2 = context;
        synchronized (context2) {
            ContextMonitor localMonitor;
            if (context.closed) {
                throw new GSException(145040, "Already closed");
            }
            ContextMonitor contextMonitor2 = localMonitor = contextMonitor == null ? context.contextMonitor : contextMonitor;
            if (localMonitor != null && contextMonitor == null) {
                localMonitor.startStatement(statement, statementId, partitionId, null);
            }
            int reqLength = req.base().position();
            SocketAddress orgAddress = null;
            long failoverStartTime = 0L;
            int failoverTrialCount = 0;
            boolean firstTrial = true;
            while (true) {
                try {
                    if (statement == null) {
                        if (localMonitor != null) {
                            localMonitor.startStatementIO();
                        }
                        context.activeResolverExecutor.execute();
                    } else {
                        this.updateConnection(context, partitionId, firstTrial);
                        if (localMonitor != null) {
                            localMonitor.startStatementIO();
                        }
                        context.lastConnection.executeStatement(statement, context.partitionId, statementId, req, resp);
                    }
                    if (!firstTrial) {
                        if (failoverTrialCount > 0) {
                            context.failoverCount++;
                        }
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info(failoverTrialCount > 0 ? "connection.failoverSucceeded" : "connection.retrySucceeded", new Object[]{ContextMonitor.getObjectId(context), statement, orgAddress, context.getLastRemoteAddress(), partitionId, statementId, failoverTrialCount});
                        }
                    }
                    if (localMonitor == null) break;
                    localMonitor.endStatementIO();
                    if (contextMonitor != null) break;
                    localMonitor.endStatement();
                    break;
                }
                catch (GSConnectionException e) {
                    long failoverTimeout;
                    long trialDuration;
                    try {
                        if (context.lastConnection != null) {
                            SocketAddress address = context.lastConnection.getRemoteSocketAddress();
                            context.activeConnections.remove(address);
                            try {
                                context.lastConnection.close();
                            }
                            catch (GSException e2) {
                                // empty catch block
                            }
                            if (orgAddress != null) {
                                orgAddress = address;
                            }
                        }
                        context.lastConnection = null;
                    }
                    finally {
                        if (this.statementRetryMode == 0) {
                            this.invalidateMaster(context);
                        }
                    }
                    req.base().position(reqLength);
                    if (localMonitor != null) {
                        localMonitor.endStatementIO();
                    }
                    if (statement != null && GridStoreChannel.isConnectionDependentStatement(statement)) {
                        throw new GSRecoverableException(145042, (Throwable)e);
                    }
                    if ((this.statementRetryMode == 0 || this.statementRetryMode == 2) && firstTrial && !(e instanceof GSWrongNodeException)) {
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info("connection.retryStarted", new Object[]{ContextMonitor.getObjectId(context), statement, orgAddress, partitionId, statementId, failoverTrialCount, e});
                        }
                    }
                    long curTime = System.currentTimeMillis();
                    if (failoverStartTime == 0L) {
                        failoverStartTime = curTime;
                    }
                    if ((trialDuration = curTime - failoverStartTime) >= (failoverTimeout = this.getFailoverTimeoutMillis(context))) {
                        String errorReason;
                        String string = errorReason = e.getMessage() == null ? "" : e.getMessage();
                        String errorMessage = failoverTimeout > 0L ? "Failover timed out (trialCount=" + failoverTrialCount + ", trialMillis=" + trialDuration + ", timeoutMillis=" + failoverTimeout + ", reason=" + errorReason + ")" : (firstTrial ? null : "Retry failed (reason=" + errorReason + ")");
                        throw new GSTimeoutException(e.getErrorCode(), errorMessage, e);
                    }
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("connection.failoverWorking", new Object[]{ContextMonitor.getObjectId(context), statement, orgAddress, partitionId, statementId, failoverTrialCount, trialDuration, failoverTimeout, e});
                    }
                    if (this.statementRetryMode == 2 && failoverTrialCount > 0 || this.statementRetryMode == 1 && e instanceof GSWrongNodeException) {
                        this.invalidateMaster(context);
                    }
                    try {
                        Thread.sleep(this.config.getFailoverRetryIntervalMillis());
                    }
                    catch (InterruptedException e2) {
                        // empty catch block
                    }
                    ++failoverTrialCount;
                }
                catch (GSStatementException e) {
                    if (!firstTrial && failoverTrialCount > 0) {
                        context.failoverCount++;
                    }
                    if (!firstTrial && LOGGER.isInfoEnabled()) {
                        LOGGER.info("connection.statementErrorAfter" + (failoverTrialCount > 0 ? "Failover" : "Retry"), new Object[]{ContextMonitor.getObjectId(context), statement, orgAddress, context.getLastRemoteAddress(), partitionId, statementId, failoverTrialCount, e});
                    }
                    throw e;
                }
                firstTrial = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T executeResolver(Context context, ResolverExecutor<T> executor) throws GSException {
        context.activeResolverExecutor = executor;
        try {
            this.executeStatement(context, null, 0, 0L, context.getRequestBuffer(), null, null);
            Object t = executor.result;
            return t;
        }
        finally {
            context.activeResolverExecutor = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConnection(Context context, int partitionId, boolean preferConnectionPool) throws GSException {
        InetSocketAddress address;
        InetSocketAddress cachedAddress;
        NodeConnection lastConnection = context.lastConnection;
        if (lastConnection != null && context.partitionId == partitionId) {
            return;
        }
        if (context.partitionCount < 0) {
            context.partitionCount = this.nodeResolver.getPartitionCount();
        }
        if (partitionId >= 0 && partitionId < context.addressCache.size() && (cachedAddress = (InetSocketAddress)context.addressCache.get(partitionId)) != null) {
            address = cachedAddress;
        } else {
            address = this.nodeResolver.getNodeAddress(partitionId, !context.loginInfo.isOwnerMode(), context.partitionCount, (InetAddress)context.preferableHosts.get(partitionId));
            if (partitionId >= 0 && partitionId < context.partitionCount) {
                while (partitionId >= context.addressCache.size()) {
                    context.addressCache.add(null);
                }
                context.addressCache.set(partitionId, address);
            }
        }
        if (lastConnection != null && address.equals(lastConnection.getRemoteSocketAddress())) {
            context.partitionId = partitionId;
            return;
        }
        context.lastConnection = (NodeConnection)context.activeConnections.get(address);
        if (context.lastConnection != null) {
            context.partitionId = partitionId;
            return;
        }
        BasicBuffer req = this.createRequestBuffer(64);
        BasicBuffer resp = this.createResponseBuffer(64);
        NodeConnection newConnection = this.pool.resolve(address, req, resp, this.config.getConnectionConfig(), context.loginInfo, preferConnectionPool);
        boolean updated = false;
        try {
            context.activeConnections.put(address, newConnection);
            context.lastConnection = newConnection;
            context.partitionId = partitionId;
            updated = true;
        }
        finally {
            if (!updated) {
                context.lastConnection = null;
                context.partitionId = -1;
                try {
                    context.activeConnections.remove(address);
                }
                finally {
                    this.pool.add(newConnection);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateMaster(Context context) {
        Context context2 = context;
        synchronized (context2) {
            context.containerHashMode = null;
            context.partitionCount = -1;
            context.addressCache.clear();
            this.nodeResolver.invalidateMaster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkContextAvailable(Context context) throws GSException {
        Context context2 = context;
        synchronized (context2) {
            if (context.closed) {
                throw new GSException(145040, "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetSocketAddress[] getNodeAddressList(Context context, final int partitionId) throws GSException {
        Context context2 = context;
        synchronized (context2) {
            return this.executeResolver(context, new ResolverExecutor<InetSocketAddress[]>(){

                @Override
                public void execute() throws GSException {
                    this.result = GridStoreChannel.this.nodeResolver.getNodeAddressList(partitionId);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPartitionCount(Context context) throws GSException {
        Context context2 = context;
        synchronized (context2) {
            if (context.partitionCount < 0) {
                context.partitionCount = this.executeResolver(context, new ResolverExecutor<Integer>(){

                    @Override
                    public void execute() throws GSException {
                        this.result = GridStoreChannel.this.nodeResolver.getPartitionCount();
                    }
                });
            }
            return context.partitionCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int resolvePartitionId(final Context context, String containerName) throws GSException {
        Context context2 = context;
        synchronized (context2) {
            if (context.partitionCount < 0 || context.containerHashMode == null) {
                this.executeResolver(context, new ResolverExecutor<Void>(){

                    @Override
                    public void execute() throws GSException {
                        context.partitionCount = GridStoreChannel.this.nodeResolver.getPartitionCount();
                        context.containerHashMode = GridStoreChannel.this.nodeResolver.getContainerHashMode();
                    }
                });
            }
            if (containerName.equals("gs#users@0")) {
                return 0;
            }
            int subContainerId = -1;
            String base = null;
            String affinity = null;
            int partitionId = -1;
            int partitioningCount = 0;
            boolean newPartitioningRule = false;
            int affinityPos = containerName.indexOf(64);
            int subPartitionIdPos = containerName.indexOf(47);
            if (subPartitionIdPos == -1) {
                if (affinityPos == -1) {
                    base = RowMapper.normalizeExtendedSymbol(containerName, true);
                    return GridStoreChannel.calculatePartitionId(base, context.containerHashMode, context.partitionCount);
                }
                subPartitionIdPos = containerName.length();
            } else {
                if (subPartitionIdPos == 0) {
                    throw new GSException(145002, "Illegal container name (" + containerName + ")");
                }
                int partitioningPos = containerName.indexOf(95, subPartitionIdPos + 1);
                if (partitioningPos != -1) {
                    newPartitioningRule = true;
                } else {
                    partitioningPos = containerName.length();
                }
                String subPartitionId = containerName.substring(subPartitionIdPos + 1, partitioningPos);
                if (subPartitionId.isEmpty()) {
                    throw new GSException(145002, "Illegal container name (" + containerName + ")");
                }
                Matcher m1 = NUMERICAL_REGEX_PATTERN.matcher(subPartitionId);
                if (!m1.find()) {
                    throw new GSException(145002, "Illegal container name (, " + containerName + ")");
                }
                subContainerId = Integer.parseInt(subPartitionId);
                if (newPartitioningRule) {
                    String partitioningCountStr = containerName.substring(partitioningPos + 1, containerName.length());
                    Matcher m2 = NUMERICAL_REGEX_PATTERN.matcher(partitioningCountStr);
                    if (m2.find()) {
                        partitioningCount = Integer.parseInt(partitioningCountStr);
                    } else {
                        throw new GSException(145002, "Illegal container name (, " + containerName + ")");
                    }
                }
            }
            if (affinityPos == 0) {
                throw new GSException(145002, "Illegal container name (" + containerName + ")");
            }
            if (affinityPos == -1) {
                base = containerName.substring(0, subPartitionIdPos);
                base = RowMapper.normalizeExtendedSymbol(base, true);
            } else {
                if (affinityPos > subPartitionIdPos || affinityPos + 1 == subPartitionIdPos) {
                    throw new GSException(145002, "Illegal container name (" + containerName + ")");
                }
                affinity = containerName.substring(affinityPos + 1, subPartitionIdPos);
                if (affinity.isEmpty()) {
                    throw new GSException(145002, "Illegal container name (" + containerName + ")");
                }
                Matcher m1 = NUMERICAL_REGEX_PATTERN.matcher(affinity);
                if (m1.find()) {
                    partitionId = Integer.parseInt(affinity);
                    if (subContainerId != -1) {
                        partitionId += subContainerId;
                    }
                } else {
                    affinity = RowMapper.normalizeSymbol("_" + affinity);
                    base = affinity = affinity.substring(1);
                }
            }
            if (partitionId != -1) {
                partitionId %= context.partitionCount;
            } else if (affinity != null && !newPartitioningRule) {
                partitionId = GridStoreChannel.calculatePartitionId(affinity, context.containerHashMode, context.partitionCount);
            } else if (!newPartitioningRule) {
                partitionId = GridStoreChannel.calculatePartitionId(base, context.containerHashMode, context.partitionCount);
                if (subContainerId != -1) {
                    partitionId = (partitionId + subContainerId) % context.partitionCount;
                }
            } else {
                if (context.partitionCount <= partitioningCount) {
                    return subContainerId % context.partitionCount;
                }
                int pbase = context.partitionCount / partitioningCount;
                int pmod = context.partitionCount % partitioningCount;
                CRC32 crc = new CRC32();
                crc.update(base.getBytes(BasicBuffer.DEFAULT_CHARSET));
                partitionId = pbase * subContainerId + Math.min(pmod, subContainerId) + (int)((crc.getValue() & 0xFFFFFFFFFFFFFFFFL) % (long)pbase);
            }
            return partitionId;
        }
    }

    public static int calculatePartitionId(String normalizedString, NodeResolver.ContainerHashMode hashMode, int partitionCount) throws GSException {
        switch (hashMode) {
            case CRC32: {
                CRC32 crc = new CRC32();
                crc.update(normalizedString.getBytes(BasicBuffer.DEFAULT_CHARSET));
                return (int)((crc.getValue() & 0xFFFFFFFFFFFFFFFFL) % (long)partitionCount);
            }
        }
        throw new GSException(145000, "Unsupported hash mode");
    }

    public static int statementToNumber(Statement statement) {
        return NodeConnection.statementToNumber(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws GSException {
        try {
            this.closeAllContext(false);
        }
        finally {
            try {
                this.nodeResolver.close();
            }
            finally {
                this.pool.close();
            }
        }
    }

    static ContextMonitor createContextMonitorIfAvailable() {
        if (STATEMENT_LOGGER.isDebugEnabled()) {
            return new ContextMonitor();
        }
        return null;
    }

    static /* synthetic */ int access$000() {
        return FAILOVER_TIMEOUT_DEFAULT;
    }

    static /* synthetic */ int access$100() {
        return FAILOVER_RETRY_INTERVAL;
    }

    static class ContextMonitor {
        String containerName;
        String query;
        long statementStartTime;
        long statementIOStartTime;
        long statementIOTotalTime;
        long sessionStartTime;
        long transactionStartTime;
        boolean containerIdSpecified;
        boolean sessionSpecified;
        boolean transactionStarted;
        Statement lastStatement;
        long lastStatementId;
        int lastPartitionId;
        long lastContainerId;
        long lastSessionId;

        ContextMonitor() {
        }

        void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        void setQuery(String query) {
            this.query = query;
        }

        void startStatement(Statement statement, long statementId, int partitionId, Long containerId) {
            this.statementStartTime = System.nanoTime();
            this.statementIOTotalTime = 0L;
            this.lastStatement = statement;
            this.lastStatementId = statementId;
            this.lastPartitionId = partitionId;
            if (containerId == null) {
                this.lastContainerId = 0L;
                this.containerIdSpecified = false;
            } else {
                this.lastContainerId = containerId;
                this.containerIdSpecified = true;
            }
            this.logStatement(true);
        }

        void endStatement() {
            this.logStatement(false);
        }

        private void logStatement(boolean start) {
            ArrayList<Object> args;
            String key;
            block9: {
                block8: {
                    block7: {
                        if (!STATEMENT_LOGGER.isDebugEnabled()) {
                            return;
                        }
                        key = "statementExec.";
                        key = key + (start ? "started" : "ended");
                        args = new ArrayList<Object>();
                        args.add(ContextMonitor.getObjectId(this));
                        args.add((Object)this.lastStatement);
                        args.add(this.lastStatementId);
                        args.add(this.lastPartitionId);
                        args.add(this.lastSessionId);
                        if (this.containerName == null) break block7;
                        args.add(this.containerName);
                        break block8;
                    }
                    if (!this.containerIdSpecified) break block9;
                    args.add(this.lastContainerId);
                }
                if (this.query == null) {
                    key = key + "WithContainer";
                } else {
                    args.add(this.query);
                    key = key + "WithQuery";
                }
            }
            if (!start) {
                long totalTime = System.nanoTime() - this.statementStartTime;
                args.add(ContextMonitor.formatNanosAsMillis(this.statementIOTotalTime));
                args.add(ContextMonitor.formatNanosAsMillis(totalTime - this.statementIOTotalTime));
            }
            LOGGER.debug(key, args.toArray());
        }

        void startStatementIO() {
            this.statementIOStartTime = System.nanoTime();
        }

        void endStatementIO() {
            this.statementIOTotalTime += System.nanoTime() - this.statementIOStartTime;
        }

        void startSession(long sessionId) {
            this.sessionStartTime = System.nanoTime();
            this.lastSessionId = sessionId;
            this.sessionSpecified = true;
        }

        void endSession() {
            this.sessionStartTime = 0L;
            this.lastSessionId = 0L;
            this.sessionSpecified = false;
        }

        void startTransaction() {
            this.transactionStartTime = System.nanoTime();
            this.transactionStarted = true;
        }

        void endTransaction() {
            this.transactionStartTime = 0L;
            this.transactionStarted = false;
        }

        static String getObjectId(Object obj) {
            return Long.toHexString(System.identityHashCode(obj));
        }

        GSStatementException analyzeStatementException(GSStatementException e, Context context, Object resource) {
            long curTime = System.nanoTime();
            StringBuilder message = new StringBuilder();
            Formatter formatter = new Formatter(message);
            message.append("reason=").append(e.getMessage());
            message.append(", localContext=").append(ContextMonitor.getObjectId(this));
            message.append(", context=").append(ContextMonitor.getObjectId(context));
            message.append(", resource=").append(ContextMonitor.getObjectId(resource));
            if (resource != null) {
                message.append(", resourceClass=");
                message.append(resource.getClass().getSimpleName());
            }
            if (this.lastStatement != null) {
                message.append(", statement=").append((Object)this.lastStatement);
                message.append(", statementId=").append(this.lastStatementId);
                message.append(", statementMillis=");
                ContextMonitor.formatNanosAsMillis(formatter, curTime - this.statementStartTime);
                message.append(", partitionId=").append(this.lastPartitionId);
            }
            if (this.containerIdSpecified) {
                message.append(", containerId=").append(this.lastContainerId);
            }
            if (this.sessionSpecified) {
                message.append(", sessionId=").append(this.lastSessionId);
                message.append(", sessionMillis=");
                ContextMonitor.formatNanosAsMillis(formatter, curTime - this.sessionStartTime);
            }
            if (this.transactionStarted) {
                message.append(", transactionMillis=");
                ContextMonitor.formatNanosAsMillis(formatter, curTime - this.transactionStartTime);
            }
            return new GSStatementException(e.getErrorCode(), message.toString(), e);
        }

        private static void formatNanosAsMillis(Formatter formatter, long nanoTime) {
            formatter.format("%.3f", (double)nanoTime / 1000.0 / 1000.0);
        }

        private static String formatNanosAsMillis(long nanoTime) {
            return String.format("%.3f", (double)nanoTime / 1000.0 / 1000.0);
        }
    }

    public static class DataAffinityPattern {
        private List<Entry> entryList = new ArrayList<Entry>();

        public DataAffinityPattern(String patternString) throws GSException {
            if (patternString == null || patternString.isEmpty()) {
                return;
            }
            Pattern basePattern = Pattern.compile("([^%]+)|(%)");
            for (String entryString : patternString.split(",", -1)) {
                String[] pair = entryString.split("=");
                if (pair.length != 2) {
                    throw new GSException(145002, "Illegal data affinity pattern entry (entry=\"" + entryString + "\", pattern=\"" + patternString + "\")");
                }
                String subPattern = pair[0];
                try {
                    String nonNodeAffinityPattern = subPattern.replaceFirst("@", "_");
                    RowMapper.normalizeSymbol(nonNodeAffinityPattern.replaceAll("%", "_"));
                }
                catch (GSException e) {
                    throw new GSException(145002, "Illegal character found or empty sub pattern found in data affinity pattern (subPattern=\"" + subPattern + "\", entry=\"" + entryString + "\", pattern=\"" + patternString + "\")");
                }
                if (subPattern.contains("%%")) {
                    throw new GSException(145002, "Duplicated wildcard found in data affinity pattern (subPattern=\"" + subPattern + "\", entry=\"" + entryString + "\", pattern=\"" + patternString + "\")");
                }
                String affinity = pair[1];
                try {
                    RowMapper.normalizeSymbol(affinity);
                }
                catch (GSException e) {
                    throw new GSException(145002, "Illegal character found or empty affinity string found in data affinity pattern (affinity=\"" + affinity + "\", entry=\"" + entryString + "\", pattern=\"" + patternString + "\")");
                }
                Matcher matcher = basePattern.matcher(subPattern);
                StringBuilder patternBuilder = new StringBuilder();
                patternBuilder.append("^");
                while (matcher.find()) {
                    if (matcher.group(2) == null) {
                        String elem;
                        try {
                            elem = RowMapper.normalizeExtendedSymbol("_" + matcher.group(1), true).substring(1);
                        }
                        catch (GSException e) {
                            throw new Error(e);
                        }
                        patternBuilder.append(Pattern.quote(elem));
                        continue;
                    }
                    patternBuilder.append(".*");
                }
                patternBuilder.append("$");
                Pattern compiledSubPattern = Pattern.compile(patternBuilder.toString());
                this.entryList.add(new Entry(compiledSubPattern, affinity));
            }
        }

        public String match(String containerName, String defaultAffinity) throws GSException {
            if (!this.entryList.isEmpty()) {
                String normalized = RowMapper.normalizeExtendedSymbol(containerName, true);
                for (Entry entry : this.entryList) {
                    if (!entry.pattern.matcher(normalized).find()) continue;
                    return entry.affinity;
                }
            }
            return defaultAffinity;
        }

        private static class Entry {
            final Pattern pattern;
            final String affinity;

            Entry(Pattern pattern, String affinity) {
                this.pattern = pattern;
                this.affinity = affinity;
            }
        }
    }

    public static class SessionInfo {
        private final Key key;
        private final long sessionId;
        private final long lastStatementId;

        public SessionInfo(int partitionId, long containerId, long sessionId, long lastStatementId) {
            this.key = new Key(partitionId, containerId);
            this.sessionId = sessionId;
            this.lastStatementId = lastStatementId;
        }

        public int getPartitionId() {
            return this.key.partitionId;
        }

        public long getContainerId() {
            return this.key.containerId;
        }

        public long getSessionId() {
            return this.sessionId;
        }

        public long getLastStatementId() {
            return this.lastStatementId;
        }

        private static class Key {
            private final int partitionId;
            private final long containerId;

            public Key(int partitionId, long containerId) {
                this.partitionId = partitionId;
                this.containerId = containerId;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (int)(this.containerId ^ this.containerId >>> 32);
                result = 31 * result + this.partitionId;
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Key other = (Key)obj;
                if (this.containerId != other.containerId) {
                    return false;
                }
                return this.partitionId == other.partitionId;
            }
        }
    }

    public static class LocatedSchema {
        private final RowMapper mapper;
        private final long containerId;
        private final int versionId;
        private final String containerName;

        public LocatedSchema(RowMapper mapper, long containerId, int versionId, String containerName) {
            this.mapper = mapper;
            this.containerId = containerId;
            this.versionId = versionId;
            this.containerName = containerName;
        }

        public RowMapper getMapper() {
            return this.mapper;
        }

        public long getContainerId() {
            return this.containerId;
        }

        public int getVersionId() {
            return this.versionId;
        }

        public String getContainerName() {
            return this.containerName;
        }
    }

    public static class ContainerCache {
        private final int cacheSize;
        private final Map<String, LocatedSchema> schemaCache = new LinkedHashMap<String, LocatedSchema>();
        private final Map<SessionInfo.Key, SessionInfo> sessionCache = new LinkedHashMap<SessionInfo.Key, SessionInfo>();

        public ContainerCache(int cacheSize) {
            this.cacheSize = cacheSize;
        }

        public LocatedSchema findSchema(String normalizedContainerName, Class<?> rowType, ContainerType containerType) {
            LocatedSchema schema = this.schemaCache.get(normalizedContainerName);
            if (schema == null || rowType != null && rowType != schema.mapper.getRowType() || containerType != null && containerType != schema.mapper.getContainerType()) {
                return null;
            }
            return schema;
        }

        public void cacheSchema(String normalizedContainerName, LocatedSchema schema) {
            this.schemaCache.put(normalizedContainerName, schema);
            if (this.schemaCache.size() > this.cacheSize) {
                Iterator<LocatedSchema> it = this.schemaCache.values().iterator();
                it.next();
                it.remove();
            }
        }

        public void removeSchema(String normalizedContainerName) {
            this.schemaCache.remove(normalizedContainerName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SessionInfo takeSession(Context context, int partitionId, long containerId) {
            Context context2 = context;
            synchronized (context2) {
                return this.sessionCache.remove(new SessionInfo.Key(partitionId, containerId));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SessionInfo cacheSession(Context context, SessionInfo sessionInfo) {
            Context context2 = context;
            synchronized (context2) {
                SessionInfo old = this.sessionCache.put(sessionInfo.key, sessionInfo);
                if (old != null) {
                    return old;
                }
                if (this.sessionCache.size() > this.cacheSize) {
                    Iterator<SessionInfo> it = this.sessionCache.values().iterator();
                    SessionInfo eariest = it.next();
                    it.remove();
                    return eariest;
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<SessionInfo> takeAllSessions(Context context) {
            Context context2 = context;
            synchronized (context2) {
                ArrayList<SessionInfo> list = new ArrayList<SessionInfo>(this.sessionCache.values());
                this.sessionCache.clear();
                return list;
            }
        }
    }

    public static class ContextReference
    extends WeakReference<Object> {
        final Context context;

        ContextReference(Object target, Context context) {
            super(target);
            this.context = context;
        }
    }

    public static class Context {
        private final ContextMonitor contextMonitor = GridStoreChannel.createContextMonitorIfAvailable();
        private final long failoverTimeoutMillis;
        private final long transactionTimeoutMillis;
        private int partitionId = -1;
        private int partitionCount = -1;
        private NodeResolver.ContainerHashMode containerHashMode;
        private NodeConnection lastConnection;
        private final Map<SocketAddress, NodeConnection> activeConnections = new HashMap<SocketAddress, NodeConnection>();
        private final NodeConnection.LoginInfo loginInfo;
        private boolean closed;
        private int failoverCount;
        private final BasicBuffer req;
        private BasicBuffer resp;
        private final BasicBuffer syncReq;
        private final BasicBuffer syncResp;
        private final NodeConnection.OptionalRequest optionalRequest = new NodeConnection.OptionalRequest();
        private final List<InetSocketAddress> addressCache = new ArrayList<InetSocketAddress>();
        private final UUID sessionUUID = UUID.randomUUID();
        private long lastSessionId;
        private final Map<Class<?>, Set<RemoteReference<?>>> remoteRefTable = new HashMap();
        private final ReferenceQueue<Object> remoteRefQueue = new ReferenceQueue();
        private final ContainerCache containerCache;
        private final Map<Integer, InetAddress> preferableHosts = new HashMap<Integer, InetAddress>();
        private final DataAffinityPattern dataAffinityPattern;
        private ResolverExecutor<?> activeResolverExecutor;

        private Context(long failoverTimeoutMillis, long transactionTimeoutMillis, NodeConnection.LoginInfo loginInfo, BasicBuffer req, BasicBuffer resp, BasicBuffer syncReq, BasicBuffer syncResp, int containerCacheSize, DataAffinityPattern dataAffinityPattern) {
            this.failoverTimeoutMillis = failoverTimeoutMillis;
            this.transactionTimeoutMillis = transactionTimeoutMillis;
            this.loginInfo = loginInfo;
            this.req = req;
            this.resp = resp;
            this.syncReq = syncReq;
            this.syncResp = syncResp;
            this.containerCache = containerCacheSize > 0 ? new ContainerCache(containerCacheSize) : null;
            this.dataAffinityPattern = dataAffinityPattern;
        }

        public boolean isClosedAsync() {
            return this.closed;
        }

        public long getTransactionTimeoutMillis() {
            return this.transactionTimeoutMillis;
        }

        public int getFailoverCount() {
            return this.failoverCount;
        }

        public SocketAddress getLastConnectionAddress() {
            if (this.lastConnection == null) {
                return null;
            }
            return this.lastConnection.getRemoteSocketAddress();
        }

        public BasicBuffer getRequestBuffer() {
            return this.req;
        }

        public BasicBuffer getResponseBuffer() {
            return this.resp;
        }

        public BasicBuffer replaceResponseBuffer(BasicBuffer newResp) {
            BasicBuffer orgResp = this.resp;
            this.resp = newResp;
            return orgResp;
        }

        public BasicBuffer getSynchronizedRequestBuffer() {
            return this.syncReq;
        }

        public BasicBuffer getSynchronizedResponseBuffer() {
            return this.syncResp;
        }

        public NodeConnection.OptionalRequest getOptionalRequest() {
            this.optionalRequest.clear();
            return this.optionalRequest;
        }

        public UUID getSessionUUID() {
            return this.sessionUUID;
        }

        public long generateSessionId() {
            long newId;
            for (newId = this.lastSessionId + 1L; newId == 0L; ++newId) {
            }
            this.lastSessionId = newId;
            return newId;
        }

        public Set<Class<?>> getReferenceTargetClasses() {
            return this.remoteRefTable.keySet();
        }

        public Set<RemoteReference<?>> getRemoteReferences(Class<?> targetClass) {
            Set<RemoteReference<?>> set = this.remoteRefTable.get(targetClass);
            return set == null ? Collections.emptySet() : set;
        }

        public void addRemoteReference(RemoteReference<?> reference) {
            Set<RemoteReference<?>> set = this.remoteRefTable.get(reference.targetClass);
            if (set == null) {
                set = new LinkedHashSet();
                this.remoteRefTable.put(reference.targetClass, set);
            }
            set.add(reference);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeRemoteReference(RemoteReference<?> reference) {
            Set<RemoteReference<?>> set = this.remoteRefTable.get(reference.targetClass);
            if (set == null) {
                return;
            }
            try {
                set.remove(reference);
            }
            finally {
                reference.clear();
            }
        }

        public ContainerCache getContainerCache() {
            return this.containerCache;
        }

        public void setPreferableHost(int partitionId, InetAddress host) {
            if (host == null) {
                this.preferableHosts.remove(partitionId);
            } else {
                this.preferableHosts.put(partitionId, host);
            }
            if (!(partitionId < 0 || partitionId >= this.addressCache.size() || host != null && host.equals(this.addressCache.get(partitionId)))) {
                this.addressCache.set(partitionId, null);
            }
        }

        private SocketAddress getLastRemoteAddress() {
            if (this.lastConnection == null) {
                return null;
            }
            return this.lastConnection.getRemoteSocketAddress();
        }

        public DataAffinityPattern getDataAffinityPattern() {
            return this.dataAffinityPattern;
        }

        public String getUser() {
            return this.loginInfo.getUser();
        }

        public String getDatabaseName() {
            return this.loginInfo.getDatabase();
        }
    }

    private static abstract class ResolverExecutor<T> {
        protected T result;

        private ResolverExecutor() {
        }

        public abstract void execute() throws GSException;
    }

    public static abstract class RemoteReference<T>
    extends WeakReference<T> {
        protected final Class<?> targetClass;
        protected final int partitionId;
        protected final long containerId;

        public RemoteReference(T target, Class<?> targetClass, Context context, int partitionId, long containerId) {
            super(target, context.remoteRefQueue);
            this.targetClass = targetClass;
            this.partitionId = partitionId;
            this.containerId = containerId;
        }

        public abstract void close(GridStoreChannel var1, Context var2) throws GSException;
    }

    public static class Key {
        private final boolean passive;
        private final InetSocketAddress address;
        private final String user;
        private final String clusterName;
        private final ServiceAddressResolver.Config sarConfig;
        private final List<InetSocketAddress> memberList;

        public Key(boolean passive, InetSocketAddress address, String user, String clusterName, ServiceAddressResolver.Config sarConfig, List<InetSocketAddress> memberList) {
            this.passive = passive;
            this.address = address;
            this.user = user;
            this.clusterName = clusterName;
            this.sarConfig = sarConfig == null ? null : new ServiceAddressResolver.Config(sarConfig);
            ArrayList<InetSocketAddress> arrayList = this.memberList = sarConfig == null ? Collections.emptyList() : new ArrayList<InetSocketAddress>(memberList);
            if (sarConfig != null) {
                Collections.sort(this.memberList, new ServiceAddressResolver.SocketAddressComparator());
            }
        }

        public boolean isIPV6Enabled() {
            if (this.address == null) {
                return this.sarConfig.isIPv6Expected();
            }
            return this.address.getAddress() instanceof Inet6Address;
        }

        public boolean isPassive() {
            return this.passive;
        }

        public InetSocketAddress getAddress() {
            return this.address;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
            result = 31 * result + (this.clusterName == null ? 0 : this.clusterName.hashCode());
            result = 31 * result + (this.memberList == null ? 0 : ((Object)this.memberList).hashCode());
            result = 31 * result + (this.passive ? 1231 : 1237);
            result = 31 * result + (this.sarConfig == null ? 0 : this.sarConfig.hashCode());
            result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
                return false;
            }
            if (this.clusterName == null ? other.clusterName != null : !this.clusterName.equals(other.clusterName)) {
                return false;
            }
            if (this.memberList == null ? other.memberList != null : !((Object)this.memberList).equals(other.memberList)) {
                return false;
            }
            if (this.passive != other.passive) {
                return false;
            }
            if (this.sarConfig == null ? other.sarConfig != null : !this.sarConfig.equals(other.sarConfig)) {
                return false;
            }
            return !(this.user == null ? other.user != null : !this.user.equals(other.user));
        }
    }

    public static class Source {
        private final Key key;
        private final int partitionCount;
        private final long failoverTimeoutMillis;
        private final long transactionTimeoutMillis;
        private final NodeConnection.LoginInfo loginInfo;
        private final transient String password;
        private final int containerCacheSize;
        private final DataAffinityPattern dataAffinityPattern;

        public Source(PropertyUtils.WrappedProperties props) throws GSException {
            boolean backupPreferred;
            boolean[] passive = new boolean[1];
            ServiceAddressResolver.Config sarConfig = new ServiceAddressResolver.Config();
            ArrayList<InetSocketAddress> memberList = new ArrayList<InetSocketAddress>();
            InetSocketAddress address = NodeResolver.getAddressProperties(props, passive, sarConfig, memberList, null);
            if (address != null) {
                sarConfig = null;
                memberList = null;
            }
            String clusterName = props.getProperty("clusterName", "", false);
            String user = props.getProperty("user", "", false);
            String password = props.getProperty("password", "", false);
            String database = props.getProperty("database", NodeConnection.LoginInfo.DEFAULT_DATABASE_NAME, false);
            this.key = new Key(passive[0], address, user, clusterName, sarConfig, memberList);
            this.password = password;
            Integer partitionCount = props.getIntProperty("partitionCount", true);
            this.partitionCount = partitionCount == null ? 0 : partitionCount;
            String consistency = props.getProperty("consistency", false);
            if (consistency == null || consistency.equals("IMMEDIATE")) {
                backupPreferred = false;
            } else if (consistency.equals("EVENTUAL")) {
                backupPreferred = true;
            } else {
                throw new GSException(145002, "Unknown consistency type (consistency=" + consistency + ")");
            }
            Integer containerCacheSize = props.getIntProperty("containerCacheSize", false);
            if (containerCacheSize != null && containerCacheSize < 0) {
                throw new GSException(145002, "Negative container cache size (size=" + containerCacheSize + ")");
            }
            this.failoverTimeoutMillis = props.getTimeoutProperty("failoverTimeout", -1L, false);
            this.transactionTimeoutMillis = props.getTimeoutProperty("transactionTimeout", -1L, false);
            this.loginInfo = new NodeConnection.LoginInfo(user, password, !backupPreferred, database, clusterName, this.transactionTimeoutMillis);
            this.containerCacheSize = containerCacheSize == null ? 0 : containerCacheSize;
            this.dataAffinityPattern = new DataAffinityPattern(props.getProperty("dataAffinityPattern", false));
        }

        public int getPartitionCount() {
            return this.partitionCount;
        }

        public NodeConnection.LoginInfo getLoginInfo() {
            return this.loginInfo;
        }

        public Key getKey() {
            return this.key;
        }

        public Context createContext() {
            BasicBuffer req = this.createRequestBuffer();
            BasicBuffer resp = new BasicBuffer(INITIAL_BUFFER_SIZE);
            BasicBuffer syncReq = this.createRequestBuffer();
            BasicBuffer syncResp = new BasicBuffer(INITIAL_BUFFER_SIZE);
            return new Context(this.failoverTimeoutMillis, this.transactionTimeoutMillis, this.loginInfo, req, resp, syncReq, syncResp, this.containerCacheSize, this.dataAffinityPattern);
        }

        private BasicBuffer createRequestBuffer() {
            int requestHeadLength = NodeConnection.getRequestHeadLength(this.key.isIPV6Enabled());
            BasicBuffer req = new BasicBuffer(Math.max(requestHeadLength, INITIAL_BUFFER_SIZE));
            NodeConnection.fillRequestHead(this.key.isIPV6Enabled(), req);
            return req;
        }
    }

    public static class Config {
        private NodeConnection.Config connectionConfig = new NodeConnection.Config();
        private long failoverTimeoutMillis = GridStoreChannel.access$000();
        private long failoverRetryIntervalMillis = GridStoreChannel.access$100();
        private long notificationReceiveTimeoutMillis = 10000L;
        private int maxConnectionPoolSize = -1;

        public synchronized void set(Config config) {
            this.connectionConfig.set(config.connectionConfig);
            this.failoverTimeoutMillis = config.failoverTimeoutMillis;
            this.failoverRetryIntervalMillis = config.failoverRetryIntervalMillis;
            this.notificationReceiveTimeoutMillis = config.notificationReceiveTimeoutMillis;
            this.maxConnectionPoolSize = config.maxConnectionPoolSize;
        }

        public synchronized boolean set(PropertyUtils.WrappedProperties props) throws GSException {
            Integer maxConnectionPoolSize;
            long failoverTimeoutMillis = props.getTimeoutProperty("failoverTimeout", this.failoverTimeoutMillis, false);
            long failoverRetryIntervalMillis = props.getTimeoutProperty("failoverRetryInterval", this.failoverRetryIntervalMillis, true);
            long notificationReceiveTimeoutMillis = props.getTimeoutProperty("notificationReceiveTimeout", this.notificationReceiveTimeoutMillis, true);
            if (failoverTimeoutMillis < 0L || failoverRetryIntervalMillis < 0L || notificationReceiveTimeoutMillis < 0L) {
                throw new GSException(145005, "Negative timeout parameter");
            }
            boolean updated = this.connectionConfig.set(props);
            if (failoverTimeoutMillis != this.failoverTimeoutMillis || failoverRetryIntervalMillis != this.failoverRetryIntervalMillis || notificationReceiveTimeoutMillis != this.notificationReceiveTimeoutMillis) {
                this.failoverTimeoutMillis = failoverTimeoutMillis;
                this.failoverRetryIntervalMillis = failoverRetryIntervalMillis;
                this.notificationReceiveTimeoutMillis = notificationReceiveTimeoutMillis;
                updated = true;
            }
            if ((maxConnectionPoolSize = props.getIntProperty("maxConnectionPoolSize", false)) != null && maxConnectionPoolSize != this.maxConnectionPoolSize) {
                if (maxConnectionPoolSize < 0) {
                    throw new GSException(145005, "Negative connection pool size");
                }
                this.maxConnectionPoolSize = maxConnectionPoolSize;
                updated = true;
            }
            return updated;
        }

        public synchronized NodeConnection.Config getConnectionConfig() {
            NodeConnection.Config connectionConfig = new NodeConnection.Config();
            connectionConfig.set(this.connectionConfig);
            return connectionConfig;
        }

        public synchronized long getFailoverTimeoutMillis() {
            return this.failoverTimeoutMillis;
        }

        public synchronized long getFailoverRetryIntervalMillis() {
            return this.failoverRetryIntervalMillis;
        }

        public synchronized long getNotificationReceiveTimeoutMillis() {
            return this.notificationReceiveTimeoutMillis;
        }

        public synchronized int getMaxConnectionPoolSize() {
            return this.maxConnectionPoolSize;
        }
    }
}

