/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs;

import com.toshiba.mwcloud.gs.CompressionMethod;
import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.TimeUnit;
import com.toshiba.mwcloud.gs.common.GSErrorCode;
import com.toshiba.mwcloud.gs.common.RowMapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TimeSeriesProperties
implements Cloneable {
    private int rowExpirationTime = -1;
    private TimeUnit rowExpirationTimeUnit;
    private int compressionWindowSize = -1;
    private TimeUnit compressionWindowSizeUnit;
    private CompressionMethod compressionMethod = CompressionMethod.NO;
    private Map<String, Entry> entryMap = new HashMap<String, Entry>();
    private int expirationDivisionCount = -1;

    public TimeSeriesProperties() {
    }

    private TimeSeriesProperties(TimeSeriesProperties props) {
        this.rowExpirationTime = props.rowExpirationTime;
        this.rowExpirationTimeUnit = props.rowExpirationTimeUnit;
        this.compressionWindowSize = props.compressionWindowSize;
        this.compressionWindowSizeUnit = props.compressionWindowSizeUnit;
        this.compressionMethod = props.compressionMethod;
        this.expirationDivisionCount = props.expirationDivisionCount;
        this.entryMap.putAll(props.entryMap);
    }

    public void setCompressionMethod(CompressionMethod compressionMethod) {
        if (compressionMethod == null) {
            throw GSErrorCode.checkNullParameter((Object)compressionMethod, "compressionMethod", null);
        }
        if (compressionMethod != this.compressionMethod) {
            this.entryMap.clear();
        }
        this.compressionMethod = compressionMethod;
    }

    public CompressionMethod getCompressionMethod() {
        return this.compressionMethod;
    }

    public void setRelativeHiCompression(String column, double rate, double span) {
        if (!(0.0 <= rate) || !(rate <= 1.0)) {
            throw new IllegalArgumentException("Rate out of range (value=" + rate + ")");
        }
        this.compressionMethod = CompressionMethod.HI;
        Entry entry = new Entry(column);
        entry.relative = true;
        entry.rate = rate;
        entry.span = span;
        try {
            this.entryMap.put(TimeSeriesProperties.normalizeColumn(column), entry);
        }
        catch (NullPointerException e) {
            throw GSErrorCode.checkNullParameter(column, "column", e);
        }
    }

    public void setAbsoluteHiCompression(String column, double width) {
        this.compressionMethod = CompressionMethod.HI;
        Entry entry = new Entry(column);
        entry.width = width;
        try {
            this.entryMap.put(TimeSeriesProperties.normalizeColumn(column), entry);
        }
        catch (NullPointerException e) {
            throw GSErrorCode.checkNullParameter(column, "column", e);
        }
    }

    public Boolean isCompressionRelative(String column) {
        Entry entry;
        try {
            entry = this.entryMap.get(TimeSeriesProperties.normalizeColumn(column));
        }
        catch (NullPointerException e) {
            throw GSErrorCode.checkNullParameter(column, "column", e);
        }
        if (this.compressionMethod != CompressionMethod.HI || entry == null) {
            return null;
        }
        return entry.relative;
    }

    public Double getCompressionRate(String column) {
        Entry entry;
        try {
            entry = this.entryMap.get(TimeSeriesProperties.normalizeColumn(column));
        }
        catch (NullPointerException e) {
            throw GSErrorCode.checkNullParameter(column, "column", e);
        }
        if (this.compressionMethod != CompressionMethod.HI || entry == null || !entry.relative) {
            return null;
        }
        return entry.rate;
    }

    public Double getCompressionSpan(String column) {
        Entry entry;
        try {
            entry = this.entryMap.get(TimeSeriesProperties.normalizeColumn(column));
        }
        catch (NullPointerException e) {
            throw GSErrorCode.checkNullParameter(column, "column", e);
        }
        if (this.compressionMethod != CompressionMethod.HI || entry == null || !entry.relative) {
            return null;
        }
        return entry.span;
    }

    public Double getCompressionWidth(String column) {
        Entry entry;
        try {
            entry = this.entryMap.get(TimeSeriesProperties.normalizeColumn(column));
        }
        catch (NullPointerException e) {
            throw GSErrorCode.checkNullParameter(column, "column", e);
        }
        if (this.compressionMethod != CompressionMethod.HI || entry == null || entry.relative) {
            return null;
        }
        return entry.width;
    }

    public Set<String> getSpecifiedColumns() {
        HashSet<String> columnNames = new HashSet<String>();
        for (Entry entry : this.entryMap.values()) {
            columnNames.add(entry.column);
        }
        return columnNames;
    }

    @Deprecated
    void setNonCompression(String column) {
        throw new Error("Not supported");
    }

    @Deprecated
    public void setLosslessCompression(String column) {
        throw new Error("Not supported");
    }

    @Deprecated
    public boolean isLosslessCompression(String column) {
        throw new Error("Not supported");
    }

    @Deprecated
    public void setLossyCompression(String column, double threshold, boolean thresholdRelative) {
        throw new Error("Not supported");
    }

    @Deprecated
    public boolean isLossyCompression(String column) {
        throw new Error("Not supported");
    }

    @Deprecated
    public double getCompressionThreshold(String column) {
        throw new Error("Not supported");
    }

    @Deprecated
    public boolean isRelativeCompressionThreshold(String column) {
        throw new Error("Not supported");
    }

    public void setRowExpiration(int elapsedTime, TimeUnit timeUnit) {
        if (elapsedTime <= 0) {
            throw new IllegalArgumentException("Time must not be zero or negative (time=" + elapsedTime + ")");
        }
        try {
            switch (timeUnit) {
                case YEAR: 
                case MONTH: {
                    throw new IllegalArgumentException("Time unit must not be YEAR or MONTH (unit=" + (Object)((Object)timeUnit) + ")");
                }
            }
        }
        catch (NullPointerException e) {
            GSErrorCode.checkNullParameter((Object)timeUnit, "timeUnit", e);
            throw e;
        }
        this.rowExpirationTime = elapsedTime;
        this.rowExpirationTimeUnit = timeUnit;
    }

    public int getRowExpirationTime() {
        return this.rowExpirationTime;
    }

    public TimeUnit getRowExpirationTimeUnit() {
        return this.rowExpirationTimeUnit;
    }

    public void setCompressionWindowSize(int compressionWindowSize, TimeUnit compressionWindowSizeUnit) {
        if (compressionWindowSize <= 0) {
            throw new IllegalArgumentException("Windows size must not be zero or negative (size=" + compressionWindowSize + ")");
        }
        try {
            switch (compressionWindowSizeUnit) {
                case YEAR: 
                case MONTH: {
                    throw new IllegalArgumentException("Size unit must not be YEAR or MONTH (unit=" + (Object)((Object)compressionWindowSizeUnit) + ")");
                }
            }
        }
        catch (NullPointerException e) {
            GSErrorCode.checkNullParameter((Object)compressionWindowSizeUnit, "compressionWindowSizeUnit", e);
            throw e;
        }
        this.compressionWindowSize = compressionWindowSize;
        this.compressionWindowSizeUnit = compressionWindowSizeUnit;
    }

    public int getExpirationDivisionCount() {
        return this.expirationDivisionCount;
    }

    public void setExpirationDivisionCount(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("Division count must not be zero or negative (count=" + count + ")");
        }
        this.expirationDivisionCount = count;
    }

    public int getCompressionWindowSize() {
        return this.compressionWindowSize;
    }

    public TimeUnit getCompressionWindowSizeUnit() {
        return this.compressionWindowSizeUnit;
    }

    public TimeSeriesProperties clone() {
        return new TimeSeriesProperties(this);
    }

    private static String normalizeColumn(String column) {
        try {
            return RowMapper.normalizeSymbol(column);
        }
        catch (GSException e) {
            throw new IllegalArgumentException("Illegal column format (reason=" + e.getMessage() + ")", e);
        }
    }

    private static class Entry {
        final String column;
        boolean relative;
        double rate;
        double span;
        double width;

        public Entry(String column) {
            this.column = column;
        }
    }
}

