/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;

public class BlobImpl
implements Blob {
    private final BlobImpl chain;
    private byte[] data;
    private ByteArrayOutputStream streamOutput;
    private long streamOutputPos;
    private boolean closed;

    public BlobImpl() {
        this.chain = null;
    }

    public BlobImpl(BlobImpl chain) {
        this.chain = chain;
    }

    public byte[] getDataDirect() throws SQLException {
        this.prepareData();
        return this.data;
    }

    public void setDataDirect(byte[] data) {
        this.data = data;
        this.streamOutput = null;
        this.streamOutputPos = 0L;
    }

    public void close() {
        if (this.chain != null) {
            this.chain.close();
        }
        if (!this.closed) {
            this.free();
            this.closed = true;
        }
    }

    private void checkAvailable() throws SQLException {
        if (this.closed) {
            throw new SQLException();
        }
    }

    private void prepareData() throws SQLException {
        if (this.streamOutput != null) {
            byte[] outBytes = this.streamOutput.toByteArray();
            this.setBytesInternal(this.streamOutputPos, outBytes, true, 0, outBytes.length);
            this.streamOutput = null;
            this.streamOutputPos = 0L;
        }
        if (this.data == null) {
            this.data = new byte[0];
        }
    }

    @Override
    public long length() throws SQLException {
        this.checkAvailable();
        this.prepareData();
        if (this.data != null) {
            return this.data.length;
        }
        if (this.streamOutput != null) {
            return this.streamOutput.size();
        }
        return 0L;
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        this.checkAvailable();
        this.prepareData();
        if (pos <= 0L || pos + (long)length >= Integer.MAX_VALUE || length < 0 || (int)(pos - 1L + (long)length) > this.data.length) {
            throw new SQLException();
        }
        return Arrays.copyOfRange(this.data, (int)pos - 1, (int)pos - 1 + length);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.checkAvailable();
        this.prepareData();
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        this.checkAvailable();
        this.prepareData();
        this.setBytesInternal(pos, bytes, false, offset, len);
        return len;
    }

    private void setBytesInternal(long pos, byte[] bytes, boolean internalArray, int offset, int len) throws SQLException {
        byte[] newData;
        if (pos <= 0L || offset < 0 || len < 0 || pos + (long)len >= Integer.MAX_VALUE) {
            throw new SQLException();
        }
        if (len == 0) {
            return;
        }
        int orgLength = this.data == null ? 0 : this.data.length;
        int minLength = (int)pos - 1 + len;
        if (internalArray && orgLength == 0 && orgLength == minLength) {
            this.data = bytes;
            return;
        }
        if (minLength <= orgLength) {
            newData = this.data;
        } else {
            newData = new byte[minLength];
            if (orgLength > 0) {
                System.arraycopy(this.data, 0, newData, 0, orgLength);
            }
        }
        System.arraycopy(bytes, offset, newData, (int)pos - 1, len);
        this.data = newData;
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        this.checkAvailable();
        this.prepareData();
        if (pos <= 0L || pos > Integer.MAX_VALUE) {
            throw new SQLException();
        }
        this.streamOutputPos = pos;
        this.streamOutput = new ByteArrayOutputStream();
        return this.streamOutput;
    }

    @Override
    public void truncate(long len) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void free() {
        this.data = null;
        this.streamOutput = null;
        this.streamOutputPos = 0L;
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        int dataLen;
        this.checkAvailable();
        int n = dataLen = this.data == null ? 0 : this.data.length;
        if (pos <= 0L || length <= 0L || pos + length > (long)dataLen) {
            throw new SQLException();
        }
        return new ByteArrayInputStream(this.data, (int)pos - 1, (int)length);
    }
}

