/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.subnet;

import com.toshiba.mwcloud.gs.Collection;
import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.Geometry;
import com.toshiba.mwcloud.gs.GeometryOperator;
import com.toshiba.mwcloud.gs.Query;
import com.toshiba.mwcloud.gs.common.BasicBuffer;
import com.toshiba.mwcloud.gs.common.GSErrorCode;
import com.toshiba.mwcloud.gs.common.GeometryUtils;
import com.toshiba.mwcloud.gs.common.RowMapper;
import com.toshiba.mwcloud.gs.common.Statement;
import com.toshiba.mwcloud.gs.subnet.GridStoreChannel;
import com.toshiba.mwcloud.gs.subnet.SubnetContainer;
import com.toshiba.mwcloud.gs.subnet.SubnetGridStore;
import com.toshiba.mwcloud.gs.subnet.SubnetQuery;

public class SubnetCollection<K, R>
extends SubnetContainer<K, R>
implements Collection<K, R> {
    public SubnetCollection(SubnetGridStore store, GridStoreChannel channel, GridStoreChannel.Context context, Class<R> rowType, RowMapper mapper, int schemaVerId, int partitionId, long containerId, String normalizedContainerName, String remoteContainerName) throws GSException {
        super(store, channel, context, rowType, mapper, schemaVerId, partitionId, containerId, normalizedContainerName, remoteContainerName);
    }

    @Override
    public Query<R> query(final String column, final Geometry geometry, final GeometryOperator geometryOp) throws GSException {
        this.checkOpened();
        return new SubnetQuery(this, this.rowType, this.mapper, Statement.QUERY_COLLECTION_GEOMETRY_RELATED, new SubnetContainer.QueryFormatter(){

            @Override
            public void format(BasicBuffer inBuf) throws GSException {
                SubnetCollection.this.formatQuery(inBuf, column, geometry, geometryOp);
            }

            @Override
            public String getQueryString() {
                return "{column=" + column + ", geometry=" + geometry + ", op=" + (Object)((Object)geometryOp) + "}";
            }
        });
    }

    private void formatQuery(BasicBuffer inBuf, String column, Geometry geometry, GeometryOperator geometryOp) throws GSException {
        try {
            inBuf.putInt(this.mapper.resolveColumnId(column));
            RowMapper.putSize(inBuf, GeometryUtils.getBytesLength(geometry), SubnetCollection.getRowMappingMode());
            GeometryUtils.putGeometry(inBuf, geometry);
            inBuf.putByteEnum(geometryOp);
        }
        catch (NullPointerException e) {
            GSErrorCode.checkNullParameter(column, "column", e);
            GSErrorCode.checkNullParameter(geometry, "geometry", e);
            GSErrorCode.checkNullParameter((Object)geometryOp, "geometryOp", e);
            throw e;
        }
    }

    @Override
    public Query<R> query(final String column, final Geometry geometryIntersection, final Geometry geometryDisjoint) throws GSException {
        this.checkOpened();
        return new SubnetQuery(this, this.rowType, this.mapper, Statement.QUERY_COLLECTION_GEOMETRY_WITH_EXCLUSION, new SubnetContainer.QueryFormatter(){

            @Override
            public void format(BasicBuffer inBuf) throws GSException {
                SubnetCollection.this.formatQuery(inBuf, column, geometryIntersection, geometryDisjoint);
            }

            @Override
            public String getQueryString() {
                return "{column=" + column + ", intersection=" + geometryIntersection + ", disjoint=" + geometryDisjoint + "}";
            }
        });
    }

    private void formatQuery(BasicBuffer inBuf, String column, Geometry geometryIntersection, Geometry geometryDisjoint) throws GSException {
        try {
            inBuf.putInt(this.mapper.resolveColumnId(column));
            RowMapper.MappingMode mode = SubnetContainer.getRowMappingMode();
            RowMapper.putSize(inBuf, GeometryUtils.getBytesLength(geometryIntersection), mode);
            GeometryUtils.putGeometry(inBuf, geometryIntersection);
            RowMapper.putSize(inBuf, GeometryUtils.getBytesLength(geometryDisjoint), mode);
            GeometryUtils.putGeometry(inBuf, geometryDisjoint);
        }
        catch (NullPointerException e) {
            GSErrorCode.checkNullParameter(column, "column", e);
            GSErrorCode.checkNullParameter(geometryIntersection, "geometryIntersection", e);
            GSErrorCode.checkNullParameter(geometryDisjoint, "geometryDisjoint", e);
            throw e;
        }
    }
}

