/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.subnet;

import com.toshiba.mwcloud.gs.AggregationResult;
import com.toshiba.mwcloud.gs.Container;
import com.toshiba.mwcloud.gs.ContainerType;
import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.GSRecoverableException;
import com.toshiba.mwcloud.gs.IndexType;
import com.toshiba.mwcloud.gs.QueryAnalysisEntry;
import com.toshiba.mwcloud.gs.Row;
import com.toshiba.mwcloud.gs.RowSet;
import com.toshiba.mwcloud.gs.TriggerInfo;
import com.toshiba.mwcloud.gs.common.BasicBuffer;
import com.toshiba.mwcloud.gs.common.BlobImpl;
import com.toshiba.mwcloud.gs.common.GSConnectionException;
import com.toshiba.mwcloud.gs.common.GSErrorCode;
import com.toshiba.mwcloud.gs.common.GSStatementException;
import com.toshiba.mwcloud.gs.common.LoggingUtils;
import com.toshiba.mwcloud.gs.common.PropertyUtils;
import com.toshiba.mwcloud.gs.common.RowMapper;
import com.toshiba.mwcloud.gs.common.Statement;
import com.toshiba.mwcloud.gs.subnet.GridStoreChannel;
import com.toshiba.mwcloud.gs.subnet.NodeConnection;
import com.toshiba.mwcloud.gs.subnet.SubnetGridStore;
import com.toshiba.mwcloud.gs.subnet.SubnetQuery;
import com.toshiba.mwcloud.gs.subnet.SubnetRowSet;
import java.net.URL;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class SubnetContainer<K, R>
implements Container<K, R>,
RowMapper.BlobFactory {
    private static final boolean BLOB_CLEAR_ON_OPERATION_ENABLED = false;
    static final int MAX_SESSION_REPAIR_COUNT = 2;
    public static final int SESSION_NOT_FOUND_ERROR_CODE = 110003;
    public static final int UUID_UNMATCHED_ERROR_CODE = 110016;
    public static final int ROW_SET_NOT_FOUND_ERROR_CODE = 60132;
    private static boolean timeSeriesUpdateEnabled = true;
    private static boolean queryStatementIdPreserved = true;
    private static final Map<Statement, Statement> TIME_SERIES_STATEMENT_MAP;
    private static final Set<Statement> FIXED_SESSION_MODE_STATEMENTS;
    private final GridStoreChannel.ContextMonitor contextMonitor = GridStoreChannel.createContextMonitorIfAvailable();
    private static final LoggingUtils.BaseGridStoreLogger LOGGER;
    private SubnetGridStore store;
    protected final GridStoreChannel channel;
    protected final GridStoreChannel.Context context;
    protected final Class<R> rowType;
    protected final RowMapper mapper;
    private final int schemaVerId;
    private final int partitionId;
    private final long containerId;
    private final String normalizedContainerName;
    protected long sessionId = 0L;
    private long transactionId = 1L;
    private long statementId;
    private boolean sessionPrepared;
    private boolean containerLocked;
    private boolean transactionStarted;
    private boolean autoCommit = true;
    private boolean cacheDisabled;
    private BlobImpl lastBlob;
    private SessionReference sessionRef;

    protected SubnetContainer(SubnetGridStore store, GridStoreChannel channel, GridStoreChannel.Context context, Class<R> rowType, RowMapper mapper, int schemaVerId, int partitionId, long containerId, String normalizedContainerName, String remoteContainerName) throws GSException {
        this.store = store;
        this.channel = channel;
        this.context = context;
        this.rowType = rowType;
        this.mapper = mapper;
        this.schemaVerId = schemaVerId;
        this.partitionId = partitionId;
        this.containerId = containerId;
        this.normalizedContainerName = normalizedContainerName;
        if (this.contextMonitor != null) {
            this.contextMonitor.setContainerName(remoteContainerName);
        }
        store.createReference(this);
    }

    SubnetGridStore getStore() {
        return this.store;
    }

    Class<R> getRowType() {
        return this.rowType;
    }

    public int getSchemaVersionId() {
        return this.schemaVerId;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public long getContainerId() {
        return this.containerId;
    }

    public String getNormalizedContainerName() {
        return this.normalizedContainerName;
    }

    protected void clearBlob(boolean force) {
        if ((force || this.autoCommit) && this.lastBlob != null) {
            this.lastBlob.close();
            this.lastBlob = null;
        }
    }

    void disableCache() {
        GridStoreChannel.ContainerCache cache;
        if (this.cacheDisabled) {
            return;
        }
        this.cacheDisabled = true;
        if (this.normalizedContainerName != null && (cache = this.context.getContainerCache()) != null) {
            cache.removeSchema(this.normalizedContainerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeStatement(Statement statement, BasicBuffer req, BasicBuffer resp, StatementFamily familyForSession) throws GSException {
        if (this.store == null || this.context.isClosedAsync()) {
            throw new GSException(145038, "Already closed");
        }
        boolean sessionRequired = familyForSession != null;
        int trialCount = 0;
        while (true) {
            long statementId;
            long curSessionId = this.sessionId;
            if (sessionRequired) {
                if (!queryStatementIdPreserved || familyForSession != StatementFamily.QUERY) {
                    while (++this.statementId == 0L) {
                    }
                }
                statementId = this.statementId;
                if (curSessionId == 0L || statementId == 0L) {
                    throw new Error("Internal error by empty session or statement ID");
                }
                SessionReference sessionRef = this.sessionRef;
                if (sessionRef != null) {
                    sessionRef.lastStatementId = statementId;
                }
            } else {
                statementId = 0L;
            }
            int requestSize = req.base().position();
            try {
                if (this.contextMonitor != null) {
                    this.contextMonitor.startStatement(statement, statementId, this.getPartitionId(), this.getContainerId());
                }
                Statement actualStatement = !SubnetGridStore.isContainerStatementUnified() && this.mapper.isForTimeSeries() && TIME_SERIES_STATEMENT_MAP.containsKey((Object)statement) ? TIME_SERIES_STATEMENT_MAP.get((Object)statement) : statement;
                this.channel.executeStatement(this.context, actualStatement, this.getPartitionId(), statementId, req, resp, this.contextMonitor);
                if (sessionRequired) {
                    if (!this.sessionPrepared) {
                        this.setSessionIdDirect(curSessionId, true);
                    }
                    if (!this.autoCommit) {
                        this.setTransactionStarted(true);
                    }
                }
                if (trialCount > 0 && LOGGER.isInfoEnabled()) {
                    LOGGER.info("transaction.sessionRepaired", new Object[]{GridStoreChannel.ContextMonitor.getObjectId(this.context), statement, this.partitionId, statementId, this.containerId, curSessionId, trialCount});
                }
                if (this.contextMonitor == null) break;
                this.contextMonitor.endStatement();
            }
            catch (GSStatementException e) {
                boolean started;
                boolean bl = started = this.transactionStarted || this.containerLocked;
                if (statement != Statement.CLOSE_SESSION) {
                    try {
                        GridStoreChannel.Context context = this.context;
                        synchronized (context) {
                            this.closeSession(true);
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                if (!sessionRequired || !SubnetContainer.isInitialSessionLost(statement, statementId, started, e)) {
                    try {
                        this.disableCache();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    if (this.contextMonitor == null) {
                        throw e;
                    }
                    throw this.contextMonitor.analyzeStatementException(e, this.context, this);
                }
                if (trialCount >= 2) {
                    throw new GSStatementException(e.getErrorCode(), "Failed to repair session (trialCount=" + trialCount + ", reason=" + e.getMessage() + ")", e);
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("transaction.repairingSession", new Object[]{GridStoreChannel.ContextMonitor.getObjectId(this.context), statement, this.partitionId, statementId, this.containerId, curSessionId, trialCount, started, e});
                }
                byte[] requestData = new byte[requestSize];
                req.base().position(0);
                req.base().get(requestData);
                this.channel.setupRequestBuffer(req);
                int containerIdSize = 8;
                int sessionIdPos = req.base().position() + 8;
                this.createSession();
                req.base().position(0);
                req.base().put(requestData);
                req.base().position(sessionIdPos);
                req.putLong(this.sessionId);
                if (SubnetContainer.isSessionIdGeneratorEnabled() && !FIXED_SESSION_MODE_STATEMENTS.contains((Object)statement)) {
                    int uuidSize = 16;
                    int schemaVerIdSize = 4;
                    req.base().position(req.base().position() + 16 + 4);
                    req.putByteEnum(SessionMode.GET);
                }
                req.base().position(requestSize);
                ++trialCount;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeMultiStepStatement(Statement statement, BasicBuffer req, BasicBuffer resp, StatementFamily familyForSession, int statementStep) throws GSException {
        if (statementStep <= 0) {
            throw new Error("Internal error by illegal step");
        }
        try {
            this.executeStatement(statement, req, resp, familyForSession);
        }
        finally {
            if (this.sessionPrepared && SubnetContainer.isMultiStepStatementIdEnabled()) {
                this.statementId += (long)(statementStep - 1);
            }
        }
    }

    protected StatementFamily prepareSession(StatementFamily family) throws GSException {
        boolean sessionRequired;
        if (SubnetContainer.isSessionIdGeneratorEnabled()) {
            boolean requiredImmediately;
            switch (family) {
                case QUERY: {
                    sessionRequired = !this.autoCommit && this.transactionStarted;
                    requiredImmediately = false;
                    break;
                }
                case LOCK: {
                    if (this.autoCommit) {
                        throw new GSException(145035, "Auto commit mode must be turned off for a lock operation");
                    }
                    sessionRequired = true;
                    requiredImmediately = false;
                    break;
                }
                case UPDATE: {
                    sessionRequired = this.containerLocked || !this.autoCommit || !this.mapper.hasKey();
                    requiredImmediately = sessionRequired && !this.mapper.hasKey();
                    break;
                }
                case POST: {
                    sessionRequired = true;
                    requiredImmediately = true;
                    break;
                }
                default: {
                    throw new Error("Internal error by unknown statement family");
                }
            }
            if (!this.sessionPrepared) {
                if (requiredImmediately) {
                    this.createSession();
                } else if (sessionRequired) {
                    this.setSessionIdDirect(this.context.generateSessionId(), false);
                }
            }
        } else {
            boolean bl = sessionRequired = family != StatementFamily.QUERY || !this.autoCommit && this.sessionId != 0L;
            if (sessionRequired && this.sessionId == 0L) {
                this.createSession();
            }
        }
        return sessionRequired ? family : null;
    }

    private void createSession() throws GSException {
        long newSessionId;
        GridStoreChannel.SessionInfo sessionInfo;
        GridStoreChannel.ContainerCache cache = this.context.getContainerCache();
        if (cache != null && (sessionInfo = cache.takeSession(this.context, this.partitionId, this.containerId)) != null) {
            this.setSessionIdDirect(sessionInfo.getSessionId(), true);
            this.statementId = sessionInfo.getLastStatementId();
            return;
        }
        this.channel.cleanRemoteResources(this.context, Collections.singleton(SubnetContainer.class));
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        int trialCount = 0;
        while (true) {
            block10: {
                long generatedSessionId;
                this.channel.setupRequestBuffer(req);
                req.putLong(this.getContainerId());
                long l = generatedSessionId = SubnetContainer.isSessionIdGeneratorEnabled() ? this.context.generateSessionId() : 0L;
                if (generatedSessionId != 0L) {
                    req.putLong(generatedSessionId);
                }
                if (SubnetContainer.isInitialSessionRetrialEnabled()) {
                    req.putUUID(this.context.getSessionUUID());
                }
                NodeConnection.tryPutEmptyOptionalRequest(req);
                if (generatedSessionId == 0L) {
                    SubnetContainer.putNewSessionProperties(req, this.channel, this.context);
                }
                try {
                    this.executeStatement(Statement.CREATE_SESSION, req, resp, null);
                }
                catch (GSStatementException e) {
                    if (!SubnetContainer.isNewSessionConflicted(e)) {
                        throw e;
                    }
                    if (trialCount >= 2) {
                        throw new GSStatementException(e.getErrorCode(), "Failed to create session (trialCount=" + trialCount + ", reason=" + e.getMessage() + ")", e);
                    }
                    break block10;
                }
                long l2 = newSessionId = generatedSessionId == 0L ? resp.base().getLong() : generatedSessionId;
                if (newSessionId == 0L) {
                    throw new GSException(145031, "Protocol error by empty session ID");
                }
                break;
            }
            ++trialCount;
        }
        this.setSessionIdDirect(newSessionId, true);
    }

    static void putNewSessionProperties(BasicBuffer req, GridStoreChannel channel, GridStoreChannel.Context context) throws GSException {
        req.putInt(PropertyUtils.timeoutPropertyToIntSeconds(channel.getFailoverTimeoutMillis(context)));
        req.putInt(PropertyUtils.timeoutPropertyToIntSeconds(context.getTransactionTimeoutMillis()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSession(boolean invalidating) throws GSException {
        if (this.sessionId == 0L) {
            return;
        }
        try {
            BasicBuffer req = this.context.getSynchronizedRequestBuffer();
            BasicBuffer resp = this.context.getSynchronizedResponseBuffer();
            GridStoreChannel.ContainerCache cache = this.context.getContainerCache();
            if (cache == null || this.transactionStarted || invalidating) {
                this.channel.setupRequestBuffer(req);
                req.putLong(this.getContainerId());
                this.putSessionInfo(req, this.sessionId);
                NodeConnection.tryPutEmptyOptionalRequest(req);
                this.executeStatement(Statement.CLOSE_SESSION, req, resp, StatementFamily.POST);
            } else {
                GridStoreChannel.SessionInfo oldSessionInfo = cache.cacheSession(this.context, new GridStoreChannel.SessionInfo(this.partitionId, this.containerId, this.sessionId, this.statementId));
                if (oldSessionInfo != null) {
                    SubnetContainer.closeSession(this.channel, this.context, req, resp, oldSessionInfo);
                }
            }
        }
        finally {
            this.setSessionIdDirect(0L, true);
        }
    }

    static void closeSession(GridStoreChannel channel, GridStoreChannel.Context context, BasicBuffer req, BasicBuffer resp, GridStoreChannel.SessionInfo sessionInfo) throws GSException {
        channel.setupRequestBuffer(req);
        req.putLong(sessionInfo.getContainerId());
        req.putLong(sessionInfo.getSessionId());
        if (SubnetContainer.isInitialSessionRetrialEnabled()) {
            req.putUUID(context.getSessionUUID());
        }
        NodeConnection.tryPutEmptyOptionalRequest(req);
        channel.executeStatement(context, Statement.CLOSE_SESSION, sessionInfo.getPartitionId(), sessionInfo.getLastStatementId() + 1L, req, resp, null);
    }

    static void closeAllSessions(GridStoreChannel channel, GridStoreChannel.Context context, BasicBuffer req, BasicBuffer resp, List<GridStoreChannel.SessionInfo> allSessionInfos) throws GSException {
        ArrayList<GridStoreChannel.SessionInfo> sortedSessionInfos = new ArrayList<GridStoreChannel.SessionInfo>(allSessionInfos);
        Collections.sort(sortedSessionInfos, new Comparator<GridStoreChannel.SessionInfo>(){

            @Override
            public int compare(GridStoreChannel.SessionInfo o1, GridStoreChannel.SessionInfo o2) {
                return o1.getPartitionId() - o2.getPartitionId();
            }
        });
        boolean summarized = SubnetGridStore.isSessionUUIDSummarized();
        int start = 0;
        while (start < sortedSessionInfos.size()) {
            GridStoreChannel.SessionInfo info;
            int partitionId = ((GridStoreChannel.SessionInfo)sortedSessionInfos.get(start)).getPartitionId();
            int end = start;
            while (++end < sortedSessionInfos.size() && (info = (GridStoreChannel.SessionInfo)sortedSessionInfos.get(end)).getPartitionId() == partitionId) {
            }
            try {
                channel.setupRequestBuffer(req);
                if (summarized) {
                    req.putUUID(context.getSessionUUID());
                }
                NodeConnection.tryPutEmptyOptionalRequest(req);
                req.putInt(end - start);
                for (int i = start; i < end; ++i) {
                    GridStoreChannel.SessionInfo info2 = (GridStoreChannel.SessionInfo)sortedSessionInfos.get(i);
                    NodeConnection.putStatementId(req, info2.getLastStatementId() + 1L);
                    req.putLong(info2.getContainerId());
                    req.putLong(info2.getSessionId());
                    if (summarized) continue;
                    req.putUUID(context.getSessionUUID());
                }
                channel.executeStatement(context, Statement.CLOSE_MULTIPLE_SESSIONS, partitionId, 0L, req, resp, null);
            }
            catch (Exception e) {
                // empty catch block
            }
            start = end;
        }
    }

    protected void putTransactionInfo(BasicBuffer req, StatementFamily familyForSession, TransactionInfoType type, Boolean forUpdate) {
        boolean generatorEnabled;
        boolean sessionRequired;
        boolean bl = sessionRequired = familyForSession != null;
        if (sessionRequired && this.sessionId == 0L) {
            throw new Error("Internal error by invalid session parameters");
        }
        req.putLong(sessionRequired ? this.sessionId : 0L);
        if (type != TransactionInfoType.NO_UUID && SubnetContainer.isInitialSessionRetrialEnabled()) {
            req.putUUID(this.context.getSessionUUID());
        }
        if (!(generatorEnabled = SubnetContainer.isSessionIdGeneratorEnabled())) {
            if (forUpdate != null) {
                req.putBoolean(forUpdate);
            }
            if (type != TransactionInfoType.SKIP_COMMIT_MODE) {
                req.putBoolean(this.autoCommit);
            }
        }
        req.putInt(this.getSchemaVersionId());
        if (generatorEnabled) {
            if (sessionRequired) {
                req.putByteEnum(this.sessionPrepared ? SessionMode.GET : SessionMode.CREATE);
            } else {
                req.putByteEnum(SessionMode.AUTO);
            }
            if (this.autoCommit || !sessionRequired) {
                req.putByteEnum(TransactionMode.AUTO);
            } else {
                req.putByteEnum(this.transactionStarted ? TransactionMode.CONTINUE : TransactionMode.BEGIN);
            }
        }
        this.tryPutOptionalRequest(req, forUpdate != null && forUpdate != false, true);
    }

    protected void tryPutOptionalRequest(BasicBuffer req, boolean forUpdate, boolean containerLockAwared) {
        boolean containerLockRequired;
        if (!NodeConnection.isOptionalRequestEnabled()) {
            return;
        }
        boolean bl = containerLockRequired = containerLockAwared && this.containerLocked;
        if (forUpdate || containerLockRequired) {
            NodeConnection.OptionalRequest optionalRequest = this.context.getOptionalRequest();
            if (forUpdate) {
                optionalRequest.put(NodeConnection.OptionalRequestType.FOR_UPDATE, true);
            }
            if (containerLockRequired) {
                optionalRequest.put(NodeConnection.OptionalRequestType.CONTAINER_LOCK_REQUIRED, true);
            }
            optionalRequest.format(req);
        } else {
            NodeConnection.tryPutEmptyOptionalRequest(req);
        }
    }

    long getSessionIdDirect() {
        return this.sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSessionIdDirect(long sessionId, boolean statusUpdatable) {
        boolean orgSessionPrepared;
        boolean orgTransactionStarted;
        block33: {
            block35: {
                long orgSessionId;
                block34: {
                    orgTransactionStarted = this.transactionStarted;
                    orgSessionPrepared = this.sessionPrepared;
                    orgSessionId = this.sessionId;
                    if (statusUpdatable) {
                        if (sessionId == 0L) {
                            this.statementId = 0L;
                            if (++this.transactionId == 0L) {
                                this.transactionId = 1L;
                            }
                            this.sessionPrepared = false;
                            this.containerLocked = false;
                            this.transactionStarted = false;
                        } else {
                            this.sessionPrepared = true;
                        }
                    }
                    try {
                        GridStoreChannel.Context context = this.context;
                        synchronized (context) {
                            if (this.sessionId != sessionId) {
                                if (this.sessionRef != null) {
                                    this.context.removeRemoteReference(this.sessionRef);
                                    this.sessionRef = null;
                                }
                                if (sessionId != 0L) {
                                    this.sessionRef = new SessionReference(this, sessionId);
                                    this.context.addRemoteReference(this.sessionRef);
                                }
                            }
                        }
                        this.sessionId = sessionId;
                        if (!LOGGER.isDebugEnabled()) break block33;
                        if (!(orgSessionPrepared ^ this.sessionPrepared)) break block34;
                        LOGGER.debug(this.sessionPrepared ? "transaction.sessionStarted" : "transaction.sessionClosed", "transaction.sessionStarted", GridStoreChannel.ContextMonitor.getObjectId(this.context), this.partitionId, this.containerId, this.sessionPrepared ? sessionId : orgSessionId);
                    }
                    catch (Throwable throwable) {
                        this.sessionId = sessionId;
                        if (LOGGER.isDebugEnabled()) {
                            if (orgSessionPrepared ^ this.sessionPrepared) {
                                LOGGER.debug(this.sessionPrepared ? "transaction.sessionStarted" : "transaction.sessionClosed", "transaction.sessionStarted", GridStoreChannel.ContextMonitor.getObjectId(this.context), this.partitionId, this.containerId, this.sessionPrepared ? sessionId : orgSessionId);
                            } else if (sessionId != 0L && orgSessionId != sessionId) {
                                LOGGER.debug("transaction.sessionIdGenerated", GridStoreChannel.ContextMonitor.getObjectId(this.context), this.partitionId, this.containerId, sessionId);
                            }
                            if (orgTransactionStarted ^ this.transactionStarted) {
                                LOGGER.debug(this.transactionStarted ? "transaction.transactionStarted" : "transaction.transactionEnded", GridStoreChannel.ContextMonitor.getObjectId(this.context), this.partitionId, this.containerId, sessionId);
                            }
                        }
                        if (this.contextMonitor != null) {
                            if (orgSessionPrepared ^ this.sessionPrepared) {
                                if (this.sessionPrepared) {
                                    this.contextMonitor.startSession(sessionId);
                                } else {
                                    this.contextMonitor.endSession();
                                }
                            }
                            if (orgTransactionStarted ^ this.transactionStarted) {
                                if (this.transactionStarted) {
                                    this.contextMonitor.startTransaction();
                                } else {
                                    this.contextMonitor.endTransaction();
                                }
                            }
                        }
                        throw throwable;
                    }
                    break block35;
                }
                if (sessionId != 0L && orgSessionId != sessionId) {
                    LOGGER.debug("transaction.sessionIdGenerated", GridStoreChannel.ContextMonitor.getObjectId(this.context), this.partitionId, this.containerId, sessionId);
                }
            }
            if (orgTransactionStarted ^ this.transactionStarted) {
                LOGGER.debug(this.transactionStarted ? "transaction.transactionStarted" : "transaction.transactionEnded", GridStoreChannel.ContextMonitor.getObjectId(this.context), this.partitionId, this.containerId, sessionId);
            }
        }
        if (this.contextMonitor != null) {
            if (orgSessionPrepared ^ this.sessionPrepared) {
                if (this.sessionPrepared) {
                    this.contextMonitor.startSession(sessionId);
                } else {
                    this.contextMonitor.endSession();
                }
            }
            if (orgTransactionStarted ^ this.transactionStarted) {
                if (this.transactionStarted) {
                    this.contextMonitor.startTransaction();
                } else {
                    this.contextMonitor.endTransaction();
                }
            }
        }
    }

    long getStatementIdDirect() {
        return this.statementId;
    }

    boolean isTransactionStarted() {
        return this.transactionStarted;
    }

    private void setTransactionStarted(boolean started) {
        boolean orgStarted = this.transactionStarted;
        this.transactionStarted = started;
        if (orgStarted ^ started) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(started ? "transaction.transactionStarted" : "transaction.transactionEnded", GridStoreChannel.ContextMonitor.getObjectId(this.context), this.partitionId, this.containerId, this.sessionId);
            }
            if (this.contextMonitor != null) {
                if (started) {
                    this.contextMonitor.startTransaction();
                } else {
                    this.contextMonitor.endTransaction();
                }
            }
        }
    }

    long updateStatementIdDirect() {
        if (this.sessionId == 0L) {
            throw new Error("Internal error by empty session");
        }
        while (++this.statementId == 0L) {
        }
        return this.statementId;
    }

    public static boolean isInitialSessionRetrialEnabled(int protocolVersion) {
        return protocolVersion >= 2;
    }

    private static boolean isInitialSessionRetrialEnabled() {
        return SubnetContainer.isInitialSessionRetrialEnabled(NodeConnection.getProtocolVersion());
    }

    static boolean isSessionIdGeneratorEnabled() {
        return NodeConnection.getProtocolVersion() >= 3;
    }

    static boolean isDDLSessionEnabled() {
        return NodeConnection.getProtocolVersion() >= 3 && !GridStoreChannel.v15DDLCompatible;
    }

    static boolean isRowSetIdHintDisabled() {
        return NodeConnection.getProtocolVersion() >= 3;
    }

    static boolean isPartialRowSetLostAcceptable() {
        return NodeConnection.getProtocolVersion() >= 3;
    }

    protected static RowMapper.MappingMode getRowMappingMode() {
        if (NodeConnection.getProtocolVersion() >= 3) {
            return RowMapper.MappingMode.ROWWISE_SEPARATED_V2;
        }
        return RowMapper.MappingMode.ROWWISE_SEPARATED;
    }

    static boolean isMultiStepStatementIdEnabled() {
        return NodeConnection.getProtocolVersion() >= 5 && !GridStoreChannel.v21StatementIdCompatible;
    }

    static boolean isNewSessionConflicted(GSStatementException cause) {
        if (!SubnetContainer.isSessionIdGeneratorEnabled()) {
            return false;
        }
        return cause.getErrorCode() == 110016;
    }

    static boolean isInitialSessionLost(Statement statement, long statementId, boolean transactionStarted, GSStatementException cause) {
        if (statement == Statement.CREATE_SESSION || statement == Statement.CLOSE_SESSION) {
            return false;
        }
        int errorCode = cause.getErrorCode();
        if (errorCode != 110003 && errorCode != 110016) {
            return false;
        }
        if (!SubnetContainer.isInitialSessionRetrialEnabled()) {
            return false;
        }
        return !(SubnetContainer.isSessionIdGeneratorEnabled() ? transactionStarted : statementId != 1L);
    }

    protected void putSessionInfo(BasicBuffer req, long sessionId) {
        req.putLong(sessionId);
        if (SubnetContainer.isInitialSessionRetrialEnabled()) {
            req.putUUID(this.context.getSessionUUID());
        }
    }

    protected boolean isAutoCommit() {
        return this.autoCommit;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public RowMapper getRowMapper() {
        return this.mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws GSException {
        if (this.autoCommit) {
            throw new GSException(145035, "Auto commit mode must be turned off for a transactional operation");
        }
        if (!this.transactionStarted) {
            return;
        }
        if (++this.transactionId == 0L) {
            this.transactionId = 1L;
        }
        this.clearBlob(true);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        this.putSessionInfo(req, this.sessionId);
        NodeConnection.tryPutEmptyOptionalRequest(req);
        try {
            this.executeStatement(Statement.COMMIT_TRANSACTION, req, resp, StatementFamily.POST);
        }
        finally {
            this.setTransactionStarted(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() throws GSException {
        if (this.autoCommit) {
            throw new GSException(145035, "Auto commit mode must be turned off for a transactional operation");
        }
        if (!this.transactionStarted) {
            return;
        }
        if (++this.transactionId == 0L) {
            this.transactionId = 1L;
        }
        this.clearBlob(true);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        boolean succeeded = false;
        try {
            this.channel.setupRequestBuffer(req);
            req.putLong(this.getContainerId());
            this.putSessionInfo(req, this.sessionId);
            NodeConnection.tryPutEmptyOptionalRequest(req);
            this.executeStatement(Statement.ABORT_TRANSACTION, req, resp, StatementFamily.POST);
            succeeded = true;
        }
        catch (Throwable throwable) {
            try {
                this.setTransactionStarted(false);
                this.closeSubResources(!succeeded, true);
            }
            catch (Throwable throwable2) {
                this.closeSubResources(!succeeded, true);
                throw throwable2;
            }
            throw throwable;
        }
        try {
            this.setTransactionStarted(false);
            this.closeSubResources(!succeeded, true);
        }
        catch (Throwable throwable) {
            this.closeSubResources(!succeeded, true);
            throw throwable;
        }
    }

    @Override
    public void setAutoCommit(boolean enabled) throws GSException {
        this.checkOpened();
        if (this.autoCommit && !enabled) {
            this.autoCommit = false;
            this.setTransactionStarted(false);
        } else if (!this.autoCommit && enabled) {
            this.commit();
            this.autoCommit = true;
        }
    }

    @Override
    public R get(K key) throws GSException {
        return this.get(key, false);
    }

    @Override
    public R get(K key, boolean forUpdate) throws GSException {
        StatementFamily family = this.prepareSession(forUpdate ? StatementFamily.LOCK : StatementFamily.QUERY);
        this.clearBlob(false);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        this.putTransactionInfo(req, family, null, forUpdate);
        this.mapper.encodeKey(req, key, SubnetContainer.getRowMappingMode());
        this.executeStatement(Statement.GET_ROW, req, resp, family);
        if (!resp.getBoolean()) {
            return null;
        }
        boolean rowIdIncluded = !this.mapper.isForTimeSeries();
        RowMapper.Cursor cursor = this.mapper.createCursor(resp, SubnetContainer.getRowMappingMode(), 1, rowIdIncluded, this);
        return this.rowType.cast(this.mapper.decode(cursor));
    }

    @Override
    public boolean put(R value) throws GSException {
        return this.put(null, value);
    }

    @Override
    public boolean put(K key, R value) throws GSException {
        StatementFamily family = this.prepareSession(StatementFamily.UPDATE);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        this.putTransactionInfo(req, family, null, null);
        this.mapper.encode(req, SubnetContainer.getRowMappingMode(), key, value);
        this.executeStatement(Statement.PUT_ROW, req, resp, family);
        boolean found = resp.getBoolean();
        this.clearBlob(false);
        return found;
    }

    @Override
    public boolean put(Collection<R> rowCollection) throws GSException {
        try {
            if (rowCollection.isEmpty()) {
                return false;
            }
        }
        catch (NullPointerException e) {
            throw GSErrorCode.checkNullParameter(rowCollection, "rowCollection", e);
        }
        StatementFamily family = this.prepareSession(StatementFamily.UPDATE);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        this.putTransactionInfo(req, family, null, null);
        int rowCount = rowCollection.size();
        req.putLong(rowCount);
        RowMapper.Cursor cursor = this.mapper.createCursor(req, SubnetContainer.getRowMappingMode(), rowCount, false, this);
        for (R row : rowCollection) {
            this.mapper.encode(cursor, null, row);
        }
        this.executeMultiStepStatement(Statement.PUT_MULTIPLE_ROWS, req, resp, family, rowCount);
        this.clearBlob(false);
        return resp.getBoolean();
    }

    @Override
    public SubnetQuery<R> query(String tql) throws GSException {
        return this.query(tql, this.rowType);
    }

    @Override
    public <S> SubnetQuery<S> query(final String tql, Class<S> rowType) throws GSException {
        this.checkOpened();
        RowMapper resultMapper = this.mapper.applyResultType(rowType);
        return new SubnetQuery<S>(this, rowType, resultMapper, Statement.QUERY_TQL, new QueryFormatter(){

            @Override
            public void format(BasicBuffer inBuf) {
                try {
                    inBuf.putString(tql);
                }
                catch (NullPointerException e) {
                    throw GSErrorCode.checkNullParameter(tql, "tql", e);
                }
            }

            @Override
            public String getQueryString() {
                return tql;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSubResources(boolean silent, boolean transactionalOnly) throws GSException {
        GridStoreChannel.Context context = this.context;
        synchronized (context) {
            HashSet targetClasses = new HashSet();
            for (Class<?> targetClass : this.context.getReferenceTargetClasses()) {
                if (!ContainerSubResource.class.isAssignableFrom(targetClass) || transactionalOnly && !TransactionalResource.class.isAssignableFrom(targetClass)) continue;
                targetClasses.add(targetClass);
            }
            this.channel.closeAllRemoteResources(this.context, targetClasses, this.partitionId, this.containerId, silent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <S> SubnetRowSet<S> queryAndFetch(Statement statement, Class<S> resultType, RowMapper resultMapper, QueryFormatter formatter, boolean forUpdate, long fetchSize) throws GSException {
        Object targetConnection;
        StatementFamily family = this.prepareSession(forUpdate ? StatementFamily.LOCK : StatementFamily.QUERY);
        this.clearBlob(false);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        this.putTransactionInfo(req, family, null, forUpdate);
        formatter.format(req);
        GridStoreChannel.Context context = this.context;
        synchronized (context) {
            if (this.contextMonitor != null) {
                this.contextMonitor.setQuery(formatter.getQueryString());
            }
            try {
                this.executeStatement(statement, req, resp, family);
            }
            finally {
                if (this.contextMonitor != null) {
                    this.contextMonitor.setQuery(null);
                }
            }
            targetConnection = this.channel.getLastConnection(this.context);
        }
        return this.acceptQueryResponse(statement, resultType, resultMapper, forUpdate, fetchSize, resp, targetConnection, true);
    }

    void makeQueryRequest(Statement statement, QueryFormatter formatter, boolean forUpdate, long fetchSize, BasicBuffer req, boolean noUUID) throws GSException {
        if (forUpdate && (!this.sessionPrepared || this.sessionId == 0L)) {
            throw new Error("Internal error by invalid session status");
        }
        StatementFamily family = this.prepareSession(forUpdate ? StatementFamily.LOCK : StatementFamily.QUERY);
        TransactionInfoType type = noUUID ? TransactionInfoType.NO_UUID : null;
        req.putLong(this.getContainerId());
        this.putTransactionInfo(req, family, type, forUpdate);
        formatter.format(req);
    }

    <S> SubnetRowSet<S> acceptQueryResponse(Statement statement, Class<S> resultType, RowMapper resultMapper, boolean forUpdate, long fetchSize, BasicBuffer resp, Object targetConnection, boolean bufSwapAllowed) throws GSException {
        long rowSetTransactionId;
        boolean partial;
        boolean rowIdIncluded;
        RowMapper.MappingMode mode;
        Class mapperRowType;
        block13: {
            block12: {
                if (!SubnetContainer.isAnyQueryResultTypeEnabled(NodeConnection.getProtocolVersion()) && statement != Statement.QUERY_TQL && bufSwapAllowed) break block12;
                switch (resp.getByteEnum(QueryResultType.class)) {
                    case ROW_SET: {
                        mapperRowType = this.mapper.getRowType();
                        mode = SubnetContainer.getRowMappingMode();
                        rowIdIncluded = !this.mapper.isForTimeSeries();
                        partial = false;
                        break block13;
                    }
                    case AGGREGATION_RESULT: {
                        mapperRowType = AggregationResult.class;
                        mode = RowMapper.MappingMode.AGGREGATED;
                        rowIdIncluded = false;
                        partial = false;
                        break block13;
                    }
                    case QUERY_ANALYSIS: {
                        mapperRowType = QueryAnalysisEntry.class;
                        mode = SubnetContainer.getRowMappingMode();
                        rowIdIncluded = false;
                        partial = false;
                        break block13;
                    }
                    case PARTIAL_ROW_SET: {
                        mode = SubnetContainer.getRowMappingMode();
                        rowIdIncluded = !this.mapper.isForTimeSeries();
                        mapperRowType = this.mapper.getRowType();
                        partial = true;
                        break block13;
                    }
                    default: {
                        throw new GSException(145031, "Protocol error by unknown result type");
                    }
                }
            }
            mode = SubnetContainer.getRowMappingMode();
            rowIdIncluded = !this.mapper.isForTimeSeries();
            mapperRowType = this.mapper.getRowType();
            partial = false;
        }
        if (resultType != null && resultType != mapperRowType) {
            throw new GSException(145002, "Inconsistent result type (requiredType=" + resultType + ", " + "actualType=" + mapperRowType + ")");
        }
        if (resultMapper == null) {
            resultMapper = this.mapper.applyResultType(mapperRowType);
        } else if (resultMapper.getRowType() != mapperRowType) {
            throw new GSException(145002, "Inconsistent result type (requiredType=" + resultMapper.getRowType() + ", " + "actualType=" + mapperRowType + ")");
        }
        if (forUpdate) {
            this.setTransactionStarted(true);
        }
        long l = rowSetTransactionId = forUpdate ? this.transactionId : 0L;
        if (partial) {
            long totalRowCount = resp.base().getLong();
            long rowSetId = resp.base().getLong();
            long rowSetIdHint = SubnetContainer.isRowSetIdHintDisabled() ? 0L : resp.base().getLong();
            int rowCount = this.getResultRowSetCount(resp);
            BasicBuffer resultBuffer = this.getResultBuffer(resp, bufSwapAllowed);
            RowMapper.Cursor cursor = resultMapper.createCursor(resultBuffer, mode, rowCount, rowIdIncluded, this);
            return new SubnetRowSet<S>(this, resultType, resultMapper, cursor, rowSetTransactionId, totalRowCount, rowSetId, rowSetIdHint, fetchSize, targetConnection);
        }
        int rowCount = this.getResultRowSetCount(resp);
        BasicBuffer resultBuffer = this.getResultBuffer(resp, bufSwapAllowed);
        RowMapper.Cursor cursor = resultMapper.createCursor(resultBuffer, mode, rowCount, rowIdIncluded, this);
        return new SubnetRowSet<S>(this, resultType, resultMapper, cursor, forUpdate ? this.transactionId : 0L);
    }

    private BasicBuffer getResultBuffer(BasicBuffer resp, boolean bufSwapAllowed) {
        BasicBuffer resultBuffer;
        int resultDataSize = resp.base().remaining();
        if (!bufSwapAllowed || resultDataSize < GridStoreChannel.INITIAL_BUFFER_SIZE) {
            resultBuffer = new BasicBuffer(resultDataSize);
            resultBuffer.base().put(resp.base());
            resultBuffer.base().flip();
        } else {
            resultBuffer = resp;
            this.context.replaceResponseBuffer(this.channel.createResponseBuffer());
        }
        return resultBuffer;
    }

    private int getResultRowSetCount(BasicBuffer resp) throws GSException {
        long longRowCount = resp.base().getLong();
        if (longRowCount < 0L || longRowCount > Integer.MAX_VALUE) {
            throw new GSConnectionException(145031, "Protocol error by result row count out of range");
        }
        return (int)longRowCount;
    }

    public static boolean isAnyQueryResultTypeEnabled(int protocolVersion) {
        return protocolVersion >= 2 && (GridStoreChannel.v1ProtocolCompatible == null || GridStoreChannel.v1ProtocolCompatible == false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void closeRowSet(GridStoreChannel channel, GridStoreChannel.Context context, int partitionId, long containerId, long rowSetId, long rowSetIdHint, Object targetConnection) throws GSException {
        GridStoreChannel.Context context2 = context;
        synchronized (context2) {
            BasicBuffer req = context.getSynchronizedRequestBuffer();
            BasicBuffer resp = context.getSynchronizedResponseBuffer();
            channel.setupRequestBuffer(req);
            req.putLong(containerId);
            NodeConnection.tryPutEmptyOptionalRequest(req);
            req.putLong(rowSetId);
            if (!SubnetContainer.isRowSetIdHintDisabled()) {
                req.putLong(rowSetIdHint);
            }
            channel.checkActiveConnection(context, partitionId, targetConnection);
            channel.executeStatement(context, Statement.CLOSE_ROW_SET, partitionId, 0L, req, resp, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowMapper.Cursor fetchRowSet(long rowSetId, long rowSetIdHint, long totalCount, long remainingCount, long fetchSize, Object[] targetConnection, RowMapper resultMapper) throws GSException {
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        req.putInt(this.getSchemaVersionId());
        this.tryPutOptionalRequest(req, false, true);
        req.putLong(rowSetId);
        if (!SubnetContainer.isRowSetIdHintDisabled()) {
            req.putLong(rowSetIdHint);
        }
        req.putLong(totalCount - remainingCount);
        req.putLong(fetchSize);
        GridStoreChannel.Context context = this.context;
        synchronized (context) {
            this.channel.checkActiveConnection(this.context, this.partitionId, targetConnection[0]);
            try {
                this.executeStatement(Statement.FETCH_ROW_SET, req, resp, null);
            }
            catch (GSRecoverableException e) {
                targetConnection[0] = null;
                throw e;
            }
            catch (GSStatementException e) {
                if (e.getErrorCode() == 60132) {
                    targetConnection[0] = null;
                    throw new GSRecoverableException(145043, "Row set temporarily lost by connection problem (reason=" + e.getMessage() + ")", e);
                }
                throw e;
            }
        }
        boolean resultClosed = resp.getBoolean();
        if (resultClosed) {
            targetConnection[0] = null;
        }
        long varDataBaseOffset = resp.base().getLong();
        int resultRowCount = this.getResultRowSetCount(resp);
        long newRemainingCount = remainingCount - (long)resultRowCount;
        if (newRemainingCount < 0L || resultClosed && newRemainingCount > 0L && !SubnetContainer.isPartialRowSetLostAcceptable() || !resultClosed && newRemainingCount == 0L) {
            throw new GSConnectionException(145031, "Protocol error by unexpected result (resultClosed=" + resultClosed + ", resultRowCount=" + resultRowCount + ", remainingCount=" + remainingCount + ")");
        }
        BasicBuffer resultBuffer = this.getResultBuffer(resp, true);
        boolean rowIdIncluded = !this.mapper.isForTimeSeries();
        RowMapper.Cursor cursor = resultMapper.createCursor(resultBuffer, SubnetContainer.getRowMappingMode(), resultRowCount, rowIdIncluded, this);
        cursor.setVarDataBaseOffset(varDataBaseOffset);
        return cursor;
    }

    @Override
    public boolean remove(K key) throws GSException {
        StatementFamily family = this.prepareSession(StatementFamily.UPDATE);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        this.putTransactionInfo(req, family, null, null);
        this.mapper.encodeKey(req, key, SubnetContainer.getRowMappingMode());
        this.executeStatement(Statement.DELETE_ROW, req, resp, family);
        boolean found = resp.getBoolean();
        this.clearBlob(false);
        return found;
    }

    public void remove(RowMapper resolvedMapper, long transactionId, long rowId, Object key) throws GSException {
        if (transactionId != this.transactionId || this.autoCommit) {
            if (transactionId == 0L) {
                throw new GSException(145039, "Update option must be turned on");
            }
            throw new GSException(145036, "Transaction expired");
        }
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        StatementFamily family = StatementFamily.UPDATE;
        if (this.mapper.isForTimeSeries()) {
            this.putTransactionInfo(req, family, null, null);
            resolvedMapper.encodeKey(req, key, SubnetContainer.getRowMappingMode());
            this.executeStatement(Statement.DELETE_ROW, req, resp, family);
        } else {
            this.putTransactionInfo(req, family, TransactionInfoType.SKIP_COMMIT_MODE, null);
            req.putLong(rowId);
            this.executeStatement(Statement.DELETE_ROW_BY_ID, req, resp, family);
        }
    }

    public void update(RowMapper resolvedMapper, long transactionId, long rowId, Object key, Object newRowObj) throws GSException {
        Statement statement;
        if (this.mapper.isForTimeSeries() && !timeSeriesUpdateEnabled) {
            throw new GSException(145003, "TimeSeries row can not be updated");
        }
        if (transactionId != this.transactionId || this.autoCommit) {
            if (transactionId == 0L) {
                throw new GSException(145039, "Update option must be turned on");
            }
            throw new GSException(145036, "Transaction expired");
        }
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        StatementFamily family = StatementFamily.UPDATE;
        if (this.mapper.isForTimeSeries()) {
            this.putTransactionInfo(req, family, null, null);
            statement = Statement.PUT_ROW;
        } else {
            this.putTransactionInfo(req, family, TransactionInfoType.SKIP_COMMIT_MODE, null);
            req.putLong(rowId);
            statement = Statement.UPDATE_ROW_BY_ID;
        }
        resolvedMapper.encode(req, SubnetContainer.getRowMappingMode(), key, newRowObj);
        this.executeStatement(statement, req, resp, family);
    }

    @Override
    public Blob createBlob() throws GSException {
        this.checkOpened();
        return new BlobImpl(null);
    }

    @Override
    public Blob createBlob(byte[] data) throws GSException {
        BlobImpl blob = new BlobImpl(null);
        blob.setDataDirect(data);
        return blob;
    }

    @Override
    public void createIndex(String columnName) throws GSException {
        IndexType indexType;
        try {
            indexType = this.getDefaultIndexType(columnName);
        }
        catch (NullPointerException e) {
            throw GSErrorCode.checkNullParameter(columnName, "columnName", e);
        }
        if (indexType == null) {
            throw new GSException(145019, "Default index can not be assigned (columnName=" + columnName + ")");
        }
        this.createIndex(columnName, indexType);
    }

    @Override
    public void createIndex(String columnName, IndexType type) throws GSException {
        StatementFamily family = SubnetContainer.isDDLSessionEnabled() ? this.prepareSession(StatementFamily.POST) : null;
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        if (family != null) {
            this.putSessionInfo(req, this.sessionId);
        }
        req.putInt(this.getSchemaVersionId());
        this.tryPutOptionalRequest(req, false, true);
        try {
            req.putInt(this.mapper.resolveColumnId(columnName));
            req.putByteEnum(type);
        }
        catch (NullPointerException e) {
            GSErrorCode.checkNullParameter(columnName, "columnName", e);
            GSErrorCode.checkNullParameter((Object)type, "type", e);
            throw e;
        }
        this.executeStatement(Statement.CREATE_INDEX, req, resp, family);
    }

    @Override
    public void dropIndex(String columnName) throws GSException {
        IndexType indexType;
        try {
            indexType = this.getDefaultIndexType(columnName);
        }
        catch (NullPointerException e) {
            throw GSErrorCode.checkNullParameter(columnName, "columnName", e);
        }
        if (indexType == null) {
            return;
        }
        this.dropIndex(columnName, indexType);
    }

    @Override
    public void dropIndex(String columnName, IndexType type) throws GSException {
        StatementFamily family = SubnetContainer.isDDLSessionEnabled() ? this.prepareSession(StatementFamily.POST) : null;
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        if (family != null) {
            this.putSessionInfo(req, this.sessionId);
        }
        req.putInt(this.getSchemaVersionId());
        this.tryPutOptionalRequest(req, false, true);
        try {
            req.putInt(this.mapper.resolveColumnId(columnName));
            req.putByteEnum(type);
        }
        catch (NullPointerException e) {
            GSErrorCode.checkNullParameter(columnName, "columnName", e);
            GSErrorCode.checkNullParameter((Object)type, "type", e);
            throw e;
        }
        this.executeStatement(Statement.DROP_INDEX, req, resp, family);
    }

    private IndexType getDefaultIndexType(String columnName) throws GSException {
        int columnId = this.mapper.resolveColumnId(columnName);
        if (this.mapper.isArray(columnId)) {
            return null;
        }
        switch (this.mapper.getFieldElementType(columnId)) {
            case TIMESTAMP: {
                if (columnId == 0 && this.mapper.isForTimeSeries()) {
                    return null;
                }
                return IndexType.TREE;
            }
            case GEOMETRY: {
                if (this.mapper.isForTimeSeries()) {
                    return null;
                }
                return IndexType.SPATIAL;
            }
            case BLOB: {
                return null;
            }
        }
        return IndexType.TREE;
    }

    @Override
    public void createEventNotification(URL url) throws GSException {
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        NodeConnection.tryPutEmptyOptionalRequest(req);
        try {
            req.putString(url.toString());
        }
        catch (NullPointerException e) {
            GSErrorCode.checkNullParameter(url, "url", e);
            throw e;
        }
        this.executeStatement(Statement.CREATE_EVENT_NOTIFICATION, req, resp, null);
    }

    @Override
    public void dropEventNotification(URL url) throws GSException {
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        NodeConnection.tryPutEmptyOptionalRequest(req);
        try {
            req.putString(url.toString());
        }
        catch (NullPointerException e) {
            GSErrorCode.checkNullParameter(url, "url", e);
            throw e;
        }
        this.executeStatement(Statement.DROP_EVENT_NOTIFICATION, req, resp, null);
    }

    @Override
    public void flush() throws GSException {
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        NodeConnection.tryPutEmptyOptionalRequest(req);
        this.executeStatement(Statement.FLUSH_LOG, req, resp, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws GSException {
        GridStoreChannel.Context context = this.context;
        synchronized (context) {
            if (this.isClosed()) {
                return;
            }
            try {
                this.closeSubResources(false, false);
            }
            finally {
                try {
                    this.closeSession(false);
                }
                finally {
                    SubnetGridStore store = this.store;
                    if (store != null) {
                        this.store = null;
                        store.removeReference(this);
                    }
                }
            }
        }
    }

    public boolean isClosed() {
        return this.store == null || this.context.isClosedAsync();
    }

    protected void checkOpened() throws GSException {
        if (this.isClosed()) {
            throw new GSException(145040, "Already closed");
        }
    }

    @Override
    public ContainerType getType() throws GSException {
        this.checkOpened();
        return this.mapper.getContainerType();
    }

    @Override
    public R createRow() throws GSException {
        this.checkOpened();
        return this.rowType.cast(this.mapper.createRow(false));
    }

    public RowSet<Row> getRowSet(long[] position, long fetchLimit) throws GSException {
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        StatementFamily family = null;
        this.putTransactionInfo(req, family, TransactionInfoType.SKIP_COMMIT_MODE, null);
        req.putLong(fetchLimit);
        req.putLong(position[0]);
        this.executeStatement(Statement.GET_MULTIPLE_ROWS, req, resp, family);
        position[0] = resp.base().getLong();
        long rowCount = resp.base().getLong();
        BasicBuffer resultData = resp;
        this.context.replaceResponseBuffer(this.channel.createResponseBuffer());
        if (this.mapper.getRowType() != Row.class) {
            throw new GSException(145003, "Not supported for this row type (class=" + this.mapper.getRowType() + ")");
        }
        RowMapper.Cursor cursor = this.mapper.createCursor(resultData, SubnetContainer.getRowMappingMode(), (int)rowCount, false, this);
        return new SubnetRowSet<Row>(this, Row.class, this.mapper, cursor, 0L);
    }

    public boolean putRowSet(SubnetRowSet<?> rowSet) throws GSException {
        int rowCount = rowSet.size();
        if (rowCount == 0) {
            return false;
        }
        StatementFamily family = this.prepareSession(StatementFamily.UPDATE);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        this.putTransactionInfo(req, family, null, null);
        req.putLong(rowCount);
        RowMapper.Cursor cursor = this.mapper.createCursor(req, SubnetContainer.getRowMappingMode(), rowCount, false, this);
        for (int i = 0; i < rowCount; ++i) {
            this.mapper.encode(cursor, null, (Object)rowSet.nextGeneralRow(), true);
        }
        this.executeMultiStepStatement(Statement.PUT_MULTIPLE_ROWS, req, resp, family, rowCount);
        this.clearBlob(false);
        return resp.getBoolean();
    }

    @Override
    public void createTrigger(TriggerInfo info) throws GSException {
        StatementFamily family = SubnetContainer.isDDLSessionEnabled() ? this.prepareSession(StatementFamily.POST) : null;
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        if (family != null) {
            this.putSessionInfo(req, this.sessionId);
        }
        req.putInt(this.getSchemaVersionId());
        this.tryPutOptionalRequest(req, false, true);
        if (info.getName() == null) {
            throw new GSException(145001, "Trigger name not assigned");
        }
        req.putString(info.getName());
        if (info.getType() == null) {
            throw new GSException(145001, "Trigger type not assigned");
        }
        req.putByteEnum(info.getType());
        if (info.getURI() == null) {
            throw new GSException(145001, "Trigger URI not assigned");
        }
        req.putString(info.getURI().toString());
        int eventType = 0;
        for (TriggerInfo.EventType e : info.getTargetEvents()) {
            eventType |= 1 << e.ordinal();
        }
        req.putInt(eventType);
        int columnCount = info.getTargetColumns().size();
        req.putInt(columnCount);
        for (String columnName : info.getTargetColumns()) {
            req.putInt(this.mapper.resolveColumnId(columnName));
        }
        String emptyString = "";
        switch (info.getType()) {
            case REST: {
                req.putString("");
                req.putString("");
                req.putString("");
                req.putString("");
                req.putString("");
                break;
            }
            case JMS: {
                req.putString("activemq");
                if (info.getJMSDestinationType() == null) {
                    throw new GSException(145001, "Destination type not assigned");
                }
                req.putString(info.getJMSDestinationType());
                if (info.getJMSDestinationName() == null) {
                    throw new GSException(145001, "Destination name not assigned");
                }
                req.putString(info.getJMSDestinationName());
                if (info.getUser() == null) {
                    req.putString("");
                } else {
                    req.putString(info.getUser());
                }
                if (info.getPassword() == null) {
                    req.putString("");
                    break;
                }
                req.putString(info.getPassword());
                break;
            }
            default: {
                throw new Error("Internal error by unknown trigger type");
            }
        }
        this.executeStatement(Statement.CREATE_TRIGGER, req, resp, family);
    }

    @Override
    public void dropTrigger(String name) throws GSException {
        StatementFamily family = SubnetContainer.isDDLSessionEnabled() ? this.prepareSession(StatementFamily.POST) : null;
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        if (family != null) {
            this.putSessionInfo(req, this.sessionId);
        }
        req.putInt(this.getSchemaVersionId());
        this.tryPutOptionalRequest(req, false, true);
        req.putString(name);
        this.executeStatement(Statement.DROP_TRIGGER, req, resp, family);
    }

    static {
        Map<Statement, Statement> map = TIME_SERIES_STATEMENT_MAP = new EnumMap<Statement, Statement>(Statement.class);
        map.put(Statement.GET_ROW, Statement.GET_TIME_SERIES_ROW);
        map.put(Statement.QUERY_TQL, Statement.QUERY_TIME_SERIES_TQL);
        map.put(Statement.PUT_ROW, Statement.PUT_TIME_SERIES_ROW);
        map.put(Statement.PUT_MULTIPLE_ROWS, Statement.PUT_TIME_SERIES_MULTIPLE_ROWS);
        map.put(Statement.DELETE_ROW, Statement.DELETE_TIME_SERIES_ROW);
        map.put(Statement.GET_MULTIPLE_ROWS, Statement.GET_TIME_SERIES_MULTIPLE_ROWS);
        Set<Statement> set = FIXED_SESSION_MODE_STATEMENTS = EnumSet.noneOf(Statement.class);
        set.add(Statement.CREATE_SESSION);
        set.add(Statement.CLOSE_SESSION);
        set.add(Statement.COMMIT_TRANSACTION);
        set.add(Statement.ABORT_TRANSACTION);
        LOGGER = LoggingUtils.getLogger("Transaction");
    }

    public static interface QueryFormatter {
        public void format(BasicBuffer var1) throws GSException;

        public String getQueryString();
    }

    public static enum QueryResultType {
        ROW_SET,
        AGGREGATION_RESULT,
        QUERY_ANALYSIS,
        PARTIAL_ROW_SET;

    }

    static interface TransactionalResource
    extends ContainerSubResource {
    }

    static interface ContainerSubResource {
    }

    static enum TransactionInfoType {
        NO_UUID,
        SKIP_COMMIT_MODE;

    }

    static enum SessionMode {
        AUTO,
        CREATE,
        GET;

    }

    static enum TransactionMode {
        AUTO,
        BEGIN,
        CONTINUE;

    }

    private static class SessionReference
    extends GridStoreChannel.RemoteReference<SubnetContainer<?, ?>> {
        private final long sessionId;
        private long lastStatementId;

        public SessionReference(SubnetContainer<?, ?> target, long sessionId) {
            super(target, SubnetContainer.class, target.context, ((SubnetContainer)target).partitionId, ((SubnetContainer)target).containerId);
            this.sessionId = sessionId;
        }

        @Override
        public void close(GridStoreChannel channel, GridStoreChannel.Context context) throws GSException {
            GridStoreChannel.SessionInfo sessionInfo = new GridStoreChannel.SessionInfo(this.partitionId, this.containerId, this.sessionId, this.lastStatementId);
            SubnetContainer.closeSession(channel, context, context.getSynchronizedRequestBuffer(), context.getSynchronizedResponseBuffer(), sessionInfo);
        }
    }

    protected static enum StatementFamily {
        QUERY,
        LOCK,
        UPDATE,
        POST;

    }
}

