/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.subnet;

import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.PartitionController;
import com.toshiba.mwcloud.gs.common.BasicBuffer;
import com.toshiba.mwcloud.gs.common.GSErrorCode;
import com.toshiba.mwcloud.gs.common.Statement;
import com.toshiba.mwcloud.gs.experimental.ContainerAttribute;
import com.toshiba.mwcloud.gs.experimental.ContainerCondition;
import com.toshiba.mwcloud.gs.subnet.GridStoreChannel;
import com.toshiba.mwcloud.gs.subnet.SubnetGridStore;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class SubnetPartitionController
implements PartitionController {
    private final GridStoreChannel channel;
    private final GridStoreChannel.Context context;
    private boolean closed;

    public SubnetPartitionController(GridStoreChannel channel, GridStoreChannel.Context context) {
        this.channel = channel;
        this.context = context;
    }

    private void checkOpened() throws GSException {
        if (this.closed) {
            throw new GSException(145040, "This controller already closed");
        }
        this.channel.checkContextAvailable(this.context);
    }

    private void checkPartitionIndex(int partitionIndex) throws GSException {
        int partitionCount = this.channel.getPartitionCount(this.context);
        if (partitionIndex < 0 || partitionIndex >= partitionCount) {
            throw new GSException(145002, "Partition index out of range (partitionIndex=" + partitionIndex + ", " + "partitionCount=" + partitionCount + ")");
        }
    }

    @Override
    public int getPartitionCount() throws GSException {
        this.checkOpened();
        return this.channel.getPartitionCount(this.context);
    }

    @Override
    public long getContainerCount(int partitionIndex) throws GSException {
        ContainerCondition cond = new ContainerCondition();
        cond.setAttributes(EnumSet.of(ContainerAttribute.BASE));
        return this.getContainerCount(partitionIndex, cond, false);
    }

    public long getContainerCount(int partitionIndex, ContainerCondition cond, boolean systemMode) throws GSException {
        this.checkOpened();
        this.checkPartitionIndex(partitionIndex);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        SubnetGridStore.tryPutSystemOptionalRequest(req, this.context, systemMode);
        long start = 0L;
        long limit = 0L;
        req.putLong(0L);
        req.putLong(0L);
        req.putInt(cond.getAttributes().size());
        if (0 < cond.getAttributes().size()) {
            for (ContainerAttribute attribute : cond.getAttributes()) {
                req.putInt(SubnetGridStore.getContainerAttributeFlag(attribute));
            }
        } else {
            throw new GSException(145001, "Container attribute is not specified.");
        }
        this.channel.executeStatement(this.context, Statement.GET_PARTITION_CONTAINER_NAMES, partitionIndex, 0L, req, resp, null);
        long totalCount = resp.base().getLong();
        if (totalCount < 0L) {
            throw new GSException(145031, "Negative result by protocol error");
        }
        return totalCount;
    }

    @Override
    public List<String> getContainerNames(int partitionIndex, long start, Long limit) throws GSException {
        ContainerCondition cond = new ContainerCondition();
        cond.setAttributes(EnumSet.of(ContainerAttribute.BASE));
        return this.getContainerNames(partitionIndex, start, limit, cond, false);
    }

    public List<String> getContainerNames(int partitionIndex, long start, Long limit, ContainerCondition cond, boolean systemMode) throws GSException {
        this.checkOpened();
        this.checkPartitionIndex(partitionIndex);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        SubnetGridStore.tryPutSystemOptionalRequest(req, this.context, systemMode);
        req.putLong(start);
        req.putLong(limit == null ? Long.MAX_VALUE : limit);
        req.putInt(cond.getAttributes().size());
        if (0 < cond.getAttributes().size()) {
            for (ContainerAttribute attribute : cond.getAttributes()) {
                req.putInt(SubnetGridStore.getContainerAttributeFlag(attribute));
            }
        } else {
            throw new GSException(145001, "Container attribute is not specified.");
        }
        this.channel.executeStatement(this.context, Statement.GET_PARTITION_CONTAINER_NAMES, partitionIndex, 0L, req, resp, null);
        resp.base().getLong();
        int entryCount = resp.base().getInt();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < entryCount; ++i) {
            list.add(resp.getString());
        }
        return list;
    }

    private List<InetAddress> toAddressList(InetSocketAddress[] sockAddrList) {
        ArrayList<InetAddress> addrList = new ArrayList<InetAddress>();
        for (InetSocketAddress sockAddr : sockAddrList) {
            if (sockAddr == null || addrList.contains(sockAddr.getAddress())) continue;
            addrList.add(sockAddr.getAddress());
        }
        return addrList;
    }

    @Override
    public List<InetAddress> getHosts(int partitionIndex) throws GSException {
        this.checkOpened();
        this.checkPartitionIndex(partitionIndex);
        InetSocketAddress[] baseList = this.channel.getNodeAddressList(this.context, partitionIndex);
        return this.toAddressList(baseList);
    }

    @Override
    public InetAddress getOwnerHost(int partitionIndex) throws GSException {
        this.checkOpened();
        this.checkPartitionIndex(partitionIndex);
        InetSocketAddress[] baseList = this.channel.getNodeAddressList(this.context, partitionIndex);
        if (baseList.length == 0 || baseList[0] == null) {
            return null;
        }
        return baseList[0].getAddress();
    }

    @Override
    public List<InetAddress> getBackupHosts(int partitionIndex) throws GSException {
        this.checkOpened();
        this.checkPartitionIndex(partitionIndex);
        InetSocketAddress[] baseList = this.channel.getNodeAddressList(this.context, partitionIndex);
        if (baseList.length > 0) {
            baseList[0] = null;
        }
        return this.toAddressList(baseList);
    }

    @Override
    public void assignPreferableHost(int partitionIndex, InetAddress host) throws GSException {
        this.checkOpened();
        this.checkPartitionIndex(partitionIndex);
        this.context.setPreferableHost(partitionIndex, host);
    }

    @Override
    public int getPartitionIndexOfContainer(String containerName) throws GSException {
        this.checkOpened();
        try {
            return this.channel.resolvePartitionId(this.context, containerName);
        }
        catch (NullPointerException e) {
            throw GSErrorCode.checkNullParameter(containerName, "containerName", e);
        }
    }

    @Override
    public void close() throws GSException {
        this.closed = true;
    }
}

