/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.subnet;

import com.toshiba.mwcloud.gs.FetchOption;
import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.Query;
import com.toshiba.mwcloud.gs.RowSet;
import com.toshiba.mwcloud.gs.common.BasicBuffer;
import com.toshiba.mwcloud.gs.common.GSErrorCode;
import com.toshiba.mwcloud.gs.common.RowMapper;
import com.toshiba.mwcloud.gs.common.Statement;
import com.toshiba.mwcloud.gs.subnet.GridStoreChannel;
import com.toshiba.mwcloud.gs.subnet.NodeConnection;
import com.toshiba.mwcloud.gs.subnet.SubnetContainer;
import com.toshiba.mwcloud.gs.subnet.SubnetRowSet;

public class SubnetQuery<R>
implements Query<R>,
SubnetContainer.QueryFormatter {
    private final SubnetContainer<?, ?> container;
    private final Class<R> resultType;
    private final RowMapper mapper;
    private final Statement statement;
    private final SubnetContainer.QueryFormatter formatter;
    private long fetchLimit = Long.MAX_VALUE;
    private long fetchSize = Long.MAX_VALUE;
    private SubnetRowSet<R> lastRowSet;
    private boolean forUpdate;
    private boolean lastRowSetVisible;
    private boolean closed;

    public SubnetQuery(SubnetContainer<?, ?> container, Class<R> resultType, RowMapper mapper, Statement statement, SubnetContainer.QueryFormatter formatter) {
        this.container = container;
        this.resultType = resultType;
        this.mapper = mapper;
        this.statement = statement;
        this.formatter = formatter;
    }

    SubnetContainer<?, ?> getContainer() {
        return this.container;
    }

    Statement getStatement() {
        return this.statement;
    }

    private void checkOpened() throws GSException {
        if (GridStoreChannel.v10ResourceCompatible) {
            return;
        }
        if (this.closed || this.container.isClosed()) {
            throw new GSException(145040, "");
        }
    }

    @Override
    public void setFetchOption(FetchOption option, Object value) throws GSException {
        this.checkOpened();
        if (option == null) {
            throw GSErrorCode.checkNullParameter(value, "option", null);
        }
        if (value == null) {
            throw GSErrorCode.checkNullParameter(value, "value", null);
        }
        switch (option) {
            case LIMIT: {
                long longValue;
                if (value instanceof Integer) {
                    longValue = ((Integer)value).intValue();
                } else if (value instanceof Long) {
                    longValue = (Long)value;
                } else {
                    throw new GSException(145010, "Unsupported limit value type (class=" + value.getClass() + ")");
                }
                if (longValue < 0L) {
                    throw new GSException(145002, "Unsupported limit value (value=" + value + ")");
                }
                this.fetchLimit = longValue;
                break;
            }
            case SIZE: {
                long longValue;
                if (value instanceof Integer) {
                    longValue = ((Integer)value).intValue();
                } else if (value instanceof Long) {
                    longValue = (Long)value;
                } else {
                    throw new GSException(145010, "Unsupported size value type (class=" + value.getClass() + ")");
                }
                if (longValue < 0L) {
                    throw new GSException(145002, "Unsupported size value (value=" + value + ")");
                }
                this.fetchSize = longValue;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
    }

    @Override
    public void close() throws GSException {
        this.closed = true;
        this.clearLastRowSet();
    }

    @Override
    public RowSet<R> fetch() throws GSException {
        return this.fetch(false);
    }

    @Override
    public RowSet<R> fetch(boolean forUpdate) throws GSException {
        this.checkOpened();
        this.clearLastRowSet();
        this.lastRowSet = this.container.queryAndFetch(this.statement, this.resultType, this.mapper, this, this.forUpdate || forUpdate, this.fetchSize);
        this.lastRowSetVisible = true;
        return this.lastRowSet;
    }

    @Override
    public void format(BasicBuffer inBuf) throws GSException {
        inBuf.putLong(this.fetchLimit);
        if (SubnetQuery.isFetchSizeEnabled(NodeConnection.getProtocolVersion())) {
            inBuf.putLong(this.fetchSize);
        }
        this.formatter.format(inBuf);
    }

    @Override
    public String getQueryString() {
        return this.formatter.getQueryString();
    }

    @Override
    public RowSet<R> getRowSet() throws GSException {
        this.checkOpened();
        if (!this.lastRowSetVisible) {
            return null;
        }
        this.lastRowSetVisible = false;
        return this.lastRowSet;
    }

    private void clearLastRowSet() throws GSException {
        SubnetRowSet<R> rowSet = this.lastRowSet;
        this.lastRowSet = null;
        this.lastRowSetVisible = false;
        if (rowSet == null) {
            return;
        }
        if (!GridStoreChannel.v10ResourceCompatible || rowSet.isPartial()) {
            rowSet.close();
        }
    }

    public static boolean isFetchSizeEnabled(int protocolVersion) {
        return protocolVersion >= 2 && (GridStoreChannel.v1ProtocolCompatible == null || GridStoreChannel.v1ProtocolCompatible == false);
    }

    public long getFetchLimit() {
        return this.fetchLimit;
    }

    public void setForUpdate(boolean forUpdate) {
        this.forUpdate = forUpdate;
    }

    public boolean isForUpdate() {
        return this.forUpdate;
    }

    void makeRequest(BasicBuffer req, boolean noUUID) throws GSException {
        this.checkOpened();
        this.clearLastRowSet();
        this.container.makeQueryRequest(this.statement, this, this.forUpdate, this.fetchSize, req, noUUID);
    }

    void acceptResponse(BasicBuffer resp, Object targetConnection, boolean bufSwapAllowed) throws GSException {
        this.clearLastRowSet();
        this.lastRowSet = this.container.acceptQueryResponse(this.statement, this.resultType, this.mapper, this.forUpdate, this.fetchSize, resp, targetConnection, bufSwapAllowed);
        this.lastRowSetVisible = true;
    }
}

