#!/bin/bash

## Default GridDB Cluster Configurations
GRIDDB_HOST=239.0.0.1
GRIDDB_PORT=31999
GRIDDB_CLUSTER=defaultCluster
GRIDDB_USER=admin
GRIDDB_PASSWORD=admin

echo "To run the file, ensure your GridDB server is up and running."

## Project Directory for Building a GridDB Database that will be used by the PostgreSQL Data Wrapper
PROJECT_DIR=sample

##Programs for building the GridDB Database or for flushing it
FLUSH_CLASS=FlushCluster
LOAD_CLASS=LoadDatabase

##Directory where the compiled java executables will be stored and run from.
CLASSES_DIR=class

echo "Compiling $PROJECT_DIR project directory"
ant clean
ant make

echo "Compilation Complete."
cd $CLASSES_DIR

echo "Flushing GridDB Containers with $FLUSH_CLASS"
echo java -cp :${PWD}/../lib/gridstore.jar:${PWD}/../lib/opencsv-2.3.jar $PROJECT_DIR/$FLUSH_CLASS $GRIDDB_HOST $GRIDDB_PORT $GRIDDB_CLUSTER $GRIDDB_USER $GRIDDB_PASSWORD
java -cp :${PWD}/../lib/gridstore.jar:${PWD}/../lib/opencsv-2.3.jar $PROJECT_DIR/$FLUSH_CLASS $GRIDDB_HOST $GRIDDB_PORT $GRIDDB_CLUSTER $GRIDDB_USER $GRIDDB_PASSWORD

echo "Loading GridDB Container with $LOAD_CLASS to be reference with PostgreSQL Foreign Data Wrapper."
echo java -cp :${PWD}/../lib/gridstore.jar:${PWD}/../lib/opencsv-2.3.jar $PROJECT_DIR/$LOAD_CLASS $GRIDDB_HOST $GRIDDB_PORT $GRIDDB_CLUSTER $GRIDDB_USER $GRIDDB_PASSWORD
java -cp :${PWD}/../lib/gridstore.jar:${PWD}/../lib/opencsv-2.3.jar $PROJECT_DIR/$LOAD_CLASS $GRIDDB_HOST $GRIDDB_PORT $GRIDDB_CLUSTER $GRIDDB_USER $GRIDDB_PASSWORD

echo "GridDB Database has been built and containers built from the programs in the $PROJECT_DIR directory."
echo "These containers can now be tested with the GridDB Foreign Data Wrapper for PostgreSQL."
