package sample.logic;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialException;

import au.com.bytecode.opencsv.CSVReader;
import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.GridStore;
import com.toshiba.mwcloud.gs.TimeSeries;
import com.toshiba.mwcloud.gs.TimeUnit;
import com.toshiba.mwcloud.gs.TimestampUtils;

import sample.row.InstrumentLog;


public class InstrumentLogLoader {
	//Directory of where image files are located
	private static final String IMAGE_PREFIX = "../data/img/";

	public static void load(GridStore gridstore,String name,String path) throws GSException, IOException, ParseException, SerialException, SQLException {
		SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm", Locale.US); //Format to parse timestamps
		String[] line = null;
		CSVReader reader = null;

		try {
			//Create a Timeseries container for storing timestamped weather readings
			TimeSeries<InstrumentLog> timeseries = gridstore.putTimeSeries(name,InstrumentLog.class); 
			reader = new CSVReader(new FileReader(path)); //Open that data source *.csv file that will eventually stored into the Timeseries container

			while ((line = reader.readNext()) != null) {
				//Create a new timestamp reading 
				InstrumentLog log = new InstrumentLog();
				log.weatherstationid = line[0]; //Obtain sensor id of where the timestamp reading was recorded
				log.timestamp = TimestampUtils.current(); //Have timestamp be the current time
				//log.timestamp = format.parse(line[1]);
				log.temperature = Double.valueOf(line[2]); //Parse temperature reading

				// Write Blob data if an input image file is specified
				ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
				String filePath = line[3];
				if ((filePath != null) && (!filePath.isEmpty())) {
					File imageFile = new File(IMAGE_PREFIX + filePath);
					if (imageFile.exists() && imageFile.isFile()) {
						InputStream inputStream = null;
						try {
							inputStream = new BufferedInputStream(new FileInputStream(imageFile));
							byte[] buff = new byte[1024];
							while ((inputStream.read(buff)) != -1) {
								outputStream.write(buff);
							}
						} catch(Exception e){
							e.printStackTrace();
						} finally {
							if (inputStream != null) {
								inputStream.close();
							}
						}
					}
				}

				log.liveimage = new SerialBlob(outputStream.toByteArray());

				timeseries.put(log.timestamp,log); //Insert row into the timeseries container
			}
		} catch(Exception e){
			e.printStackTrace();
		} finally {
			if(reader != null){
				reader.close(); //Close data source file.
			}
		}
	}
}