package sample.logic;

import java.io.FileReader;
import java.io.IOException;

import au.com.bytecode.opencsv.CSVReader;

import com.toshiba.mwcloud.gs.TimeSeries;
import com.toshiba.mwcloud.gs.TimestampUtils;
import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.GridStore;

import sample.row.QualitySample;


public class QualitySampleLoader {
	public static void load(GridStore gridstore,String name, String path) throws GSException, IOException{
		CSVReader reader = null;
		String nextLine[];

		try {
			//Create a Timeseries container with a row-schema for storing water quality readings
			TimeSeries<QualitySample> timeseries = gridstore.putTimeSeries(name,QualitySample.class); 
			
			reader = new CSVReader(new FileReader(path)); //Open the data source file to load into our GridDB container
			reader.readNext(); //Skip the first row containing the headers

			while((nextLine = reader.readNext()) != null){
				QualitySample sample = new QualitySample(); //Create a new Timeseries for storing the water quality sample

				sample.timestamp = TimestampUtils.current(); //Timestamp will the current time
				sample.beach_name  = nextLine[1]; // Obtain location name of the sample reading

				sample.water_temperature = Double.valueOf(nextLine[3]); //Obtain water temperature of the sample at that time 
				sample.turbidity  = Double.valueOf(nextLine[4]); //Obtain the turbidity of the sample at that time
				sample.depth = Double.valueOf(nextLine[5]); //Obtain the depth of the water sample at the specified time

				sample.wave_height = Double.valueOf(nextLine[6]); //Height of the wave when the sample was recorded
				sample.wave_period = Double.valueOf(nextLine[7]); //Period of the wave when the sample was recorded

				sample.battery_life = Double.valueOf(nextLine[8]); //Remaining battery life estimate when the sample was recorded

				timeseries.put(sample.timestamp,sample);	//Insert timestamp reading into GridDB Timeseries container.			
			}

		} catch(Exception e){
			e.printStackTrace(); 
		} finally {
			if(reader != null){
				reader.close(); //Close data source file
			}
		}
	}
}