package sample.logic;

import java.io.FileReader;
import java.io.IOException;

import au.com.bytecode.opencsv.CSVReader;

import com.toshiba.mwcloud.gs.Collection;
import com.toshiba.mwcloud.gs.TimestampUtils;
import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.GridStore;

import sample.row.WeatherStation;


public class WeatherStationLoader {

	//Load GridDB Container with a user-specified container with data from a *.csv file from the 'path'
	public static void load(GridStore gridstore,String name, String path) throws GSException, IOException{
		CSVReader reader = null;
		String nextLine[] = null;

		try {
			//Create a Collection Container with the WeatherStation Schema
			Collection<String,WeatherStation> collection = gridstore.putCollection(name,WeatherStation.class);
			
			reader = new CSVReader(new FileReader(path)); // Open the data source *.csv file to load its data into its container rows.

			while((nextLine = reader.readNext()) != null){
				WeatherStation station = new WeatherStation(); //Create a new row in the Collection container for storing Weather sensor information

				station.id = String.format("weather_station_%s",nextLine[0]); //Sensor id of the weather sensor. 
				//This 'id' will also correspond to a timeseries container that will store the sensors recorded temperature readings
				
				station.name = nextLine[1]; // Get canonical name of the area that the sensor is located in 
				station.latitude = Double.valueOf(nextLine[2]); //Load Latitude coordinate of the sensor
				station.longitude = Double.valueOf(nextLine[3]);//Obtain longitude coordinate of the sensor
				station.hascamera = Boolean.valueOf(nextLine[4]); //Obtain and determine if the weather station has a camera for storing pictures (as BLOB data)

				collection.put(station.id,station); //Insert weather sensor information into the Collection container in GridDB
			}

		} catch(Exception e){
			e.printStackTrace();
		} finally {
			if(reader != null){
				reader.close(); //Close data source file.
			}
		}
	}
}