#!/usr/bin/python3.6 -u 
from flask import Flask, request, jsonify, json, abort
from flask_cors import CORS, cross_origin
from datetime import datetime
import griddb_python


griddb = griddb_python
factory = griddb.StoreFactory.get_instance()
app = Flask(__name__)
cors = CORS(app)
app.config['CORS_HEADERS'] = 'Content-Type'

methods = ('GET', 'POST')

@app.route('/', methods=methods)
@cross_origin()
def hello_world():
    return("GridDB Data source")

@app.route('/search', methods=methods)
@cross_origin()
def find_metrics():
    req = request.get_json()
    print("/search req: "+ repr(req))

    if req['target'] == "hosts":
        retval=[]
        ts = gridstore.get_container("SYS_METRICS_INDEX")
        tql = "select *"
        query = ts.query(tql) 
        rs = query.fetch(False) 
        while rs.has_next():
            data = rs.next()
            retval.append(data[0])
        return jsonify(retval)
    return jsonify([])


@app.route('/query', methods=methods)
@cross_origin(max_age=600)
def query_metrics():
    req = request.get_json()

    print("/query req: "+ repr(req))

    results = []

    start =  int(datetime.strptime(req['range']['from'], "%Y-%m-%dT%H:%M:%S.%fZ").timestamp()*1000)
    end = int(datetime.strptime(req['range']['to'], "%Y-%m-%dT%H:%M:%S.%fZ").timestamp()*1000)

    if 'intervalMs' in req:
        freq = "TIME_SAMPLING(*, TO_TIMESTAMP_MS("+ str(start) +"), TO_TIMESTAMP_MS("+ str(end) +"), "+ str(req.get('intervalMs'))+", MILLISECOND)"
    else:
        freq = "*"


    for target in req['targets']:
        datapoints= []
        if ':' not in target.get('target', ''):
            abort(404, Exception('Target must be of type: <container>:<column no> got instead: ' + target['target']))

        req_type = target.get('type', 'timeserie')
        container, column = target['target'].split(':', 1)

        ts = gridstore.get_container(container)

        tql = "select "+ freq 
        if freq == "*":
            tql = tql + " where timestamp > TO_TIMESTAMP_MS("+str(start)+") and timestamp < TO_TIMESTAMP_MS("+str(end)+")"

        query = ts.query(tql) 
        rs = query.fetch(False) 
        columns = rs.get_column_names()

        a=0
        
        while rs.has_next():
            data = rs.next()
            datapoints.append((data[int(columns.index(column))], int(data[0].timestamp()*1000)))
            a=a+1
        column = {'target': '%s' % (container+" "+column), 'datapoints': datapoints}
        results.append(column)

    return jsonify(results)

@app.route('/annotations', methods=methods)
@cross_origin(max_age=600)
def query_annotations():
    req = request.get_json()

    response = []
    start =  int(datetime.strptime(req['range']['from'], "%Y-%m-%dT%H:%M:%S.%fZ").timestamp()*1000)
    end = int(datetime.strptime(req['range']['to'], "%Y-%m-%dT%H:%M:%S.%fZ").timestamp()*1000)


    container, query = req['annotation']['query'].split(':', 1)

    ts = gridstore.get_container(container)

    tql = "select * where timestamp > TO_TIMESTAMP_MS("+str(start)+") and timestamp < TO_TIMESTAMP_MS("+str(end)+") and ( "+query+" )"
    query = ts.query(tql) 
    rs = query.fetch(False) 
    last = None

    while rs.has_next():
        data = rs.next()
        if not last or data[0].timestamp() - last[0].timestamp() > 60:
            response.append({
                "annotation": container, # The original annotation sent from Grafana.
                "time": int(data[0].timestamp()*1000), # Time since UNIX Epoch in milliseconds. (required)
                "title": container, # The title for the annotation tooltip. (required)
            })
        last = data

    return jsonify(response)


@app.route('/panels', methods=methods)
@cross_origin()
def get_panel():
    req = request.args 
    return

if __name__ == '__main__':
    gridstore = factory.get_store(
        host="239.0.0.1",
        port=31999,
        cluster_name="defaultCluster",
        username="admin",
        password="admin"
    )

    app.run(host='0.0.0.0', port=3003, debug=True)
