#!/usr/bin/python3.6 
import psutil
import threading
import os
import datetime
import griddb_python
import socket
import re

class PsUtilLogger:

    def __init__(self, delay):
        self.i = 1;
        self.delay = delay
        self.stop = False

        self.hostname = socket.gethostname()
        self.ipAddress = socket.gethostbyname(self.hostname)
        self.cnid = re.sub("\.", "_", self.ipAddress)

        griddb = griddb_python
        factory = griddb.StoreFactory.get_instance()
        self.gridstore = factory.get_store(
            host="239.0.0.1",
            port=31999,
            cluster_name="defaultCluster",
            username="admin",
            password="admin"
        )

        idxConInfo = griddb.ContainerInfo("SYS_METRICS_INDEX",
                        [["id", griddb.Type.STRING],
                        ["hostname", griddb.Type.STRING],
                        ["ipAddress", griddb.Type.STRING],
                        ["lastUpdate", griddb.Type.TIMESTAMP]],
                        griddb.ContainerType.COLLECTION, True)
        self.idxCl= self.gridstore.put_container(idxConInfo)
        self.idxCl.set_auto_commit(False)

                        
        cpuConInfo = griddb.ContainerInfo("CPU_"+self.cnid,
                        [["timestamp", griddb.Type.TIMESTAMP],
                        ["percent", griddb.Type.FLOAT],
                        ["user", griddb.Type.FLOAT],
                        ["nice", griddb.Type.FLOAT],
                        ["system", griddb.Type.FLOAT],
                        ["idle", griddb.Type.FLOAT],
                        ["iowait", griddb.Type.FLOAT],
                        ["load1", griddb.Type.FLOAT],
                        ["load5", griddb.Type.FLOAT],
                        ["load15", griddb.Type.FLOAT]],
                        griddb.ContainerType.TIME_SERIES, True)
        self.cpuTs= self.gridstore.put_container(cpuConInfo)
        self.cpuTs.set_auto_commit(False)

        memConInfo = griddb.ContainerInfo("MEM_"+self.cnid,
                        [["timestamp", griddb.Type.TIMESTAMP],
                        ["percent", griddb.Type.FLOAT],
                        ["total", griddb.Type.LONG],
                        ["available", griddb.Type.LONG],
                        ["used", griddb.Type.LONG],
                        ["free", griddb.Type.LONG],
                        ["buffers", griddb.Type.LONG],
                        ["cached", griddb.Type.LONG]],
                        griddb.ContainerType.TIME_SERIES, True)
        self.memTs = self.gridstore.put_container(memConInfo)
        self.memTs.set_auto_commit(False)

        diskConInfo = griddb.ContainerInfo("DISK_"+self.cnid,
                        [["timestamp", griddb.Type.TIMESTAMP],
                        ["mount", griddb.Type.STRING],
                        ["percent", griddb.Type.FLOAT],
                        ["total", griddb.Type.LONG],
                        ["used", griddb.Type.LONG]],
                        griddb.ContainerType.TIME_SERIES, True)
        self.diskTs = self.gridstore.put_container(diskConInfo)
        self.diskTs.set_auto_commit(False)

        
        self.run()
    def run(self):
        self.write()
        self.i=self.i+1
        if not self.stop:
            threading.Timer(self.delay, self.run).start()

    def write(self):

        now = datetime.datetime.utcnow()
        idx = [self.cnid, self.hostname, self.ipAddress, now]
        scputimes = psutil.cpu_times_percent()
        loadavg = os.getloadavg()
        cpu = [ now, 100.0-scputimes.idle, scputimes.user, scputimes.nice,  scputimes.system, scputimes.idle, scputimes.iowait, loadavg[0], loadavg[1], loadavg[2] ]

        svmem = psutil.virtual_memory()
        mem = [ now, svmem.percent, svmem.total, svmem.available, svmem.used, svmem.free, svmem.buffers, svmem.cached ]

        mounts = []
        mounts_used = []
        mounts_total = [] 
#        for sdiskpart in psutil.disk_partitions():
#            sdiskusage = psutil.disk_usage(sdiskpart.mountpoint)
#            mounts.append([now, sdiskpart.mountpoint, sdiskusage.percent, sdiskusage.total, sdiskusage.used])
#            now = datetime.datetime.utcnow()
        sdiskusage = psutil.disk_usage("/")
        mounts.append([now, "/", sdiskusage.percent, sdiskusage.total, sdiskusage.used])

        self.cpuTs.put(cpu)
        self.cpuTs.commit()

        self.memTs.put(mem)
        self.memTs.commit()

        self.diskTs.multi_put(mounts)
        self.diskTs.commit()

        self.idxCl.put(idx)
        self.idxCl.commit()

        return

    def stop(self):
        self.stop = True
        return


if __name__ == "__main__":
    p = PsUtilLogger(10)
    print("Started PSUtilLogger")
