#!/usr/bin/python3

import griddb_python as griddb
import sys

factory = griddb.StoreFactory.get_instance()

argv = sys.argv

blob = bytearray([65, 66, 67, 68, 69, 70, 71, 72, 73, 74])
update = True

try:
	#Get GridStore object
	gridstore = factory.get_store(
        notification_member="griddb-server:10001",
        cluster_name="defaultCluster",
        username="admin",
        password="admin"
    )
     
	#Create Collection
	conInfo = griddb.ContainerInfo("pycol01",
					[["name", griddb.Type.STRING],
		            ["status", griddb.Type.BOOL],
		            ["count", griddb.Type.LONG],
		            ["lob", griddb.Type.BLOB]],
		            griddb.ContainerType.COLLECTION, True)
	col = gridstore.put_container(conInfo)

	#Change auto commit mode to false
	col.set_auto_commit(False)

	#Set an index on the Row-key Column
	col.create_index("name", griddb.IndexType.DEFAULT)

	#Set an index on the Column
	col.create_index("count", griddb.IndexType.DEFAULT)

	#Put row: RowKey is "name01"
	ret = col.put(["name01", False, 1, blob])
	#Remove row with RowKey "name01"
	col.remove("name01")

	#Put row: RowKey is "name02"
	col.put(["name02", False, 1, blob])
	col.commit();

	mlist = col.get("name02")
	#print(mlist)

	#Create normal query
	query=col.query("select * where name = 'name02'")

	#Execute query
	rs = query.fetch(update)
	while rs.has_next():
		data = rs.next()

		data[2] = data[2] + 1
		print("Person: name={0} status={1} count={2} lob=[{3}]".format(data[0], data[1], data[2], ', '.join(str(e) for e in data[3])))
		rs.update(data)

	#End transaction
	col.commit()

except griddb.GSException as e:
	for i in range(e.get_error_stack_size()):
		print("[", i, "]")
		print(e.get_error_code(i))
		print(e.get_location(i))
		print(e.get_message(i))
