
#!/usr/bin/python

import griddb_python as griddb
import sys
import datetime

factory = griddb.StoreFactory.get_instance()

update = True

try:
	#Get GridStore object

    gridstore = factory.get_store(
        host="239.0.0.1",
        port=31999,
        cluster_name="defaultCluster",
        username="admin",
        password="admin"
    )

	#Create Collection
    colConInfo = griddb.ContainerInfo("Person",
	    [["name", griddb.Type.STRING],
		["age", griddb.Type.INTEGER]],
		griddb.ContainerType.COLLECTION, True)
    col = gridstore.put_container(colConInfo)
    #Create TimeSeries
    timeConInfo = griddb.ContainerInfo("HeartRate",
        [["timestamp", griddb.Type.TIMESTAMP],
        ["heartRate", griddb.Type.INTEGER],
        ["activity", griddb.Type.STRING]],
        griddb.ContainerType.TIME_SERIES, True)
    ts = gridstore.put_container(timeConInfo)

    #Put row to timeseries with current timestamp
    now = datetime.datetime.utcnow()
    ts.put([now, 60, "resting"])

    #Create normal query for range of timestamp from 6 hours ago to now
    query = ts.query("select * where timestamp > TIMESTAMPADD(HOUR, NOW(), -6)")
    rs = query.fetch()

    #Get result
    while rs.has_next():
        data = rs.next()
        timestamp = str(data[0])
        heartRate = data[1]
        activity = data[2]
        print("Time={0} heartRate={1} activity={2}".format(timestamp, heartRate, activity))

	#Change auto commit mode to false
    col.set_auto_commit(False)

	#Set an index on the Row-key Column
    col.create_index("name", griddb.IndexType.DEFAULT)

	#Set an index on the Column
    col.create_index("age", griddb.IndexType.DEFAULT)

	#Put row: RowKey is "Person"
    ret = col.put(["John", 30])

	#Create normal query
    query=col.query("select * where name = 'John'")

	#Execute query
    rs = query.fetch(update)
    while rs.has_next():
	    data = rs.next()

	    print("Person: name={0} age={1}".format(data[0], data[1]))

		#Update row
	    rs.update(data)

	#End transaction
    col.commit()

except griddb.GSException as e:
	for i in range(e.get_error_stack_size()):
		print("[", i, "]")
		print(e.get_error_code(i))
		print(e.get_location(i))
		print(e.get_message(i))
