// standard boilerplate
var griddb = require('griddb_node');
var fs = require('fs');
var csv = require('csv-parser')

// our Cluster's credentials
let factory = griddb.StoreFactory.getInstance();
let store = factory.getStore({
    "host": '239.0.0.1',
    "port": 31999,
    "clusterName": "defaultCluster",
    "username": "admin",
    "password": "admin"
});

let promises = [] 
let results = {}

var iterate = function(locID ) {
        return function(rowset) {
            if(rowset != null) {
                while (rowset.hasNext()) {
                    row = rowset.next();
                    results[locID] = row.get(griddb.GS_TYPE_LONG)
                }
        }
    }

}

var query = function (locID) {
    return function(cont) {
        if(cont != null) {
            q = cont.query("SELECT count(*) ");
            return q.fetch()
        }
    }
}

for (let i=0; i < 265; i++) {
    var locID = i
    promise = store.getContainer("col"+i)
    .then(query(i))
    .then(iterate(i))
    .catch(err => {
        if (err.constructor.name == "GSException") {
            for (var i = 0; i < err.getErrorStackSize(); i++) {
                console.log("[", i, "]");
                console.log(err.getErrorCode(i));
                console.log(err.getMessage(i));
            }
        } else {
            console.log(err);
        }
    })
    promises.push(promise)
}

Promise.all(promises).then(values => {

        var items = Object.keys(results).map(function(key) {
          return [key, results[key]];
        });

        items.sort(function(first, second) {
         return second[1] - first[1];
        });
   
        //locations = items.map(function(item) {
        //    return results[item[0]]
        //})
        console.log(items.slice(0, 10))
    
})


