// standard boilerplate
var griddb = require('griddb_node');
var fs = require('fs');
var csv = require('csv-parser')

// our Cluster's credentials
let factory = griddb.StoreFactory.getInstance();
let store = factory.getStore({
    "host": '239.0.0.1',
    "port": 31999,
    "clusterName": "defaultCluster",
    "username": "admin",
    "password": "admin"
});


//
//VendorID: '2',
//  tpep_pickup_datetime: '03/16/2018 01:28:56 AM',
//    tpep_dropoff_datetime: '03/16/2018 01:39:56 AM',
//      passenger_count: '1',
//        trip_distance: '2.53',
//          RatecodeID: '1',
//            store_and_fwd_flag: 'N',
//              PULocationID: '209',
//                DOLocationID: '234',
//                  payment_type: '1',
//                    fare_amount: '10.5',
//                      extra: '0.5',
//                        mta_tax: '0.5',
//                          tip_amount: '2.36',
//                            tolls_amount: '0',
//                              improvement_surcharge: '0.3',
//                                total_amount: '14.16' }


let cols = {}
let count=0
fs.createReadStream('data.csv')
  .pipe(csv())
  .on('data', (data) => {
    let row = []
    row[0] = count++;
    row[1] = parseInt(Date.parse(data['tpep_dropoff_datetime'])-Date.parse(data['tpep_pickup_datetime']))/1000)
    row[2] = parseInt(data['VendorID'], 10);
    row[3] = Date.parse(data['tpep_pickup_datetime'])
    row[4] = Date.parse(data['tpep_dropoff_datetime'])
    row[5] = parseInt(data['passenger_count'], 10)
    if(data['store_and_fwd_flag'] == 'Y')
        row[6] = true
    else
        row[6] = false
    row[7] = parseInt(data['PULocationID'])
    row[8] = parseInt(data['DOLocationID'])
    row[9] = parseInt(data['payment_type'])
    row[10] = Number(data['fare_amount'])
    row[11] = Number(data['extra'])
    row[12] = Number(data['mta_tax'])
    row[13] = Number(data['tip_amount'])
    row[14] = Number(data['tolls_amount'])
    row[15] = Number(data['improvement_surcharge'])
    row[16] = Number(data['total_amount'])
    let date = new Date(row[3])
    row[17] = date.getHours()
    row[18] = date.getDay()

    var colInfo = new griddb.ContainerInfo({
        'name': "col"+data['PULocationID'],
        'columnInfoList': [
            ["id" , griddb.Type.LONG],
            ["duration", griddb.Type.INTEGER],
            ["VendorID", griddb.Type.INTEGER ],
            ["tpep_pickup_datetime", griddb.Type.TIMESTAMP ],
            ["tpep_dropoff_datetime", griddb.Type.TIMESTAMP ],
            ["passenger_count", griddb.Type.LONG],
            ["store_and_fwd_flag" , griddb.Type.BOOL],
            ["PULocationID", griddb.Type.INTEGER],
            ["DOLocationID", griddb.Type.INTEGER],
            ["payment_type", griddb.Type.INTEGER],
            ["fare_amount", griddb.Type.FLOAT],
            ["extra", griddb.Type.FLOAT],
            ["mta_tax", griddb.Type.FLOAT],
            ["tip_amount", griddb.Type.FLOAT],
            ["tolls_aount", griddb.Type.FLOAT],
            ["improvement_surcharge", griddb.Type.FLOAT],
            ["total_amount", griddb.Type.FLOAT], 
            ["hour_of_day", griddb.Type.INTEGER], 
            ["day_of_week", griddb.Type.INTEGER]],
        'type': griddb.ContainerType.COLLECTION, 'rowKey': true
    });
    store.putContainer(colInfo, false)
        .then(cont => {
            cont.put(row)
            console.log(row[0])
        })
    .catch(err => {
        if (err.constructor.name == "GSException") {
            for (var i = 0; i < err.getErrorStackSize(); i++) {
                console.log("[", i, "]");
                console.log(err.getErrorCode(i));
                console.log(err.getMessage(i));
            }
        } else {
            console.log(err);
        }
    });

});

