<?php
	/// Fusion-charts include:
    include("./includes/fusioncharts.php");
?>
<html>
<!--
	/// Valid values for the dataset:

	age: continuous. 
	workclass: Private, Self-emp-not-inc, Local-gov, State-gov, Self-emp-inc, Federal-gov, Without-pay, Never-worked.
	fnlwgt: continuous. 
	education: Bachelors, Some-college, 11th, HS-grad, Prof-school, Assoc-acdm, Assoc-voc, 9th, 7th-8th, 12th, Masters, 1st-4th, 10th, Doctorate, 5th-6th, Preschool. 
	education-num: continuous. 
	marital-status: Married-civ-spouse, Divorced, Never-married, Separated, Widowed, Married-spouse-absent, Married-AF-spouse. 	
	occupation: Tech-support, Craft-repair, Other-service, Sales, Exec-managerial, Prof-specialty, Handlers-cleaners, Machine-op-inspct, Adm-clerical, Farming-fishing, Transport-moving, Priv-house-serv, Protective-serv, Armed-Forces. 
	relationship: Wife, Own-child, Husband, Not-in-family, Other-relative, Unmarried. 
	race: White, Asian-Pac-Islander, Amer-Indian-Eskimo, Other, Black. 
	sex: Female, Male. 
	capital-gain: continuous. 
	capital-loss: continuous. 
	hours-per-week: continuous. 
	native-country: United-States, Cambodia, England, Puerto-Rico, Canada, Germany, Outlying-US(Guam-USVI-etc), India, Japan, Greece, South, China, Cuba, Iran, Honduras, Philippines, Italy, Poland, Jamaica, Vietnam, Mexico, Portugal, Ireland, France, Dominican-Republic, Laos, Ecuador, Taiwan, Haiti, Columbia, Hungary, Guatemala, Nicaragua, Scotland, Thailand, Yugoslavia, El-Salvador, Trinadad&Tobago, Peru, Hong, Holand-Netherlands.
-->
<head>
	<title>Data Visualization with PHP and GridDB</title>
	<!-- Fusion-charts scripts: -->
	<script type="text/javascript" src="//cdn.fusioncharts.com/fusioncharts/latest/fusioncharts.js"></script>
	<script type="text/javascript" src="//cdn.fusioncharts.com/fusioncharts/latest/themes/fusioncharts.theme.fusion.js"></script>
</head>
   
<body>
   
    <?php
	
	/// Female/Male distribution:
	$female_all_income = "9782";
	$female_high_income = "1112";
	$female_low_income = "8670";
	
	$male_all_income = "20381";
	$male_high_income = "6397";
	$male_low_income = "13984";
	
	$female_male_data = "{
	  \"chart\": {
		\"caption\": \"Female/Male distribution\",
		\"subcaption\": \"By Income\",
		\"numvisibleplot\": \"6\",
		\"showvalues\": \"1\",
		\"decimals\": \"1\",
		\"stack100percent\": \"1\",
		\"valuefontcolor\": \"#FFFFFF\",
		\"plottooltext\": \"\$label has \$dataValue (<b>\$percentValue</b>) \$seriesName\",
		\"theme\": \"fusion\"
	  },
	  \"categories\": [
		{
		  \"category\": [
			{
			  \"label\": \"All income\"
			},
			{
			  \"label\": \"High income\"
			},
			{
			  \"label\": \"Low income\"
			}
		  ]
		}
	  ],
	  \"dataset\": [
		{
		  \"seriesname\": \"Male\",
		  \"color\": \"#559EA7\",
		  \"data\": [
			{
			  \"value\": \"$male_all_income\"
			},
			{
			  \"value\": \"$male_high_income\"
			},
			{
			  \"value\": \"$male_low_income\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Female\",
		  \"color\": \"#D14855\",
		  \"data\": [
			{
			  \"value\": \"$female_all_income\"
			},
			{
			  \"value\": \"$female_high_income\"
			},
			{
			  \"value\": \"$female_low_income\"
			}
		  ]
		}
	  ]
	}";
	$female_male_column_chart = new FusionCharts("scrollstackedcolumn2d", "ex3", "50%", 400, "fm_dis", "json", $female_male_data);
	$female_male_column_chart->render();
	
	
	/// Workclass distribution:
	$private = "22696";
	$self_emp_not_inc = "2541";
	$local_gov = "2093";
	$state_gov = "1298";
	$self_emp_inc = "1116";
	$federal_gov = "960";
	$without_pay = "14";
	$never_worked = "7";
	
	$workclass_distribution_data = "{
	  \"chart\": {
		\"caption\": \"Workclass distribution\",
		\"subcaption\": \"Sorted from most common to least common\",
		\"numvisibleplot\": \"1\",
		\"placevaluesinside\": \"1\",
		\"numbersuffix\": \"\",
		\"drawcrossline\": \"0\",
		\"showvalues\": \"0\",
		\"showyaxisvalues\": \"0\",
		\"decimals\": \"0\",
		\"stack100percent\": \"1\",
		\"valuefontcolor\": \"#FFFFFF\",
		\"plottooltext\": \"\$label has \$dataValue (<b>\$percentValue</b>) \$seriesName\",
		\"theme\": \"fusion\"
	  },
	  \"categories\": [
		{
		  \"category\": [
			{
			  \"label\": \"\"
			}
		  ]
		}
	  ],
	  \"dataset\": [
		{
		  \"seriesname\": \"Private\",
		  \"color\": \"#B9A160\",
		  \"data\": [
			{
			  \"value\": \"$private\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Self-emp-not-inc\",
		  \"color\": \"#ACBEA8\",
		  \"data\": [
			{
			  \"value\": \"$self_emp_not_inc\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Local-gov\",
		  \"color\": \"#D58B81\",
		  \"data\": [
			{
			  \"value\": \"$local_gov\"
			}
		  ]
		},
		{
		  \"seriesname\": \"State-gov\",
		  \"color\": \"#D14855\",
		  \"data\": [
			{
			  \"value\": \"$state_gov\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Self-emp-inc\",
		  \"color\": \"#E0A779\",
		  \"data\": [
			{
			  \"value\": \"$self_emp_inc\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Federal-gov\",
		  \"color\": \"#559EA7\",
		  \"data\": [
			{
			  \"value\": \"$federal_gov\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Without-pay\",
		  \"color\": \"#EE8C4D\",
		  \"data\": [
			{
			  \"value\": \"$without_pay\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Never-worked\",
		  \"color\": \"#C29C97\",
		  \"data\": [
			{
			  \"value\": \"$never_worked\"
			}
		  ]
		}
	  ]
	}";
	$workclass_distribution_column_chart = new FusionCharts("stackedbar2d", "ex6", "50%", 200, "wcl_dis", "json", $workclass_distribution_data);
	$workclass_distribution_column_chart->render();
	
	
	/// Race distribution:
	$race_distribution_data = "{
	  \"chart\": {
		\"caption\": \"Race distribution\",
		\"subcaption\": \"Sorted from most common to least common\",
		\"showyaxisvalues\": \"0\",
		\"numvisibleplot\": \"1\",
		\"placevaluesinside\": \"1\",
		\"drawcrossline\": \"0\",
		\"showvalues\": \"0\",
		\"numbersuffix\": \"\",
		\"decimals\": \"0\",
		\"stack100percent\": \"1\",
		\"valuefontcolor\": \"#FFFFFF\",
		\"plottooltext\": \"\$label has \$dataValue (<b>\$percentValue</b>) \$seriesName\",
		\"theme\": \"fusion\"
	  },
	  \"categories\": [
		{
		  \"category\": [
			{
			  \"label\": \"\"
			}
		  ]
		}
	  ],
	  \"dataset\": [
		{
		  \"seriesname\": \"White\",
		  \"color\": \"#559EA7\",
		  \"data\": [
			{
			  \"value\": \"27816\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Black\",
		  \"color\": \"#D14855\",
		  \"data\": [
			{
			  \"value\": \"3124\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Asian-Pac-Islander\",
		  \"color\": \"#D58B81\",
		  \"data\": [
			{
			  \"value\": \"1039\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Amer-Indian-Eskimo\",
		  \"color\": \"#ACBEA8\",
		  \"data\": [
			{
			  \"value\": \"311\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Other\",
		  \"color\": \"#E0A779\",
		  \"data\": [
			{
			  \"value\": \"271\"
			}
		  ]
		}
	  ]
	}";
	$race_distribution_column_chart = new FusionCharts("stackedbar2d", "ex9", "50%", 170, "rce_dis", "json", $race_distribution_data);
	$race_distribution_column_chart->render();
	
	
	/// Nation distribution:
	$val_usa_and_co_citizen = "29184";
	$val_rest_of_world_citizen = "1541";
	
	$nation_distribution_data = "{
	  \"chart\": {
		\"caption\": \"Nation distribution\",
		\"showvalues\": \"0\",
		\"showyaxisvalues\": \"0\",
		\"numbersuffix\": \"\",
		\"decimals\": \"0\",
		\"drawcrossline\": \"0\",
		\"stack100percent\": \"1\",
		\"valuefontcolor\": \"#FFFFFF\",
		\"plottooltext\": \"\$label has \$dataValue (<b>\$percentValue</b>) \$seriesName\",
		\"theme\": \"fusion\"
	  },
	  \"categories\": [
		{
		  \"category\": [
			{
			  \"label\": \"\",
			  \"showXaxisValue\": \"0\"
			}
		  ]
		}
	  ],
	  \"dataset\": [
		{
		  \"seriesname\": \"United-States and Outlying-US\",
		  \"color\": \"#B9A160\",
		  \"data\": [
			{
			  \"value\": \"$val_usa_and_co_citizen\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Rest of the World \\n (39 nations)\",
		  \"color\": \"#ACBEA8\",
		  \"data\": [
			{
			  \"value\": \"$val_rest_of_world_citizen\"
			}
		  ]
		}
	  ]
	}";
	$nation_distribution_column_chart = new FusionCharts("stackedbar2d", "ex10", "50%", 170, "nat_dis", "json", $nation_distribution_data);
	$nation_distribution_column_chart->render();
	
	
	/// Education distribution:
	$hs_grad = "20381";
	$some_college = "9782";
	$bachelors = "5355";
	$masters = "1723";
	$assoc_voc = "1382";
	$eleventh = "1175";
	$assoc_acdm = "1067";
	$tenth = "933";
	$seventh_eighth = "646";
	$prof_school = "576";
	$ninth = "514";
	$twelfth = "433";
	$doctorate = "413";
	$fifth_sixth = "333";
	$first_fourth = "168";
	$preschool = "51";
	
	$education_distribution_data = "{
	  \"chart\": {
		\"caption\": \"Education distribution\",
		\"subcaption\": \"Sorted from most common to least common\",
		\"numvisibleplot\": \"1\",
		\"placevaluesinside\": \"1\",
		\"showvalues\": \"0\",
		\"showyaxisvalues\": \"0\",
		\"drawcrossline\": \"0\",
		\"numbersuffix\": \"\",
		\"decimals\": \"0\",
		\"stack100percent\": \"1\",
		\"valuefontcolor\": \"#FFFFFF\",
		\"plottooltext\": \"\$label has \$dataValue (<b>\$percentValue</b>) \$seriesName\",
		\"theme\": \"fusion\"
	  },
	  \"categories\": [
		{
		  \"category\": [
			{
			  \"label\": \"\"
			}
		  ]
		}
	  ],
	  \"dataset\": [
		{
		  \"seriesname\": \"HS-grad\",
		  \"color\": \"#559EA7\",
		  \"data\": [
			{
			  \"value\": \"$hs_grad\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Some-college\",
		  \"color\": \"#D14855\",
		  \"data\": [
			{
			  \"value\": \"$some_college\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Bachelors\",
		  \"color\": \"#F3F4ED\",
		  \"data\": [
			{
			  \"value\": \"$bachelors\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Masters\",
		  \"color\": \"#D58B81\",
		  \"data\": [
			{
			  \"value\": \"$masters\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Assoc-voc\",
		  \"color\": \"#ACBEA8\",
		  \"data\": [
			{
			  \"value\": \"$assoc_voc\"
			}
		  ]
		},
		{
		  \"seriesname\": \"11th\",
		  \"color\": \"#E0A779\",
		  \"data\": [
			{
			  \"value\": \"$eleventh\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Assoc-acdm\",
		  \"color\": \"#B9A160\",
		  \"data\": [
			{
			  \"value\": \"$assoc_acdm\"
			}
		  ]
		},
		{
		  \"seriesname\": \"10th\",
		  \"color\": \"#E98C37\",
		  \"data\": [
			{
			  \"value\": \"$tenth\"
			}
		  ]
		},
		{
		  \"seriesname\": \"7th-8th\",
		  \"color\": \"#EE8C4D\",
		  \"data\": [
			{
			  \"value\": \"$seventh_eight\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Prof-school\",
		  \"color\": \"#C29C97\",
		  \"data\": [
			{
			  \"value\": \"$prof_school\"
			}
		  ]
		},
		{
		  \"seriesname\": \"9th\",
		  \"color\": \"#A5AC97\",
		  \"data\": [
			{
			  \"value\": \"$ninth\"
			}
		  ]
		},
		{
		  \"seriesname\": \"12th\",
		  \"color\": \"#F1C69F\",
		  \"data\": [
			{
			  \"value\": \"$twelfth\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Doctorate\",
		  \"color\": \"#BBC6A8\",
		  \"data\": [
			{
			  \"value\": \"$doctorate\"
			}
		  ]
		},
		{
		  \"seriesname\": \"5th-6th\",
		  \"color\": \"#969584\",
		  \"data\": [
			{
			  \"value\": \"$fifth_sixth\"
			}
		  ]
		},
		{
		  \"seriesname\": \"1st-4th\",
		  \"color\": \"#F34D37\",
		  \"data\": [
			{
			  \"value\": \"$first_fourth\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Preschool\",
		  \"color\": \"#CFBD61\",
		  \"data\": [
			{
			  \"value\": \"$preschool\"
			}
		  ]
		}
	  ]
	}";
	$education_distribution_column_chart = new FusionCharts("stackedbar2d", "ex4", "50%", 240, "edu_dis", "json", $education_distribution_data);
	$education_distribution_column_chart->render();
	
	
	/// Family distribution data:
	$married_civ_spouse = "14976";
	$never_married = "10683";
	$divorced = "4443";
	$separated = "1025";
	$widowed = "993";
	$married_spouse_absent = "418";
	$married_af_spouse = "23";
	
	$family_distribution_data = "{
	  \"chart\": {
		\"caption\": \"Familiy distribution\",
		\"subcaption\": \"Sorted from most common to least common\",
		\"numvisibleplot\": \"1\",
		\"placevaluesinside\": \"1\",
		\"numbersuffix\": \"\",
		\"drawcrossline\": \"0\",
		\"showvalues\": \"0\",
		\"showyaxisvalues\": \"0\",
		\"decimals\": \"0\",
		\"stack100percent\": \"1\",
		\"valuefontcolor\": \"#FFFFFF\",
		\"plottooltext\": \"\$label has \$dataValue (<b>\$percentValue</b>) \$seriesName\",
		\"theme\": \"fusion\"
	  },
	  \"categories\": [
		{
		  \"category\": [
			{
			  \"label\": \"\"
			}
		  ]
		}
	  ],
	  \"dataset\": [
		{
		  \"seriesname\": \"Married-civ-spouse\",
		  \"color\": \"#B9A160\",
		  \"data\": [
			{
			  \"value\": \"$married_civ_spouse\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Never-married\",
		  \"color\": \"#E0A779\",
		  \"data\": [
			{
			  \"value\": \"$never_married\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Divorced\",
		  \"color\": \"#ACBEA8\",
		  \"data\": [
			{
			  \"value\": \"$divorced\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Separated\",
		  \"color\": \"#D58B81\",
		  \"data\": [
			{
			  \"value\": \"$separated\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Widowed\",
		  \"color\": \"#D14855\",
		  \"data\": [
			{
			  \"value\": \"$widowed\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Married-spouse-absent\",
		  \"color\": \"#559EA7\",
		  \"data\": [
			{
			  \"value\": \"$married_spouse_absent\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Married-AF-spouse\",
		  \"color\": \"#B5BE59\",
		  \"data\": [
			{
			  \"value\": \"$married_af_spouse\"
			}
		  ]
		}
	  ]
	}";
	$family_distribution_column_chart = new FusionCharts("stackedbar2d", "ex5", "50%", 240, "fam_dis", "json", $family_distribution_data);
	$family_distribution_column_chart->render();
	
	
	/// Occupation distribution:
	$prof_specialty = "4140";
	$craft_repair = "4099";
	$exec_mangerial = "4066";
	$adm_clerical = "3770";
	$sales = "3650";
	$other_service = "3295";
	$machine_op_inspct = "2002";
	$transport_moving = "1597";
	$handlers_cleaners = "1370";
	$farming_fishing = "994";
	$tech_support = "928";
	$protective_serv = "649";
	$priv_house_serv = "149";
	$armed_forces = "9";
	
	$occupation_distribution_data = "{
	  \"chart\": {
		\"caption\": \"Occupation distribution\",
		\"subcaption\": \"Sorted from most common to least common\",
		\"numvisibleplot\": \"1\",
		\"placevaluesinside\": \"1\",
		\"showvalues\": \"0\",
		\"showyaxisvalues\": \"0\",
		\"numbersuffix\": \"\",
		\"drawcrossline\": \"0\",
		\"decimals\": \"0\",
		\"stack100percent\": \"1\",
		\"valuefontcolor\": \"#FFFFFF\",
		\"plottooltext\": \"\$label has \$dataValue (<b>\$percentValue</b>) \$seriesName\",
		\"theme\": \"fusion\"
	  },
	  \"categories\": [
		{
		  \"category\": [
			{
			  \"label\": \"\"
			}
		  ]
		}
	  ],
	  \"dataset\": [
		{
		  \"seriesname\": \"Prof-specialty\",
		  \"color\": \"#559EA7\",
		  \"data\": [
			{
			  \"value\": \"$prof_specialty\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Craft-repair\",
		  \"color\": \"#D14855\",
		  \"data\": [
			{
			  \"value\": \"$craft_repair\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Exec-managerial\",
		  \"color\": \"#F3F4ED\",
		  \"data\": [
			{
			  \"value\": \"$exec_mangerial\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Adm-clerical\",
		  \"color\": \"#D58B81\",
		  \"data\": [
			{
			  \"value\": \"$adm_clerical\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Sales\",
		  \"color\": \"#ACBEA8\",
		  \"data\": [
			{
			  \"value\": \"$sales\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Other-service\",
		  \"color\": \"#E0A779\",
		  \"data\": [
			{
			  \"value\": \"$other_service\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Machine-op-inspct\",
		  \"color\": \"#B9A160\",
		  \"data\": [
			{
			  \"value\": \"$machine_op_inspct\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Transport-moving\",
		  \"color\": \"#E98C37\",
		  \"data\": [
			{
			  \"value\": \"$transport_moving\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Handlers-cleaners\",
		  \"color\": \"#EE8C4D\",
		  \"data\": [
			{
			  \"value\": \"$handlers_cleaners\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Farming-fishing\",
		  \"color\": \"#C29C97\",
		  \"data\": [
			{
			  \"value\": \"$farming_fishing\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Tech-support\",
		  \"color\": \"#A5AC97\",
		  \"data\": [
			{
			  \"value\": \"$tech_support\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Protective-serv\",
		  \"color\": \"#F1C69F\",
		  \"data\": [
			{
			  \"value\": \"$protective_serv\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Priv-house-serv\",
		  \"color\": \"#BBC6A8\",
		  \"data\": [
			{
			  \"value\": \"$priv_house_serv\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Armed-Forces\",
		  \"color\": \"#969584\",
		  \"data\": [
			{
			  \"value\": \"$armed_forces\"
			}
		  ]
		}
	  ]
	}";
	$occupation_column_charts = new FusionCharts("stackedbar2d", "ex7", "50%", 240, "occ_dis", "json", $occupation_distribution_data);
	$occupation_column_charts->render();
	
	
	/// Relationship distribution:
	$husband = "13193";
	$not_in_family = "8305";
	$own_child = "5068";
	$unmarried = "3446";
	$wife = "1568";
	$other_relative = "981";
	
	$relationship_distribution_data = "{
	  \"chart\": {
		\"caption\": \"Relationship distribution\",
		\"subcaption\": \"Sorted from most common to least common\",
		\"numvisibleplot\": \"1\",
		\"placevaluesinside\": \"1\",
		\"showyaxisvalues\": \"0\",
		\"showvalues\": \"0\",
		\"numbersuffix\": \"\",
		\"drawcrossline\": \"0\",
		\"decimals\": \"0\",
		\"stack100percent\": \"1\",
		\"valuefontcolor\": \"#FFFFFF\",
		\"plottooltext\": \"\$label has \$dataValue (<b>\$percentValue</b>) \$seriesName\",
		\"theme\": \"fusion\"
	  },
	  \"categories\": [
		{
		  \"category\": [
			{
			  \"label\": \"\"
			}
		  ]
		}
	  ],
	  \"dataset\": [
		{
		  \"seriesname\": \"Husband\",
		  \"color\": \"#B9A160\",
		  \"data\": [
			{
			  \"value\": \"$husband\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Not-in-family\",
		  \"color\": \"#E0A779\",
		  \"data\": [
			{
			  \"value\": \"$not_in_family\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Own-child\",
		  \"color\": \"#ACBEA8\",
		  \"data\": [
			{
			  \"value\": \"$own_child\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Unmarried\",
		  \"color\": \"#D58B81\",
		  \"data\": [
			{
			  \"value\": \"$unmarried\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Wife\",
		  \"color\": \"#F3F4ED\",
		  \"data\": [
			{
			  \"value\": \"$wife\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Other-relative\",
		  \"color\": \"#D14855\",
		  \"data\": [
			{
			  \"value\": \"$other_relative\"
			}
		  ]
		}
	  ]
	}";
	$relationship_distribution_column_chart = new FusionCharts("stackedbar2d", "ex8", "50%", 170, "rel_dis", "json", $relationship_distribution_data);
	$relationship_distribution_column_chart->render();
	
	
	/// Prediction accuracy by education:
	$all_educations_test_data = "0.874,0.864,0.865,0.860,0.843,0.853,0.836,0.864,0.848,0.848";
	$high_school_test_data = "0.860,0.844,0.876,0.875,0.860,0.881,0.841,0.873,0.878,0.855";
	$some_college_test_data = "0.853,0.853,0.871,0.861,0.870,0.846,0.848,0.846,0.853,0.858";
	$bachelors_test_data = "0.839,0.865,0.853,0.878,0.870,0.860,0.863,0.845,0.870,0.868";
	
	$all_educations_validation_data = "0.816,0.820,0.820,0.824,0.830,0.822,0.822,0.826,0.822,0.822";
	$high_school_validation_data = "0.854,0.854,0.856,0.850,0.856,0.854,0.860,0.858,0.858,0.862";
	$some_college_validation_data = "0.810,0.826,0.816,0.812,0.814,0.824,0.820,0.822,0.816,0.804";
	$bachelors_validation_data = "0.716,0.724,0.722,0.738,0.728,0.738,0.728,0.726,0.714,0.724";
	
	$accuracy_education_data = "{
	  \"chart\": {
		\"caption\": \"Prediction accuracy\",
		\"subcaption\": \"Depending on education\",
		\"palettecolors\": \"#5D62B5, #979AD0\",
		\"theme\": \"fusion\",
		\"showmean\": \"0\",
		\"drawmeanconnector\": \"0\",
		\"yaxisname\": \"Accuracy\",
		\"yaxismaxvalue\": \"0.88\",
		\"yaxisminvalue\": \"0.70\",
		\"plotspacepercent\": \"65\",
		\"meaniconshape\": \"polygon\",
		\"meaniconsides\": \"2\",
		\"meaniconradius\": \"2\",
		\"outliericonsides\": \"20\",
		\"outliericonalpha\": \"50\",
		\"outliericonshape\": \"triangle\",
		\"outliericonradius\": \"4\",
		\"mediancolor\": \"#FFFFFF\",
		\"plottooltext\": \"<b>Distribution for \$label:</b><br>Max: <b>\$maxDataValue</b><br>Q3: <b>\$Q3</b><br>Median: <b>\$median</b><br>Q1: <b>\$Q1</b><br>Min: <b>\$minDataValue</b>\"
	  },
	  \"categories\": [
		{
		  \"category\": [
			{
			  \"label\": \"All educations\"
			},
			{
			  \"label\": \"High school graduates\"
			},
			{
			  \"label\": \"Not graduated college attendees\"
			},
			{
			  \"label\": \"Bachelor degree holders\"
			}
		  ]
		}
	  ],
	  \"dataset\": [
		{
		  \"seriesname\": \"Test\",
		  \"lowerboxcolor\": \"#559EA7\",
          \"upperboxcolor\": \"#9EB6A8\",
		  \"data\": [
			{
			  \"value\": \"$all_educations_test_data\"
			},
			{
			  \"value\": \"$high_school_test_data\"
			},
			{
			  \"value\": \"$some_college_test_data\"
			},
			{
			  \"value\": \"$bachelors_test_data\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Validation\",
		  \"lowerboxcolor\": \"#DC8C7D\",
          \"upperboxcolor\": \"#D14855\",
		  \"data\": [
			{
			  \"value\": \"$all_educations_validation_data\"
			},
			{
			  \"value\": \"$high_school_validation_data\"
			},
			{
			  \"value\": \"$some_college_validation_data\"
			},
			{
			  \"value\": \"$bachelors_validation_data\"
			}
		  ]
		}
	  ]
	}";
	$accuracy_education_whisker_chart = new FusionCharts("boxandwhisker2d", "ex1", "50%", 600, "accuracy_education", "json", $accuracy_education_data);
	$accuracy_education_whisker_chart->render();
	
	
	/// Prediction accuracy by various subsets:
	$single_household_test_data = "0.858,0.864,0.861,0.845,0.833,0.863,0.861,0.853,0.854,0.845";
	$married_household_test_data = "0.878,0.835,0.871,0.851,0.844,0.839,0.865,0.849,0.849,0.851";
	$physical_labourers_test_data = "0.858,0.865,0.848,0.851,0.863,0.868,0.851,0.856,0.871,0.879";
	$outliers_test_data = "0.870,0.861,0.873,0.846,0.855,0.863,0.856,0.870,0.860,0.845";
	
	$single_household_validation_data = "0.912,0.910,0.912,0.914,0.912,0.912,0.914,0.916,0.910,0.912";
	$married_household_validation_data = "0.718,0.706,0.700,0.720,0.716,0.702,0.710,0.706,0.710,0.702";
	$physical_labourers_validation_data = "0.816,0.818,0.814,0.820,0.820,0.822,0.820,0.820,0.812,0.818";
	$outliers_validation_data = "0.834,0.854,0.848,0.846,0.844,0.836,0.830,0.850,0.844,0.858";
	
	$accuracy_various_data = "{
	  \"chart\": {
		\"caption\": \"Prediction accuracy\",
		\"subcaption\": \"For various data subsets\",
		\"palettecolors\": \"#5D62B5, #979AD0\",
		\"theme\": \"fusion\",
		\"showmean\": \"0\",
		\"drawmeanconnector\": \"0\",
		\"yaxisname\": \"Accuracy\",
		\"yaxismaxvalue\": \"0.92\",
		\"yaxisminvalue\": \"0.7\",
		\"plotspacepercent\": \"65\",
		\"meaniconshape\": \"polygon\",
		\"meaniconsides\": \"2\",
		\"meaniconradius\": \"2\",
		\"outliericonsides\": \"20\",
		\"outliericonalpha\": \"50\",
		\"outliericonshape\": \"triangle\",
		\"outliericonradius\": \"4\",
		\"mediancolor\": \"#FFFFFF\",
		\"plottooltext\": \"<b>Distribution for \$label:</b><br>Max: <b>\$maxDataValue</b><br>Q3: <b>\$Q3</b><br>Median: <b>\$median</b><br>Q1: <b>\$Q1</b><br>Min: <b>\$minDataValue</b>\"
	  },
	  \"categories\": [
		{
		  \"category\": [
			{
			  \"label\": \"Single Household\"
			},
			{
			  \"label\": \"Married Household\"
			},
			{
			  \"label\": \"Physical Labourers\"
			},
			{
			  \"label\": \"Outliers\"
			}
		  ]
		}
	  ],
	  \"dataset\": [
		{
		  \"seriesname\": \"Test\",
		  \"lowerboxcolor\": \"#559EA7\",
          \"upperboxcolor\": \"#9EB6A8\",
		  \"data\": [
			{
			  \"value\": \"$single_household_test_data\"
			},
			{
			  \"value\": \"$married_household_test_data\"
			},
			{
			  \"value\": \"$physical_labourers_test_data\"
			},
			{
			  \"value\": \"$outliers_test_data\"
			}
		  ]
		},
		{
		  \"seriesname\": \"Validation\",
		  \"lowerboxcolor\": \"#DC8C7D\",
          \"upperboxcolor\": \"#D14855\",
		  \"data\": [
			{
			  \"value\": \"$single_household_validation_data\"
			},
			{
			  \"value\": \"$married_household_validation_data\"
			},
			{
			  \"value\": \"$physical_labourers_validation_data\"
			},
			{
			  \"value\": \"$outliers_validation_data\"
			}
		  ]
		}
	  ]
	}";
	$accuracy_various_whisker_chart = new FusionCharts("boxandwhisker2d", "ex2", "50%", 600, "accuracy_various", "json", $accuracy_various_data);
	$accuracy_various_whisker_chart->render();	
   ?>
   
   <!--<div> Charts: </div> -->
	<div id="fm_dis"> Female/Male distribution chart. </div>
	
	<div id="wcl_dis"> Workclass distribution chart. </div>
	<div id="rce_dis"> Race distribution chart. </div>
	<div id="nat_dis"> Nation distribution chart. </div>
	
	<div id="edu_dis"> Education distribution chart. </div>
	<div id="fam_dis"> Family distribution chart. </div>
	<div id="occ_dis"> Occupation distribution chart. </div>
	<div id="rel_dis"> Relationship distribution chart. </div>
	
	<div id="accuracy_education"> Prediction accuracy depending on education. </div>
    <div id="accuracy_various"> Prediction accuracy for various data subsets. </div>
   </body>
</html>