<?php
    include('griddb_php_client.php');

    $factory = StoreFactory::get_default();
    $containerName = "income_ml";

    try{
        // Connect to cluster
        $gridstore = $factory->get_store(array("notificationAddress" => $argv[1],
                        "notificationPort" => $argv[2],
                        "clusterName" => $argv[3],
                        "user" => $argv[4],
                        "password" => $argv[5]
                    ));

        $gridstore->get_container("containerName");
        echo("Connect to Cluster\n");

        // Create a collection container, setup row types
        $col = $gridstore->put_container($containerName, 
			array(
				array("id" => GS_TYPE_INTEGER),
				array("age" => GS_TYPE_INTEGER),
				array("workclass" => GS_TYPE_STRING),
				array("education" => GS_TYPE_STRING),
				array("family" => GS_TYPE_STRING),
				array("occupation" => GS_TYPE_STRING),
				array("relationship" => GS_TYPE_STRING),
				array("race" => GS_TYPE_STRING),
				array("gender" => GS_TYPE_STRING),
				array("nation" => GS_TYPE_STRING),
				array("income_status" => GS_TYPE_STRING),
			),
        GS_CONTAINER_COLLECTION);

        echo("Operation completed! \n");

    } catch(GSException $e){
        echo($e->what()."\n");
        echo($e->get_code()."\n");
    }
?>
