<?php
    declare(strict_types=1);

    include 'vendor/autoload.php';    
    include('griddb_php_client.php');

    $factory = StoreFactory::get_default();
    $containerName = "income_ml";
    
    use Phpml\Dataset\CsvDataset;
    use Phpml\Dataset\ArrayDataset;
    use Phpml\FeatureExtraction\TokenCountVectorizer;
    use Phpml\Tokenization\WordTokenizer;
    use Phpml\CrossValidation\StratifiedRandomSplit;
    use Phpml\FeatureExtraction\TfIdfTransformer;
    use Phpml\Metric\Accuracy;
    use Phpml\Classification\SVC;
    use Phpml\SupportVectorMachine\Kernel;

    $rowList = array();
    $update = true;

	ini_set('memory_limit', '-1');

    try{
		
		// Connect to cluster
		echo("Connecting to cluster...\n");
		$gridstore = $factory->get_store(array("notificationAddress" => $argv[1],
						"notificationPort" => $argv[2],
						"clusterName" => $argv[3],
						"user" => $argv[4],
						"password" => $argv[5]
					));
		$gridstore->get_container("containerName");
		
		// Get the container
        $col = $gridstore->get_container($containerName);
        if($col == NULL){
            echo("ERROR Container not found. name=$containerName\n");
        }

		$col->set_auto_commit(false);
		
		// Load data
		echo("Loading data...\n");
		$dataset = new CsvDataset(__DIR__.'/income.csv', 14, false, ',');
		$samples = $dataset->getSamples();
		$labels = $dataset->getTargets();

        // Setup rows
		echo("Importing data... \n");
        $rowCount = 32561;
		for($i = 0; $i < $rowCount; $i++){
            // Create an empty row
            $rowList[$i] = $col->create_row();

            // Fill row with data
			$rowList[$i]->set_field_by_integer(0, $i);
            $rowList[$i]->set_field_by_integer(1,$samples[$i][0]);
            $rowList[$i]->set_field_by_string(2, $samples[$i][1]);
            $rowList[$i]->set_field_by_string(4, $samples[$i][3]);
            $rowList[$i]->set_field_by_string(6, $samples[$i][5]);
            $rowList[$i]->set_field_by_string(7, $samples[$i][6]);
            $rowList[$i]->set_field_by_string(8, $samples[$i][7]);
            $rowList[$i]->set_field_by_string(9, $samples[$i][8]);
            $rowList[$i]->set_field_by_string(10, $samples[$i][9]);
            $rowList[$i]->set_field_by_string(14, $samples[$i][13]);
            $rowList[$i]->set_field_by_string(15, $labels[$i]);

			// Emplace the row
            $col->put_row($rowList[$i]);
        }

		$col->commit();
		
		///////////////////////////////////////////////////////////////////////
		//////////		Update the collection container if needed	 //////////
		///////////////////////////////////////////////////////////////////////
		/*
        $col = $gridstore->put_container($containerName, 
			array(
				array("age" => GS_TYPE_INTEGER),
				array("workclass" => GS_TYPE_STRING),
				array("education" => GS_TYPE_STRING),
				array("familiy" => GS_TYPE_STRING),
				array("occupation" => GS_TYPE_STRING),
				array("relationship" => GS_TYPE_STRING),
				array("race" => GS_TYPE_STRING),
				array("gender" => GS_TYPE_STRING),
				array("nation" => GS_TYPE_STRING),
				array("income_status" => GS_TYPE_STRING),
			),
        GS_CONTAINER_COLLECTION, true);
		*/	
		///////////////////////////////////////////////////////////////////////
		
		echo("Operation completed! \n");

    } catch(GSException $e){
        echo($e->what()."\n");
        echo($e->get_code()."\n");
    }
?>
