/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs;

import com.toshiba.mwcloud.gs.IndexType;
import com.toshiba.mwcloud.gs.common.GSErrorCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IndexInfo {
    private IndexType type;
    private String name;
    private List<Integer> columnList = Collections.emptyList();
    private List<String> columnNameList = Collections.emptyList();

    public IndexInfo() {
    }

    public IndexInfo(IndexInfo info) {
        boolean sameClass;
        try {
            sameClass = info.getClass() == IndexInfo.class;
        }
        catch (NullPointerException e) {
            throw GSErrorCode.checkNullParameter(info, "info", e);
        }
        if (sameClass) {
            this.type = info.type;
            this.name = info.name;
            this.columnList = info.columnList;
            this.columnNameList = info.columnNameList;
        } else {
            this.setType(info.getType());
            this.setName(info.getName());
            this.setColumnList(info.getColumnList());
            this.setColumnNameList(info.getColumnNameList());
        }
    }

    public static IndexInfo createByColumn(String columnName, IndexType type) {
        IndexInfo info = new IndexInfo();
        info.setColumnName(columnName);
        info.setType(type);
        return info;
    }

    public static IndexInfo createByColumnList(List<String> columnNames, IndexType type) {
        IndexInfo info = new IndexInfo();
        info.setColumnNameList(columnNames);
        info.setType(type);
        return info;
    }

    public static IndexInfo createByName(String name, IndexType type) {
        IndexInfo info = new IndexInfo();
        info.setName(name);
        info.setType(type);
        return info;
    }

    public IndexType getType() {
        return this.type;
    }

    public void setType(IndexType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getColumn() {
        if (this.columnList.size() > 1 || this.columnNameList.size() > 1) {
            throw new IllegalStateException("This method cannot be used for composite index");
        }
        if (this.columnList.isEmpty()) {
            return null;
        }
        return this.columnList.get(0);
    }

    public void setColumn(Integer column) {
        this.columnList = column == null ? Collections.emptyList() : Collections.singletonList(column);
    }

    public String getColumnName() {
        if (this.columnList.size() > 1 || this.columnNameList.size() > 1) {
            throw new IllegalStateException("This method cannot be used for composite index");
        }
        if (this.columnNameList.isEmpty()) {
            return null;
        }
        return this.columnNameList.get(0);
    }

    public void setColumnName(String columnName) {
        this.columnNameList = columnName == null ? Collections.emptyList() : Collections.singletonList(columnName);
    }

    public void setColumnList(List<Integer> columns) {
        List<Integer> dest;
        try {
            dest = Collections.unmodifiableList(new ArrayList<Integer>(columns));
        }
        catch (NullPointerException e) {
            throw GSErrorCode.checkNullParameter(columns, "columns", e);
        }
        this.columnList = IndexInfo.checkListElements(dest, "columns");
    }

    public List<Integer> getColumnList() {
        return this.columnList;
    }

    public void setColumnNameList(List<String> columnNames) {
        List<String> dest;
        try {
            dest = Collections.unmodifiableList(new ArrayList<String>(columnNames));
        }
        catch (NullPointerException e) {
            throw GSErrorCode.checkNullParameter(columnNames, "columnNames", e);
        }
        this.columnNameList = IndexInfo.checkListElements(dest, "columnNames");
    }

    public List<String> getColumnNameList() {
        return this.columnNameList;
    }

    private static <T> List<T> checkListElements(List<T> list, String listName) {
        for (T elem : list) {
            GSErrorCode.checkNullParameter(elem, "element of " + listName, null);
        }
        return list;
    }

    static IndexInfo toImmutable(IndexInfo base) {
        if (base instanceof Immutable) {
            return (Immutable)base;
        }
        return new Immutable(base);
    }

    private static class Immutable
    extends IndexInfo {
        private Immutable(IndexInfo info) {
            super(info);
        }

        @Override
        public void setType(IndexType type) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setName(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setColumn(Integer column) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setColumnName(String columnName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setColumnList(List<Integer> columns) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setColumnNameList(List<String> columnNames) {
            throw new UnsupportedOperationException();
        }
    }
}

