/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.common;

import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.common.BasicBuffer;
import com.toshiba.mwcloud.gs.common.RowMapper;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

public class ContainerKeyConverter {
    private static final int PUBLIC_DATABASE_ID = 0;
    private static final int LATEST_VERSION = 14;
    private static final int LATEST_COMPATIBLE_VERSION = 13;
    private static final int DEFAULT_VERSION = 13;
    private static final int DATABASE_ID_FLAG = 1;
    private static final int LARGE_ID_FLAG = 2;
    private static final int AFFINITY_NUM_FLAG = 4;
    private static final int AFFINITY_STR_FLAG = 8;
    private static final int SYSTEM_NUM_FLAG = 16;
    private static final int SYSTEM_STR_FLAG = 32;
    private static final Charset DEFAULT_CHARSET = BasicBuffer.DEFAULT_CHARSET;
    private static final long VAR_INT_MAX_VALUE = 0x3FFFFFFFFFFFFFFFL;
    private static final int COMPATIBLE_MAX_AFFINITY_DIGITS = 9;
    private static final int COMPATIBLE_MAX_AFFINITY_NUM = 999999999;
    private static final char SYSTEM_SEP = '#';
    private static final char NON_SYSTEM_SEP = '@';
    private static final char SUB_SEP = '/';
    private static final char SUB_COUNT_SEP = '_';
    private static final String BASIC_SYMBOLS = "_";
    private static final String EXTRA_SYMBOLS1 = ".-/=";
    private static final ContainerKeyConverter DEFAULT_INSTANCE = new ContainerKeyConverter(13, false, false);
    private static final ContainerKeyConverter DEFAULT_SYSTEM_INSTANCE = new ContainerKeyConverter(13, false, true);
    private static final ContainerKeyConverter DEFAULT_INTERNAL_INSTANCE = new ContainerKeyConverter(13, true, true);
    private final int version;
    private final boolean internalMode;
    private final boolean systemAllowed;

    public ContainerKeyConverter(int version, boolean internalMode, boolean systemAllowed) {
        this.version = version;
        this.internalMode = internalMode;
        this.systemAllowed = systemAllowed;
    }

    public static ContainerKeyConverter getInstance(int version, boolean internalMode) {
        return ContainerKeyConverter.getInstance(version, internalMode, internalMode);
    }

    public static ContainerKeyConverter getInstance(int version, boolean internalMode, boolean systemAllowed) {
        if (version <= 0 || version == 13) {
            if (internalMode) {
                return DEFAULT_INTERNAL_INSTANCE;
            }
            if (systemAllowed) {
                return DEFAULT_SYSTEM_INSTANCE;
            }
            return DEFAULT_INSTANCE;
        }
        return new ContainerKeyConverter(version, internalMode, systemAllowed);
    }

    public static long getPublicDatabaseId() {
        return 0L;
    }

    public ContainerKey get(BasicBuffer buf, boolean caseSensitive, boolean validating) throws GSException {
        byte[] bytes;
        Components components = validating ? new Components() : null;
        int[] caseOffsetRef = new int[1];
        ByteBuffer base = buf.base();
        try {
            int expectedBodySize = this.since14() ? ContainerKeyConverter.getIntVarSize(base) : base.getInt();
            bytes = this.decomposeInternal(base, components, caseOffsetRef, true, false, expectedBodySize);
        }
        catch (BufferUnderflowException e) {
            throw ContainerKeyConverter.errorValidation(145031, "Protocol error by illegal container key image", null, e, new Object[0]);
        }
        if (validating) {
            this.validateInternal(components, null);
        }
        return new ContainerKey(bytes, caseOffsetRef[0], caseSensitive, !this.since14());
    }

    public void put(ContainerKey key, long databaseId, BasicBuffer buf) throws GSException {
        boolean modifying;
        byte[] bytes = key.bytes;
        if (!this.since14()) {
            buf.putInt(bytes.length);
            buf.prepare(bytes.length);
            buf.base().put(bytes);
            return;
        }
        int bodySize = bytes.length;
        byte flags = bytes[0];
        int databaseIdSize = 0;
        boolean bl = modifying = databaseId != 0L && (flags & 1) == 0;
        if (modifying) {
            flags = (byte)(flags | 1);
            databaseIdSize = 8;
            bodySize += databaseIdSize;
        }
        ContainerKeyConverter.putIntVarSize(buf, bodySize);
        buf.prepare(bodySize);
        buf.base().put(flags);
        if (modifying) {
            buf.base().putLong(databaseId);
        }
        buf.base().put(bytes, 1, bytes.length - 1);
    }

    public ContainerKey compose(Components components, boolean caseSensitive) throws GSException {
        BasicBuffer buf = new BasicBuffer(64);
        this.compose(components, buf);
        buf.base().flip();
        int[] caseOffsetRef = new int[1];
        byte[] bytes = this.decomposeInternal(buf.base(), null, caseOffsetRef, true, true, buf.base().remaining());
        return new ContainerKey(bytes, caseOffsetRef[0], caseSensitive, !this.since14());
    }

    public void compose(Components components, BasicBuffer buf) throws GSException {
        if (!this.since14()) {
            StringBuilder builder = new StringBuilder();
            this.format(components, builder);
            byte[] bytes = builder.toString().getBytes(DEFAULT_CHARSET);
            buf.prepare(bytes.length);
            buf.base().put(bytes);
            return;
        }
        int startPos = buf.base().position();
        int flags = 0;
        buf.put((byte)flags);
        if (components.databaseId != 0L) {
            flags |= 1;
            buf.putLong(components.databaseId);
        }
        byte[] baseBytes = components.base == null ? new byte[]{} : components.base.getBytes(DEFAULT_CHARSET);
        ContainerKeyConverter.putIntVarSize(buf, baseBytes.length);
        int basePos = buf.base().position();
        buf.prepare(baseBytes.length);
        buf.base().position(basePos + baseBytes.length);
        if (components.largeId >= 0L) {
            flags |= 2;
            ContainerKeyConverter.putLongVarSize(buf, components.largeId);
        }
        byte[] affinityBytes = null;
        int affinityStrPos = -1;
        if (components.affinityNum >= 0L) {
            flags |= 4;
            ContainerKeyConverter.putLongVarSize(buf, components.affinityNum);
        } else if (components.affinityStr != null) {
            flags |= 8;
            affinityBytes = components.affinityStr.getBytes(DEFAULT_CHARSET);
            ContainerKeyConverter.putIntVarSize(buf, affinityBytes.length);
            affinityStrPos = buf.base().position();
            buf.prepare(affinityBytes.length);
            buf.base().position(affinityStrPos + affinityBytes.length);
        }
        byte[] systemBytes = null;
        int systemStrPos = -1;
        if (components.systemNum >= 0L) {
            flags |= 0x10;
            ContainerKeyConverter.putLongVarSize(buf, components.systemNum);
        } else if (components.systemStr != null) {
            flags |= 0x20;
            systemBytes = components.systemStr.getBytes(DEFAULT_CHARSET);
            ContainerKeyConverter.putIntVarSize(buf, systemBytes.length);
            systemStrPos = buf.base().position();
            buf.prepare(systemBytes.length);
            buf.base().position(systemStrPos + systemBytes.length);
        }
        int caseBitPos = 0;
        int caseBits = 0;
        for (int i = 0; i < 3; ++i) {
            byte[] bytes;
            byte[] byArray = i == 0 ? baseBytes : (bytes = i == 1 ? affinityBytes : systemBytes);
            if (bytes == null) continue;
            for (int j = 0; j < bytes.length; ++j) {
                byte ch;
                if (caseBitPos >= 8) {
                    buf.put((byte)caseBits);
                    caseBitPos = 0;
                    caseBits = 0;
                }
                if (ASCIIUtils.isUpper(ch = bytes[j])) {
                    bytes[j] = (byte)ASCIIUtils.toLower(ch);
                    caseBits |= 1 << caseBitPos;
                }
                ++caseBitPos;
            }
        }
        if (caseBitPos != 0) {
            buf.put((byte)caseBits);
        }
        int endPos = buf.base().position();
        buf.base().position(startPos);
        buf.base().put((byte)flags);
        buf.base().position(basePos);
        buf.base().put(baseBytes);
        if (affinityBytes != null) {
            buf.base().position(affinityStrPos);
            buf.base().put(affinityBytes);
        }
        if (systemBytes != null) {
            buf.base().position(systemStrPos);
            buf.base().put(systemBytes);
        }
        buf.base().position(endPos);
    }

    public void decompose(ContainerKey key, Components components) throws GSException {
        ByteBuffer buf = BasicBuffer.wrapBase(key.bytes);
        this.decomposeInternal(buf, components, null, false, true, key.bytes.length);
        if (buf.remaining() > 0) {
            throw ContainerKeyConverter.errorValidation(145031, "Protocol error by remaining bytes in container key", null, null, new Object[0]);
        }
    }

    public void format(ContainerKey key, StringBuilder builder) throws GSException {
        Components components = new Components();
        this.decompose(key, components);
        this.format(components, builder);
    }

    public void format(Components components, StringBuilder builder) {
        if (components.base != null) {
            ContainerKeyConverter.escape(components.base, builder);
        }
        if (components.systemStr != null || components.systemNum >= 0L) {
            builder.append('#');
            if (components.systemStr != null) {
                ContainerKeyConverter.escape(components.systemStr, builder);
            } else {
                builder.append(components.systemNum);
            }
        }
        if (components.largeId >= 0L) {
            builder.append(this.since14() ? (char)'@' : '/');
            builder.append(components.largeId);
        }
        if (components.subCount >= 0) {
            builder.append('_');
            builder.append(components.subCount);
        }
        if (components.affinityStr != null || components.affinityNum >= 0L) {
            builder.append('@');
            if (components.affinityStr != null) {
                ContainerKeyConverter.escape(components.affinityStr, builder);
            } else {
                builder.append(components.affinityNum);
            }
        }
    }

    public ContainerKey parse(String str, boolean caseSensitive) throws GSException {
        Components components = new Components();
        this.parse(str, components, true);
        BasicBuffer buf = new BasicBuffer(str.length() * 2);
        this.compose(components, buf);
        buf.base().flip();
        int[] caseOffsetRef = new int[1];
        byte[] bytes = this.decomposeInternal(buf.base(), null, caseOffsetRef, true, false, buf.base().remaining());
        return new ContainerKey(bytes, caseOffsetRef[0], caseSensitive, !this.since14());
    }

    public void parse(String str, Components components, boolean validating) throws GSException {
        ValidationSource source = new ValidationSource(str);
        String baseStr = null;
        boolean systemFound = false;
        boolean largeIdFound = false;
        int len = str.length();
        int off = 0;
        while (off < len) {
            int endOff;
            char ch = str.charAt(off);
            boolean separated = false;
            switch (ch) {
                case '@': {
                    Long num;
                    String subStr;
                    if (!largeIdFound && this.internalMode && this.since14() && (endOff = ContainerKeyConverter.findSeparator(str, '@', off + 1)) >= 0) {
                        subStr = str.substring(off + 1, endOff);
                        num = ContainerKeyConverter.tryParseLongVar(subStr, true, source.at(off + 1), "largeId");
                        components.largeId = num;
                        largeIdFound = true;
                    } else {
                        subStr = str.substring(off + 1);
                        num = !this.since14() && subStr.length() > 9 ? null : ContainerKeyConverter.tryParseLongVar(subStr, false, null, null);
                        if (num == null) {
                            components.affinityStr = this.unescape(subStr, source.at(off + 1), "affinity");
                        } else {
                            components.affinityNum = num;
                        }
                        endOff = len;
                    }
                    separated = true;
                    break;
                }
                case '/': {
                    if (!this.since14() && !largeIdFound && this.internalMode) {
                        int subEndOff = ContainerKeyConverter.findSeparator(str, '_', off + 1);
                        endOff = ContainerKeyConverter.findSeparator(str, '@', (subEndOff >= 0 ? subEndOff : off) + 1);
                        if (endOff < 0) {
                            endOff = len;
                        }
                        if (subEndOff >= 0) {
                            components.subCount = ContainerKeyConverter.parseInt(str.substring(subEndOff + 1, endOff), source.at(subEndOff + 1), "subCount");
                        }
                        components.largeId = ContainerKeyConverter.parseInt(str.substring(off + 1, subEndOff >= 0 ? subEndOff : endOff), source.at(off + 1), "largeId");
                        largeIdFound = true;
                        separated = true;
                        break;
                    }
                    endOff = off + 1;
                    break;
                }
                case '#': {
                    Long num;
                    if (!systemFound && this.since14()) {
                        String subStr;
                        if (!this.internalMode && !this.systemAllowed) {
                            throw ContainerKeyConverter.errorCharacter(ch, source.at(off), null, null);
                        }
                        endOff = ContainerKeyConverter.findSeparator(str, '@', off + 1);
                        if (endOff < 0) {
                            endOff = len;
                        }
                        if ((num = ContainerKeyConverter.tryParseLongVar(subStr = str.substring(off + 1, endOff), false, null, null)) == null) {
                            components.systemStr = this.unescape(subStr, source.at(off + 1), "system");
                        } else {
                            components.systemNum = num;
                        }
                        systemFound = true;
                        separated = true;
                        break;
                    }
                    endOff = off + 1;
                    break;
                }
                default: {
                    endOff = off + 1;
                }
            }
            if (separated && baseStr == null) {
                baseStr = str.substring(0, off);
            }
            off = endOff;
        }
        if (baseStr == null) {
            baseStr = str;
        }
        components.base = this.unescape(baseStr, source.at(0), "base");
        if (validating) {
            this.validateInternal(components, source.at(-1));
        }
    }

    public void validate(Components components) throws GSException {
        this.validateInternal(components, null);
    }

    private void validateInternal(Components components, ValidationSource source) throws GSException {
        boolean affinityFound = false;
        boolean systemFound = false;
        for (int i = 0; i < 2; ++i) {
            String componentName = i == 0 ? "affinity" : "system";
            String str = i == 0 ? components.affinityStr : components.systemStr;
            long num = i == 0 ? components.affinityNum : components.systemNum;
            boolean found = false;
            if (str != null) {
                this.validateStr(str, false, false, source, componentName);
                found = true;
            }
            if (num != -1L) {
                this.validateLongVar(num, source, componentName);
                found = true;
            }
            if (str != null && num >= 0L) {
                throw ContainerKeyConverter.errorValidation(145006, "Both string and number specified", source, null, "component", componentName);
            }
            if (!found) continue;
            if (i == 0) {
                affinityFound = true;
                continue;
            }
            systemFound = true;
        }
        if (components.databaseId < 0L) {
            throw ContainerKeyConverter.errorValidation(145006, "Database ID must not be negative", source, null, "databaseId", components.databaseId);
        }
        if (components.largeId != -1L) {
            this.validateLongVar(components.largeId, source, "largeId");
            if (this.since6()) {
                if (!affinityFound && this.since13()) {
                    throw ContainerKeyConverter.errorValidation(145006, "Affinity must be specified on largeId specified", source, null, "largeId", components.largeId);
                }
            } else {
                throw ContainerKeyConverter.errorComponent(source, "largeId");
            }
        }
        if (components.subCount != -1) {
            this.validateLongVar(components.subCount, source, "subCount");
            if (this.since13() || !this.since11()) {
                throw ContainerKeyConverter.errorComponent(source, "subCount");
            }
            if (components.largeId >= (long)components.subCount) {
                throw ContainerKeyConverter.errorValidation(145006, "LargeId must be less than subCount", source, null, "largeId", components.largeId, "subCount", components.subCount);
            }
        }
        if (affinityFound) {
            if (components.affinityNum >= 0L && !this.since14() && components.affinityNum > 999999999L) {
                throw ContainerKeyConverter.errorValidation(145006, "Affinity number out of range", source, null, "affinity", components.affinityNum);
            }
            if (!this.since6()) {
                throw ContainerKeyConverter.errorComponent(source, "affinity");
            }
        }
        if (systemFound && !this.since14()) {
            throw ContainerKeyConverter.errorComponent(source, "system");
        }
        if (components.base == null) {
            throw ContainerKeyConverter.errorValidation(145006, "Base name not specified", source, null, new Object[0]);
        }
        this.validateStr(components.base, systemFound, true, source, "base");
    }

    private byte[] decomposeInternal(ByteBuffer buf, Components components, int[] caseOffsetRef, boolean withBytes, boolean withDatabase, int expectedBodySize) throws GSException, BufferUnderflowException {
        byte[] bytes;
        int reducingDatabaseIdSize;
        int baseStrPos;
        int baseStrSize;
        int systemStrPos;
        int systemStrSize;
        int affinityStrPos;
        int affinityStrSize;
        boolean databaseIdFound;
        int bodyPos;
        block27: {
            int flags;
            block32: {
                block31: {
                    long value;
                    block30: {
                        block29: {
                            block28: {
                                if (!this.since14()) {
                                    if (caseOffsetRef != null) {
                                        caseOffsetRef[0] = -1;
                                    }
                                    byte[] bytes2 = new byte[expectedBodySize];
                                    buf.get(bytes2);
                                    if (components != null) {
                                        String str = new String(bytes2, DEFAULT_CHARSET);
                                        this.parse(str, components, true);
                                    }
                                    return (byte[])(withBytes ? bytes2 : null);
                                }
                                bodyPos = buf.position();
                                databaseIdFound = false;
                                affinityStrSize = -1;
                                affinityStrPos = -1;
                                systemStrSize = -1;
                                systemStrPos = -1;
                                flags = buf.get();
                                if (flags != 0 && ((flags &= 0xFF) & 1) != 0) {
                                    value = buf.getLong();
                                    if (value == 0L) {
                                        throw ContainerKeyConverter.errorValidation(145031, "Protocol error by illegal database ID in container key", null, null, new Object[0]);
                                    }
                                    if (components != null && withDatabase) {
                                        components.databaseId = value;
                                    }
                                    flags &= 0xFFFFFFFE;
                                    databaseIdFound = true;
                                }
                                baseStrSize = ContainerKeyConverter.getIntVarSize(buf);
                                baseStrPos = buf.position();
                                BasicBuffer.BufferUtils.skipForward(buf, baseStrSize);
                                if (flags == 0) break block27;
                                if ((flags & 2) == 0) break block28;
                                value = ContainerKeyConverter.getLongVarSize(buf);
                                if (components != null) {
                                    components.largeId = value;
                                }
                                if ((flags &= 0xFFFFFFFD) == 0) break block27;
                            }
                            if ((flags & 4) == 0) break block29;
                            value = ContainerKeyConverter.getLongVarSize(buf);
                            if (components != null) {
                                components.affinityNum = value;
                            }
                            if ((flags &= 0xFFFFFFFB) != 0) break block30;
                            break block27;
                        }
                        if ((flags & 8) == 0) break block30;
                        affinityStrSize = ContainerKeyConverter.getIntVarSize(buf);
                        affinityStrPos = buf.position();
                        BasicBuffer.BufferUtils.skipForward(buf, affinityStrSize);
                        if ((flags &= 0xFFFFFFF7) == 0) break block27;
                    }
                    if ((flags & 0x10) == 0) break block31;
                    value = ContainerKeyConverter.getLongVarSize(buf);
                    if (components != null) {
                        components.systemNum = value;
                    }
                    if ((flags &= 0xFFFFFFEF) != 0) break block32;
                    break block27;
                }
                if ((flags & 0x20) == 0) break block32;
                systemStrSize = ContainerKeyConverter.getIntVarSize(buf);
                systemStrPos = buf.position();
                BasicBuffer.BufferUtils.skipForward(buf, systemStrSize);
                if ((flags &= 0xFFFFFFDF) == 0) break block27;
            }
            if (flags != 0) {
                throw ContainerKeyConverter.errorValidation(145031, "Protocol error by unknown container key flags", null, null, "flags", flags);
            }
        }
        int totalStrSize = baseStrSize + Math.max(affinityStrSize, 0) + Math.max(systemStrSize, 0);
        int caseSize = (totalStrSize + 8 - 1) / 8;
        int bodySize = buf.position() - bodyPos + caseSize;
        if (expectedBodySize != bodySize) {
            throw ContainerKeyConverter.errorValidation(145031, "Protocol error by invalid container key size", null, null, "expected", expectedBodySize, "actual", bodySize);
        }
        int n = reducingDatabaseIdSize = databaseIdFound && !withDatabase ? 8 : 0;
        if (caseOffsetRef != null) {
            caseOffsetRef[0] = bodySize - caseSize - reducingDatabaseIdSize;
        }
        if (components != null) {
            bytes = new byte[totalStrSize + caseSize];
            int off = 0;
            buf.position(baseStrPos);
            buf.get(bytes, off, baseStrSize);
            off += baseStrSize;
            if (affinityStrSize >= 0) {
                buf.position(affinityStrPos);
                buf.get(bytes, off, affinityStrSize);
                off += affinityStrSize;
            }
            if (systemStrSize >= 0) {
                buf.position(systemStrPos);
                buf.get(bytes, off, systemStrSize);
                off += systemStrSize;
            }
            buf.position(bodyPos + bodySize - caseSize);
            buf.get(bytes, off, caseSize);
            off = 0;
            int caseOff = totalStrSize;
            int caseBitPos = 8;
            int caseBits = 0;
            while (off < totalStrSize) {
                if (caseBitPos >= 8) {
                    if ((caseBits = bytes[caseOff++] & 0xFF) == 0) {
                        off += 8;
                        continue;
                    }
                    caseBitPos = 0;
                }
                int ch = bytes[off] & 0xFF;
                if ((caseBits & 1 << caseBitPos) != 0) {
                    if (!ASCIIUtils.isLower(ch)) {
                        throw ContainerKeyConverter.errorValidation(145031, "Protocol error by illegal container key image", null, null, "characterByte", ch);
                    }
                    bytes[off] = (byte)ASCIIUtils.shiftToUpper(ch);
                }
                ++off;
                ++caseBitPos;
            }
            off = 0;
            components.base = new String(bytes, off, baseStrSize, DEFAULT_CHARSET);
            off += baseStrSize;
            if (affinityStrSize >= 0) {
                components.affinityStr = new String(bytes, off, affinityStrSize, DEFAULT_CHARSET);
                off += affinityStrSize;
            }
            if (systemStrSize >= 0) {
                components.systemStr = new String(bytes, off, systemStrSize, DEFAULT_CHARSET);
            }
        }
        if (withBytes) {
            bytes = new byte[bodySize - reducingDatabaseIdSize];
            buf.position(bodyPos);
            bytes[0] = buf.get();
            if (!withDatabase) {
                bytes[0] = (byte)(bytes[0] & 0xFFFFFFFE);
            }
            buf.position(buf.position() + reducingDatabaseIdSize);
            buf.get(bytes, 1, bytes.length - 1);
            return bytes;
        }
        return null;
    }

    private void validateLongVar(long value, ValidationSource source, String componentName) throws GSException {
        if (value < 0L || value > 0x3FFFFFFFFFFFFFFFL) {
            throw ContainerKeyConverter.errorValidation(145006, "Number out of range", source, null, null, value, "component", componentName);
        }
        if (!this.since14() && value > Integer.MAX_VALUE) {
            throw ContainerKeyConverter.errorValidation(145006, "Number out of range for integer", source, null, null, value, "component", componentName);
        }
    }

    private void validateStr(String str, boolean withEmpty, boolean withExtra, ValidationSource source, String componentName) throws GSException {
        int len = str.length();
        if (len == 0 && !withEmpty) {
            throw ContainerKeyConverter.errorValidation(145006, "Empty component of container name", source, null, "component", componentName);
        }
        for (int off = 0; off < len; ++off) {
            char ch = str.charAt(off);
            if (ASCIIUtils.isUpper(ch) || ASCIIUtils.isLower(ch) || BASIC_SYMBOLS.indexOf(ch) >= 0 || ASCIIUtils.isDigit(ch) && (off > 0 || !withExtra || this.since14()) || (this.since14() ? EXTRA_SYMBOLS1.indexOf(ch) >= 0 : withExtra && ch == '#' && this.internalMode)) continue;
            throw ContainerKeyConverter.errorCharacter(ch, ValidationSource.duplicate(source).merge(off), componentName, str);
        }
    }

    private static void escape(String str, StringBuilder builder) {
        builder.append(str);
    }

    private String unescape(String str, ValidationSource source, String componentName) throws GSException {
        int len = str.length();
        for (int off = 0; off < len; ++off) {
            char ch = str.charAt(off);
            if (ch != '@' && (ch != '#' || !this.since14()) && (ch != '/' || this.since14())) continue;
            throw ContainerKeyConverter.errorCharacter(ch, ValidationSource.duplicate(source).merge(off), componentName, str);
        }
        return str;
    }

    private static int findSeparator(String str, char separatorChar, int offset) {
        return str.indexOf(separatorChar, offset);
    }

    private static int parseInt(String str, ValidationSource source, String componentName) throws GSException {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            throw ContainerKeyConverter.errorValidation(145006, "Illegal integer format", source, e, null, str);
        }
    }

    private static Long tryParseLongVar(String str, boolean force, ValidationSource source, String componentName) throws GSException {
        if (str.isEmpty()) {
            if (!force) {
                return null;
            }
            throw ContainerKeyConverter.errorValidation(145006, "Empty number string", source, null, "component", componentName);
        }
        char ch = str.charAt(0);
        if (!ASCIIUtils.isDigit(ch) || ASCIIUtils.isZero(ch) && str.length() > 1) {
            if (!force) {
                return null;
            }
            throw ContainerKeyConverter.errorValidation(145006, "Illegal number format", source, null, null, str, "component", componentName);
        }
        NumberFormat format = NumberFormat.getIntegerInstance(Locale.ROOT);
        format.setParseIntegerOnly(true);
        ParsePosition pos = new ParsePosition(0);
        Number rawValue = format.parse(str, pos);
        if (!(rawValue instanceof Long) || str.length() != pos.getIndex()) {
            if (!force) {
                return null;
            }
            throw ContainerKeyConverter.errorValidation(145006, "Illegal number format", source, null, null, str, "component", componentName);
        }
        Long value = (Long)rawValue;
        if (value < 0L || value > 0x3FFFFFFFFFFFFFFFL) {
            if (!force) {
                return null;
            }
            throw ContainerKeyConverter.errorValidation(145006, "Number out of range", source, null, null, str, "component", componentName);
        }
        return value;
    }

    private static int getIntVarSize(ByteBuffer buf) throws GSException {
        byte first = buf.get();
        if (RowMapper.varSizeIs1Byte(first)) {
            return RowMapper.decode1ByteVarSize(first);
        }
        if (RowMapper.varSizeIs4Byte(first)) {
            buf.position(buf.position() - 1);
            int rawSize = buf.getInt();
            return RowMapper.decode4ByteVarSize(rawSize);
        }
        throw ContainerKeyConverter.errorValidation(145031, "Protocol error by illegal var size", null, null, new Object[0]);
    }

    private static long getLongVarSize(ByteBuffer buf) {
        byte first = buf.get();
        if (RowMapper.varSizeIs1Byte(first)) {
            return RowMapper.decode1ByteVarSize(first);
        }
        if (RowMapper.varSizeIs4Byte(first)) {
            buf.position(buf.position() - 1);
            int rawSize = buf.getInt();
            return RowMapper.decode4ByteVarSize(rawSize);
        }
        buf.position(buf.position() - 1);
        long rawSize = buf.getLong();
        return RowMapper.decode8ByteVarSize(rawSize);
    }

    private static void putIntVarSize(BasicBuffer buf, int value) throws GSException {
        if ((long)value < 128L) {
            buf.put(RowMapper.encode1ByteVarSize((byte)value));
        } else if ((long)value < 0x40000000L) {
            buf.putInt(RowMapper.encode4ByteVarSize(value));
        } else {
            throw ContainerKeyConverter.errorValidation(145000, "Internal error by illegal var size", null, null, null, value);
        }
    }

    private static void putLongVarSize(BasicBuffer buf, long value) throws GSException {
        if (value < 128L) {
            buf.put(RowMapper.encode1ByteVarSize((byte)value));
        } else if (value < 0x40000000L) {
            buf.putInt(RowMapper.encode4ByteVarSize((int)value));
        } else if (value < 0x4000000000000000L) {
            buf.putLong(RowMapper.encode8ByteVarSize(value));
        } else {
            throw ContainerKeyConverter.errorValidation(145000, "Internal error by illegal var size", null, null, null, value);
        }
    }

    private static GSException errorComponent(ValidationSource source, String componentName) {
        return ContainerKeyConverter.errorValidation(145006, "Unacceptable component specified", source, null, "component", componentName);
    }

    private static GSException errorCharacter(char ch, ValidationSource source, String componentName, String componentStr) {
        StringBuilder builder = new StringBuilder();
        if (!Character.isISOControl(ch) && Character.isDefined(ch)) {
            builder.append("\"");
            builder.append(ch);
            builder.append("\"");
        }
        if (ch < '\u0000' || ch > '\u007f' || ch == ' ' || Character.isISOControl(ch)) {
            builder.append("(\\u");
            builder.append(String.format(Locale.ROOT, "%04x", (int)ch));
            builder.append(")");
        }
        String errorStr = ValidationSource.isStringSpecified(source) ? null : componentStr;
        return ContainerKeyConverter.errorValidation(145007, "Illegal character found", source, null, "character", builder.toString(), "component", componentName, null, errorStr);
    }

    private static GSException errorValidation(int errorCode, String message, ValidationSource source, Throwable cause, Object ... paramNameAndValues) {
        StringBuilder builder = new StringBuilder();
        builder.append(message);
        boolean paramFound = false;
        for (Object p : paramNameAndValues) {
            if (p == null) continue;
            paramFound = true;
        }
        boolean extra = source != null || cause != null || paramFound;
        boolean extraStarted = false;
        if (extra) {
            if (message != null && !message.isEmpty()) {
                builder.append(' ');
            }
            builder.append('(');
        }
        if (paramFound) {
            for (int i = 0; i < paramNameAndValues.length; i += 2) {
                Object value;
                Object name = paramNameAndValues[i];
                Object object = value = i + 1 < paramNameAndValues.length ? paramNameAndValues[i + 1] : null;
                if (value == null) continue;
                if (extraStarted) {
                    builder.append(", ");
                }
                extraStarted = true;
                builder.append(name == null ? "value" : name);
                builder.append('=');
                builder.append(value);
            }
        }
        if (source != null) {
            if (source.str != null) {
                if (extraStarted) {
                    builder.append(", ");
                }
                extraStarted = true;
                builder.append("containerName=");
                builder.append("\"");
                builder.append(source.str);
                builder.append("\"");
            }
            if (source.index >= 0) {
                if (extraStarted) {
                    builder.append(", ");
                }
                extraStarted = true;
                builder.append("index=");
                builder.append(source.index);
            }
        }
        if (cause != null) {
            if (extraStarted) {
                builder.append(", ");
            }
            extraStarted = true;
            builder.append("reason=");
            builder.append(cause.getMessage());
        }
        if (extra) {
            builder.append(')');
        }
        return new GSException(errorCode, builder.toString(), cause);
    }

    private boolean since6() {
        return this.version >= 6;
    }

    private boolean since11() {
        return this.version >= 11;
    }

    private boolean since13() {
        return this.version >= 13;
    }

    private boolean since14() {
        return this.version >= 14;
    }

    static class ASCIIUtils {
        ASCIIUtils() {
        }

        static boolean isLower(int ch) {
            return ch <= 122 && ch >= 97;
        }

        static boolean isUpper(int ch) {
            return ch <= 90 && ch >= 65;
        }

        static boolean isDigit(int ch) {
            return ch <= 57 && ch >= 48;
        }

        static boolean isZero(int ch) {
            return ch == 48;
        }

        static int shiftToLower(int ch) {
            return ch - 65 + 97;
        }

        static int shiftToUpper(int ch) {
            return ch - 97 + 65;
        }

        static int toLower(int ch) {
            return ASCIIUtils.isUpper(ch) ? ASCIIUtils.shiftToLower(ch) : ch;
        }

        static int toUpper(int ch) {
            return ASCIIUtils.isLower(ch) ? ASCIIUtils.shiftToUpper(ch) : ch;
        }
    }

    static class ValidationSource {
        String str;
        int index;

        ValidationSource(String str) {
            this(str, -1);
        }

        ValidationSource(String str, int index) {
            this.str = str;
            this.index = index;
        }

        ValidationSource at(int index) {
            ValidationSource dest = ValidationSource.duplicate(this);
            dest.index = index;
            return dest;
        }

        ValidationSource merge(int relativeIndex) {
            ValidationSource dest = ValidationSource.duplicate(this);
            dest.index = dest.index < 0 ? relativeIndex : (dest.index += relativeIndex);
            return dest;
        }

        static ValidationSource duplicate(ValidationSource src) {
            if (src == null) {
                return new ValidationSource(null);
            }
            return new ValidationSource(src.str, src.index);
        }

        static boolean isStringSpecified(ValidationSource src) {
            return src != null && src.str != null;
        }
    }

    public static class Components {
        public long databaseId = 0L;
        public String base;
        public long largeId = -1L;
        public long affinityNum = -1L;
        public String affinityStr;
        public long systemNum = -1L;
        public String systemStr;
        public int subCount = -1;
    }

    public static class ContainerKey {
        private static final int OFF_NO_STR = -1;
        private static final int OFF_COMPAT_NO_SENSITIVE = -2;
        private static final int OFF_COMPAT_SENSITIVE = -3;
        private final byte[] bytes;
        private final int caseOffset;

        ContainerKey(byte[] bytes, int caseOffset, boolean caseSensitive, boolean compatible) {
            this.bytes = bytes;
            if (compatible) {
                this.caseOffset = caseSensitive ? -3 : -2;
            } else if (caseSensitive) {
                this.caseOffset = bytes.length;
            } else {
                if (caseOffset < 0) {
                    throw new IllegalArgumentException();
                }
                this.caseOffset = bytes.length == caseOffset ? -1 : caseOffset;
            }
        }

        public boolean isCaseSensitive() {
            if (this.caseOffset >= 0) {
                return this.caseOffset == this.bytes.length;
            }
            return this.caseOffset == -3;
        }

        public ContainerKey toCaseSensitive(boolean caseSensitive) {
            boolean thisCaseSensitive = this.isCaseSensitive();
            if (thisCaseSensitive == caseSensitive) {
                return this;
            }
            boolean compatible = this.isCompatible();
            if (compatible || caseSensitive) {
                return new ContainerKey(this.bytes, -1, caseSensitive, compatible);
            }
            ContainerKeyConverter converter = ContainerKeyConverter.getInstance(14, true, true);
            int[] caseOffsetRef = new int[1];
            try {
                converter.decomposeInternal(BasicBuffer.wrapBase(this.bytes), null, caseOffsetRef, false, true, this.bytes.length);
            }
            catch (GSException e) {
                throw new IllegalStateException(e);
            }
            return new ContainerKey(this.bytes, caseOffsetRef[0], caseSensitive, false);
        }

        public int hashCode() {
            int hash = 1;
            int comparisonEnd = this.getComparisonEnd();
            boolean normalizing = this.isComparisonNormalizing();
            for (int i = 0; i < comparisonEnd; ++i) {
                byte b = this.bytes[i];
                if (normalizing) {
                    b = (byte)ASCIIUtils.toLower(b);
                }
                hash = hash * 31 + b;
            }
            return hash;
        }

        public boolean equals(Object obj) {
            boolean normalizing;
            int comparisonEnd;
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ContainerKey)) {
                return false;
            }
            ContainerKey key = (ContainerKey)obj;
            if (this.bytes == key.bytes) {
                return true;
            }
            if (this.bytes.length != key.bytes.length) {
                return false;
            }
            if (this.isCaseSensitive() || key.isCaseSensitive()) {
                comparisonEnd = this.bytes.length;
                normalizing = false;
            } else {
                if (this.isCompatible() != key.isCompatible()) {
                    return false;
                }
                if (this.caseOffset != key.caseOffset) {
                    return false;
                }
                comparisonEnd = this.getComparisonEnd();
                normalizing = this.isComparisonNormalizing();
            }
            for (int i = 0; i < comparisonEnd; ++i) {
                byte b1 = this.bytes[i];
                byte b2 = key.bytes[i];
                if (b1 == b2 || normalizing && ASCIIUtils.toLower(b1) == ASCIIUtils.toLower(b2)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            int version = this.isCompatible() ? 13 : 14;
            ContainerKeyConverter converter = ContainerKeyConverter.getInstance(version, true, true);
            StringBuilder builder = new StringBuilder();
            try {
                converter.format(this, builder);
            }
            catch (GSException e) {
                builder.append("(Container key with problem (cause=");
                builder.append(e.getMessage());
                builder.append("))");
            }
            return builder.toString();
        }

        private int getComparisonEnd() {
            return this.caseOffset >= 0 ? this.caseOffset : this.bytes.length;
        }

        private boolean isComparisonNormalizing() {
            return this.caseOffset == -2;
        }

        private boolean isCompatible() {
            return this.caseOffset == -2 || this.caseOffset == -3;
        }
    }
}

