/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.common;

import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.Geometry;
import com.toshiba.mwcloud.gs.common.BasicBuffer;
import java.nio.BufferUnderflowException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GeometryUtils {
    private static boolean strictMode;
    private static boolean quadraticSurfaceStrict;
    private static final int SR_ID_DEFAULT = -1;
    private static final Pattern SR_ID_BASE_PATTERN;
    private static final String SR_ID_PATTERN_STR;
    private static final short PV3KEY_NONE = 0;
    private static boolean specialPointValueEnabled;
    private static final String EMPTY_CONTENT = "EMPTY";
    private static final String NAN_STRING = "NAN";
    private static final String POSITIVE_INFINITY_STRING = "INF";
    private static final String NEGATIVE_INFINITY_STRING = "-INF";
    private static final Pattern GEOMETRY_MAIN_PATTERN;
    private static final Pattern POINT_PATTERN;
    private static final int[] LOWER_PATTERN_LEVELS;
    private static final int[] COUNT_BIASES;
    private static final Pattern[] POINTS_PATTERN_ARRAY;
    private static final Pattern QUADRATIC_SURFACE;
    private static final int QUADRATIC_SURFACE_ELEMENT_COUNT = 13;
    private static final int QUADRATIC_SURFACE_EXTRA_ELEMENT_COUNT = 3;
    private static final AtomicReference<DirectAccessor> ACCESSOR_REF;

    private static Pattern parenthesizePattern(Pattern base) {
        return Pattern.compile("\\(\\s*" + base.pattern() + "\\s*" + SR_ID_PATTERN_STR + "\\)");
    }

    private static Pattern repeatPattern(Pattern base) {
        return Pattern.compile(base.pattern() + "(?:\\s*,\\s*" + base.pattern() + ")*");
    }

    public static byte[] encodeGeometry(String geometryStr) throws GSException {
        Matcher typeMatcher = GEOMETRY_MAIN_PATTERN.matcher(geometryStr);
        if (!typeMatcher.matches()) {
            throw new GSException(145006, "Illegal geometry string: " + geometryStr);
        }
        String geometryTypeStr = typeMatcher.group(1);
        String geometryValuePart = typeMatcher.group(3);
        BasicBuffer buffer = new BasicBuffer(256);
        try {
            int srId;
            GeometryType geometryType;
            try {
                geometryType = GeometryType.valueOf(geometryTypeStr);
            }
            catch (IllegalArgumentException e) {
                throw new GSException(145006, "Unsupported geometry type: " + geometryTypeStr);
            }
            buffer.putShort((short)geometryType.ordinal());
            int srIdPos = buffer.base().position();
            buffer.putInt(-1);
            switch (geometryType) {
                case POINT: {
                    srId = GeometryUtils.encodePoints(buffer, geometryValuePart, 1);
                    break;
                }
                case LINESTRING: {
                    srId = GeometryUtils.encodePoints(buffer, geometryValuePart, 2);
                    break;
                }
                case POLYGON: {
                    srId = GeometryUtils.encodePoints(buffer, geometryValuePart, 3);
                    break;
                }
                case POLYHEDRALSURFACE: {
                    srId = GeometryUtils.encodePoints(buffer, geometryValuePart, 4);
                    break;
                }
                case QUADRATICSURFACE: {
                    srId = GeometryUtils.encodeQuadraticSurface(buffer, geometryValuePart);
                    break;
                }
                default: {
                    throw new GSException(145000, "Unsupported geometry type: " + geometryTypeStr);
                }
            }
            if (srId != -1) {
                int endPos = buffer.base().position();
                buffer.base().position(srIdPos);
                buffer.putInt(srId);
                buffer.base().position(endPos);
            }
            buffer.base().flip();
            byte[] result = new byte[buffer.base().limit()];
            buffer.base().get(result);
            return result;
        }
        catch (GSException e) {
            throw new GSException(145006, "Illegal geometry string: " + geometryStr, e);
        }
    }

    private static int encodePoints(BasicBuffer buffer, String str, int level) throws GSException {
        if (str == null) {
            boolean dimension = false;
            buffer.put((byte)0);
            return -1;
        }
        Matcher matcher = POINTS_PATTERN_ARRAY[level].matcher(str);
        if (!matcher.matches()) {
            throw new GSException(145006, "Illegal format: " + str);
        }
        int srId = GeometryUtils.parseSrId(matcher.group(matcher.groupCount()));
        int startPos = buffer.base().position();
        boolean dummyDimension = false;
        buffer.put((byte)0);
        int dimension = GeometryUtils.encodePointsContent(buffer, str, level);
        int endPos = buffer.base().position();
        buffer.base().position(startPos);
        buffer.put((byte)dimension);
        buffer.base().position(endPos);
        return srId;
    }

    private static int encodePointsContent(BasicBuffer buffer, String str, int level) throws GSException {
        if (level > 0) {
            int startPos = buffer.base().position();
            boolean dummyCount = false;
            if (level > 1) {
                buffer.putShort((short)0);
            }
            int lowerLevel = LOWER_PATTERN_LEVELS[level];
            Matcher matcher = POINTS_PATTERN_ARRAY[lowerLevel].matcher(str);
            int count = 0;
            int dimension = -1;
            while (matcher.find()) {
                if (lowerLevel > 0 && matcher.group(matcher.groupCount()) != null) {
                    throw new GSException(145002, "Illegal SR_ID: " + str);
                }
                int lastDimension = GeometryUtils.encodePointsContent(buffer, matcher.group(), lowerLevel);
                if (count > 0 && dimension != lastDimension) {
                    throw new GSException(145002, "Inconsistent dimension: " + str);
                }
                dimension = lastDimension;
                ++count;
            }
            if (count > Short.MAX_VALUE) {
                throw new GSException(145002, "Too many points: " + str);
            }
            if (level > 1) {
                int endPos = buffer.base().position();
                buffer.base().position(startPos);
                buffer.putShort((short)(count - COUNT_BIASES[level]));
                buffer.base().position(endPos);
            }
            return dimension;
        }
        Matcher matcher = POINT_PATTERN.matcher(str);
        if (!matcher.find()) {
            throw new GSException(145006, "Illegal format: " + str);
        }
        GeometryUtils.encodeDoubleValue(buffer, matcher.group(1));
        GeometryUtils.encodeDoubleValue(buffer, matcher.group(2));
        String lastElementStr = matcher.group(4);
        if (lastElementStr != null) {
            GeometryUtils.encodeDoubleValue(buffer, lastElementStr);
            return 3;
        }
        buffer.putDouble(Double.NaN);
        return 2;
    }

    private static int encodeQuadraticSurface(BasicBuffer buffer, String str) throws GSException {
        if (str == null) {
            boolean dimension = false;
            buffer.put((byte)0);
            return -1;
        }
        int dimension = 3;
        buffer.put((byte)3);
        buffer.putShort((short)0);
        Matcher matcher = QUADRATIC_SURFACE.matcher(str);
        if (!matcher.find()) {
            throw new GSException(145006, "Illegal format: " + str);
        }
        int groupCount = matcher.groupCount();
        int srId = GeometryUtils.parseSrId(matcher.group(groupCount));
        for (int i = 2; i < groupCount; ++i) {
            String valueStr = matcher.group(i);
            if (i >= groupCount - 3) {
                if (valueStr != null && quadraticSurfaceStrict) {
                    throw new GSException(145006, "Illegal format: " + str);
                }
                buffer.putDouble(0.0);
                continue;
            }
            GeometryUtils.encodeDoubleValue(buffer, valueStr);
        }
        return srId;
    }

    private static void encodeDoubleValue(BasicBuffer buffer, String valueStr) throws GSException {
        double value;
        try {
            boolean special;
            if (valueStr.equals(NAN_STRING)) {
                special = true;
                value = Double.NaN;
            } else if (valueStr.equals(POSITIVE_INFINITY_STRING)) {
                special = true;
                value = Double.POSITIVE_INFINITY;
            } else if (valueStr.equals(NEGATIVE_INFINITY_STRING)) {
                special = true;
                value = Double.NEGATIVE_INFINITY;
            } else {
                special = false;
                value = Double.parseDouble(valueStr);
            }
            if (special && !specialPointValueEnabled) {
                throw new GSException(145002, "Illegal value: " + value);
            }
        }
        catch (NumberFormatException e) {
            throw new GSException(145006, "Illegal point element: " + valueStr, e);
        }
        buffer.putDouble(value);
    }

    private static int parseSrId(String valueStr) throws GSException {
        if (valueStr == null) {
            return -1;
        }
        try {
            Matcher matcher = SR_ID_BASE_PATTERN.matcher(valueStr);
            matcher.find();
            return Integer.parseInt(matcher.group());
        }
        catch (NumberFormatException e) {
            throw new GSException(145006, "Illegal SR_ID: " + valueStr, e);
        }
    }

    public static String decodeGeometry(byte[] bytesData) throws GSException {
        int remaining;
        BasicBuffer in = new BasicBuffer(bytesData.length);
        in.base().put(bytesData);
        in.base().flip();
        StringBuilder out = new StringBuilder();
        try {
            GeometryType geometryType = GeometryUtils.decodeGeometryType(in, out);
            int srId = in.base().getInt();
            switch (geometryType) {
                case POINT: {
                    GeometryUtils.decodePoints(in, out, 1, srId);
                    break;
                }
                case LINESTRING: {
                    GeometryUtils.decodePoints(in, out, 2, srId);
                    break;
                }
                case POLYGON: {
                    GeometryUtils.decodePoints(in, out, 3, srId);
                    break;
                }
                case POLYHEDRALSURFACE: {
                    GeometryUtils.decodePoints(in, out, 4, srId);
                    break;
                }
                case QUADRATICSURFACE: {
                    GeometryUtils.decodeQuadraticSurface(in, out, srId);
                    break;
                }
                default: {
                    throw new GSException(145000, "Unsupported geometry type: " + (Object)((Object)geometryType));
                }
            }
        }
        catch (BufferUnderflowException e) {
            throw new GSException(145002, "Illegal input", e);
        }
        if (strictMode && (remaining = in.base().remaining()) > 0) {
            throw new GSException(145002, "Unknown part exists (size=" + remaining + ")");
        }
        return out.toString();
    }

    private static GeometryType decodeGeometryType(BasicBuffer in, StringBuilder out) throws GSException {
        GeometryType[] typeArray = (GeometryType[])GeometryType.class.getEnumConstants();
        short typeNumber = in.base().getShort();
        if (typeNumber < 0 || typeNumber >= typeArray.length) {
            throw new GSException(145002, "Unsupported geometry type: " + typeNumber);
        }
        GeometryType type = typeArray[typeNumber];
        out.append((Object)type);
        return type;
    }

    private static void decodePoints(BasicBuffer in, StringBuilder out, int level, int srId) throws GSException {
        byte dimension = in.base().get();
        switch (dimension) {
            case 0: {
                out.append("(");
                out.append(EMPTY_CONTENT);
                out.append(")");
                return;
            }
            case 2: {
                GeometryUtils.decodePointsContent(in, out, dimension, level, srId);
                return;
            }
            case 3: {
                GeometryUtils.decodePointsContent(in, out, dimension, level, srId);
                return;
            }
        }
        throw new GSException(145002, "Unsupported dimension: " + dimension);
    }

    private static void decodePointsContent(BasicBuffer in, StringBuilder out, int dimension, int level, int srId) throws GSException {
        if (level > 0) {
            int count = (level > 1 ? in.base().getShort() : (short)1) + COUNT_BIASES[level];
            out.append("(");
            if (count <= 0) {
                throw new GSException(145002, "Illegal points count: " + count);
            }
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    out.append(",");
                }
                GeometryUtils.decodePointsContent(in, out, dimension, LOWER_PATTERN_LEVELS[level], -1);
            }
            GeometryUtils.decodeSrId(out, srId);
            out.append(")");
        } else {
            double x = in.base().getDouble();
            double y = in.base().getDouble();
            double z = in.base().getDouble();
            GeometryUtils.decodeDoubleValue(out, x);
            out.append(" ");
            GeometryUtils.decodeDoubleValue(out, y);
            if (dimension > 2) {
                out.append(" ");
                GeometryUtils.decodeDoubleValue(out, z);
            }
        }
    }

    private static void decodeQuadraticSurface(BasicBuffer in, StringBuilder out, int srId) throws GSException {
        out.append("(");
        byte dimension = in.base().get();
        if (dimension == 0) {
            out.append(EMPTY_CONTENT);
        } else {
            int i;
            short pv3key = in.base().getShort();
            if (pv3key != 0) {
                throw new GSException(145002, "Illegal pv3key: " + pv3key);
            }
            for (i = 0; i < 13; ++i) {
                if (i > 0) {
                    out.append(" ");
                }
                GeometryUtils.decodeDoubleValue(out, in.base().getDouble());
            }
            for (i = 0; i < 3; ++i) {
                in.base().getDouble();
            }
            GeometryUtils.decodeSrId(out, srId);
        }
        out.append(")");
    }

    private static void decodeDoubleValue(StringBuilder out, double value) throws GSException {
        String valueStr;
        boolean special;
        if (Double.isInfinite(value)) {
            special = true;
            valueStr = value < 0.0 ? NEGATIVE_INFINITY_STRING : POSITIVE_INFINITY_STRING;
        } else if (Double.isNaN(value)) {
            special = true;
            valueStr = NAN_STRING;
        } else {
            special = false;
            valueStr = Double.toString(value);
            if (valueStr.contains("E")) {
                valueStr = valueStr.replace("E", "e").replace(".0e", "e");
            } else if (valueStr.endsWith("0") && valueStr.contains(".")) {
                int trimmingLength = 1;
                if (valueStr.endsWith(".0")) {
                    ++trimmingLength;
                }
                valueStr = valueStr.substring(0, valueStr.length() - trimmingLength);
            }
        }
        if (special && !specialPointValueEnabled) {
            throw new GSException(145002, "Illegal value: " + value);
        }
        out.append(valueStr);
    }

    private static void decodeSrId(StringBuilder out, int srId) {
        if (srId != -1) {
            out.append(";");
            out.append(srId);
        }
    }

    public static void setDirectAccessor(DirectAccessor accessor) {
        ACCESSOR_REF.set(accessor);
    }

    public static DirectAccessor getDirectAccessor() {
        for (int i = 0; i < 10; ++i) {
            DirectAccessor accessor = ACCESSOR_REF.get();
            if (accessor != null) {
                return accessor;
            }
            try {
                Class.forName(Geometry.class.getName());
            }
            catch (ClassNotFoundException e) {
                throw new Error(e);
            }
            if (i <= 0) continue;
            Thread.yield();
        }
        throw new Error();
    }

    public static int getBytesLength(Geometry geometry) {
        DirectAccessor accessor = GeometryUtils.getDirectAccessor();
        return accessor.getBytesLength(geometry);
    }

    public static void putGeometry(BasicBuffer out, Geometry geometry) {
        DirectAccessor accessor = GeometryUtils.getDirectAccessor();
        accessor.putGeometry(out, geometry);
    }

    public static Geometry getGeometry(BasicBuffer in, int size) throws GSException {
        return GeometryUtils.getDirectAccessor().getGeometry(in, size);
    }

    public static boolean isSpecialPointValueEnabled() {
        return specialPointValueEnabled;
    }

    public static void setStrictMode(boolean strictMode) {
        GeometryUtils.strictMode = strictMode;
    }

    static {
        Pattern[] array;
        strictMode = false;
        quadraticSurfaceStrict = false;
        SR_ID_BASE_PATTERN = Pattern.compile("[^\\s,();]+");
        SR_ID_PATTERN_STR = "(;\\s*" + SR_ID_BASE_PATTERN.pattern() + "\\s*)?";
        specialPointValueEnabled = false;
        GEOMETRY_MAIN_PATTERN = Pattern.compile("^(\\w+)\\s*(\\(\\s*EMPTY\\s*\\)\\s*|(.*))$");
        POINT_PATTERN = Pattern.compile("^([^\\s,();]+)\\s+([^\\s,();]+)(\\s+([^\\s,();]+))?$");
        LOWER_PATTERN_LEVELS = new int[]{-1, 0, 0, 2, 3};
        COUNT_BIASES = new int[]{0, 0, 0, 1, 0};
        Pattern base = Pattern.compile("[^\\s,();][^,();]*\\s[^,();]*[^\\s,();]");
        array = new Pattern[]{base, GeometryUtils.parenthesizePattern(base), GeometryUtils.parenthesizePattern(GeometryUtils.repeatPattern(base)), GeometryUtils.parenthesizePattern(GeometryUtils.repeatPattern(array[2])), GeometryUtils.parenthesizePattern(GeometryUtils.repeatPattern(array[3]))};
        POINTS_PATTERN_ARRAY = array;
        QUADRATIC_SURFACE = Pattern.compile("(\\(\\s*([^\\s,();]+)\\s+([^\\s,();]+)\\s+([^\\s,();]+)\\s+([^\\s,();]+)\\s+([^\\s,();]+)\\s+([^\\s,();]+)\\s+([^\\s,();]+)\\s+([^\\s,();]+)\\s+([^\\s,();]+)\\s+([^\\s,();]+)\\s+([^\\s,();]+)\\s+([^\\s,();]+)\\s+([^\\s,();]+)(?:\\s+([^\\s,();]+)\\s+([^\\s,();]+)\\s+([^\\s,();]+))?\\s*" + SR_ID_PATTERN_STR + "\\))");
        ACCESSOR_REF = new AtomicReference();
    }

    public static interface DirectAccessor {
        public int getBytesLength(Geometry var1);

        public void putGeometry(BasicBuffer var1, Geometry var2);

        public Geometry getGeometry(BasicBuffer var1, int var2) throws GSException;
    }

    private static enum GeometryType {
        POINT,
        LINESTRING,
        LINE,
        LINEARRING,
        POLYGON,
        POINTGEOM,
        MULTIPOINT,
        MULTISTRING,
        MULTIPOLYGON,
        POLYHEDRALSURFACE,
        QUADRATICSURFACE;

    }
}

