/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.common;

import com.toshiba.mwcloud.gs.GSException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertyUtils {
    private static final Pattern TIME_ZONE_OFFSET_PATTERN = Pattern.compile("([+\\-])([0-9]{2}):?([0-9]{2})");

    private PropertyUtils() {
    }

    public static int timeoutPropertyToIntSeconds(long value) {
        if (value < 0L) {
            return -1;
        }
        if (value >= 2147483647000L) {
            return Integer.MAX_VALUE;
        }
        return (int)(value / 1000L);
    }

    public static int timeoutPropertyToIntMillis(long value) {
        if (value < 0L) {
            return -1;
        }
        if (value >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)value;
    }

    public static void checkExclusiveProperties(Properties props, String ... nameList) throws GSException {
        int count = 0;
        for (String name : nameList) {
            if (!props.containsKey(name)) continue;
            ++count;
        }
        if (count > 1) {
            StringBuilder builder = new StringBuilder();
            builder.append("Either one of following properties ");
            builder.append("can be specified (");
            boolean found = false;
            for (String name : nameList) {
                if (!props.containsKey(name)) continue;
                if (!found) {
                    builder.append(", ");
                    found = true;
                }
                builder.append(name);
                builder.append("=");
                builder.append(props.getProperty(name));
            }
            builder.append(")");
            throw new GSException(145005, builder.toString());
        }
    }

    public static SimpleTimeZone parseTimeZoneOffset(String str, boolean withAuto) throws GSException {
        if (str.equals("Z")) {
            return PropertyUtils.createTimeZoneOffset(0);
        }
        if (withAuto && str.equals("auto")) {
            return PropertyUtils.getLocalTimeZoneOffset();
        }
        Matcher matcher = PropertyUtils.getTimeZoneOffsetPattern().matcher(str);
        if (!matcher.find() || matcher.start() != 0 || matcher.end() != str.length()) {
            throw new GSException(145005, "Illegal time zone format (value=" + str + ")");
        }
        int sign = matcher.group(1).equals("+") ? 1 : -1;
        int hour = 0;
        int min = 0;
        for (int i = 0; i < 2; ++i) {
            String strElem = matcher.group(i + 2);
            int elem = Integer.valueOf(strElem);
            if (i == 0) {
                hour = elem;
                continue;
            }
            min = elem;
        }
        if (hour > 23 || min > 59) {
            throw new GSException(145005, "Illegal time zone format (value=" + str + ")");
        }
        int offset = sign * (hour * 60 + min) * 60 * 1000;
        return PropertyUtils.createTimeZoneOffset(offset);
    }

    public static String formatTimeZoneOffset(long offsetMillis, boolean forId) {
        String gmtStr = "GMT";
        if (offsetMillis == 0L) {
            if (forId) {
                return "GMT";
            }
            return "Z";
        }
        long absMillis = offsetMillis >= 0L ? offsetMillis : -offsetMillis;
        String elemFormat = "%02d";
        StringBuilder sb = new StringBuilder();
        if (forId) {
            sb.append("GMT");
        }
        sb.append(offsetMillis >= 0L ? "+" : "-");
        sb.append(String.format(Locale.ROOT, "%02d", absMillis / 3600000L % 24L));
        sb.append(":");
        sb.append(String.format(Locale.ROOT, "%02d", absMillis / 60000L % 60L));
        return sb.toString();
    }

    public static SimpleTimeZone getLocalTimeZoneOffset() throws GSException {
        TimeZone src = TimeZone.getDefault();
        if (src.useDaylightTime() || src.getDSTSavings() != 0) {
            throw new GSException(145003, "Daylight time is not supported (zoneId=" + src.getID() + ", zoneName=" + src.getDisplayName(Locale.ROOT) + ", zoneDetail=" + src + ")");
        }
        return PropertyUtils.createTimeZoneOffset(src.getRawOffset());
    }

    public static SimpleTimeZone createTimeZoneOffset(int offsetMillis) {
        return new SimpleTimeZone(offsetMillis, PropertyUtils.formatTimeZoneOffset(offsetMillis, true));
    }

    public static Pattern getTimeZoneOffsetPattern() {
        return TIME_ZONE_OFFSET_PATTERN;
    }

    public static class WrappedProperties {
        private final Properties base;
        private final Map<String, Boolean> visited = new HashMap<String, Boolean>();

        public WrappedProperties(Properties base) {
            this.base = base;
        }

        public Properties getBase() {
            return this.base;
        }

        public Long getTimeoutProperty(String name, Long defaultValue, boolean deprecated) throws GSException {
            String millisecName = name + "Millis";
            Integer secValue = this.getIntProperty(name, deprecated);
            Integer millisecValue = this.getIntProperty(millisecName, true);
            if (secValue != null && millisecValue != null) {
                throw new GSException(145005, "Property name conflicted: \"" + name + "\", \"" + millisecName + "\"");
            }
            Long value = secValue != null ? (secValue == Integer.MAX_VALUE ? Long.valueOf(Long.MAX_VALUE) : Long.valueOf((long)secValue.intValue() * 1000L)) : (millisecValue != null ? Long.valueOf(millisecValue.intValue()) : defaultValue);
            if (value != null && value < 0L) {
                return -1L;
            }
            return value;
        }

        public Integer getIntProperty(String name, boolean deprecated) throws GSException {
            String strValue = this.getProperty(name, deprecated);
            if (strValue == null) {
                return null;
            }
            try {
                return Integer.valueOf(strValue);
            }
            catch (NumberFormatException e) {
                throw new GSException(145006, "Failed to parse as integer (value=" + strValue + ", propertyName=" + name + ", reason=" + e.getMessage() + ")", e);
            }
        }

        public Double getDoubleProperty(String name, boolean deprecated) throws GSException {
            String strValue = this.getProperty(name, deprecated);
            if (strValue == null) {
                return null;
            }
            try {
                return Double.valueOf(strValue);
            }
            catch (NumberFormatException e) {
                throw new GSException(145006, "Failed to parse as double (value=" + strValue + ", propertyName=" + name + ", reason=" + e.getMessage() + ")", e);
            }
        }

        public Boolean getBooleanProperty(String name, Boolean defaultValue, boolean deprecated) throws GSException {
            String strValue = this.getProperty(name, deprecated);
            if (strValue == null) {
                return defaultValue;
            }
            return Boolean.valueOf(strValue);
        }

        public String getProperty(String name, boolean deprecated) {
            return this.getProperty(name, null, deprecated);
        }

        public String getProperty(String name, String defaultValue, boolean deprecated) {
            String value = this.base.getProperty(name, defaultValue);
            this.visited.put(name, value == null ? false : deprecated);
            return value == null ? defaultValue : value;
        }

        public Set<String> getUnknownNames() {
            HashSet<String> names = new HashSet<String>(this.base.stringPropertyNames());
            names.removeAll(this.visited.keySet());
            return names;
        }

        public Set<String> getDeprecatedNames() {
            Set<String> names = Collections.emptySet();
            for (Map.Entry<String, Boolean> entry : this.visited.entrySet()) {
                if (!entry.getValue().booleanValue()) continue;
                if (names.isEmpty()) {
                    names = new HashSet<String>();
                }
                names.add(entry.getKey());
            }
            return names;
        }

        public void addVisitedNames(Set<String> nameSet, boolean deprecated) {
            for (String name : nameSet) {
                this.visited.put(name, deprecated);
            }
        }
    }
}

