/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.subnet;

import com.toshiba.mwcloud.gs.Collection;
import com.toshiba.mwcloud.gs.Container;
import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.Geometry;
import com.toshiba.mwcloud.gs.GeometryOperator;
import com.toshiba.mwcloud.gs.Query;
import com.toshiba.mwcloud.gs.RowSet;
import com.toshiba.mwcloud.gs.common.BasicBuffer;
import com.toshiba.mwcloud.gs.common.ContainerKeyConverter;
import com.toshiba.mwcloud.gs.common.ContainerProperties;
import com.toshiba.mwcloud.gs.common.GSErrorCode;
import com.toshiba.mwcloud.gs.common.GeometryUtils;
import com.toshiba.mwcloud.gs.common.RowMapper;
import com.toshiba.mwcloud.gs.common.Statement;
import com.toshiba.mwcloud.gs.subnet.GridStoreChannel;
import com.toshiba.mwcloud.gs.subnet.SubnetContainer;
import com.toshiba.mwcloud.gs.subnet.SubnetGridStore;
import com.toshiba.mwcloud.gs.subnet.SubnetQuery;
import com.toshiba.mwcloud.gs.subnet.SubnetRowSet;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SubnetCollection<K, R>
extends SubnetContainer<K, R>
implements Collection<K, R> {
    public SubnetCollection(SubnetGridStore store, GridStoreChannel channel, GridStoreChannel.Context context, Container.BindType<K, R, ? extends Container<?, ?>> bindType, RowMapper mapper, int schemaVerId, int partitionId, long containerId, ContainerKeyConverter.ContainerKey normalizedContainerKey, ContainerKeyConverter.ContainerKey remoteContainerKey) throws GSException {
        super(store, channel, context, bindType, mapper, schemaVerId, partitionId, containerId, normalizedContainerKey, remoteContainerKey);
    }

    @Override
    public Query<R> query(final String column, final Geometry geometry, final GeometryOperator geometryOp) throws GSException {
        this.checkOpened();
        return new SubnetQuery(this, this.rowType, this.mapper, new SubnetContainer.QueryFormatter(Statement.QUERY_COLLECTION_GEOMETRY_RELATED){

            @Override
            public void format(BasicBuffer inBuf) throws GSException {
                SubnetCollection.this.formatQuery(inBuf, column, geometry, geometryOp);
            }

            @Override
            public String getQueryString() {
                return "{column=" + column + ", geometry=" + geometry + ", op=" + (Object)((Object)geometryOp) + "}";
            }
        });
    }

    private void formatQuery(BasicBuffer inBuf, String column, Geometry geometry, GeometryOperator geometryOp) throws GSException {
        GSErrorCode.checkNullParameter(column, "column", null);
        try {
            inBuf.putInt(this.mapper.resolveColumnId(column));
            RowMapper.putSize(inBuf, GeometryUtils.getBytesLength(geometry), SubnetCollection.getRowMappingMode());
            GeometryUtils.putGeometry(inBuf, geometry);
            inBuf.putByteEnum(geometryOp);
        }
        catch (NullPointerException e) {
            GSErrorCode.checkNullParameter(geometry, "geometry", e);
            GSErrorCode.checkNullParameter((Object)geometryOp, "geometryOp", e);
            throw e;
        }
    }

    @Override
    public Query<R> query(final String column, final Geometry geometryIntersection, final Geometry geometryDisjoint) throws GSException {
        this.checkOpened();
        return new SubnetQuery(this, this.rowType, this.mapper, new SubnetContainer.QueryFormatter(Statement.QUERY_COLLECTION_GEOMETRY_WITH_EXCLUSION){

            @Override
            public void format(BasicBuffer inBuf) throws GSException {
                SubnetCollection.this.formatQuery(inBuf, column, geometryIntersection, geometryDisjoint);
            }

            @Override
            public String getQueryString() {
                return "{column=" + column + ", intersection=" + geometryIntersection + ", disjoint=" + geometryDisjoint + "}";
            }
        });
    }

    private void formatQuery(BasicBuffer inBuf, String column, Geometry geometryIntersection, Geometry geometryDisjoint) throws GSException {
        GSErrorCode.checkNullParameter(column, "column", null);
        try {
            inBuf.putInt(this.mapper.resolveColumnId(column));
            RowMapper.MappingMode mode = SubnetContainer.getRowMappingMode();
            RowMapper.putSize(inBuf, GeometryUtils.getBytesLength(geometryIntersection), mode);
            GeometryUtils.putGeometry(inBuf, geometryIntersection);
            RowMapper.putSize(inBuf, GeometryUtils.getBytesLength(geometryDisjoint), mode);
            GeometryUtils.putGeometry(inBuf, geometryDisjoint);
        }
        catch (NullPointerException e) {
            GSErrorCode.checkNullParameter(geometryIntersection, "geometryIntersection", e);
            GSErrorCode.checkNullParameter(geometryDisjoint, "geometryDisjoint", e);
            throw e;
        }
    }

    public static class MetaRowSet<R>
    implements RowSet<R> {
        private final List<SubnetCollection<?, ?>> subContainerList;
        private final List<SubnetQuery<R>> subQueryList;
        private final List<RowSet<R>> subList;
        private RowSet<R> nextSub;
        private int nextIndex;
        private int size = -1;

        MetaRowSet(List<SubnetCollection<?, ?>> subContainerList, List<SubnetQuery<R>> subQueryList, List<RowSet<R>> subList) throws GSException {
            this.subContainerList = subContainerList;
            this.subQueryList = subQueryList;
            this.subList = subList;
            this.nextSub = this.subList.get(this.nextIndex);
            this.prepareNext();
        }

        private void prepareNext() throws GSException {
            if (this.nextSub == null) {
                return;
            }
            while (!this.nextSub.hasNext()) {
                ++this.nextIndex;
                if (this.nextIndex >= this.subList.size()) {
                    this.nextSub = null;
                    break;
                }
                this.nextSub = this.subList.get(this.nextIndex);
            }
        }

        @Override
        public boolean hasNext() throws GSException {
            return this.nextSub != null;
        }

        @Override
        public R next() throws GSException {
            R row;
            try {
                row = this.nextSub.next();
            }
            catch (NullPointerException e) {
                if (this.nextSub == null) {
                    throw new GSException(145037, "No more rows were found");
                }
                throw e;
            }
            if (!this.nextSub.hasNext()) {
                this.prepareNext();
            }
            return row;
        }

        @Override
        public void remove() throws GSException {
            throw new GSException(145003, "");
        }

        @Override
        public void update(R rowObj) throws GSException {
            throw new GSException(145003, "");
        }

        @Override
        public int size() {
            if (this.size < 0) {
                int size = 0;
                for (RowSet<R> sub : this.subList) {
                    size += sub.size();
                }
                this.size = size;
            }
            return this.size;
        }

        @Override
        public void close() throws GSException {
            MetaRowSet.closeAllSub(this.subContainerList, this.subQueryList, this.subList, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static <R> void closeAllSub(List<SubnetCollection<?, ?>> subContainerList, List<SubnetQuery<R>> subQueryList, List<RowSet<R>> subRowSetList, boolean silent) throws GSException {
            try {
                try {
                    MetaCollection.closeSub(subContainerList, silent);
                }
                finally {
                    MetaQuery.closeSub(subQueryList, silent);
                }
            }
            finally {
                MetaRowSet.closeSub(subRowSetList, silent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static <R> void closeSub(List<RowSet<R>> subList, boolean silent) throws GSException {
            if (subList == null) {
                return;
            }
            try {
                for (RowSet<R> sub : subList) {
                    if (silent) {
                        try {
                            sub.close();
                        }
                        catch (Throwable throwable) {}
                        continue;
                    }
                    sub.close();
                }
            }
            finally {
                if (!silent) {
                    MetaRowSet.closeSub(subList, true);
                }
            }
        }
    }

    public static class MetaQuery<R>
    extends SubnetQuery<R> {
        private final MetaCollection<?, ?> container;
        private final Class<R> resultType;
        private final String tql;

        private MetaQuery(MetaCollection<?, ?> container, Class<R> resultType, RowMapper mapper, String tql) {
            super(container, resultType, mapper, MetaQuery.createFormatter(tql));
            this.container = container;
            this.resultType = resultType;
            this.tql = tql;
        }

        private static <R> SubnetContainer.QueryFormatter createFormatter(final String tql) {
            return new SubnetContainer.QueryFormatter(null){

                @Override
                public String getQueryString() {
                    return tql;
                }

                @Override
                void format(BasicBuffer out) throws GSException {
                    throw new GSException(145003, "");
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RowSet<R> fetch(boolean forUpdate) throws GSException {
            this.checkOpened();
            List subContainerList = null;
            List<SubnetQuery<R>> subList = null;
            List<RowSet<R>> subRowSetList = null;
            ArrayList<InetSocketAddress> addressList = new ArrayList<InetSocketAddress>();
            boolean succeeded = false;
            try {
                subContainerList = ((MetaCollection)this.container).createSubList(addressList);
                subList = this.createSubList(subContainerList);
                subRowSetList = this.fetchAllInternal(subList, addressList, forUpdate);
                MetaRowSet<R> rowSet = new MetaRowSet<R>(subContainerList, subList, subRowSetList);
                succeeded = true;
                MetaRowSet<R> metaRowSet = rowSet;
                return metaRowSet;
            }
            finally {
                if (!succeeded) {
                    MetaRowSet.closeAllSub(subContainerList, subList, subRowSetList, true);
                }
            }
        }

        @Override
        public void close() throws GSException {
            super.close();
        }

        private void checkOpened() throws GSException {
            super.getFetchLimit();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<SubnetQuery<R>> createSubList(List<SubnetCollection<?, ?>> subContainerList) throws GSException {
            ArrayList<SubnetQuery<R>> subList = new ArrayList<SubnetQuery<R>>();
            boolean succeeded = false;
            try {
                for (SubnetCollection<?, ?> subContainer : subContainerList) {
                    Query subQuery = subContainer.query(this.tql, this.resultType);
                    subList.add((SubnetQuery<R>)subQuery);
                }
                succeeded = true;
                ArrayList<SubnetQuery<R>> arrayList = subList;
                return arrayList;
            }
            finally {
                if (!succeeded) {
                    MetaQuery.closeSub(subList, true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<RowSet<R>> fetchAllInternal(List<SubnetQuery<R>> subList, List<InetSocketAddress> addressList, boolean forUpdate) throws GSException {
            int subCount = subList.size();
            ArrayList subRowSetList = new ArrayList(subCount);
            boolean succeeded = false;
            try {
                List<Long> targetList = null;
                boolean firstTarget = false;
                if (subCount > 0) {
                    SubnetQuery<R> subQuery = subList.get(0);
                    this.container.fetchInternal(subQuery, addressList.get(0), forUpdate);
                    RowSet subRowSet = subQuery.getRowSet();
                    subRowSetList.add(subRowSet);
                    SubnetRowSet.DistributedQueryTarget distTarget = SubnetRowSet.getDistTarget(subRowSet);
                    if (distTarget != null && distTarget.targeted) {
                        targetList = distTarget.targetList;
                    }
                }
                if (targetList == null) {
                    for (int i = 1; i < subCount; ++i) {
                        subRowSetList.add(this.container.fetchInternal(subList.get(i), addressList.get(i), forUpdate));
                    }
                } else {
                    Iterator iterator = targetList.iterator();
                    while (iterator.hasNext()) {
                        long targetId = (Long)iterator.next();
                        if (targetId < 0L || targetId >= (long)subCount) {
                            throw new GSException(145031, "Protocol error by invalid distributed target");
                        }
                        if (targetId == 0L) continue;
                        int intTargetId = (int)targetId;
                        subRowSetList.add(this.container.fetchInternal(subList.get(intTargetId), addressList.get(intTargetId), forUpdate));
                    }
                }
                succeeded = true;
                ArrayList arrayList = subRowSetList;
                return arrayList;
            }
            finally {
                if (!succeeded) {
                    MetaRowSet.closeSub(subRowSetList, true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static <R> void closeSub(List<SubnetQuery<R>> subList, boolean silent) throws GSException {
            if (subList == null) {
                return;
            }
            try {
                for (SubnetQuery<R> sub : subList) {
                    if (silent) {
                        try {
                            sub.close();
                        }
                        catch (Throwable throwable) {}
                        continue;
                    }
                    sub.close();
                }
            }
            finally {
                if (!silent) {
                    MetaQuery.closeSub(subList, true);
                }
            }
        }
    }

    public static class MetaCollection<K, R>
    extends SubnetCollection<K, R> {
        private static final Set<Integer> QUERY_RESULT_OPTIONS = Collections.singleton(32);
        private final GridStoreChannel channel;
        private final GridStoreChannel.Context context;
        private final ContainerProperties.MetaDistributionType metaDistType;
        private final long metaContainerId;
        private final ContainerProperties.MetaNamingType metaNamingType;
        private final ContainerKeyConverter.ContainerKey queryContainerKey;

        public MetaCollection(SubnetGridStore store, GridStoreChannel channel, GridStoreChannel.Context context, Container.BindType<K, R, ? extends Container<?, ?>> bindType, RowMapper mapper, int schemaVerId, int partitionId, ContainerProperties.MetaDistributionType metaDistType, long metaContainerId, ContainerProperties.MetaNamingType metaNamingType, ContainerKeyConverter.ContainerKey normalizedContainerKey, ContainerKeyConverter.ContainerKey remoteContainerKey) throws GSException {
            super(store, channel, context, bindType, mapper, schemaVerId, partitionId, -1L, normalizedContainerKey, remoteContainerKey);
            this.channel = channel;
            this.context = context;
            this.metaDistType = metaDistType;
            this.metaContainerId = metaContainerId;
            this.metaNamingType = metaNamingType;
            this.queryContainerKey = remoteContainerKey;
        }

        @Override
        protected void executeStatement(Statement statement, BasicBuffer req, BasicBuffer resp, SubnetContainer.StatementFamily familyForSession) throws GSException {
            if (statement != Statement.QUERY_TQL) {
                throw new GSException(145003, "");
            }
            super.executeStatement(statement, req, resp, familyForSession);
        }

        @Override
        public <S> SubnetQuery<S> query(String tql, Class<S> rowType) throws GSException {
            this.checkOpened();
            return new MetaQuery(this, rowType, this.getRowMapper(), tql);
        }

        @Override
        public void close() throws GSException {
            super.close();
        }

        private List<SubnetCollection<?, ?>> createSubList(List<InetSocketAddress> addressList) throws GSException {
            addressList.clear();
            ArrayList subList = new ArrayList();
            switch (this.metaDistType) {
                case FULL: {
                    int count = this.channel.getPartitionCount(this.context);
                    for (int i = 0; i < count; ++i) {
                        subList.add(this.createSub(i));
                        addressList.add(null);
                    }
                    break;
                }
                case NODE: {
                    for (InetSocketAddress address : this.channel.getActiveNodeAddressSet(this.context)) {
                        subList.add(this.createSub(0));
                        addressList.add(address);
                    }
                    break;
                }
                default: {
                    throw new GSException(145003, "");
                }
            }
            return subList;
        }

        private SubnetCollection<K, R> createSub(int partitionId) throws GSException {
            return new SubnetCollection(this.getStore(), this.channel, this.context, this.getBindType(), this.getRowMapper(), this.getSchemaVersionId(), partitionId, -1L, this.getNormalizedContainerKey(), this.queryContainerKey);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <S> RowSet<S> fetchInternal(SubnetQuery<S> query, InetSocketAddress address, boolean forUpdate) throws GSException {
            if (address == null) {
                query.setAcceptableResultKeys(QUERY_RESULT_OPTIONS);
                query.setMetaContainerId(this.metaContainerId, this.metaNamingType);
                query.setQeuryContainerKey(true, this.queryContainerKey);
                return query.fetch(forUpdate);
            }
            GridStoreChannel.Context.FixedAddressScope scope = new GridStoreChannel.Context.FixedAddressScope(this.context, address);
            try {
                RowSet<S> rowSet = this.fetchInternal(query, null, forUpdate);
                return rowSet;
            }
            finally {
                scope.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void closeSub(List<SubnetCollection<?, ?>> subList, boolean silent) throws GSException {
            if (subList == null) {
                return;
            }
            try {
                for (SubnetContainer subnetContainer : subList) {
                    if (silent) {
                        try {
                            subnetContainer.close();
                        }
                        catch (Throwable throwable) {}
                        continue;
                    }
                    subnetContainer.close();
                }
            }
            finally {
                if (!silent) {
                    MetaCollection.closeSub(subList, true);
                }
            }
        }
    }
}

