# Instructions For Running Benchmark

## Prereqs

1. update the gridstore.jar file to your current working version of GridDB in libs directory (if necessary)
    - it may also be necessary to change the path in common.sh to point to the updated mysql-connector file in the libs dir
2. Set your mariadb username/password/database name
3. Change parameters in the following files:
    - common.sh --> change working dir (ie. /tmp/rdbms-benchnmark)
    - gridstore.properties --> match your running instance (ie. 127.0.0.1:10001)
    - change parameters in start_mysql script and remove portions SSH portions *(see bottom for example)*
    - update your java credentials in the following files: *(see bottom for example)*
        - src/MeterBenchmark/MySQLClient.java
        * src/rdms/MySQLExtract.java
        * src/rdms/MySQLIngest.java
        * src/rdms/ThreadManager.java
4. Update scripts to use the right host, currently griddb1

## Running

1. run script "./build.sh"
2. Start MySQL/GridDB using start_mysql.sh and start_griddb.sh
3. run script "./run.sh 'db name' <1 or 2>" 1 will load data and read while 2 will only read data.
    - $ ./run.sh griddb 2
        - db name = "mysql" or "griddb"
4. Run stop_griddb.sh/stop_mysql.sh to stop the database and clear its data.

### Runall 

This script will start/build/benchmark/stop all in sequence. just make sure that you set the parameters up as explained above in prereqs. It can be configured to use multiple application hosts to generate more load on the target database.

## Examples

### start_mysql.sh

    sudo systemctl start mariadb

    echo "CREATE TABLE METERS (
        id BIGINT NOT NULL,
        contact_name TEXT,
        email TEXT,
        number TEXT,
        description TEXT,
        address TEXT,
        city TEXT,
        state_province TEXT,
        last_reading DATETIME,
        latitude FLOAT,
        longitude FLOAT,
        PRIMARY KEY (id)
    )" | mysql --user=admin --password=testpw testdb

    echo "CREATE TABLE METER_READS (
        timestamp DATETIME, 
        usage_since_read DOUBLE, 
        usage_this_hour DOUBLE, 
        usage_this_day DOUBLE, 
        usage_this_week DOUBLE,
        usage_this_month DOUBLE, 
        usage_this_year DOUBLE, 
        all_time_usage DOUBLE, 
        error_code_1 BIGINT, 
        error_code_2 BIGINT, 
        meter_id BIGINT NOT NULL,
        FOREIGN KEY (meter_id) REFERENCES METERS(id)
    )" | mysql --user=admin --password=testpw testdb

### src/rdms/MySQLIngest.java

	private static String serverName = "localhost"; 
	private static String port = "3306";
	private static String username = "admin"; 
	private static String password = "testpw"; 
	private static String db = "testdb";
